/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillAutoRepayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("drawtype");
        selector.add("confirmstatus");
        selector.add("datasource");
        selector.add("loantype");
        selector.add("repayplan_entry");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObjectCollection repayEntrys;
            QFilter confirmFilter;
            QFilter loanbillnoFilter;
            DynamicObjectCollection submitInterestBills;
            DynamicObject data = entity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(data.getString("datasource"));
            String drawType = data.getString("drawtype");
            if (!BillStatusEnum.AUDIT.getValue().equals(data.getString("billstatus")) || !DrawTypeEnum.DRAWED.getValue().equals(drawType) && !DrawTypeEnum.PARTPAYMENT.getValue().equals(drawType)) {
                this.addErrorMessage(entity, bizResource.getLoanStatus());
            }
            String confirmStatus = data.getString("confirmstatus");
            if (!ConfirmStatusEnum.YETCONFIRM.getValue().equals(confirmStatus)) {
                this.addErrorMessage(entity, bizResource.getLoanConfirmStatus());
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(submitInterestBills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"billstatus", (QFilter[])new QFilter[]{loanbillnoFilter = new QFilter("sourcebillid", "=", data.getPkValue()), confirmFilter = new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue())})))) {
                this.addErrorMessage(entity, bizResource.getIbSubmitOnlyoneValidator());
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(repayEntrys = data.getDynamicObjectCollection("repayplan_entry"))) || repayEntrys.size() == 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8fd8\u6b3e\u8ba1\u5212\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u81ea\u52a8\u8fd8\u6b3e\u3002", (String)"LoanBillAutoRepayValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            String entityName = data.getDynamicObjectType().getName();
            String loanType = data.getString("loantype");
            if ((!"cfm_loanbill_bond".equals(entityName) || LoanTypeEnum.BOND.getValue().equals(loanType)) && ("cfm_loanbill_bond".equals(entityName) || !LoanTypeEnum.BOND.getValue().equals(loanType))) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u540d\u79f0:%1$s\u4e0e\u8d37\u6b3e\u7c7b\u578b%2$s\u4e0d\u5339\u914d\u3002", (String)"LoanBillAutoRepayValidator_02", (String)"tmc-cfm-business", (Object[])new Object[0]), entityName, LoanTypeEnum.getName((String)loanType)));
        }
    }
}

