/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.repository.LoanBillApplyRepository;
import kd.tmc.cfm.common.repository.RepayApplyRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class LoanBillUnAuditOrComfirmValidator
extends AbstractTmcBizOppValidator {
    protected List<ExtendedDataEntity> validateBillHead(ExtendedDataEntity[] dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            if (loanBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getLbSunauditContractInit());
                continue;
            }
            DynamicObject contractBillF7 = loanBill.getDynamicObject("loancontractbill");
            if (EmptyUtil.isNoEmpty((DynamicObject)contractBillF7) && LoanContractStatusEnum.isClosed((String)contractBillF7.getString("contractstatus")) && contractBillF7.getBoolean("ishandend")) {
                this.addErrorMessage(dataEntity, String.format(this.getBizResource(loanBill).getIbUnOpContractByHandEnd(), contractBillF7.getString("number")));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected List<ExtendedDataEntity> validateHasRepayApplyBill(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Map repayApplyBillMap = RepayApplyRepository.getRepayApplyBillByLoanBillIds((List)BusinessHelper.getBillIds(dataEntities));
        if (repayApplyBillMap.isEmpty()) {
            return dataEntities;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            DynamicObject repayApplyBill = (DynamicObject)repayApplyBillMap.get(loanBill.getLong("id"));
            if (EmptyUtil.isNoEmpty((DynamicObject)repayApplyBill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e%1$s\u5df2\u5b58\u5728\u8fd8\u6b3e\u7533\u8bf7\u5355%2$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"loanBillUnConfirmValidator_2", (String)"tmc-cfm-business", (Object[])new Object[]{loanBill.getString("billno"), repayApplyBill.getString("billno")}));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected List<ExtendedDataEntity> validateHasApplyLoanBill(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Map applyLoanBillMap = LoanBillApplyRepository.getApplyLoanBillByLoanBillIds((List)BusinessHelper.getBillIds(dataEntities));
        if (applyLoanBillMap.isEmpty()) {
            return dataEntities;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            DynamicObject loanApply = (DynamicObject)applyLoanBillMap.get(loanBill.getLong("id"));
            if (loanApply != null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e%1$s\u5df2\u5b58\u5728\u53d8\u66f4\u7533\u8bf7\u5355%2$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"loanBillUnConfirmValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{loanBill.getString("billno"), loanApply.getString("billno")}));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected AbstractBizResource getBizResource(DynamicObject bill) {
        return BusinessHelper.getBizResource((DynamicObject)bill);
    }
}

