/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.validate.loanbill.LoanBillSaveValidator;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillUpdateRateResetDaysValidator
extends LoanBillSaveValidator {
    @Override
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("interesttype");
        sic.add("rateadjuststyle");
        sic.add("rateresetdays");
        sic.add("billstatus");
        return sic;
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            int rateResetDays;
            DynamicObject loanBill = dataEntity.getDataEntity();
            List<String> resetDayStyles = Arrays.asList(RateAdjustStyleEnum.CYCLE.getValue(), RateAdjustStyleEnum.AFTERINT.getValue());
            if (!InterestTypeEnum.isFloat((String)loanBill.getString("interesttype")) || !resetDayStyles.contains(loanBill.getString("rateadjuststyle"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6d6e\u52a8\u5229\u7387\u4e0b,\u5229\u7387\u91cd\u7f6e\u65b9\u5f0f\u4e3a\u5468\u671f\u6027\u91cd\u7f6e\u6216\u8005\u7ed3\u606f\u540e\u91cd\u7f6e\u624d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"LoanBillUpdateRateResetDaysValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((Integer)(rateResetDays = loanBill.getInt("rateresetdays")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5229\u7387\u91cd\u7f6e\u504f\u79fb\u5c0f\u4e8e\u7b49\u4e8e0,\u624d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"LoanBillUpdateRateResetDaysValidator_02", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (BillStatusEnum.isAudit((String)loanBill.getString("billstatus"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5ba1\u6838,\u624d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"LoanBillUpdateRateResetDaysValidator_03", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

