/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class LoanPush2PreInstValidator
extends AbstractTmcBizOppValidator {
    public Set<String> preparePropertys() {
        Set sel = super.preparePropertys();
        sel.add("billstatus");
        sel.add("confirmstatus");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!BillStatusEnum.isAudit((String)bill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanPush2PreInstValidator_1.loadKDString());
            }
            if (ConfirmStatusEnum.isYetconfirm((String)bill.getString("confirmstatus"))) continue;
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanPush2PreInstValidator_2.loadKDString());
        }
    }
}

