/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.business.validate.loanbill.LoanBillUnAuditOrComfirmValidator;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class loanBillUnConfirmValidator
extends LoanBillUnAuditOrComfirmValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("contractbillno");
        sic.add("loancontractbill");
        sic.add("ratetype");
        sic.add("ratedeadline");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("rateadjustcycle");
        sic.add("renewalinterestrate");
        sic.add("amount");
        sic.add("drawamount");
        sic.add("interesttype");
        sic.add("referencerate");
        sic.add("clientorg");
        sic.add("repaymentway");
        sic.add("stageplan");
        sic.add("ratetype");
        sic.add("renewalinteresttype");
        sic.add("expiredate");
        sic.add("bizdate");
        sic.add("datasource");
        sic.add("loantype");
        sic.add("loaneracctbank");
        sic.add("accountbank");
        sic.add("productfactory");
        sic.add("ratehistory_entry");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("creditorg");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        sic.add("loancontractbill");
        sic.add("settleintmode");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        String variableValue = (String)this.getOption().getVariables().get("comefrom");
        if ("bizdealbill".equals(variableValue)) {
            return;
        }
        List<ExtendedDataEntity> dataEntityList = this.validateBillHead(dataEntities);
        dataEntityList = this.validateHasApplyLoanBill(dataEntityList);
        dataEntityList = this.validateHasRepayApplyBill(dataEntityList);
        dataEntityList = this.validateHasTargetBill(dataEntityList);
    }

    @Override
    protected List<ExtendedDataEntity> validateBillHead(ExtendedDataEntity[] dataEntities) {
        List<ExtendedDataEntity> dataEntitys = super.validateBillHead(dataEntities);
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntitys.size());
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            boolean isSettleCenter = CreditorTypeEnum.SETTLECENTER.getValue().equals(loanBill.getString("creditortype"));
            if (!isSettleCenter) {
                if (BusinessHelper.isOutGroup((DynamicObject)loanBill)) {
                    this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getUnConfirmOutGroupData());
                    continue;
                }
                if (BusinessHelper.isSameSource((String)loanBill.getDataEntityType().getName(), (String)loanBill.getString("datasource"))) {
                    this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getUnConfirmSameSourceData());
                    continue;
                }
                if (!ConfirmStatusEnum.isYetconfirm((String)loanBill.getString("confirmstatus"))) {
                    this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getConfirmStatusError());
                    continue;
                }
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateHasTargetBill(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List<DynamicObject> loanBills = dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map checkMap = BusinessHelper.checkTargetBillForInnerLoan(loanBills, this.getFilterMap(loanBills));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String msg = (String)checkMap.get(dataEntity.getDataEntity().getLong("id"));
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private Map<String, QFilter> getFilterMap(List<DynamicObject> loanBills) {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(4);
        filterMap.put(CfmEntityEnum.CAS_PAYBILL.getValue(), new QFilter("billstatus", "not in", Arrays.asList("G", "F")));
        QFilter intFilter = new QFilter("instbillctg", "!=", (Object)InterestbillctgEnum.PREPAYINT.getValue());
        Pair intBotpPair = BatchIntBillHelper.getBatchIntBotpPair((String)loanBills.get(0).getString("datasource"));
        filterMap.put((String)intBotpPair.getValue(), intFilter);
        return filterMap;
    }
}

