/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loancontractbill;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class LoanContractBillActiveValidator
extends AbstractTmcBizOppValidator {
    private static final String CHECK_BOND_AMOUNT_FLAG = "checkBondAmount";
    private static final String COMMA_CHAR = ",";

    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("billno");
        sl.add("contractstatus");
        sl.add("datasource");
        sl.add("ishandend");
        return sl;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject contractBill = dataEntity.getDataEntity();
            String cDataSource = contractBill.getString("datasource");
            BizResourceFactory factory = new BizResourceFactory();
            AbstractBizResource cBizResource = factory.getBizResource(cDataSource);
            String contractBillFormId = (String)this.getOption().getVariables().get("CONTRACTBILL_FORMID");
            if (EmptyUtil.isEmpty((String)contractBillFormId)) {
                contractBillFormId = contractBill.getDataEntityType().getName();
            }
            if (!CfmContractBillHelper.isCanOpContract((String)cDataSource, (String)contractBillFormId)) {
                this.addErrorMessage(dataEntity, String.format(cBizResource.checkContractBillsOpSite(), DataSourceEnum.getName((String)cDataSource)));
                continue;
            }
            String billno = contractBill.getString("billno");
            boolean isHandEnd = contractBill.getBoolean("ishandend");
            if (!isHandEnd) {
                this.addErrorMessage(dataEntity, String.format(cBizResource.checkIsHandEndContract(), billno));
            }
            if (!StringUtils.equals((CharSequence)dataEntity.getDataEntity().getDataEntityType().getName(), (CharSequence)"cfm_loancontract_bo")) continue;
            DataSet bondBills = this.getDownLoadBills(dataEntity);
            while (null != bondBills && bondBills.hasNext()) {
                Row bondBill = bondBills.next();
                DynamicObject limit = TmcDataServiceHelper.loadSingle((Object)bondBill.getLong("occupybondlimit"), (String)"bdim_bond_limit", (String)"availamt");
                if (limit.getBigDecimal("availamt").compareTo(bondBill.getBigDecimal("drawamount")) >= 0) continue;
                this.addErrorMessage(dataEntity, String.format(cBizResource.checkBondLimit(), DataSourceEnum.getName((String)cDataSource)));
            }
        }
    }

    private DataSet getDownLoadBills(ExtendedDataEntity contractBill) {
        return QueryServiceHelper.queryDataSet((String)CHECK_BOND_AMOUNT_FLAG, (String)"cfm_loanbill_bond", (String)String.join((CharSequence)COMMA_CHAR, "occupybondlimit", "drawamount"), (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", contractBill.getDataEntity().getPkValue()).and("ishandend", "=", (Object)String.valueOf(BooleanUtils.toInteger((boolean)true))).and("occupybondlimit", ">", (Object)0L)}, (String)"drawamount").groupBy(new String[]{"occupybondlimit"}).sum("drawamount").finish();
    }
}

