/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loancontractbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loantype");
        sic.add("lendernature");
        sic.add("debtor");
        sic.add("debtortype");
        sic.add("textdebtor");
        sic.add("interesttype");
        sic.add("interestrate");
        sic.add("isclientloan");
        sic.add("clientorg");
        sic.add("repaymentway");
        sic.add("stageplan");
        sic.add("bizdate");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("islimitclause");
        sic.add("limitclauseexplain");
        sic.add("rateadjuststyle");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("rateadjustcycle");
        sic.add("rateadjustcycletype");
        sic.add("datasource");
        sic.add("loantype");
        sic.add("loaneracctbank");
        sic.add("accountbank");
        sic.add("productfactory");
        sic.add("iscallint");
        sic.add("referencerate");
        sic.add("settleintmode");
        sic.add("workcalendar");
        sic.add("creditlimit");
        sic.add("creditorg");
        sic.add("creditor");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        sic.add("banksyndicate_entry");
        sic.add("supplychainfin_entry");
        sic.add("tradefin_entry");
        sic.add("e_tf_relatebillno");
        sic.add("e_sc_coreenterprise");
        sic.add("e_bankrole");
        sic.add("e_bank");
        sic.add("e_shareamount");
        sic.add("basis");
        sic.add("term");
        sic.add("finproduct");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkAmountMaxValue(dataEntity);
            this.validate(dataEntity);
            this.validateFloatRate(dataEntity);
            this.validateWithProductFactory(dataEntity);
        }
    }

    protected String getOpVatidateName() {
        return "save";
    }

    protected void validate(ExtendedDataEntity dataEntity) {
        int diffDays;
        DynamicObject contractBill = dataEntity.getDataEntity();
        String dataSource = contractBill.getString("datasource");
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
        String loanType = contractBill.getString("loantype");
        String creditorType = contractBill.getString("creditortype");
        if (LoanTypeEnum.BANKLOAN.getValue().equals(loanType) || LoanTypeEnum.BANKSLOAN.getValue().equals(loanType)) {
            if (CreditorTypeEnum.INNERUNIT.getValue().equals(creditorType) || CreditorTypeEnum.CUSTOM.getValue().equals(creditorType) || CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u501f\u6b3e\u7c7b\u578b\u4e3a\u666e\u901a\u8d37\u6b3e\u6216\u94f6\u56e2\u8d37\u6b3e\uff0c\u503a\u6743\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u5185\u90e8\u5355\u4f4d\u3001\u5ba2\u5546\u6216\u5176\u4ed6\u3002", (String)"LoanContractBillSaveValidator_25", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        } else if ((LoanTypeEnum.ENTRUSTLOAN.getValue().equals(loanType) || LoanTypeEnum.LINKLEND.getValue().equals(loanType)) && (CreditorTypeEnum.BANK.getValue().equals(creditorType) || CreditorTypeEnum.FINORG.getValue().equals(creditorType) || CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u501f\u6b3e\u7c7b\u578b\u4e3a\u59d4\u6258\u8d37\u6b3e\u6216\u4f01\u4e1a\u5f80\u6765\uff0c\u503a\u6743\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u94f6\u884c\u3001\u975e\u94f6\u884c\u91d1\u878d\u673a\u6784\u6216\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"LoanContractBillSaveValidator_26", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (DataSourceEnum.INVEST.getValue().equals(dataSource) && EmptyUtil.isEmpty((DynamicObject)contractBill.getDynamicObject("creditorg"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d37\u6b3e\u5408\u540c\u5bf9\u5e94\u7684\u503a\u6743\u4eba\u5fc5\u586b\u3002", (String)"LoanContractBillSaveValidator_27", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(contractBill.getString("creditortype")) && contractBill.getDataEntityType().getName().equals("cfm_loancontractbill")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u76f4\u63a5\u521b\u5efa\u503a\u6743\u4eba\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u7684\u5408\u540c\u3002", (String)"LoanContractBillSaveValidator_23", (String)"tmc-cfm-business", (Object[])new Object[0]));
            return;
        }
        Date signDate = contractBill.getDate("bizdate");
        BigDecimal contractAmt = contractBill.getBigDecimal("amount");
        if (contractAmt != null && contractAmt.compareTo(BigDecimal.ZERO) < 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"LoanContractBillSaveValidator_02", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        Date startDate = contractBill.getDate("startdate");
        Date endDate = contractBill.getDate("enddate");
        boolean isSubmit = "submit".equals(this.getOpVatidateName());
        if (isSubmit && startDate != null && endDate != null && (diffDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate) - 1) < 1) {
            this.addErrorMessage(dataEntity, bizResource.getCbEnddateMin());
        }
        if (isSubmit && startDate != null && signDate != null && (diffDays = DateUtils.getDiffDays((Date)signDate, (Date)startDate) - 1) < 0) {
            this.addErrorMessage(dataEntity, bizResource.getCbSigndateMin());
        }
        DynamicObject orgDy = contractBill.getDynamicObject("org");
        boolean isAllowManyPush = false;
        if (DataSourceEnum.isCfm((String)dataSource) && EmptyUtil.isNoEmpty((DynamicObject)orgDy)) {
            isAllowManyPush = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.CFM.getId(), (long)orgDy.getLong("id"), (String)"cfm010");
        }
        if (!isAllowManyPush && this.checkLoanApplyHasContract(contractBill)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u5df2\u5b58\u5728\u4e0b\u6e38\u5408\u540c\u3002", (String)"LoanContractBillSaveValidator_04", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    protected void validateFloatRate(ExtendedDataEntity dataEntity) {
        DynamicObject contractBill = dataEntity.getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(contractBill.getString("datasource"));
        Date endDate = contractBill.getDate("enddate");
        Date date = endDate = endDate == null ? null : DateUtils.truncateDate((Date)endDate);
        if (InterestTypeEnum.FLOAT.getValue().equals(contractBill.getString("interesttype"))) {
            BigDecimal rateFloatPoint = contractBill.getBigDecimal("ratefloatpoint");
            if ("submit".equals(this.getOpVatidateName())) {
                if (EmptyUtil.isEmpty((DynamicObject)contractBill.getDynamicObject("referencerate"))) {
                    this.addErrorMessage(dataEntity, bizResource.getReferenceRateNotNull());
                }
                if (EmptyUtil.isEmpty((String)contractBill.getString("rateadjuststyle"))) {
                    this.addErrorMessage(dataEntity, bizResource.getRateAdjustStyleNotNull());
                }
            }
            if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && rateFloatPoint.compareTo(BigDecimal.ZERO) < 0) {
                this.addErrorMessage(dataEntity, bizResource.getRatefloatPointCanNotLessThanZero());
            }
            if (RateAdjustStyleEnum.CYCLE.getValue().equals(contractBill.getString("rateadjuststyle"))) {
                Date rateAdjustDate = contractBill.getDate("rateadjustdate");
                if (EmptyUtil.isNoEmpty((Object)rateAdjustDate) && endDate != null && (rateAdjustDate = DateUtils.truncateDate((Date)rateAdjustDate)).after(endDate)) {
                    this.addErrorMessage(dataEntity, bizResource.getRateadjustDateRange());
                }
                BigDecimal rateAdjustCycle = contractBill.getBigDecimal("rateadjustcycle");
                if ("submit".equals(this.getOpVatidateName()) && EmptyUtil.isEmpty((String)contractBill.getString("rateadjustcycletype"))) {
                    this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleTypeNotNull());
                }
                if (EmptyUtil.isEmpty((BigDecimal)rateAdjustCycle) || rateAdjustCycle.compareTo(BigDecimal.ZERO) == 0) {
                    if ("submit".equals(this.getOpVatidateName())) {
                        this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleNotNull());
                    }
                } else if (rateAdjustCycle.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleCanNotLessThanZero());
                }
            }
        }
    }

    private boolean checkLoanApplyHasContract(DynamicObject contractBill) {
        DynamicObject applyDO = contractBill.getDynamicObject("loanapply");
        if (applyDO == null) {
            return false;
        }
        Object contractPK = contractBill.getPkValue();
        Object applyPK = applyDO.getPkValue();
        QFilter qFilter = new QFilter("loanapply", "=", applyPK);
        if (contractPK != null) {
            qFilter.and(new QFilter("id", "!=", contractPK));
        }
        return TmcDataServiceHelper.exists((String)"cfm_loancontractbill", (QFilter[])qFilter.toArray());
    }

    private void validateWithProductFactory(ExtendedDataEntity dataEntity) {
        DynamicObject contractBill = dataEntity.getDataEntity();
        DynamicObject pfDO = contractBill.getDynamicObject("productfactory");
        if (EmptyUtil.isEmpty((DynamicObject)pfDO)) {
            return;
        }
        this.validatePFBasis(dataEntity, contractBill);
        this.checkCreditlimitByProduct(dataEntity);
    }

    private void validatePFBasis(ExtendedDataEntity dataEntity, DynamicObject contractBill) {
        DynamicObject pfDO = contractBill.getDynamicObject("productfactory");
        String contractBasis = contractBill.getString("basis");
        if (!pfDO.getBoolean("iscallint")) {
            return;
        }
        if (EmptyUtil.isEmpty((String)contractBasis) && "submit".equals(this.getOpVatidateName())) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u606f\u57fa\u51c6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanContractBillSaveValidator_19", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void checkAmountMaxValue(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        for (IDataEntityProperty prop : bill.getDataEntityType().getProperties()) {
            if (!(prop instanceof AmountProp) || bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0) continue;
            this.addErrorMessage(data, new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
        }
    }

    private void checkCreditlimitByProduct(ExtendedDataEntity data) {
        DynamicObject contractBill = data.getDataEntity();
        DynamicObject proDuctory = contractBill.getDynamicObject("productfactory");
        DynamicObject creditLimit = contractBill.getDynamicObject("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)proDuctory) && EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u878d\u8d44\u6a21\u578b\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301\u5173\u8054\u6388\u4fe1\u3002", (String)"LoanContractBillSaveValidator_28", (String)"tmc-cfm-business", (Object[])new Object[0]));
            return;
        }
        boolean isLoanComit = proDuctory.getBoolean("isloancommit");
        if (!isLoanComit && EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u878d\u8d44\u6a21\u578b\u4e2d\u7684\u3010\u5408\u540c\u5360\u7528\u6388\u4fe1\u3011\u4e3a\u5426\uff0c\u4e0d\u652f\u6301\u5173\u8054\u6388\u4fe1\u3002", (String)"LoanContractBillSaveValidator_29", (String)"tmc-cfm-business", (Object[])new Object[0]));
            return;
        }
        String creditorType = contractBill.getString("creditortype");
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            return;
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            boolean isInvest = "cim_invest_contract".equals(contractBill.getDynamicObjectType().getName());
            if (isInvest) {
                creditorType = contractBill.getString("debtortype");
            }
            if (CreditorTypeEnum.CUSTOM.getValue().equals(creditorType) || CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u503a\u6743\u4eba\u7c7b\u578b\u4e3a\u5ba2\u5546\u6216\u5176\u4ed6\uff0c\u4e0d\u652f\u6301\u5173\u8054\u6388\u4fe1\u3002", (String)"LoanContractBillSaveValidator_34", (String)"tmc-cfm-business", (Object[])new Object[0]));
                return;
            }
            DynamicObject finProduct = contractBill.getDynamicObject("finproduct");
            DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)contractBill.getLong("id"), (String)contractBill.getDataEntityType().getName());
            if (EmptyUtil.isEmpty((DynamicObject)creditUseBill)) {
                Object creditLimitBankCateId;
                Object useBankCateId;
                CreditLimitUseBean bean = new CreditLimitUseBean();
                bean.setPkId(Long.valueOf(contractBill.getLong("id")));
                DynamicObject credittype = finProduct != null ? finProduct.getDynamicObject("credittype") : null;
                DynamicObject org = contractBill.getDynamicObject("org");
                String billStatus = creditLimit.getString("status");
                if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"LoanContractBillSaveValidator_31", (String)"tmc-cfm-business", (Object[])new Object[0]));
                    return;
                }
                boolean isClose = creditLimit.getBoolean("isclose");
                if (isClose) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355\u5df2\u5173\u95ed\u3002", (String)"LoanContractBillSaveValidator_32", (String)"tmc-cfm-business", (Object[])new Object[0]));
                    return;
                }
                DynamicObject creditOrg = contractBill.getDynamicObject("creditorg");
                long creditorId = contractBill.getLong("creditor");
                if (isInvest && EmptyUtil.isNoEmpty((DynamicObject)creditOrg)) {
                    creditorId = creditOrg.getLong("id");
                }
                if (!(useBankCateId = CreditLimitHelper.getBankCateIdByFinOrgId((Long)creditorId)).equals(creditLimitBankCateId = CreditLimitHelper.getBankCateIdByFinOrgId((Long)((Long)creditLimit.getDynamicObject("bank").getPkValue())))) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u503a\u6743\u4eba\u548c\u6388\u4fe1\u673a\u6784\u5bf9\u5e94\u7684\u94f6\u884c\u7c7b\u522b\u4e0d\u5339\u914d\u3002", (String)"LoanContractBillSaveValidator_33", (String)"tmc-cfm-business", (Object[])new Object[0]));
                    return;
                }
                bean.setCreditTypeId(Long.valueOf(credittype != null ? credittype.getLong("id") : 0L));
                bean.setOrgId(Long.valueOf(isInvest ? contractBill.getLong("debtor") : org.getLong("id")));
                bean.setCurrencyId(Long.valueOf(contractBill.getDynamicObject("currency").getLong("id")));
                bean.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
                bean.setBizAmt(contractBill.getBigDecimal("amount"));
                bean.setSourceBillId(bean.getPkId());
                bean.setSourceType(contractBill.getDataEntityType().getName());
                bean.setCreditRatio(Constants.ONE_HUNDRED);
                CreditLimitF7ResBean result = CreditLimitServiceHelper.validataCreditLimitAmt((CreditLimitUseBean)bean);
                if (!result.getSuccess().booleanValue()) {
                    this.addErrorMessage(data, result.getMsg());
                }
            }
        }
    }
}

