/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loancontractbill;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.validate.loancontractbill.LoanContractBillSaveValidator;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.GuaranteeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.DefaultProductFactoryHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractBillSubmitValidator
extends LoanContractBillSaveValidator {
    @Override
    public List<String> getSelector() {
        List<String> sic = super.getSelector();
        sic.add("loantype");
        sic.add("lendernature");
        sic.add("debtor");
        sic.add("debtortype");
        sic.add("textdebtor");
        sic.add("interesttype");
        sic.add("interestrate");
        sic.add("isclientloan");
        sic.add("clientorg");
        sic.add("repaymentway");
        sic.add("stageplan");
        sic.add("bizdate");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("islimitclause");
        sic.add("limitclauseexplain");
        sic.add("rateadjuststyle");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("rateadjustcycle");
        sic.add("rateadjustcycletype");
        sic.add("datasource");
        sic.add("loantype");
        sic.add("loaneracctbank");
        sic.add("accountbank");
        sic.add("productfactory");
        sic.add("iscallint");
        sic.add("referencerate");
        sic.add("settleintmode");
        sic.add("workcalendar");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("creditorg");
        sic.add("textcreditor");
        sic.add("creditlimit");
        sic.add("repaymentway");
        sic.add("interestsettledplan");
        sic.add("basis");
        sic.add("interestsettledplan");
        sic.add("guarantee");
        sic.add("entry_gcontract");
        sic.add("gcontract");
        sic.add("issyncdraw");
        sic.add("amount");
        sic.add("syncdrawamount");
        sic.add("expiredate");
        sic.add("syncdrawdate");
        sic.add("startintdate");
        sic.add("fixedrepayamount");
        sic.add("e_loanamount");
        return sic;
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validate(dataEntity);
        }
    }

    @Override
    protected void validate(ExtendedDataEntity dataEntity) {
        DynamicObject loanContract;
        super.validate(dataEntity);
        super.validateFloatRate(dataEntity);
        this.validateMustInput(dataEntity);
        DynamicObject contractBill = dataEntity.getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(contractBill.getString("datasource"));
        Boolean isLimitClause = contractBill.getBoolean("islimitclause");
        String limitClauseExplain = contractBill.getString("limitclauseexplain");
        if (isLimitClause.booleanValue() && StringUtils.isBlank((CharSequence)limitClauseExplain)) {
            this.addErrorMessage(dataEntity, bizResource.getCbIslimitCheck());
        }
        this.checkLimitValidate(dataEntity);
        this.checkLimitGuaranteeUseValidate(dataEntity);
        this.validateCreditorDebtor(dataEntity, contractBill, bizResource);
        if (BizTypeEnum.ENTRUST.getValue().equals(contractBill.getString("loantype")) && EmptyUtil.isEmpty((DynamicObject)contractBill.getDynamicObject("clientorg"))) {
            this.addErrorMessage(dataEntity, bizResource.getCbClientorgNotNull());
        }
        if (!(loanContract = dataEntity.getDataEntity()).containsProperty("issyncdraw") || !loanContract.getBoolean("issyncdraw")) {
            this.loanContractGuaranteeTip(dataEntity);
        }
        this.validateSyncDrawInfo(dataEntity);
    }

    private void checkLimitGuaranteeUseValidate(ExtendedDataEntity dataEntity) {
        DynamicObject contractBill = dataEntity.getDataEntity();
        String loanType = contractBill.getString("loantype");
        HashSet<Long> creditLimitIdSet = new HashSet<Long>(10);
        if (LoanTypeEnum.isBanksLoan((String)loanType)) {
            creditLimitIdSet.addAll(contractBill.getDynamicObjectCollection("banksyndicate_entry").stream().filter(f -> EmptyUtil.isNoEmpty((DynamicObject)f.getDynamicObject("e_creditlimit"))).map(o -> o.getDynamicObject("e_creditlimit").getLong("id")).collect(Collectors.toSet()));
        } else if (EmptyUtil.isNoEmpty((DynamicObject)contractBill.getDynamicObject("creditlimit"))) {
            creditLimitIdSet.add(contractBill.getDynamicObject("creditlimit").getLong("id"));
        }
        DynamicObjectCollection guaranteeUseBills = GuaranteeUseHelper.getGuaranteeUseBills(creditLimitIdSet);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaranteeUseBills)) {
            return;
        }
        DynamicObjectCollection gcUseEntry = contractBill.getDynamicObjectCollection("entry_gcontract");
        HashSet contractIdSet = new HashSet(16);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)gcUseEntry)) {
            contractIdSet.addAll(gcUseEntry.stream().map(o -> o.getDynamicObject("gcontract").getLong("id")).collect(Collectors.toSet()));
        } else {
            gcUseEntry = this.getGuaranteeUseFromDb(contractBill.getLong("id"));
            contractIdSet.addAll(gcUseEntry.stream().map(o -> o.getLong("gcontract")).collect(Collectors.toSet()));
        }
        if (contractIdSet.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6388\u4fe1\u5355\u5173\u8054\u7684\u989d\u5ea6\u62c5\u4fdd\u4fe1\u606f\u5df2\u88ab\u6e05\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6388\u4fe1\u5355\u3002", (String)"LoanContractBillSubmitValidator_17", (String)"tmc-cfm-business", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject guaranteeUseBill : guaranteeUseBills) {
            if (contractIdSet.contains(guaranteeUseBill.getLong("gcontract"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6388\u4fe1\u5355\u5173\u8054\u7684\u989d\u5ea6\u62c5\u4fdd\u4fe1\u606f\u5df2\u88ab\u6e05\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6388\u4fe1\u5355\u3002", (String)"LoanContractBillSubmitValidator_17", (String)"tmc-cfm-business", (Object[])new Object[0]));
            break;
        }
    }

    private void checkLimitValidate(ExtendedDataEntity dataEntity) {
        DynamicObject contractBill = dataEntity.getDataEntity();
        String loanType = contractBill.getString("loantype");
        if (CfmContractBillHelper.mustUseCreditLimit((DynamicObject)contractBill)) {
            if (LoanTypeEnum.isBanksLoan((String)loanType)) {
                DynamicObjectCollection entrys = contractBill.getDynamicObjectCollection("banksyndicate_entry");
                for (DynamicObject entry : entrys) {
                    DynamicObject creditlimit = entry.getDynamicObject("e_creditlimit");
                    if (!EmptyUtil.isEmpty((DynamicObject)creditlimit)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u4e2d\u7684\u5360\u7528\u6388\u4fe1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanContractBillSubmitValidator_14", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
            } else {
                DynamicObject creditLimitDO = contractBill.getDynamicObject("creditlimit");
                if (EmptyUtil.isEmpty((DynamicObject)creditLimitDO)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6388\u4fe1\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanContractBillSubmitValidator_02", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
            }
        }
        DynamicObject productFactory = contractBill.getDynamicObject("productfactory");
        if (!(LoanTypeEnum.isFinLease((String)loanType) || !EmptyUtil.isEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit"))) {
            DynamicObjectCollection bankCateEntrys;
            Set entry;
            boolean isSynDraw;
            DynamicObject creditLimit = contractBill.getDynamicObject("creditlimit");
            if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u878d\u8d44\u6a21\u578b\u4e3a\u7a7a\u6216\u878d\u8d44\u6a21\u578b\u4e2d\u7684\u5408\u540c\u5360\u7528\u6388\u4fe1\u4e3a\u5426\uff0c\u5408\u540c\u6388\u4fe1\u5b57\u6bb5\u4e0d\u80fd\u6709\u503c\u3002", (String)"LoanContractBillSubmitValidator_15", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (!(isSynDraw = contractBill.getBoolean("issyncdraw")) && EmptyUtil.isNoEmpty(entry = (bankCateEntrys = contractBill.getDynamicObjectCollection("banksyndicate_entry")).stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_creditlimit"))).collect(Collectors.toSet()))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u878d\u8d44\u6a21\u578b\u4e3a\u7a7a\u6216\u878d\u8d44\u6a21\u578b\u4e2d\u7684\u5408\u540c\u5360\u7528\u6388\u4fe1\u4e3a\u5426\uff0c\u94f6\u56e2\u4fe1\u606f\u4e2d\u7684\u5360\u7528\u6388\u4fe1\u5b57\u6bb5\u4e0d\u80fd\u6709\u503c\u3002", (String)"LoanContractBillSubmitValidator_16", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }

    private void loanContractGuaranteeTip(ExtendedDataEntity dataEntity) {
        DynamicObject loanContract = dataEntity.getDataEntity();
        String guarantee = loanContract.getString("guarantee");
        if (guarantee.contains(GuaranteeEnum.ENSURE.getValue()) || guarantee.contains(GuaranteeEnum.MORTGAGE.getValue()) || guarantee.contains(GuaranteeEnum.PLEDGE.getValue())) {
            DynamicObjectCollection gcUseEntry = this.getGuaranteeUseFromDb(loanContract.getLong("id"));
            List gcUseEntryList = gcUseEntry.stream().filter(o -> BigDecimal.ZERO.compareTo(o.getBigDecimal("gratio")) != 0).collect(Collectors.toList());
            String entityName = loanContract.getDynamicObjectType().getName();
            if (!this.isRelateDebt(loanContract)) {
                return;
            }
            if (EmptyUtil.isNoEmpty(gcUseEntryList)) {
                return;
            }
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"fl_leasecontractbill") && EmptyUtil.isEmpty(gcUseEntryList)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e3a\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u8bf7\u5148\u586b\u5199\u62c5\u4fdd\u4fe1\u606f\u3002", (String)"LoanContractBillSubmitValidator_12", (String)"tmc-cfm-business", (Object[])new Object[0]));
            } else if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"cfm_loancontractbill") || StringUtils.equals((CharSequence)entityName, (CharSequence)"cim_invest_contract") || StringUtils.equals((CharSequence)entityName, (CharSequence)"ifm_loancontractbill")) && EmptyUtil.isEmpty((DynamicObjectCollection)loanContract.getDynamicObjectCollection("entry_gcontract"))) {
                this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u53c2\u6570\u503a\u52a1\u5fc5\u987b\u5173\u8054\u62c5\u4fdd\u4e3a\u662f\uff0c\u76ee\u524d\u5408\u540c\u7684\u62c5\u4fdd\u4fe1\u606f\u4e3a\u7a7a\uff0c\u540e\u7eed\u7684\u63d0\u6b3e\u73af\u8282\u9700\u8981\u9009\u62e9\u5e26\u6709\u62c5\u4fdd\u5408\u540c\u7684\u6388\u4fe1\u989d\u5ea6\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\uff1f", (String)"LoanContractBillSubmitValidator_08", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }

    private DynamicObjectCollection getGuaranteeUseFromDb(Long loanContractId) {
        if (EmptyUtil.isEmpty((Long)loanContractId)) {
            return new DynamicObjectCollection();
        }
        QFilter idFilter = new QFilter("gsrcbillid", "=", (Object)loanContractId);
        return QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcontract", "gsrcbillid", "gratio"), (QFilter[])new QFilter[]{idFilter});
    }

    private boolean isRelateDebt(DynamicObject bizBill) {
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.GM.getId(), (long)bizBill.getDynamicObject(EntityMetadataCache.getDataEntityType((String)bizBill.getDataEntityType().getName()).getMainOrg()).getLong("id"), (String)"isrelatedebt");
    }

    private void validateMustInput(ExtendedDataEntity dataEntity) {
        DynamicObject contractBill = dataEntity.getDataEntity();
        DynamicObject pfDO = DefaultProductFactoryHelper.getProductFactoryOrDefault((DynamicObject)contractBill);
        if (pfDO.getBoolean("iscallint")) {
            String interestType;
            if (EmptyUtil.isEmpty((String)contractBill.getString("settleintmode"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ed3\u606f\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanContractBillSubmitValidator_05", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)(interestType = contractBill.getString("interesttype")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5229\u7387\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanContractBillSubmitValidator_7", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
        this.validateByRepaymentWay(dataEntity, pfDO);
    }

    private void validateByRepaymentWay(ExtendedDataEntity dataEntity, DynamicObject pfDO) {
        ArrayList repayWays;
        BigDecimal interestRate;
        DynamicObject contractBill = dataEntity.getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(contractBill.getString("datasource"));
        String repaymentWay = contractBill.getString("repaymentway");
        if ((EmptyUtil.isEmpty((DynamicObject)pfDO) || pfDO.getBoolean("iscallint")) && EmptyUtil.isNoEmpty((BigDecimal)(interestRate = contractBill.getBigDecimal("interestrate"))) && RepaymentWayEnum.isZdyhk((String)repaymentWay)) {
            DynamicObject settleIntPlan = contractBill.getDynamicObject("interestsettledplan");
            String settleMode = contractBill.getString("settleintmode");
            if (SettleIntModeEnum.gdpljx.getValue().equals(settleMode) && EmptyUtil.isEmpty((DynamicObject)settleIntPlan)) {
                this.addErrorMessage(dataEntity, bizResource.getInterestSettledPlanNotNull());
            }
        }
        if ((repayWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue()})).contains(repaymentWay) && EmptyUtil.isEmpty((DynamicObject)contractBill.getDynamicObject("stageplan"))) {
            this.addErrorMessage(dataEntity, bizResource.getStagePlanNotNull());
        }
    }

    private void validateCreditorDebtor(ExtendedDataEntity dataEntity, DynamicObject contractBill, AbstractBizResource bizResource) {
        String entityName = contractBill.getDynamicObjectType().getName();
        if ("cim_invest_contract".equals(entityName)) {
            this.validateDebtor(dataEntity, contractBill, bizResource);
            DynamicObject loanerAcctBank = contractBill.getDynamicObject("loaneracctbank");
            if (EmptyUtil.isEmpty((DynamicObject)loanerAcctBank)) {
                this.addErrorMessage(dataEntity, bizResource.getContractLoanerAcctBankNotNull());
            }
        } else if ("cfm_loancontractbill".equals(entityName)) {
            this.validateCreditor(dataEntity, contractBill, bizResource);
            DynamicObject accountBank = contractBill.getDynamicObject("accountbank");
            String loantype = contractBill.getString("loantype");
            boolean isSyncDraw = contractBill.getBoolean("issyncdraw");
            if (EmptyUtil.isEmpty((DynamicObject)accountBank) && (!LoanTypeEnum.isBankLoan((String)loantype) || isSyncDraw)) {
                this.addErrorMessage(dataEntity, bizResource.getContractAcctBankNotNull());
            }
        } else if ("ifm_loancontractbill".equals(entityName)) {
            boolean isSyncDraw = contractBill.getBoolean("issyncdraw");
            DynamicObject accountBank = contractBill.getDynamicObject("accountbank");
            if (isSyncDraw && EmptyUtil.isEmpty((DynamicObject)accountBank)) {
                this.addErrorMessage(dataEntity, bizResource.getContractAcctBankNotNull());
            }
        }
    }

    private void validateDebtor(ExtendedDataEntity dataEntity, DynamicObject contractBill, AbstractBizResource bizResource) {
        String debtorName = contractBill.getString("textdebtor");
        if (EmptyUtil.isEmpty((String)contractBill.getString("textdebtor"))) {
            this.addErrorMessage(dataEntity, bizResource.getLoanFundOrgNotNull());
        } else {
            String bdTypeEntity;
            Long debtorId;
            DynamicObject baseDO;
            String bdName;
            String creditorType = contractBill.getString("debtortype");
            if (!CreditorTypeEnum.OTHER.getValue().equals(creditorType) && !debtorName.equals(bdName = (baseDO = TmcDataServiceHelper.loadSingle((Object)(debtorId = Long.valueOf(contractBill.getLong("debtor"))), (String)(bdTypeEntity = CreditorTypeEnum.valueOf((String)creditorType.toUpperCase()).getFormId()))).getString("name"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u501f\u6b3e\u4eba\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u501f\u6b3e\u4eba\u3002", (String)"LoanContractBillSubmitValidator_04", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateCreditor(ExtendedDataEntity dataEntity, DynamicObject contractBill, AbstractBizResource bizResource) {
        if (!LoanTypeEnum.isBanksLoan((String)contractBill.getString("loantype"))) {
            String creditorName = contractBill.getString("textcreditor");
            if (EmptyUtil.isEmpty((String)contractBill.getString("textcreditor"))) {
                this.addErrorMessage(dataEntity, bizResource.getCreditorCanNotNull());
            } else {
                String bdTypeEntity;
                Long creditorId;
                DynamicObject baseDO;
                String bdName;
                String creditorType = contractBill.getString("creditortype");
                if (!CreditorTypeEnum.OTHER.getValue().equals(creditorType) && !creditorName.equals(bdName = (baseDO = TmcDataServiceHelper.loadSingle((Object)(creditorId = Long.valueOf(contractBill.getLong("creditor"))), (String)(bdTypeEntity = CreditorTypeEnum.valueOf((String)creditorType.toUpperCase()).getFormId()), (String)"name")).getString("name"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u503a\u6743\u4eba\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u503a\u6743\u4eba\u3002", (String)"LoanContractBillSubmitValidator_03", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected String getOpVatidateName() {
        return "submit";
    }

    private void validateSyncDrawInfo(ExtendedDataEntity dataEntity) {
        DynamicObject creditLimit;
        BigDecimal fixedRepayAmount;
        String loanType;
        DynamicObject loanContract = dataEntity.getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanContract.getString("datasource"));
        String entityName = loanContract.getDynamicObjectType().getName();
        if (!("cfm_loancontractbill".equals(entityName) || "cim_invest_contract".equals(entityName) || "fl_leasecontractbill".equals(entityName))) {
            return;
        }
        boolean isSyncDraw = loanContract.getBoolean("issyncdraw");
        if (!isSyncDraw) {
            return;
        }
        BigDecimal amount = loanContract.getBigDecimal("amount");
        BigDecimal syncDrawAmount = loanContract.getBigDecimal("syncdrawamount");
        if (syncDrawAmount.compareTo(BigDecimal.ZERO) <= 0) {
            this.addErrorMessage(dataEntity, bizResource.getDrawAmtLessThanZero());
        }
        if (syncDrawAmount.compareTo(amount) > 0) {
            this.addErrorMessage(dataEntity, bizResource.getDrawAmtLargeThanAmt());
        }
        if (LoanTypeEnum.isBanksLoan((String)(loanType = loanContract.getString("loantype")))) {
            DynamicObjectCollection bankCateEntrys = loanContract.getDynamicObjectCollection("banksyndicate_entry");
            BigDecimal totalLoanAmount = bankCateEntrys.stream().map(o -> o.getBigDecimal("e_loanamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (syncDrawAmount.compareTo(totalLoanAmount) != 0) {
                this.addErrorMessage(dataEntity, bizResource.getDrawAmtNotEqLoanAmt());
            }
            for (int i = 0; i < bankCateEntrys.size(); ++i) {
                DynamicObject bankCateEntry = (DynamicObject)bankCateEntrys.get(i);
                BigDecimal shareAmount = bankCateEntry.getBigDecimal("e_shareamount");
                BigDecimal loanAmount = bankCateEntry.getBigDecimal("e_loanamount");
                if (loanAmount.compareTo(shareAmount) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(bizResource.getDrawAmtNotlargeConamt(), i + 1));
            }
        }
        Date expireDate = loanContract.getDate("expiredate");
        Date syncDrawDate = loanContract.getDate("syncdrawdate");
        Date startDate = loanContract.getDate("startdate");
        Date startIntDate = loanContract.getDate("startintdate");
        if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)startIntDate) && expireDate.before(startIntDate)) {
            this.addErrorMessage(dataEntity, bizResource.getStartInstDateLessThanEndDate());
        }
        if (EmptyUtil.isNoEmpty((Object)syncDrawDate) && EmptyUtil.isNoEmpty((Object)startDate) && syncDrawDate.before(startDate)) {
            this.addErrorMessage(dataEntity, bizResource.getDrawDateLessThanStartDate());
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)(fixedRepayAmount = loanContract.getBigDecimal("fixedrepayamount"))) && fixedRepayAmount.compareTo(syncDrawAmount) > 0) {
            this.addErrorMessage(dataEntity, bizResource.getPayAmtLargeThanDrawAmt());
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(creditLimit = loanContract.getDynamicObject("synccreditlimit")))) {
            DynamicObjectCollection guaranteeUseBills = GuaranteeUseHelper.getGuaranteeUseBills((Long)creditLimit.getLong("id"));
            DynamicObjectCollection gcUseEntry = loanContract.getDynamicObjectCollection("entry_gcontract");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)gcUseEntry)) {
                gcUseEntry = this.getGuaranteeUseFromDb(loanContract.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)guaranteeUseBills) && EmptyUtil.isEmpty((DynamicObjectCollection)gcUseEntry)) {
                this.addErrorMessage(dataEntity, bizResource.checkGuaranteeEntry());
            }
        }
    }
}

