/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loancontractbill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LenderNatureEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class LoanContractBillUnConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("datasource");
        sic.add("billstatus");
        sic.add("contractstatus");
        sic.add("confirmstatus");
        sic.add("creditorg");
        sic.add("org");
        sic.add("productfactory");
        sic.add("rateadjustcycletype");
        sic.add("creditortype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String dataSource;
            String checkTargetBillsMsg;
            DynamicObject bizBill = dataEntity.getDataEntity();
            String entityName = bizBill.getDataEntityType().getName();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
            if (bizBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, bizResource.getUnConfirmInitData());
                continue;
            }
            if (bizBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, bizResource.getUnConfirmInitData());
                continue;
            }
            String confirmstatus = bizBill.getString("confirmstatus");
            if (!StringUtils.equals((CharSequence)ConfirmStatusEnum.YETCONFIRM.getValue(), (CharSequence)confirmstatus)) {
                this.addErrorMessage(dataEntity, bizResource.getConfirmStatusError());
            }
            String contractStatus = bizBill.getString("contractstatus");
            if (!StringUtils.equals((CharSequence)LoanContractStatusEnum.REGISTERED.getValue(), (CharSequence)contractStatus)) {
                this.addErrorMessage(dataEntity, bizResource.getCbUnConfirmContractStatus());
            }
            if (StringUtils.isNotBlank((CharSequence)(checkTargetBillsMsg = BusinessHelper.checkTargetBills((String)entityName, (Long)bizBill.getLong("id"))))) {
                this.addErrorMessage(dataEntity, checkTargetBillsMsg);
            }
            String creditorType = bizBill.getString("creditortype");
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) continue;
            String lendernature = bizBill.getString("lendernature");
            if (StringUtils.equals((CharSequence)LenderNatureEnum.OUTGROUP.getValue(), (CharSequence)lendernature)) {
                this.addErrorMessage(dataEntity, bizResource.getUnConfirmOutGroupData());
            }
            if (!BusinessHelper.isSameSource((String)entityName, (String)(dataSource = bizBill.getString("datasource")))) continue;
            this.addErrorMessage(dataEntity, bizResource.getUnConfirmSameSourceData());
        }
    }
}

