/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loancontractbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DrawWayEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractDrawPlanSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("startdate");
        sic.add("enddate");
        sic.add("renewalexpiredate");
        sic.add("issyncdraw");
        sic.add("iscycleloan");
        sic.add("amount");
        sic.add("currency");
        sic.add("loantype");
        sic.add("datasource");
        sic.add("drawdownplan_entry");
        sic.add("drawdownplan_entry.seq");
        sic.add("drawdownplan_entry.e_plandrawdate");
        sic.add("drawdownplan_entry.e_plandrawamt");
        sic.add("drawdownplan_entry.e_drawstate");
        sic.add("drawdownplan_entry.e_drawacctbank");
        sic.add("drawdownplan_entry.e_drawmodifier");
        sic.add("drawdownplan_entry.e_drawmodifytime");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject contractBill = dataEntity.getDataEntity();
            String loanType = contractBill.getString("loantype");
            if (BizTypeEnum.isBond((String)loanType) || BizTypeEnum.isFinLease((String)loanType)) {
                return;
            }
            DynamicObjectCollection drawPlanEntry = contractBill.getDynamicObjectCollection("drawdownplan_entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)drawPlanEntry) || (Long)contractBill.getPkValue() == 0L) {
                return;
            }
            String drawWay = contractBill.getString("drawway");
            if (DrawWayEnum.ONCE.getValue().equals(drawWay) && drawPlanEntry.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u6b3e/\u653e\u6b3e\u65b9\u5f0f\u4e3a\u4e00\u6b21\u6027\uff0c\u53ea\u80fd\u6709\u4e00\u7b14\u8ba1\u5212\u3002", (String)"LoanContractDrawPlanSaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
                return;
            }
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(contractBill.getString("datasource"));
            this.checkDrawDateAmount(dataEntity, contractBill, drawPlanEntry, bizResource);
            this.checkSyncDrawDateAmount(dataEntity, contractBill, drawPlanEntry, bizResource);
        }
    }

    private void checkDrawDateAmount(ExtendedDataEntity dataEntity, DynamicObject contractBill, DynamicObjectCollection drawPlanEntry, AbstractBizResource bizResource) {
        Date contractStartDate = contractBill.getDate("startdate");
        Date contractEndDate = contractBill.getDate("enddate");
        Date renewalExpiredate = contractBill.getDate("renewalexpiredate");
        if (EmptyUtil.isNoEmpty((Object)renewalExpiredate)) {
            contractEndDate = renewalExpiredate;
        }
        BigDecimal sumDrawAmount = BigDecimal.ZERO;
        for (int i = 0; i < drawPlanEntry.size(); ++i) {
            BigDecimal planDrawAmt;
            DynamicObject drawPlan = (DynamicObject)drawPlanEntry.get(i);
            Date planDrawDate = drawPlan.getDate("e_plandrawdate");
            if (EmptyUtil.isEmpty((Object)planDrawDate)) {
                this.addErrorMessage(dataEntity, bizResource.getPlanDrawDateNull());
                return;
            }
            if (planDrawDate.before(contractStartDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getPlanDrawDateMin(), DateUtils.formatString((Date)contractStartDate, (String)"yyyy-MM-dd")));
            }
            if (EmptyUtil.isNoEmpty((Object)contractEndDate) && planDrawDate.after(contractEndDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getPlanDrawDateMax(), DateUtils.formatString((Date)contractEndDate, (String)"yyyy-MM-dd")));
            }
            if (EmptyUtil.isEmpty((BigDecimal)(planDrawAmt = drawPlan.getBigDecimal("e_plandrawamt"))) || planDrawAmt.compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(dataEntity, bizResource.getPlanDrawAmountNull());
            }
            sumDrawAmount = sumDrawAmount.add(planDrawAmt);
        }
        if (!contractBill.getBoolean("iscycleloan") && sumDrawAmount.compareTo(contractBill.getBigDecimal("amount")) > 0) {
            this.addErrorMessage(dataEntity, bizResource.getSumPlanDrawAmountMax());
        }
    }

    private void checkSyncDrawDateAmount(ExtendedDataEntity dataEntity, DynamicObject contractBill, DynamicObjectCollection drawPlanEntry, AbstractBizResource bizResource) {
        boolean isSyncDraw = contractBill.getBoolean("issyncdraw");
        if (isSyncDraw) {
            Date drawDate = contractBill.getDate("syncdrawdate");
            BigDecimal drawAmount = contractBill.getBigDecimal("syncdrawamount");
            boolean isSyncDrawPlan = false;
            int size = drawPlanEntry.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject drawPlan = (DynamicObject)drawPlanEntry.get(i);
                Date planDrawDate = drawPlan.getDate("e_plandrawdate");
                BigDecimal planDrawAmt = drawPlan.getBigDecimal("e_plandrawamt");
                if (!EmptyUtil.isNoEmpty((Object)drawDate) || !EmptyUtil.isNoEmpty((Object)planDrawDate) || drawDate.compareTo(planDrawDate) != 0 || drawAmount.compareTo(planDrawAmt) != 0) continue;
                isSyncDrawPlan = true;
                break;
            }
            if (!isSyncDrawPlan) {
                this.addErrorMessage(dataEntity, bizResource.getSyncDrawPlanNull());
            }
        }
    }
}

