/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loancontractbill;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractTradeSaveOrSubValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradefin_entry");
        selector.add("tradefin_entry.e_tf_relatebillid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            Set relateSet;
            DynamicObject contract = extData.getDataEntity();
            DynamicObjectCollection tradeEntry = contract.getDynamicObjectCollection("tradefin_entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)tradeEntry) || !EmptyUtil.isNoEmpty(relateSet = tradeEntry.stream().map(r -> r.getLong("e_tf_relatebillid")).filter(r -> EmptyUtil.isNoEmpty((Long)r)).collect(Collectors.toSet()))) continue;
            QFilter qFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and("id", "!=", contract.getPkValue());
            qFilter.and("tradefin_entry.e_tf_relatebillid", "in", relateSet);
            DynamicObjectCollection existCols = QueryServiceHelper.query((String)contract.getDataEntityType().getName(), (String)"billno", (QFilter[])new QFilter[]{qFilter}, (String)"");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)existCols)) continue;
            List existBills = existCols.stream().map(r -> r.getString("billno")).collect(Collectors.toList());
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u4ea4\u5355\u6216\u5230\u5355\u5df2\u88ab\u5176\u4ed6\u5408\u540c\u201c%s\u201d\u5173\u8054\u3002", (String)"LoanContractTradeSaveOrSubValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{String.join((CharSequence)",", existBills)}));
        }
    }
}

