/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.preinterestbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.CurrentBizTypeEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstBillCorrectValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("confirmstatus");
        selector.add("writeoffstatus");
        selector.add("nowriteoffamt");
        selector.add("operatetype");
        selector.add("org");
        selector.add("creditortype");
        selector.add("creditorg");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String confirmType = (String)this.getOption().getVariables().get("confirmtype");
        String dataStr = (String)this.getOption().getVariables().get("param_preintbillids");
        Map dataMap = EmptyUtil.isNoEmpty((String)dataStr) ? (Map)JSON.parseObject((String)dataStr, Map.class) : Collections.emptyMap();
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            this.validateBizInfo(extendedDataEntity);
            this.validateAmt(extendedDataEntity, dataMap, confirmType);
        }
    }

    private void validateBizInfo(ExtendedDataEntity extendedDataEntity) {
        DynamicObject preInstBill = extendedDataEntity.getDataEntity();
        boolean result = BillStatusEnum.isAudit((String)preInstBill.getString("billstatus"));
        if (result) {
            String operateType = preInstBill.getString("operatetype");
            result = StringUtils.equals((CharSequence)operateType, (CharSequence)CurrentBizTypeEnum.PREINT.getValue());
        }
        if (result) {
            String confirmStatus = preInstBill.getString("confirmstatus");
            result = ConfirmStatusEnum.isYetconfirm((String)confirmStatus);
        }
        if (result) {
            String writeOffStatus = preInstBill.getString("writeoffstatus");
            boolean bl = result = !WriteOffStatusEnum.isCompleteWriteOff((String)writeOffStatus);
        }
        if (!result) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u9884\u63d0\u5229\u606f\u3001\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u3001\u786e\u8ba4\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4\u3001\u51b2\u9500\u72b6\u6001\u4e3a\u672a\u51b2\u9500\u6216\u8005\u90e8\u5206\u51b2\u9500\u7684\u9884\u63d0\u8bb0\u8d26\u5355\u636e\u64cd\u4f5c\u51b2\u6b63\u3002", (String)"PreInstBillCorrectValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void validateAmt(ExtendedDataEntity extendedDataEntity, Map dataMap, String confirmType) {
        if (!CollectionUtils.isEmpty((Map)dataMap) && PreIntOperateTypeEnum.isWriteOffInt((String)confirmType)) {
            DynamicObject preInstBill = extendedDataEntity.getDataEntity();
            BigDecimal writeOffAmt = (BigDecimal)dataMap.get(preInstBill.getPkValue());
            BigDecimal noWriteOffAmt = preInstBill.getBigDecimal("nowriteoffamt");
            if (null != writeOffAmt && null != noWriteOffAmt && writeOffAmt.compareTo(noWriteOffAmt) > 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u51b2\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u9884\u63d0\u5355\u7684\u672a\u51b2\u9500\u9884\u63d0\u91d1\u989d\u3002", (String)"PreInstBillCorrectValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }
}

