/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.preinterestbill;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.IntBillWriteOffHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstBillRedWriteOffValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loanbillno");
        sic.add("prestartdate");
        sic.add("prestenddate");
        sic.add("billstatus");
        sic.add("confirmstatus");
        sic.add("writeoffpreintbillid");
        sic.add("writeoffstatus");
        sic.add("operatetype");
        sic.add("org");
        sic.add("creditortype");
        sic.add("creditorg");
        sic.add("datasource");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        String autoRedWriteOffOneSelf = (String)this.getOption().getVariables().get("autoRedWriteOffOneSelf");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject preintBill = dataEntity.getDataEntity();
            if (!PreIntOperateTypeEnum.PREINT.getValue().equals(preintBill.getString("operatetype"))) {
                String message = ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u522b\u4e3a\u9884\u63d0\u5229\u606f\u624d\u5141\u8bb8\u7ea2\u5b57\u51b2\u9500\u3002", (String)"PreInstRedWriteOffValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]);
                if (Arrays.asList("cim_depositpreint", "ifm_depositpreint").contains(preintBill.getDynamicObjectType().getName())) {
                    message = ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u522b\u4e3a\u9884\u63d0\u6536\u76ca\u624d\u5141\u8bb8\u7ea2\u5b57\u51b2\u9500\u3002", (String)"PreInstRedWriteOffValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]);
                }
                this.addErrorMessage(dataEntity, message);
                continue;
            }
            if (EmptyUtil.isEmpty((String)autoRedWriteOffOneSelf) && !BillStatusEnum.AUDIT.getValue().equals(preintBill.getString("billstatus")) || !WriteOffStatusEnum.NO_WRITEOFF.getValue().equals(preintBill.getString("writeoffstatus"))) {
                if (Arrays.asList("cim_depositpreint", "ifm_depositpreint").contains(preintBill.getDynamicObjectType().getName())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u4e14\u672a\u51b2\u9500\u5355\u636e\u624d\u5141\u8bb8\u51b2\u9500\u3002", (String)"PreInstRedWriteOffValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
                } else if (!ConfirmStatusEnum.isYetconfirm((String)preintBill.getString("confirmstatus"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u3001\u5df2\u786e\u8ba4\u4e14\u672a\u51b2\u9500\u5355\u636e\u624d\u5141\u8bb8\u51b2\u9500\u3002", (String)"PreInstRedWriteOffValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
            }
            String entityName = preintBill.getDataEntityType().getName();
            String creditorType = preintBill.getString("creditortype");
            String dataSource = preintBill.getString("datasource");
            String mainOrgField = CfmBillCommonHelper.getFundOrgFieldName((String)dataSource, (boolean)true, (String)creditorType);
            long orgId = preintBill.getDynamicObject(mainOrgField).getLong("id");
            boolean isDeposit = BatchIntBillHelper.isDepostPreInt((String)entityName);
            if (IntBillWriteOffHelper.isRedWriteOffParam((long)orgId) || isDeposit) continue;
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\uff1a\u5dee\u989d\u8865\u63d0\u6cd5\u3002", (String)"PreInstRedWriteOffValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
    }
}

