/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.preinterestbill;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.AutoConfirmParamEnum;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        sic.add("loanbillno");
        sic.add("billstatus");
        sic.add("prestenddate");
        sic.add("chargeinstid");
        sic.add("operatetype");
        sic.add("datasource");
        sic.add("confirmstatus");
        sic.add("org");
        sic.add("creditorg");
        sic.add("loantype");
        sic.add("creditortype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        AbstractBizResource cfmBizResource = new BizResourceFactory().getBizResource("");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject preInstEntity = dataEntity.getDataEntity();
            String billstatus = preInstEntity.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billstatus)) continue;
            if (PreIntOperateTypeEnum.REVERSEINT.getValue().equals(preInstEntity.getString("operatetype"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51b2\u9500\u9884\u63d0\u5229\u606f\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"PreInstBillUnAuditValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            if (LoanBillHelper.existCorrectBill((Object)preInstEntity.getPkValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u8865\u63d0\u9884\u63d0\u5229\u606f\u6216\u51b2\u9500\u9884\u63d0\u5229\u606f\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"PreInstBillUnAuditValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            Long chargeInstId = preInstEntity.getLong("chargeinstid");
            if (chargeInstId.intValue() != 0) {
                this.addErrorMessage(dataEntity, cfmBizResource.getPbUnauditCheck());
            }
            if (!BatchIntBillHelper.isDepostPreInt((String)preInstEntity.getDataEntityType().getName())) {
                String loanbillno = preInstEntity.getString("loanbillno");
                QFilter loanbillnoFilter = new QFilter("loanbillno", "=", (Object)loanbillno);
                loanbillnoFilter.and(new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue()));
                loanbillnoFilter.and(new QFilter("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue()));
                DynamicObjectCollection preInterestBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"id", (QFilter[])new QFilter[]{loanbillnoFilter}, (String)"prestartdate  desc, createtime desc");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)preInterestBills) && !((DynamicObject)preInterestBills.get(0)).get("id").equals(preInstEntity.getPkValue())) {
                    this.addErrorMessage(dataEntity, cfmBizResource.getPbUnauditChecklast());
                }
            }
            if (this.isAutoConfirm(preInstEntity) || ConfirmStatusEnum.YETRETURN.getValue().equals(preInstEntity.getString("confirmstatus")) || ConfirmStatusEnum.WAITCONFIRM.getValue().equals(preInstEntity.getString("confirmstatus"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u786e\u8ba4\u72b6\u6001\u4e3a\u5f85\u786e\u8ba4\u6216\u5df2\u9000\u56de\u624d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"PreInstBillUnAuditValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private boolean isAutoConfirm(DynamicObject preInterestBill) {
        if (!LoanTypeEnum.isEntrustLoan((String)preInterestBill.getString("loantype")) && !LoanTypeEnum.isLinklend((String)preInterestBill.getString("loantype"))) {
            return true;
        }
        String dataSource = preInterestBill.getString("datasource");
        String creditorType = preInterestBill.getString("creditortype");
        String orgFieldName = CfmBillCommonHelper.getFundOrgFieldName((String)dataSource, (boolean)false, (String)creditorType);
        String entityName = preInterestBill.getDataEntityType().getName();
        DynamicObject org = preInterestBill.getDynamicObject(orgFieldName);
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return true;
        }
        HashSet autoOps = new HashSet(5);
        if (DataSourceEnum.INVEST.getValue().equals(dataSource)) {
            autoOps.addAll(CfmSysParamHelper.getParameterComboxs((long)org.getLong("id"), (String)"cfm001"));
        } else {
            autoOps.addAll(CfmSysParamHelper.getParameterComboxs((long)org.getLong("id"), (String)"cim001"));
        }
        return (CfmEntityEnum.PREINTERESTBILL.getValue().equals(entityName) || CfmEntityEnum.CIM_PREINTERESTBILL.getValue().equals(entityName)) && autoOps.contains(AutoConfirmParamEnum.PREINTEREST.getValue());
    }
}

