/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.preinterestbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstBillUnCorrectValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("operatetype");
        selector.add("writeoffpreintbillid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map<Object, DynamicObject> billMap = this.getSrcPreInstBillMap(dataEntity);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            if (!this.validateOperateType(extendedDataEntity)) continue;
            this.validateSupIntAmt(extendedDataEntity, billMap);
        }
    }

    private Map<Object, DynamicObject> getSrcPreInstBillMap(ExtendedDataEntity[] dataEntity) {
        Object[] ids = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(v -> v.getLong("writeoffpreintbillid")).toArray();
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return new HashMap<Object, DynamicObject>();
        }
        DynamicObjectCollection preInterestBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"id,nowriteoffamt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        return preInterestBills.stream().collect(Collectors.toMap(v -> v.get("id"), Function.identity()));
    }

    private boolean validateOperateType(ExtendedDataEntity extendedDataEntity) {
        DynamicObject preIntBill = extendedDataEntity.getDataEntity();
        if (!LoanBillHelper.isCorrectPreIntBill((DynamicObject)preIntBill)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u522b\u4e3a\u8865\u63d0\u9884\u63d0\u5229\u606f\u6216\u51b2\u9500\u9884\u63d0\u5229\u606f\u624d\u5141\u8bb8\u8fdb\u884c\u64a4\u9500\u51b2\u6b63\u64cd\u4f5c\u3002", (String)"PreInstBillUnCorrectValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateSupIntAmt(ExtendedDataEntity extendedDataEntity, Map<Object, DynamicObject> billMap) {
        DynamicObject preIntBill = extendedDataEntity.getDataEntity();
        DynamicObject srcPreIntBill = billMap.get(preIntBill.get("writeoffpreintbillid"));
        if (PreIntOperateTypeEnum.isSupInt((String)preIntBill.getString("operatetype")) && EmptyUtil.isNoEmpty((DynamicObject)srcPreIntBill)) {
            BigDecimal supIntAmt = preIntBill.getBigDecimal("supintamt");
            BigDecimal noWriteOffAmt = srcPreIntBill.getBigDecimal("nowriteoffamt");
            if (null != supIntAmt && null != noWriteOffAmt && supIntAmt.compareTo(noWriteOffAmt) > 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u9884\u63d0\u5355\u672a\u51b2\u9500\u91d1\u989d\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u8865\u63d0\u3002", (String)"PreInstBillUnCorrectValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }
}

