/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.preinterestbill;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.AutoConfirmParamEnum;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstBillUnRedWriteOffValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loanbillno");
        sic.add("prestartdate");
        sic.add("prestenddate");
        sic.add("billstatus");
        sic.add("operatetype");
        sic.add("writeoffpreintbillid");
        sic.add("writeoffstatus");
        sic.add("batchnoid");
        sic.add("bizdate");
        sic.add("datasource");
        sic.add("confirmstatus");
        sic.add("org");
        sic.add("creditorg");
        sic.add("loantype");
        sic.add("creditortype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        List<Object> ids = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        String currBillAppId = Optional.ofNullable(this.getOption().getVariables().get("appid")).orElse("");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String errMsg;
            DynamicObject preIntBill = dataEntity.getDataEntity();
            if (!PreIntOperateTypeEnum.REVERSEINT.getValue().equals(preIntBill.getString("operatetype"))) {
                errMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u522b\u4e3a\u7ea2\u5b57\u51b2\u9500\u9884\u63d0\u5229\u606f\u624d\u5141\u8bb8\u53cd\u51b2\u9500\u3002", (String)"PreInstBillUnRedWriteOffValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]);
                if (this.isBelongToDeposit(preIntBill)) {
                    errMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u522b\u4e3a\u51b2\u9500\u9884\u63d0\u6536\u76ca\u624d\u5141\u8bb8\u53cd\u51b2\u9500\u3002", (String)"PreInstBillUnRedWriteOffValidator_05", (String)"tmc-cfm-business", (Object[])new Object[0]);
                }
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            if (!this.isLastPreIntBill(preIntBill, ids)) {
                errMsg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540e\u7eed\u64cd\u4f5c\u7c7b\u522b\u4e3a\u51b2\u9500\u9884\u63d0\u5229\u606f\u7684\u9884\u63d0\u5355\u4e0d\u80fd\u53cd\u51b2\u9500\u3002", (String)"PreInstBillUnRedWriteOffValidator_02", (String)"tmc-cfm-business", (Object[])new Object[0]);
                if (this.isBelongToDeposit(preIntBill)) {
                    errMsg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540e\u7eed\u64cd\u4f5c\u7c7b\u522b\u4e3a\u51b2\u9500\u9884\u63d0\u6536\u76ca\u7684\u9884\u63d0\u5355\u4e0d\u80fd\u53cd\u51b2\u9500\u3002", (String)"PreInstBillUnRedWriteOffValidator_06", (String)"tmc-cfm-business", (Object[])new Object[0]);
                }
                this.addErrorMessage(dataEntity, errMsg);
            }
            QFilter preQF = new QFilter("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
            preQF.and(new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue()));
            preQF.and(new QFilter("loanbillno", "=", (Object)preIntBill.getString("loanbillno")));
            preQF.and(new QFilter("id", "!=", preIntBill.get("writeoffpreintbillid")));
            Date preStartDate = DateUtils.getDataFormat((Date)preIntBill.getDate("prestartdate"), (boolean)true);
            Date preEndDate = DateUtils.getDataFormat((Date)preIntBill.getDate("bizdate"), (boolean)true);
            preQF.and(new QFilter("prestartdate", ">=", (Object)preStartDate).and(new QFilter("prestartdate", "<=", (Object)preEndDate)).or(new QFilter("bizdate", ">=", (Object)preStartDate).and(new QFilter("bizdate", "<=", (Object)preEndDate))));
            DynamicObjectCollection preBills = QueryServiceHelper.query((String)preIntBill.getDataEntityType().getName(), (String)"id", (QFilter[])preQF.toArray());
            boolean autoRedWriteOff = LoanBillHelper.isNeedAutoRedWriteOff((DynamicObject)preIntBill);
            if (TmcAppEnum.CIM.getValue().equals(currBillAppId) || "ifm_depositpreint".equals(preIntBill.getDynamicObjectType().getName())) {
                String param = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.CIM.getId(), (long)preIntBill.getLong("org_id"), (String)"autoredwriteoff");
                boolean bl = autoRedWriteOff = EmptyUtil.isNoEmpty((String)param) && StringUtils.equals((CharSequence)param, (CharSequence)"true");
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)preBills) && !autoRedWriteOff) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u9884\u63d0\u533a\u95f4\u5df2\u5b58\u5728\u65b0\u7684\u9884\u63d0\u5355\uff0c\u4e0d\u80fd\u53cd\u51b2\u9500\u3002", (String)"PreInstBillUnRedWriteOffValidator_03", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (this.isAutoConfirm(preIntBill) || PreIntOperateTypeEnum.isReverseInt((String)preIntBill.getString("operatetype")) || ConfirmStatusEnum.YETRETURN.getValue().equals(preIntBill.getString("confirmstatus")) || ConfirmStatusEnum.WAITCONFIRM.getValue().equals(preIntBill.getString("confirmstatus"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u786e\u8ba4\u72b6\u6001\u4e3a\u5f85\u786e\u8ba4\u6216\u5df2\u9000\u56de\u624d\u5141\u8bb8\u53cd\u51b2\u9500\u3002", (String)"PreInstBillUnRedWriteOffValidator_04", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private boolean isAutoConfirm(DynamicObject preInterestBill) {
        if (!LoanTypeEnum.isEntrustLoan((String)preInterestBill.getString("loantype")) && !LoanTypeEnum.isLinklend((String)preInterestBill.getString("loantype"))) {
            return true;
        }
        String dataSource = preInterestBill.getString("datasource");
        String creditorType = preInterestBill.getString("creditortype");
        String orgFieldName = CfmBillCommonHelper.getFundOrgFieldName((String)dataSource, (boolean)false, (String)creditorType);
        String entityName = preInterestBill.getDataEntityType().getName();
        DynamicObject org = preInterestBill.getDynamicObject(orgFieldName);
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return true;
        }
        HashSet autoOps = new HashSet(5);
        if (DataSourceEnum.INVEST.getValue().equals(dataSource)) {
            autoOps.addAll(CfmSysParamHelper.getParameterComboxs((long)org.getLong("id"), (String)"cfm001"));
        } else {
            autoOps.addAll(CfmSysParamHelper.getParameterComboxs((long)org.getLong("id"), (String)"cim001"));
        }
        return (CfmEntityEnum.PREINTERESTBILL.getValue().equals(entityName) || CfmEntityEnum.CIM_PREINTERESTBILL.getValue().equals(entityName)) && autoOps.contains(AutoConfirmParamEnum.PREINTEREST.getValue());
    }

    private boolean isLastPreIntBill(DynamicObject preIntBill, List<Object> ids) {
        QFilter preQF = new QFilter("operatetype", "=", (Object)PreIntOperateTypeEnum.REVERSEINT.getValue());
        preQF.and(new QFilter("loanbillno", "=", (Object)preIntBill.getString("loanbillno")));
        String entityName = preIntBill.getDataEntityType().getName();
        DynamicObjectCollection redWriteOffBills = QueryServiceHelper.query((String)entityName, (String)"id,prestenddate", (QFilter[])preQF.toArray(), (String)"prestenddate desc, createtime desc");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)redWriteOffBills)) {
            for (DynamicObject redWriteOffBill : redWriteOffBills) {
                Object id = redWriteOffBill.get("id");
                if (id.equals(preIntBill.getPkValue())) {
                    return true;
                }
                if (ids.contains(id)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isBelongToDeposit(DynamicObject preIntBill) {
        return Arrays.asList("cim_depositpreint", "ifm_depositpreint").contains(preIntBill.getDynamicObjectType().getName());
    }
}

