/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.rateadjust;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.RateAdjustHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class RateAdjustBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("adjustele");
        sic.add("afterrefrate");
        sic.add("afterrateadjustkey");
        sic.add("afterrateadjustval");
        sic.add("afterratesign");
        sic.add("afterinterestrate");
        sic.add("afterratefloatpoint");
        sic.add("adjusteffectdate");
        sic.add("loancontractbill");
        sic.add("creditortype");
        sic.add("datasource");
        sic.add("entry");
        sic.add("entry.afterlloanrate");
        sic.add("entry.afterlratesign");
        sic.add("entry.afterlratefloatpoint");
        sic.add("entry.ldrawbill");
        sic.add("entry.lisadjust");
        sic.add("entry.lsettleintmode");
        sic.add("entry.linterestsettledplan");
        sic.add("entry.lrateadjustdate");
        sic.add("entry.lrateadjustdate");
        sic.add("entry.lissofrrate");
        sic.add("entry.lrefrate");
        sic.add("entry.afterlrefrate");
        sic.add("entry.lrateadjustkey");
        sic.add("entry.lrateadjustval");
        sic.add("entry.afterlrateadjustkey");
        sic.add("entry.afterlrateadjustval");
        sic.add("entry.ladjusteffectdate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        String loanNo;
        HashMap<String, ExtendedDataEntity> loanNoEntityMap = new HashMap<String, ExtendedDataEntity>(16);
        HashMap<Long, String> loanIdNoMap = new HashMap<Long, String>(16);
        ArrayList<Long> loanIds = new ArrayList<Long>(16);
        ArrayList<String> loanNos = new ArrayList<String>(16);
        HashMap<String, Date> loanNoAdjustDateMap = new HashMap<String, Date>(16);
        String dataSource = DataSourceEnum.CFM.getValue();
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            String currentFormId;
            boolean cannotOpRateAdjust;
            String creditType;
            DynamicObject adjustBill = dataEntity.getDataEntity();
            dataSource = adjustBill.getString("datasource");
            DynamicObjectCollection entrys = adjustBill.getDynamicObjectCollection("entry");
            Iterator iterator = entrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                if (!dynamicObject.getBoolean("lisadjust")) continue;
                DynamicObject loanBill = dynamicObject.getDynamicObject("ldrawbill");
                long loanId = loanBill.getLong("id");
                String loanNo2 = loanBill.getString("number");
                Date adjustDate = dynamicObject.getDate("ladjusteffectdate");
                loanNoEntityMap.put(loanNo2, dataEntity);
                loanIdNoMap.put(loanId, loanNo2);
                loanIds.add(loanId);
                loanNos.add(loanNo2);
                loanNoAdjustDateMap.put(loanNo2, adjustDate);
            }
            AbstractBizResource iterator2 = new BizResourceFactory().getBizResource(dataSource);
            List list = RateAdjustHelper.getLoanBillNoList((DynamicObject)adjustBill);
            if (RateAdjustHelper.validateLoanBillHasInDoingInt((List)list)) {
                this.addErrorMessage(dataEntity, iterator2.checkExtLoanBillHasUnauditInt());
            }
            if (StringUtils.equals((CharSequence)(creditType = adjustBill.getString("creditortype")), (CharSequence)"settlecenter")) {
                this.validateBizDealBillNotAudit(dataEntity, iterator2, list);
            }
            if (!(cannotOpRateAdjust = RateAdjustHelper.isCannotOpRateAdjust((String)dataSource, (String)(currentFormId = this.getOption().getVariableValue("RATEADJUSTBILL_FORMID"))))) continue;
            this.addErrorMessage(dataEntity, String.format(iterator2.checkRateAdjustOpSite(), DataSourceEnum.getName((String)dataSource)));
        }
        DynamicObjectCollection rateAdjustBills = RateAdjustHelper.getRateAdjustBills(loanIds);
        DynamicObjectCollection extendBills = RateAdjustHelper.getExtendBills(loanNos, (String)dataSource);
        DynamicObjectCollection loanBills = LoanBillRepository.getLoanBillByIds(loanIds);
        String loanName = CfmBillCommonHelper.getLoanNameByDataSource((String)dataSource);
        Map loanIdDateMap = RateAdjustHelper.getLoanIdDateMap((DynamicObjectCollection)rateAdjustBills);
        for (Map.Entry entry : loanIdDateMap.entrySet()) {
            Long l = (Long)entry.getKey();
            loanNo = (String)loanIdNoMap.get(l);
            if (((Date)loanNoAdjustDateMap.get(loanNo)).compareTo((Date)entry.getValue()) >= 0) continue;
            this.addErrorMessage((ExtendedDataEntity)loanNoEntityMap.get(loanNo), CfmBusinessResourceEnum.RateAdjustBillUnAuditValidator_1.loadKDString(loanName, loanNo));
        }
        Map loanNoDateMap = RateAdjustHelper.getLoanNoDateMap((DynamicObjectCollection)extendBills);
        for (Map.Entry entry : loanNoDateMap.entrySet()) {
            loanNo = (String)entry.getKey();
            if (((Date)loanNoAdjustDateMap.get(loanNo)).compareTo((Date)entry.getValue()) >= 0) continue;
            this.addErrorMessage((ExtendedDataEntity)loanNoEntityMap.get(loanNo), CfmBusinessResourceEnum.RateAdjustBillUnAuditValidator_2.loadKDString(loanName, loanNo));
        }
        HashMap hashMap = RateAdjustHelper.getLoanIdPayIntDateMap((DynamicObjectCollection)loanBills);
        for (Map.Entry entry : hashMap.entrySet()) {
            Long loanId = (Long)entry.getKey();
            String loanNo3 = (String)loanIdNoMap.get(loanId);
            if (((Date)entry.getValue()).compareTo((Date)loanNoAdjustDateMap.get(loanNo3)) < 0) continue;
            this.addErrorMessage((ExtendedDataEntity)loanNoEntityMap.get(loanNo3), CfmBusinessResourceEnum.RateAdjustBillUnAuditValidator_3.loadKDString(loanName, loanNo3));
        }
    }

    private void validateBizDealBillNotAudit(ExtendedDataEntity dataEntity, AbstractBizResource bizResource, List<String> loanBillNo) {
        QFilter intFilter = new QFilter("loanbillno", "in", loanBillNo);
        intFilter.and(new QFilter("creditortype", "=", (Object)"settlecenter"));
        intFilter.and(new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.WAITCONFIRM.getValue()));
        DynamicObjectCollection intBill = QueryServiceHelper.query((String)"cfm_interestbill", (String)"instbillctg,id,repaymentid", (QFilter[])intFilter.toArray());
        if (intBill.size() == 0) {
            return;
        }
        ArrayList idList = Lists.newArrayList();
        List oriIntIdList = intBill.stream().filter(r -> StringUtils.equals((CharSequence)"payinterst", (CharSequence)r.getString("instbillctg"))).map(r -> r.getLong("id")).collect(Collectors.toList());
        List oriRepayIdList = intBill.stream().filter(r -> StringUtils.equals((CharSequence)"payprinandinte", (CharSequence)r.getString("instbillctg"))).map(r -> r.getLong("repaymentid")).collect(Collectors.toList());
        idList.addAll(oriIntIdList);
        idList.addAll(oriRepayIdList);
        QFilter bizDealFilter = new QFilter("sourcebillid", "in", (Object)idList);
        bizDealFilter.and(new QFilter("businessstatus", "=", (Object)"A"));
        bizDealFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        bizDealFilter.and(new QFilter("applitype", "in", (Object)new String[]{"int_apply", "repay_apply"}));
        boolean exists = TmcDataServiceHelper.exists((String)"ifm_bizdealbill", (QFilter[])bizDealFilter.toArray());
        if (exists) {
            this.addErrorMessage(dataEntity, bizResource.checkExtLoanBillHasUnauditInt());
        }
    }
}

