/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.bean.ValidateBean;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class RepaymentBillConfirmValidator
extends AbstractTmcBizOppValidator {
    private static final String[] selectProps = new String[]{"sourcebillid", "billstatus", "confirmstatus", "datasource"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("loans.e_ispayinst");
        sic.add("loans.e_loanbill");
        sic.add("datasource");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            List<Long> loanBillIds = this.getLoanBillIds(repayBill.getDynamicObjectCollection("loans"));
            if (loanBillIds.isEmpty()) continue;
            QFilter instFilter = new QFilter("sourcebillid", "in", loanBillIds).and(new QFilter("repaymentid", "=", repayBill.getPkValue()));
            DynamicObject[] interestBills = TmcDataServiceHelper.load((String)"cfm_interestbill", (String)String.join((CharSequence)",", selectProps), (QFilter[])instFilter.toArray());
            Map validateBeanMap = InterestValidateHelper.validateOnConfirm(Arrays.asList(interestBills));
            if (validateBeanMap.isEmpty()) continue;
            ValidateBean validateBean = (ValidateBean)validateBeanMap.values().iterator().next();
            this.addErrorMessage(dataEntity, validateBean.getErrorInfo());
        }
    }

    private List<Long> getLoanBillIds(DynamicObjectCollection loanEntry) {
        return loanEntry.stream().filter(d -> d.getBoolean("e_ispayinst")).map(d -> d.getLong("e_loanbill.id")).collect(Collectors.toList());
    }
}

