/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillPush2RecValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("isrelcash");
        sic.add("billstatus");
        sic.add("confirmstatus");
        sic.add("isinit");
        sic.add("eassrcid");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isRelCash = bill.getBoolean("isrelcash");
            if (!isRelCash) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u672c\u91d1\u6536\u56de\u4e0d\u4ea7\u751f\u5b9e\u9645\u73b0\u91d1\u6d41\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u6536\u6b3e\u5355\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RepaymentBillPush2RecValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (!BillStatusEnum.isAudit((String)bill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_3.loadKDString());
            }
            if (!ConfirmStatusEnum.isYetconfirm((String)bill.getString("confirmstatus"))) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_4.loadKDString());
            }
            if (bill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_2.loadKDString());
            }
            if (!EmptyUtil.isNoEmpty((String)bill.getString("eassrcid"))) continue;
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_6.loadKDString());
        }
    }
}

