/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.bean.ValidateBean;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class RepaymentBillUnAuditOrConfirmValidator
extends AbstractTmcBizOppValidator {
    private static final String[] INTEREST_PROPS = new String[]{"sourcebillid", "billno", "billstatus", "instbillctg", "lendernature", "repaymentid", "confirmstatus", "datasource", "creditortype", "debtortype"};

    protected List<ExtendedDataEntity> validateBillHead(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            if (repayBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, this.getBizResource(repayBill).getRbUnauditContractinit());
                continue;
            }
            DynamicObject contractBillF7 = repayBill.getDynamicObject("loancontractbill");
            if (EmptyUtil.isNoEmpty((DynamicObject)contractBillF7) && LoanContractStatusEnum.isClosed((String)contractBillF7.getString("contractstatus")) && contractBillF7.getBoolean("ishandend")) {
                this.addErrorMessage(dataEntity, String.format(this.getBizResource(repayBill).getIbUnOpContractByHandEnd(), contractBillF7.getString("number")));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected void checkValidateResult(List<ExtendedDataEntity> dataEntities, Map<Long, String> validateMap, List<ExtendedDataEntity> dataEntityList) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long repayBillId = dataEntity.getDataEntity().getLong("id");
            String error = validateMap.get(repayBillId);
            if (EmptyUtil.isNoEmpty((String)error)) {
                this.addErrorMessage(dataEntity, error);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
    }

    protected DynamicObject[] getInterestBills(List<ExtendedDataEntity> dataEntities, QFilter qFilter) {
        HashSet<Long> repaymentBillIds = new HashSet<Long>(dataEntities.size());
        HashSet loanBillIds = new HashSet(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            List<DynamicObject> payIntEntrys = repayBill.getDynamicObjectCollection("loans").stream().filter(d -> d.getBoolean("e_ispayinst")).collect(Collectors.toList());
            if (payIntEntrys.isEmpty()) continue;
            repaymentBillIds.add(repayBill.getLong("id"));
            payIntEntrys.forEach(d -> loanBillIds.add(d.getLong("e_loanbill.id")));
        }
        QFilter instFilter = new QFilter("sourcebillid", "in", loanBillIds).and(new QFilter("repaymentid", "in", repaymentBillIds));
        if (qFilter != null) {
            instFilter.and(qFilter);
        }
        return TmcDataServiceHelper.load((String)"cfm_interestbill", (String)String.join((CharSequence)",", INTEREST_PROPS), (QFilter[])instFilter.toArray());
    }

    protected List<ExtendedDataEntity> checkValidateIntBillResult(List<ExtendedDataEntity> dataEntities, DynamicObject[] interestBills, Map<Long, ValidateBean> validateBeanMap) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Map<Long, List<DynamicObject>> interestBillMap = Arrays.stream(interestBills).collect(Collectors.groupingBy(d -> d.getLong("repaymentid")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            long repayBillId = repayBill.getLong("id");
            List<DynamicObject> interestBillList = interestBillMap.get(repayBillId);
            if (EmptyUtil.isEmpty(interestBillList)) {
                dataEntityList.add(dataEntity);
                continue;
            }
            boolean isBreak = false;
            Map<Long, DynamicObject> loanBillIdMap = interestBillList.stream().collect(Collectors.toMap(d -> d.getLong("sourcebillid"), d -> d, (d1, d2) -> d1));
            for (DynamicObject enrty : repayBill.getDynamicObjectCollection("loans")) {
                ValidateBean validateBean;
                DynamicObject interestBill;
                if (!enrty.getBoolean("e_ispayinst") || (interestBill = loanBillIdMap.get(enrty.getLong("e_loanbill.id"))) == null || (validateBean = validateBeanMap.get(interestBill.getLong("id"))) == null) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u4ed8\u606f\u5904\u7406\u5355[%s]", (String)"RepaymentBillUnAuditValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]), interestBill.getString("billno"));
                this.addMessage(dataEntity, msg + validateBean.getErrorInfo(), validateBean.isError() ? ErrorLevel.Error : ErrorLevel.Warning);
                isBreak = true;
                break;
            }
            if (isBreak) continue;
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected AbstractBizResource getBizResource(DynamicObject repayBill) {
        return new BizResourceFactory().getBizResource(repayBill.getString("datasource"));
    }
}

