/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.business.validate.repaymentbill.RepaymentBillUnAuditOrConfirmValidator;
import kd.tmc.cfm.business.validate.repaymentbill.RepaymentBillValidatorHelper;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillUnConfirmValidator
extends RepaymentBillUnAuditOrConfirmValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("e_ispayinst");
        sic.add("loancontractbill");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("datasource");
        sic.add("confirmstatus");
        sic.add("creditortype");
        sic.add("debtortype");
        sic.add("loans");
        sic.add("loans.e_ispayinst");
        sic.add("loans.e_loanbill");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        List<ExtendedDataEntity> dataEntityList = Arrays.stream(dataEntities).collect(Collectors.toList());
        dataEntityList = this.validateBillHead(dataEntityList);
        dataEntityList = this.validateTargetBill(dataEntityList);
        dataEntityList = this.validateIsPayInt(dataEntityList);
    }

    @Override
    protected List<ExtendedDataEntity> validateBillHead(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities = super.validateBillHead(dataEntities))) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            if (!ConfirmStatusEnum.isYetconfirm((String)repayBill.getString("confirmstatus"))) {
                this.addErrorMessage(dataEntity, this.getBizResource(repayBill).getConfirmStatusError());
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateTargetBill(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Map<String, List<ExtendedDataEntity>> creditorTypeMap = dataEntities.stream().collect(Collectors.groupingBy(d -> d.getDataEntity().getString("creditortype")));
        for (Map.Entry<String, List<ExtendedDataEntity>> entry : creditorTypeMap.entrySet()) {
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(entry.getKey())) {
                dataEntityList.addAll(this.validateForSettleCenter(entry.getValue()));
                continue;
            }
            dataEntityList.addAll(this.validateForNotSettleCenter(entry.getValue()));
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateForSettleCenter(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List settleRepayBills = dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map validateMap = BusinessHelper.checkTargetBillForInnerLoan(settleRepayBills, null);
        this.checkValidateResult(dataEntities, validateMap, dataEntityList);
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateForNotSettleCenter(List<ExtendedDataEntity> dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        AbstractBizResource bizResource = RepaymentBillValidatorHelper.getBizResource(dataEntities.get(0).getDataEntity());
        ArrayList<ExtendedDataEntity> inGroupDataEntitys = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            if (BusinessHelper.isOutGroup((DynamicObject)repayBill)) {
                this.addErrorMessage(dataEntity, bizResource.getUnConfirmOutGroupData());
                continue;
            }
            if (BusinessHelper.isSameSource((String)repayBill.getDataEntityType().getName(), (String)repayBill.getString("datasource"))) {
                this.addErrorMessage(dataEntity, bizResource.getUnConfirmSameSourceData());
                continue;
            }
            inGroupDataEntitys.add(dataEntity);
        }
        if (!inGroupDataEntitys.isEmpty()) {
            List settleRepayBills = inGroupDataEntitys.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            Map<String, QFilter> filterMap = Collections.singletonMap(CfmEntityEnum.CAS_PAYBILL.getValue(), new QFilter("billstatus", "not in", Arrays.asList("G", "F")));
            Map validateMap = BusinessHelper.checkTargetBillForInnerLoan(settleRepayBills, filterMap);
            this.checkValidateResult(inGroupDataEntitys, validateMap, dataEntityList);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateIsPayInt(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Object[] interestBills = this.getInterestBills(dataEntities, new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()));
        if (EmptyUtil.isEmpty((Object[])interestBills)) {
            return dataEntities;
        }
        Map validateBeanMap = InterestValidateHelper.validateOnUnConfirm(Arrays.asList(interestBills), (Boolean)Boolean.TRUE);
        if (EmptyUtil.isEmpty((Object)validateBeanMap)) {
            return dataEntities;
        }
        dataEntityList.addAll(this.checkValidateIntBillResult(dataEntities, (DynamicObject[])interestBills, validateBeanMap));
        return dataEntityList;
    }
}

