/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillValidatorHelper {
    public static AbstractBizResource getBizResource(DynamicObject repayBill) {
        return BusinessHelper.getBizResource((DynamicObject)repayBill);
    }

    public static Set<Long> getLoanBillIds(List<ExtendedDataEntity> dataEntityList) {
        return RepaymentbillHelper.getLoanBillIds(dataEntityList.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList()));
    }

    public static Map<Long, Set<Long>> getLoanBillIdMap(List<DynamicObject> repayBills) {
        HashMap<Long, Set<Long>> loanBillIdMap = new HashMap<Long, Set<Long>>(repayBills.size());
        for (DynamicObject repayBill : repayBills) {
            long repayBillId = repayBill.getLong("id");
            Set loanBillIdSet = repayBill.getDynamicObjectCollection("loans").stream().filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("e_loanbill"))).map(d -> d.getLong("e_loanbill.id")).collect(Collectors.toSet());
            loanBillIdMap.put(repayBillId, loanBillIdSet);
        }
        return loanBillIdMap;
    }

    public static Map<Long, Set<DynamicObject>> getLoanBillMap(List<DynamicObject> repayBills) {
        HashMap<Long, Set<DynamicObject>> loanBillMap = new HashMap<Long, Set<DynamicObject>>(repayBills.size());
        for (DynamicObject repayBill : repayBills) {
            long repayBillId = repayBill.getLong("id");
            Set loanBillSet = repayBill.getDynamicObjectCollection("loans").stream().filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("e_loanbill"))).map(d -> d.getDynamicObject("e_loanbill")).collect(Collectors.toSet());
            loanBillMap.put(repayBillId, loanBillSet);
        }
        return loanBillMap;
    }
}

