/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.scheme;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;

public class FinancingSchemeSaveValitator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("loanapply");
        selector.add("org");
        selector.add("creditortype");
        selector.add("creditordatatype");
        selector.add("creditor");
        selector.add("startdate");
        selector.add("enddate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            Long creditor;
            String creditorType;
            DynamicObject loanApply;
            DynamicObjectCollection entry;
            DynamicObject scheme = data.getDataEntity();
            Date startDate = scheme.getDate("startdate");
            Date endDate = scheme.getDate("enddate");
            if (startDate != null && endDate != null && startDate.compareTo(endDate) > 0) {
                this.addErrorMessage(data, CfmBusinessResourceEnum.FinancingSchemeSaveValitator_7.loadKDString());
            }
            if (CollectionUtils.isEmpty((Collection)(entry = scheme.getDynamicObjectCollection("entry")))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u878d\u8d44\u6210\u672c\u3002", (String)"FinancingSchemeSaveValitator_6", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (null == (loanApply = scheme.getDynamicObject("loanapply"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u878d\u8d44\u7533\u8bf7.\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinancingSchemeSaveValitator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            boolean isNeedScheme = loanApply.getBoolean("isneedscheme");
            if (!isNeedScheme) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u878d\u8d44\u7533\u8bf7.\u5355\u636e\u7f16\u53f7\u7684\u4e0d\u9700\u8981\u51fa\u5177\u65b9\u6848\u3002", (String)"FinancingSchemeSaveValitator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            String billstatus = loanApply.getString("status");
            if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u878d\u8d44\u7533\u8bf7.\u5355\u636e\u7f16\u53f7\u7684\u72b6\u6001\u4e3a\u5df2\u5ba1\u6279\uff0c\u4e0d\u5141\u8bb8\u518d\u5173\u8054\u878d\u8d44\u65b9\u6848\u3002", (String)"FinancingSchemeSaveValitator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            DynamicObject org = scheme.getDynamicObject("org");
            DynamicObject loanCompany = loanApply.getDynamicObject("org");
            if (null != org) {
                if (!org.getPkValue().equals(loanCompany.getPkValue())) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u501f\u6b3e\u7ec4\u7ec7\u4e0d\u7b49\u4e8e\u878d\u8d44\u7533\u8bf7\u7684\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"FinancingSchemeSaveValitator_4", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
            } else {
                org = loanCompany;
            }
            if (!StringUtils.equals((CharSequence)(creditorType = scheme.getString("creditortype")), (CharSequence)CreditorTypeEnum.INNERUNIT.getValue()) || null == (creditor = Long.valueOf(scheme.getLong("creditor"))) || !creditor.equals(org.getPkValue())) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u501f\u6b3e\u7ec4\u7ec7\u7b49\u4e8e\u503a\u6743\u4eba\uff0c\u4e1a\u52a1\u4e0d\u5408\u7406\u3002", (String)"FinancingSchemeSaveValitator_5", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

