/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.compcost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.helper.CompCostHelper;
import kd.tmc.cfm.mservice.api.CompCostService;
import kd.tmc.fbp.common.bean.CompCostBean;
import kd.tmc.fbp.common.bean.CompCostRateBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.collections.MapUtils;

public class CompCostServiceImpl
implements CompCostService {
    public List<CompCostBean> calcCompCostForApply(List<Object> applyIdList) {
        if (EmptyUtil.isEmpty(applyIdList)) {
            return new ArrayList<CompCostBean>(8);
        }
        Map<Long, Long> idMap = this.buildContract2ApplyMap(applyIdList);
        ArrayList<Object> contractIds = new ArrayList<Object>(idMap.keySet());
        List<CompCostBean> costBeans = this.calcCompCostForContract(contractIds);
        if (EmptyUtil.isEmpty(costBeans)) {
            return new ArrayList<CompCostBean>(8);
        }
        for (CompCostBean bean : costBeans) {
            bean.setBillId(idMap.get(bean.getBillId()));
        }
        return costBeans;
    }

    public List<CompCostBean> calcCompCostForContract(List<Object> contractIdList) {
        if (EmptyUtil.isEmpty(contractIdList)) {
            return new ArrayList<CompCostBean>(8);
        }
        return CompCostHelper.calcCompCost(contractIdList);
    }

    public List<CompCostRateBean> calCompCostRateForApply(List<CompCostBean> list) {
        if (EmptyUtil.isEmpty(list)) {
            return new ArrayList<CompCostRateBean>(8);
        }
        List<Object> applyIds = list.stream().map(r -> r.getBillId()).collect(Collectors.toList());
        Map<Long, Long> idMap = this.buildContract2ApplyMap(applyIds);
        Map apply2ConMap = MapUtils.invertMap(idMap);
        for (CompCostBean bean : list) {
            bean.setBillId((Long)apply2ConMap.get(bean.getBillId()));
        }
        List<CompCostRateBean> costRateBeans = this.calCompCostRateForContract(list);
        if (EmptyUtil.isEmpty(costRateBeans)) {
            return new ArrayList<CompCostRateBean>(8);
        }
        for (CompCostRateBean bean : costRateBeans) {
            bean.setBillId(idMap.get(bean.getBillId()));
        }
        return costRateBeans;
    }

    public List<CompCostRateBean> calCompCostRateForContract(List<CompCostBean> list) {
        if (EmptyUtil.isEmpty(list)) {
            return new ArrayList<CompCostRateBean>(8);
        }
        return CompCostHelper.calcCompCostRate(list);
    }

    private Map<Long, Long> buildContract2ApplyMap(List<Object> applyIdList) {
        HashMap<Long, Long> resMap = new HashMap<Long, Long>(applyIdList.size());
        DynamicObjectCollection applyBills = QueryServiceHelper.query((String)"cfm_loan_apply", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", applyIdList)}, (String)"");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)applyBills)) {
            return resMap;
        }
        Map<String, Long> noToIdMap = applyBills.stream().collect(Collectors.toMap(r -> r.getString("billno"), r -> r.getLong("id"), (r1, r2) -> r1));
        DynamicObjectCollection contractBills = QueryServiceHelper.query((String)"cfm_loancontractbill", (String)"id,lenderapplyno", (QFilter[])new QFilter[]{new QFilter("lenderapplyno", "in", noToIdMap.keySet())}, (String)"");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)contractBills)) {
            return resMap;
        }
        for (DynamicObject contract : contractBills) {
            Long applyId = noToIdMap.get(contract.getString("lenderapplyno"));
            if (EmptyUtil.isEmpty((Long)applyId)) continue;
            resMap.put(contract.getLong("id"), applyId);
        }
        return resMap;
    }
}

