/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.consistency.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CfmConsistencyInfo
implements Serializable {
    private String businessType = "";
    private String serviceName = "";
    private List<Object> businessIds = new ArrayList<Object>();
    private Object param;
    private DTXCallback callback;

    private CfmConsistencyInfo() {
    }

    public static CfmConsistencyInfo build(String businessType, String serviceName, List<Object> businessIds) {
        return new CfmConsistencyInfo().setBusinessType(businessType).setServiceName(serviceName).setBusinessIds(businessIds);
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public CfmConsistencyInfo setBusinessType(String businessType) {
        this.businessType = businessType;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public CfmConsistencyInfo setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public List<Object> getBusinessIds() {
        return this.businessIds;
    }

    public CfmConsistencyInfo setBusinessIds(List<Object> businessIds) {
        this.businessIds = businessIds;
        return this;
    }

    public Object getParam() {
        return this.param;
    }

    public CfmConsistencyInfo setParam(Object param) {
        this.param = param;
        return this;
    }

    public CfmConsistencyInfo setCallback(DTXCallback callback) {
        this.callback = callback;
        return this;
    }

    public DTXCallback getCallback() {
        return this.callback;
    }

    public boolean needCallback() {
        return null != this.callback;
    }

    public List<String> getBusinessIdStr() {
        if (EmptyUtil.isNoEmpty(this.businessIds)) {
            return this.businessIds.stream().map(Object::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "CfmConsistencyInfo{businessType=" + this.businessType + ", serviceName=" + this.serviceName + ", businessIds=[" + String.join((CharSequence)",", this.getBusinessIdStr()) + "]}";
    }
}

