/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.consistency.helper;

import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DTX;
import kd.bos.kdtx.sdk.session.DTXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cfm.mservice.consistency.bean.CfmConsistencyInfo;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.TmcAppEnum;

public class CfmConsistencyServiceHelper {
    private static final Log logger = LogFactory.getLog(CfmConsistencyServiceHelper.class);

    public static void asyncPush(CfmConsistencyInfo info) {
        String businessType = info.getBusinessType();
        logger.info("asyncPush dtx start, param{}", (Object)businessType, (Object)info.toString());
        try (DTXHandle dtx = DTX.requiresNew((String)businessType, (DBRoute)DBRouteConst.TMC, (boolean)false);){
            try {
                CommonParam param = new CommonParam();
                param.put((Object)"asyncPushInfo", (Object)info);
                param.put((Object)"currUserId", (Object)RequestContext.get().getCurrUserId());
                dtx.setBusinessType(businessType);
                dtx.setBusinessInfo(info.getBusinessIdStr());
                dtx.register(TmcAppEnum.TMC.getValue(), TmcAppEnum.CFM.getValue(), info.getServiceName(), (Param)param);
                if (info.needCallback()) {
                    dtx.setCallback(TmcAppEnum.CFM.getValue(), info.getCallback());
                }
            }
            catch (Exception e) {
                dtx.markRollback();
                logger.error("asyncPush dtx error,{}", (Object)e.getMessage());
                throw e;
            }
        }
    }
}

