/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.paywriteback;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.helper.PushPayBillVerifyHelper;
import kd.tmc.cfm.common.resource.CfmCommonResourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public class LoanBillPayBillWriteBackService
extends AbstractPayBillWriteBackService {
    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.addForwardValid(sourceBill);
        super.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doPayValidateExecute(param, sourceBill);
    }

    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject loanBill) {
        this.writeBackBizDeal(param, loanBill);
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        this.writeBackBizDeal(param, sourceBill);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        this.reserveWriteBackBizDeal(param, sourceBill);
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject loanBill) {
        super.doDeleteExecute(param, loanBill);
        this.reserveWriteBackBizDeal(param, loanBill);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject repaymentBill) {
        this.reserveWriteBackBizDeal(param, repaymentBill);
    }

    private void writeBackBizDeal(PayBillWriteBackParam param, DynamicObject loanBill) {
        String payBillNo = null;
        Long payBillId = null;
        DynamicObject latestPayBill = this.getLatestPayBill(loanBill, null);
        if (latestPayBill == null) {
            PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
            payBillNo = payBill.getPayBillNo();
            payBillId = payBill.getPayBillId();
        } else {
            payBillNo = latestPayBill.getString("billno");
            payBillId = latestPayBill.getLong("id");
        }
        loanBill.set("paybillno", (Object)payBillNo);
        DynamicObject paybill = TmcDataServiceHelper.newDynamicObject((String)"cas_paybill");
        paybill.set("id", (Object)payBillId);
        loanBill.set("paybill", (Object)paybill);
        BigDecimal dbAllPayAmt = this.getSourceBillLockPayAmount(loanBill, null);
        loanBill.set("lockpayamt", (Object)dbAllPayAmt);
        this.DBTxBizUpdate(loanBill);
    }

    private void reserveWriteBackBizDeal(PayBillWriteBackParam param, DynamicObject loanBill) {
        Set payBillIds = this.getCachePayBillIds(param);
        payBillIds.add(param.getPayBill().getPayBillId());
        BigDecimal dbAllPayAmt = this.batchGetSourceBillLockPayAmount(loanBill, payBillIds);
        loanBill.set("lockpayamt", (Object)dbAllPayAmt);
        if (!PayBillWriteBackOperateEnum.isDelete((String)param.getOperate())) {
            payBillIds.remove(param.getPayBill().getPayBillId());
        }
        DynamicObject latestPayBill = this.getLatestPayBill(loanBill, payBillIds);
        String payBillNo = "";
        DynamicObject paybill = null;
        if (EmptyUtil.isNoEmpty((DynamicObject)latestPayBill)) {
            payBillNo = latestPayBill.getString("billno");
            paybill = TmcDataServiceHelper.newDynamicObject((String)"cas_paybill");
            paybill.set("id", (Object)latestPayBill.getLong("id"));
        }
        loanBill.set("paybillno", (Object)payBillNo);
        loanBill.set("paybill", (Object)paybill);
        this.DBTxBizUpdate(loanBill);
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return TmcDataServiceHelper.loadSingle((Object)payBillInfo.getSourceBillId(), (String)"cim_invest_loanbill", (String)"id,isrelcash,isinit,eassrcid,billno,billstatus,confirmstatus,drawtype,drawamount,currency,bizdate,paybillno,paybill,lockpayamt,settleintmode,payedintamount");
    }

    private void addForwardValid(DynamicObject bill) {
        String error = PushPayBillVerifyHelper.verifyCimInvestLoanBill((DynamicObject)bill, (boolean)Boolean.TRUE, (boolean)Boolean.FALSE);
        if (EmptyUtil.isNoEmpty((String)error)) {
            throw new KDBizException(error);
        }
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("currency").getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        return PushPayBillVerifyHelper.getLoanBillCanPayAmount((DynamicObject)sourceBill);
    }

    protected boolean beforePayBillWriteBack(List<PayBillWriteBackParam> writeBackParams) {
        super.beforePayBillWriteBack(writeBackParams);
        this.checkMergePayBillValid(writeBackParams);
        return true;
    }

    private void checkMergePayBillValid(List<PayBillWriteBackParam> writeBackParams) {
        DynamicObjectCollection loanBills;
        Map<String, List<DynamicObject>> map;
        if (!PayBillWriteBackOperateEnum.isValidate((String)writeBackParams.get(0).getOperate())) {
            return;
        }
        List billIds = writeBackParams.stream().map(p -> p.getPayBill().getSourceBillId()).collect(Collectors.toList());
        if (billIds.size() > 1 && (map = (loanBills = QueryServiceHelper.query((String)"cim_invest_loanbill", (String)"billno,creditorg.id,org.id,loaneracctbank.id,currency.id", (QFilter[])new QFilter("id", "in", billIds).toArray())).stream().collect(Collectors.groupingBy(this::getKey))).size() > 1) {
            String billnos = loanBills.stream().map(d -> d.getString("billno")).collect(Collectors.joining(", "));
            throw new KDBizException(CfmCommonResourceEnum.Push2PayValidator_8.loadKDString(new Object[]{billnos}));
        }
    }

    private String getKey(DynamicObject loanBill) {
        return String.format("%d_%d_%d_%d", loanBill.getLong("org.id"), loanBill.getLong("creditorg.id"), loanBill.getLong("loaneracctbank.id"), loanBill.getLong("currency.id"));
    }
}

