/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.paywriteback;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.PushPayBillVerifyHelper;
import kd.tmc.cfm.common.resource.CfmCommonResourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public class RepayBillPayBillWriteBackService
extends AbstractPayBillWriteBackService {
    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject repaymentBill) {
        this.addForwardValid(repaymentBill);
        super.doSaveValidateExecute(param, repaymentBill);
        this.addDefineOpValid(param, repaymentBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject repaymentBill) {
        this.writeBackBizDeal(param, repaymentBill);
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.writeBackBizDeal(param, sourceBill);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject repaymentBill) {
        super.doChargebackExecute(param, repaymentBill);
        this.reserveWriteBackBizDeal(param, repaymentBill);
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject repaymentBill) {
        super.doDeleteExecute(param, repaymentBill);
        this.reserveWriteBackBizDeal(param, repaymentBill);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject repaymentBill) {
        super.doRenoteExecute(param, repaymentBill);
        this.reserveWriteBackBizDeal(param, repaymentBill);
    }

    private void writeBackBizDeal(PayBillWriteBackParam param, DynamicObject repaymentBill) {
        String payBillNo = null;
        Long payBillId = null;
        DynamicObject latestPayBill = this.getLatestPayBill(repaymentBill, null);
        if (latestPayBill == null) {
            PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
            payBillNo = payBill.getPayBillNo();
            payBillId = payBill.getPayBillId();
        } else {
            payBillNo = latestPayBill.getString("billno");
            payBillId = latestPayBill.getLong("id");
        }
        repaymentBill.set("paybillno", (Object)payBillNo);
        DynamicObject paybill = TmcDataServiceHelper.newDynamicObject((String)"cas_paybill");
        paybill.set("id", (Object)payBillId);
        repaymentBill.set("paybill", (Object)paybill);
        BigDecimal dbAllPayAmt = this.getSourceBillLockPayAmount(repaymentBill, null);
        repaymentBill.set("lockpayamt", (Object)dbAllPayAmt);
        this.DBTxBizUpdate(repaymentBill);
    }

    private void reserveWriteBackBizDeal(PayBillWriteBackParam param, DynamicObject repaymentBill) {
        Set payBillIds = this.getCachePayBillIds(param);
        Long payBillId = param.getPayBill().getPayBillId();
        payBillIds.add(payBillId);
        BigDecimal dbAllPayAmt = this.batchGetSourceBillLockPayAmount(repaymentBill, payBillIds);
        repaymentBill.set("lockpayamt", (Object)dbAllPayAmt);
        if (!PayBillWriteBackOperateEnum.isDelete((String)param.getOperate())) {
            payBillIds.remove(payBillId);
        }
        DynamicObject latestPayBill = this.getLatestPayBill(repaymentBill, payBillIds);
        String payBillNo = "";
        DynamicObject paybill = null;
        if (EmptyUtil.isNoEmpty((DynamicObject)latestPayBill)) {
            payBillNo = latestPayBill.getString("billno");
            paybill = TmcDataServiceHelper.newDynamicObject((String)"cas_paybill");
            paybill.set("id", (Object)latestPayBill.getLong("id"));
        }
        repaymentBill.set("paybillno", (Object)payBillNo);
        repaymentBill.set("paybill", (Object)paybill);
        this.DBTxBizUpdate(repaymentBill);
    }

    private void addForwardValid(DynamicObject bill) {
        String error = PushPayBillVerifyHelper.verifyRepaymentBill((DynamicObject)bill, (boolean)Boolean.TRUE, (boolean)Boolean.FALSE);
        if (EmptyUtil.isNoEmpty((String)error)) {
            throw new KDBizException(error);
        }
    }

    private void addDefineOpValid(PayBillWriteBackParam param, DynamicObject repaymentBill) {
        DynamicObjectCollection loanEntrys = repaymentBill.getDynamicObjectCollection("loans");
        List entrys = loanEntrys.stream().filter(d -> d.getBoolean("e_ispayinst") && d.getBoolean("e_combineinst")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(entrys)) {
            return;
        }
        List loanBillIds = entrys.stream().map(d -> d.getLong("e_loanbill.id")).collect(Collectors.toList());
        QFilter instFilter = new QFilter("sourcebillid", "in", loanBillIds).and("repaymentid", "=", (Object)repaymentBill.getLong("id"));
        DynamicObjectCollection instBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id,billno,sourcebillid", (QFilter[])instFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)instBills)) {
            return;
        }
        Map<Long, DynamicObject> instBillMap = instBills.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        QFilter filter = new QFilter("entry.e_sourcebillid", "in", instBillMap.keySet()).and("billstatus", "not in", Arrays.asList("G", "F"));
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"entry.e_sourcebillid", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)payBills)) {
            return;
        }
        Set sourceBillIds = payBills.stream().map(d -> d.getLong("entry.e_sourcebillid")).collect(Collectors.toSet());
        for (int i = 0; i < loanEntrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)loanEntrys.get(i);
            DynamicObject intBill = instBillMap.get(entry.getLong("e_loanbill.id"));
            if (intBill == null || !sourceBillIds.contains(intBill.getLong("id"))) continue;
            PayBillWriteBackOperateEnum operateEnum = PayBillWriteBackOperateEnum.getByValue((String)param.getOperate());
            String operateName = operateEnum != null ? operateEnum.getName() : param.getOperate();
            String error = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25: \u8be5\u4e0a\u6e38\u5bf9\u5e94\u7684\u8fd8\u6b3e\u5355:[%2$s]\u7684\u63d0\u6b3e\u4fe1\u606f\u5206\u5f55\u4e2d\u7684\u7b2c[%3$s]\u884c\u5df2\u7ecf\u52fe\u9009\u4ed8\u606f,\u5e76\u5bf9\u5e94\u7684\u4ed8\u606f\u5355[%4$s]\u5df2\u7ecf\u751f\u6210\u4ed8\u6b3e\u5355,\u4e0d\u80fd\u518d\u52fe\u9009\u5408\u5e76\u5229\u606f\u3002", (String)"RepayBillPayBillWriteBackService_01", (String)"tmc-cfm-mservice", (Object[])new Object[0]), operateName, repaymentBill.getString("billno"), i + 1, intBill.getString("billno"));
            throw new KDBizException(error);
        }
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return TmcDataServiceHelper.loadSingle((Object)payBillInfo.getSourceBillId(), (String)"cfm_repaymentbill", (String)"id,isrelcash,isinit,eassrcid,billno,billstatus,confirmstatus,amount,needpayamt,currency,loancurrency,bizdate,paybillno,paybill,lockpayamt,loans,loans.e_ispayinst,loans.e_actintamt,loans.e_combineinst,loans.e_loanbill,issuretyrepay,entry_surety,entry_surety.suretyrepayamt");
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        DynamicObject loanCurrency = sourceBill.getDynamicObject("loancurrency");
        if (EmptyUtil.isEmpty((DynamicObject)loanCurrency)) {
            DynamicObject currency = sourceBill.getDynamicObject("currency");
            if (EmptyUtil.isEmpty((DynamicObject)currency)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e0a\u6e38\u5bf9\u5e94\u7684\u8fd8\u6b3e\u5355\u636e\u7684\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RepayBillPayBillWriteBackService_02", (String)"tmc-cfm-mservice", (Object[])new Object[0]));
            }
            return currency.getLong("id");
        }
        return loanCurrency.getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        return CfmBillCommonHelper.getNeedPayAmt((DynamicObject)sourceBill);
    }

    protected boolean beforePayBillWriteBack(List<PayBillWriteBackParam> writeBackParams) {
        super.beforePayBillWriteBack(writeBackParams);
        this.checkMergePayBillValid(writeBackParams);
        return true;
    }

    private void checkMergePayBillValid(List<PayBillWriteBackParam> writeBackParams) {
        DynamicObjectCollection repayBills;
        Map<String, List<DynamicObject>> map;
        if (!PayBillWriteBackOperateEnum.isValidate((String)writeBackParams.get(0).getOperate())) {
            return;
        }
        List billIds = writeBackParams.stream().map(p -> p.getPayBill().getSourceBillId()).collect(Collectors.toList());
        if (billIds.size() > 1 && (map = (repayBills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"billno,textcreditor,org.id,accountbank.id,currency.id,datasource", (QFilter[])new QFilter("id", "in", billIds).toArray())).stream().collect(Collectors.groupingBy(this::getKey))).size() > 1) {
            String billnos = repayBills.stream().map(d -> d.getString("billno")).collect(Collectors.joining(", "));
            boolean isBond = DataSourceEnum.isBond((String)((DynamicObject)repayBills.get(0)).getString("datasource"));
            if (isBond) {
                throw new KDBizException(CfmCommonResourceEnum.Push2PayValidator_12.loadKDString(new Object[]{billnos}));
            }
            throw new KDBizException(CfmCommonResourceEnum.Push2PayValidator_11.loadKDString(new Object[]{billnos}));
        }
    }

    private String getKey(DynamicObject repayBill) {
        boolean isBond = DataSourceEnum.isBond((String)repayBill.getString("datasource"));
        if (isBond) {
            return String.format("%d_%d_%d", repayBill.getLong("org.id"), repayBill.getLong("accountbank.id"), repayBill.getLong("currency.id"));
        }
        return String.format("%d_%s_%d_%d", repayBill.getLong("org.id"), repayBill.getString("textcreditor"), repayBill.getLong("accountbank.id"), repayBill.getLong("currency.id"));
    }
}

