/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LenderNatureEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.ListUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LenderNatureUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(LenderNatureUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result;
        block22: {
            result = new UpgradeResult();
            result.setEl("warning");
            long beginTime = System.currentTimeMillis();
            boolean withExc = false;
            try (TXHandle txHandle = TX.requiresNew();){
                long endTime;
                try {
                    result.setLog("start upgrade contractBill... ");
                    long begin = System.currentTimeMillis();
                    this.upgradeContract();
                    result.setLog("end upgrade contractBill... ");
                    result.setLog(String.format("upgradeContract take up time \uff1a%sms", System.currentTimeMillis() - begin));
                }
                catch (Exception e) {
                    try {
                        withExc = true;
                        result.setErrorInfo(e.getMessage());
                        result.setSuccess(false);
                        logger.info(e.getMessage());
                        logger.info(result.getErrorInfo());
                    }
                    catch (Throwable throwable) {
                        System.clearProperty("javax.net.debug");
                        long endTime2 = System.currentTimeMillis();
                        if (withExc) {
                            result.setLog(String.format("LenderNatureUpgradeService Exception take up time \uff1a%sms", endTime2 - beginTime));
                        } else {
                            result.setLog(String.format("LenderNatureUpgradeService no Exception take up time \uff1a%sms", endTime2 - beginTime));
                        }
                        throw throwable;
                    }
                    System.clearProperty("javax.net.debug");
                    endTime = System.currentTimeMillis();
                    if (withExc) {
                        result.setLog(String.format("LenderNatureUpgradeService Exception take up time \uff1a%sms", endTime - beginTime));
                    } else {
                        result.setLog(String.format("LenderNatureUpgradeService no Exception take up time \uff1a%sms", endTime - beginTime));
                    }
                    break block22;
                }
                System.clearProperty("javax.net.debug");
                endTime = System.currentTimeMillis();
                if (withExc) {
                    result.setLog(String.format("LenderNatureUpgradeService Exception take up time \uff1a%sms", endTime - beginTime));
                } else {
                    result.setLog(String.format("LenderNatureUpgradeService no Exception take up time \uff1a%sms", endTime - beginTime));
                }
            }
        }
        return result;
    }

    private void upgradeContract() {
        String querySql = "select fid, floantype, fcreditortype, fdebtortype, fcreditorid, fdebtorid, fdatasource from t_cfm_loancontractbill_e where floantype != 'bond' and fcreditortype != 'settlecenter' and fcreditortype != 'bank'";
        DataSet contractDs = DB.queryDataSet((String)"upgradeContract", (DBRoute)DBRouteConst.TMC, (String)querySql);
        querySql = "select fid, floantype, fcreditortype, fdebtortype, fcreditorid, fdebtorid, fdatasource from t_cfm_loancontractbill_e where floantype != 'bond' and fcreditortype != 'settlecenter' and fcreditortype = 'bank' and floantype != 'loan'";
        DataSet contractDs_sl = DB.queryDataSet((String)"upgradeContract", (DBRoute)DBRouteConst.TMC, (String)querySql);
        if (contractDs.isEmpty() && contractDs_sl.isEmpty()) {
            return;
        }
        if (contractDs.isEmpty()) {
            contractDs = contractDs_sl;
        } else if (!contractDs_sl.isEmpty()) {
            contractDs = contractDs.union(contractDs_sl);
        }
        List<Long> contractIds = this.getIds(contractDs);
        logger.info("upgradeContract: contractIds size = " + contractIds.size());
        for (List list : ListUtils.splitList(contractIds, (long)3000L)) {
            DataSet subDataSet = contractDs.copy().filter("fid in (" + TmcBusinessBaseHelper.idListToString((List)list) + ")");
            querySql = "select fid, ffinorginfoid from t_cfm_loancontractbill_ba where fid in (" + TmcBusinessBaseHelper.idListToString((List)list) + ")";
            DataSet banksLoanDs = DB.queryDataSet((String)"banksLoanDs", (DBRoute)DBRouteConst.TMC, (String)querySql);
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            Pair<List<Long>, List<Long>> idsPair = this.getIdsByType(subDataSet);
            List<Long> finOrgIds = this.getFinOrgIds((List)idsPair.getLeft());
            List<Long> customIds = this.getCustomIds((List)idsPair.getRight());
            for (Row contractObj : subDataSet) {
                String loanType = contractObj.getString("floantype");
                String creditorType = this.getType(contractObj);
                Long creditorId = this.getId(contractObj);
                String lenderNature = this.getLenderNature(loanType, creditorType, creditorId, finOrgIds, customIds, banksLoanDs.copy().filter("fid = " + contractObj.getString("fid")));
                Object[] params = new Object[]{lenderNature, contractObj.getLong("fid")};
                paramsList.add(params);
            }
            logger.info("upgradeContract: size= " + paramsList.size());
            String updateSql = "update t_cfm_loancontractbill set flendernature = ? where fid = ?";
            if (paramsList.size() <= 0) continue;
            for (List pl : ListUtils.splitList(paramsList, (long)500L)) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, (List)pl);
            }
        }
    }

    private String getLenderNature(String loanType, String type, Long creditorId, List<Long> finOrgIds, List<Long> customIds, DataSet dataSet) {
        String lenderNature = LenderNatureEnum.OUTGROUP.getValue();
        switch (type) {
            case "innerunit": 
            case "settlecenter": {
                lenderNature = LenderNatureEnum.INGROUP.getValue();
                break;
            }
            case "bank": {
                if (LoanTypeEnum.isBankLoan((String)loanType)) {
                    lenderNature = LenderNatureEnum.OUTGROUP.getValue();
                    break;
                }
                if (!LoanTypeEnum.isBanksLoan((String)loanType)) break;
                lenderNature = this.getLenderNatureByBanksLoan(dataSet);
                break;
            }
            case "finorg": {
                if (LoanTypeEnum.isBanksLoan((String)loanType)) {
                    lenderNature = this.getLenderNatureByBanksLoan(dataSet);
                    break;
                }
                lenderNature = finOrgIds.contains(creditorId) ? LenderNatureEnum.OUTGROUP.getValue() : LenderNatureEnum.INGROUP.getValue();
                break;
            }
            case "custom": {
                lenderNature = customIds.contains(creditorId) ? LenderNatureEnum.INGROUP.getValue() : LenderNatureEnum.OUTGROUP.getValue();
                break;
            }
            case "other": {
                lenderNature = LenderNatureEnum.OUTGROUP.getValue();
                break;
            }
        }
        dataSet.close();
        return lenderNature;
    }

    private String getLenderNatureByBanksLoan(DataSet dataSet) {
        if (dataSet.isEmpty()) {
            return LenderNatureEnum.OUTGROUP.getValue();
        }
        List<Long> finOrgIds = this.getFinOrgIds(this.getSLIds(dataSet));
        return finOrgIds.size() > 0 ? LenderNatureEnum.OUTGROUP.getValue() : LenderNatureEnum.INGROUP.getValue();
    }

    private String getType(Row contractObj) {
        return this.isCimInvest(contractObj) ? contractObj.getString("fdebtortype") : contractObj.getString("fcreditortype");
    }

    private Long getId(Row contractObj) {
        return this.isCimInvest(contractObj) ? contractObj.getLong("fdebtorid") : contractObj.getLong("fcreditorid");
    }

    private boolean isCimInvest(Row contractObj) {
        String loanType = contractObj.getString("floantype");
        String dataSource = contractObj.getString("fdatasource");
        return DataSourceEnum.isInvest((String)dataSource) && (LoanTypeEnum.isLinklend((String)loanType) || LoanTypeEnum.isEntrustLoan((String)loanType));
    }

    private List<Long> getFinOrgIds(List<Long> ids) {
        if (ids.size() == 0) {
            return new ArrayList<Long>(10);
        }
        String querySql = "select fid, forgid from t_bd_finorginfo where forgid = 0 and fid in (" + TmcBusinessBaseHelper.idListToString(ids) + ")";
        DataSet finOrgDataSet = DB.queryDataSet((String)"upgradeInitBill", (DBRoute)DBRouteConst.SYS, (String)querySql);
        return this.getIds(finOrgDataSet);
    }

    private List<Long> getCustomIds(List<Long> ids) {
        if (ids.size() == 0) {
            return new ArrayList<Long>(10);
        }
        String querySql = "select fid, finternalcompanyid from t_bd_bizpartner where finternalcompanyid != 0 and fid in (" + TmcBusinessBaseHelper.idListToString(ids) + ")";
        DataSet customDataSet = DB.queryDataSet((String)"upgradeInitBill", (DBRoute)DBRouteConst.SYS, (String)querySql);
        return this.getIds(customDataSet);
    }

    private Pair<List<Long>, List<Long>> getIdsByType(DataSet dataSet) {
        ArrayList<Long> ids_loan = new ArrayList<Long>(10);
        ArrayList<Long> ids_custom = new ArrayList<Long>(10);
        for (Row row : dataSet.copy()) {
            String type = this.getType(row);
            if (CreditorTypeEnum.FINORG.getValue().equals(type)) {
                if (!LoanTypeEnum.isBankLoan((String)row.getString("floantype"))) continue;
                ids_loan.add(this.getId(row));
                continue;
            }
            if (!CreditorTypeEnum.CUSTOM.getValue().equals(type)) continue;
            ids_custom.add(this.getId(row));
        }
        return Pair.of(ids_loan, ids_custom);
    }

    private Pair<List<Long>, List<Long>> getCreditorIdsByType(DataSet dataSet) {
        ArrayList<Long> ids_loan = new ArrayList<Long>(10);
        ArrayList<Long> ids_custom = new ArrayList<Long>(10);
        for (Row row : dataSet.copy()) {
            String creditorType = row.getString("fcreditortype");
            Long creditorId = row.getLong("fcreditorid");
            if (CreditorTypeEnum.FINORG.getValue().equals(creditorType)) {
                if (!LoanTypeEnum.isBankLoan((String)row.getString("floantype"))) continue;
                ids_loan.add(creditorId);
                continue;
            }
            if (!CreditorTypeEnum.CUSTOM.getValue().equals(creditorType)) continue;
            ids_custom.add(creditorId);
        }
        return Pair.of(ids_loan, ids_custom);
    }

    private List<Long> getSLIds(DataSet dataSet) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Row row : dataSet.copy()) {
            ids.add(row.getLong("ffinorginfoid"));
        }
        return ids;
    }

    private List<Long> getIds(DataSet dataSet) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Row row : dataSet.copy()) {
            ids.add(row.getLong("fid"));
        }
        return ids;
    }
}

