/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;

public class LoanApplyCostInfoUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(LoanApplyCostInfoUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                result.setLog("start upgrade loanApply costInfo");
                this.executeUpgrade();
                result.setLog("end upgrade loanApply costInfo");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.info(e.getMessage());
                logger.info(result.getErrorInfo());
            }
        }
        return result;
    }

    private void executeUpgrade() {
        String querySql = "select fid,finterestrate,fstartdate,fenddate,famount from t_cfm_loanapply where fisneedscheme = '0' and fid not in (select fid from t_cfm_loanapply_cost)";
        DataSet loanApplyBills = DB.queryDataSet((String)"upgradeLoanApplyCostInfo", (DBRoute)DBRouteConst.TMC, (String)querySql);
        if (loanApplyBills.isEmpty()) {
            return;
        }
        ArrayList<Object[]> bodyParamsList = new ArrayList<Object[]>();
        ArrayList<Object[]> entryParamsList = new ArrayList<Object[]>();
        int count = loanApplyBills.copy().count("fid", false);
        long[] entryIds = DB.genLongIds((String)"t_cfm_loanapply_cost", (int)count);
        int rowIndex = 0;
        String textCost = ResManager.loadKDString((String)"\u5229\u606f", (String)"LoanApplySchemeEditPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
        for (Object loanApplyBill : loanApplyBills) {
            BigDecimal instRate = loanApplyBill.getBigDecimal("finterestrate");
            Date startDate = loanApplyBill.getDate("fstartdate");
            Date endDate = loanApplyBill.getDate("fenddate");
            Object id = loanApplyBill.get("fid");
            BigDecimal amount = loanApplyBill.getBigDecimal("famount");
            BigDecimal costAmt = BigDecimal.ZERO;
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{instRate, startDate, endDate, amount}) && DateUtils.getDiffDays((Date)startDate, (Date)endDate) > 1) {
                int termDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate) - 1;
                costAmt = instRate.multiply(new BigDecimal(termDays)).multiply(amount).divide(new BigDecimal(36000), amount.scale(), 4);
            }
            bodyParamsList.add(new Object[]{costAmt, instRate, id});
            entryParamsList.add(new Object[]{id, entryIds[rowIndex], 1, textCost, 0, instRate, costAmt});
            ++rowIndex;
        }
        String updateSql = "update t_cfm_loanapply_e set fcompcost = ?, fcompcostrate = ? where fid = ?";
        for (List paramList : ListUtils.splitList(bodyParamsList, (long)500L)) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, (List)paramList);
        }
        String insertSql = "insert into t_cfm_loanapply_cost(fid, fentryid, fseq, ftextcost, fcostid, fcostrate, fcostamt) values (?, ?, ?, ?, ?, ?, ?)";
        for (List paramList : ListUtils.splitList(entryParamsList, (long)500L)) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)insertSql, (List)paramList);
        }
    }
}

