/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.upgrade;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class LoanBillUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(LoanBillUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                result.setLog("start upgrade t_cfm_loanbill_ca ");
                this.upgrade();
                result.setLog("end upgrade loanBill t_cfm_loanbill_ca");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.info(e.getMessage());
                logger.info(result.getErrorInfo());
            }
        }
        return result;
    }

    private void upgrade() {
        String querySql = "select lc.fpkid, l.fid loanid, lc.fbasedataid fbasedataid from t_cfm_loanbill_e l inner join t_cfm_loancontractbill_ca lc on l.floancontractbillid = lc.fid  where not exists (select ca.fid from t_cfm_loanbill_ca ca where ca.fid = l.fid)";
        DataSet wcDs = DB.queryDataSet((String)"upgradeWorkCalendar", (DBRoute)DBRouteConst.TMC, (String)querySql);
        if (wcDs.isEmpty()) {
            return;
        }
        for (Row row : wcDs) {
            Long loanId = row.getLong("loanid");
            Long basedataId = row.getLong("fbasedataid");
            Long id = DB.genGlobalLongId();
            String insertSQL = "insert into t_cfm_loanbill_ca(fpkid, fid, fbasedataid) values(?, ?, ?)";
            DB.execute((DBRoute)DBRouteConst.TMC, (String)insertSQL, (Object[])new Object[]{id, loanId, basedataId});
        }
        wcDs.close();
    }
}

