/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.enums;

import java.util.Arrays;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum InschemeEnum {
    YEAR("year", new MultiLangEnumBridge("\u5e74", "InschemeEnum_0", "tmc-cfm-common")),
    HALFYEAR("halfyear", new MultiLangEnumBridge("\u534a\u5e74", "InschemeEnum_1", "tmc-cfm-common")),
    QUARTER("quarter", new MultiLangEnumBridge("\u5b63\u5ea6", "InschemeEnum_2", "tmc-cfm-common")),
    MONTH("month", new MultiLangEnumBridge("\u6708", "InschemeEnum_3", "tmc-cfm-common")),
    TOYEAR("toyear", new MultiLangEnumBridge("\u5bf9\u5e74", "InschemeEnum_4", "tmc-cfm-common")),
    TOQUARTER("toquarter", new MultiLangEnumBridge("\u5bf9\u5b63", "InschemeEnum_7", "tmc-cfm-common")),
    TOMONTH("tomonth", new MultiLangEnumBridge("\u5bf9\u6708", "InschemeEnum_5", "tmc-cfm-common")),
    TOHALFYEAR("tohalfyear", new MultiLangEnumBridge("\u5bf9\u534a\u5e74", "InschemeEnum_9", "tmc-cfm-common")),
    ENDINTEREST("endinterest", new MultiLangEnumBridge("\u5230\u671f\u4e00\u6b21\u7ed3\u606f", "InschemeEnum_6", "tmc-cfm-common")),
    CUSTOM("custom", new MultiLangEnumBridge("\u81ea\u5b9a\u4e49\u7ed3\u606f\u65e5", "InschemeEnum_8", "tmc-cfm-common"));

    private String value;
    private MultiLangEnumBridge bridge;

    private InschemeEnum(String value, MultiLangEnumBridge bridge) {
        this.value = value;
        this.bridge = bridge;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static InschemeEnum getByValue(String value) {
        return Arrays.stream(InschemeEnum.values()).filter(e -> e.getValue().equals(value)).findFirst().orElse(null);
    }

    public static String getName(String value) {
        InschemeEnum inschemeEnum = InschemeEnum.getByValue(value);
        return inschemeEnum != null ? inschemeEnum.getName() : "";
    }

    public static boolean isCycle(String value) {
        return InschemeEnum.isYear(value) || InschemeEnum.isHalfYear(value) || InschemeEnum.isQuarter(value) || InschemeEnum.isMonth(value);
    }

    public static boolean isToCycle(String value) {
        return InschemeEnum.isToYear(value) || InschemeEnum.isToQuarter(value) || InschemeEnum.isToMonth(value) || InschemeEnum.isToHalfYear(value);
    }

    public static String getMonths(InschemeEnum inschemeEnum) {
        switch (inschemeEnum) {
            case YEAR: {
                return "12";
            }
            case HALFYEAR: {
                return "6,12";
            }
            case QUARTER: {
                return "3,6,9,12";
            }
            case MONTH: {
                return "1,2,3,4,5,6,7,8,9,10,11,12";
            }
        }
        return null;
    }

    public static boolean isYear(String value) {
        return YEAR.getValue().equals(value);
    }

    public static boolean isHalfYear(String value) {
        return HALFYEAR.getValue().equals(value);
    }

    public static boolean isQuarter(String value) {
        return QUARTER.getValue().equals(value);
    }

    public static boolean isMonth(String value) {
        return MONTH.getValue().equals(value);
    }

    public static boolean isToYear(String value) {
        return TOYEAR.getValue().equals(value);
    }

    public static boolean isToQuarter(String value) {
        return TOQUARTER.getValue().equals(value);
    }

    public static boolean isToMonth(String value) {
        return TOMONTH.getValue().equals(value);
    }

    public static boolean isToHalfYear(String value) {
        return TOHALFYEAR.getValue().equals(value);
    }

    public static boolean isEndinterest(String value) {
        return ENDINTEREST.getValue().equals(value);
    }

    public static boolean isCustom(String value) {
        return CUSTOM.getValue().equals(value);
    }
}

