/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cfm.common.constant.CfmEntityConst;
import kd.tmc.cfm.common.enums.AutoConfirmParamEnum;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.helper.DealBotpRelationHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BusinessHelper {
    public static final String OP_CONFIRM = "businessconfirm";

    public static void delPushRecPayBill(DynamicObject data) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)data.getDynamicObjectType().getName(), (Long[])new Long[]{data.getLong("id")});
        botpMap.forEach((entity, id) -> {
            if ("cas_recbill".equals(entity) || "cas_paybill".equals(entity)) {
                try (TXHandle tx = TX.requiresNew();){
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("isdelbypaysche", "1");
                    TmcOperateServiceHelper.execOperate((String)"delete", (String)entity, (Object[])id.toArray(), (OperateOption)operateOption);
                }
            }
        });
    }

    public static void fillConfirmInfo(List<DynamicObject> datas) {
        for (DynamicObject data : datas) {
            data.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
            data.set("confirmer", (Object)RequestContext.get().getCurrUserId());
            data.set("confirmtime", (Object)DateUtils.getCurrentTime());
        }
        DealBotpRelationHelper.creatOppositeBotpRelation(datas);
    }

    public static void fillConfirmInfo(DynamicObject data) {
        BusinessHelper.fillConfirmInfo(Collections.singletonList(data));
    }

    public static void clearConfirmInfo(List<DynamicObject> datas) {
        BusinessHelper.clearConfirmInfo(datas, ConfirmStatusEnum.WAITCONFIRM);
    }

    private static void clearConfirmInfo(List<DynamicObject> datas, ConfirmStatusEnum confirmStatus) {
        for (DynamicObject data : datas) {
            BusinessHelper.clearConfirmData(data, confirmStatus);
        }
        DealBotpRelationHelper.deleteOppositeBotpRelation(datas);
    }

    private static void clearConfirmData(DynamicObject data, ConfirmStatusEnum confirmStatus) {
        data.set("confirmstatus", (Object)confirmStatus.getValue());
        data.set("confirmer", null);
        data.set("confirmtime", null);
    }

    public static void clearConfirmInfo(DynamicObject data) {
        BusinessHelper.clearConfirmInfo(Collections.singletonList(data));
    }

    public static void clearConfirmInfoForUnAudit(List<DynamicObject> datas) {
        BusinessHelper.clearConfirmInfo(datas, ConfirmStatusEnum.REGISTRYING);
    }

    public static void clearConfirmInfoForUnAudit(DynamicObject data) {
        BusinessHelper.clearConfirmInfoForUnAudit(Collections.singletonList(data));
    }

    public static void clearConfirmInfoForBack(List<DynamicObject> datas) {
        BusinessHelper.clearConfirmInfo(datas, ConfirmStatusEnum.YETRETURN);
    }

    public static void clearConfirmInfoForBack(DynamicObject data) {
        BusinessHelper.clearConfirmData(data, ConfirmStatusEnum.YETRETURN);
    }

    public static void clearReturnreason(DynamicObject data) {
        data.set("returnreason", null);
    }

    @Deprecated
    public static DynamicObject getLoanApplyBill(DynamicObject loanContractBill) {
        return TmcBotpHelper.getSourceBill((String)"cfm_loancontractbill", (Object)loanContractBill.getPkValue(), (String)"cfm_loan_apply");
    }

    public static Map<Long, DynamicObject> getLoanApplyBill(List<DynamicObject> loanBills) {
        DynamicObject[] loanApplys;
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(loanBills.size());
        Map<Long, List<DynamicObject>> loanBillMap = loanBills.stream().collect(Collectors.groupingBy(d -> d.getLong("loancontractbill.id")));
        DynamicObjectCollection loanContractColl = QueryServiceHelper.query((String)"cfm_loancontractbill", (String)"id,loanapply", (QFilter[])new QFilter("id", "in", loanBillMap.keySet()).toArray());
        Map loanContractMap = loanContractColl.stream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("loanapply"))).collect(Collectors.groupingBy(d -> d.getLong("loanapply"), Collectors.mapping(d -> d.getLong("id"), Collectors.toList())));
        if (loanContractMap.isEmpty()) {
            return map;
        }
        for (DynamicObject loanApply : loanApplys = TmcDataServiceHelper.load((String)"cfm_loan_apply", (String)"id,billno,creditlimit", (QFilter[])new QFilter("id", "in", loanContractMap.keySet()).toArray())) {
            List loanContractIds = loanContractMap.get(loanApply.getLong("id"));
            for (Long loanContractId : loanContractIds) {
                List<DynamicObject> loanBillList = loanBillMap.get(loanContractId);
                loanBillList.forEach(d -> map.put(d.getLong("id"), loanApply));
            }
        }
        return map;
    }

    public static DynamicObject getLoanApplyBill(DynamicObject loanContractBill, String loanEntityName) {
        if (EmptyUtil.isEmpty((DynamicObject)loanContractBill)) {
            return null;
        }
        DynamicObject contractBill = TmcDataServiceHelper.loadSingle((String)"cfm_loancontractbill", (String)"loanapply", (QFilter[])new QFilter[]{new QFilter("id", "=", loanContractBill.getPkValue())});
        if (EmptyUtil.isEmpty((DynamicObject)contractBill) || EmptyUtil.isEmpty((DynamicObject)contractBill.getDynamicObject("loanapply"))) {
            return null;
        }
        DynamicObject applyF7 = contractBill.getDynamicObject("loanapply");
        return TmcDataServiceHelper.loadSingle((String)"cfm_loan_apply", (String)"id,billno,creditlimit", (QFilter[])new QFilter[]{new QFilter("id", "=", applyF7.getPkValue())});
    }

    public static boolean isAutoConfirm(DynamicObject data) {
        boolean isAuto = BusinessHelper.isOutGroup(data);
        if (isAuto) {
            return true;
        }
        String entityName = data.getDataEntityType().getName();
        if (CfmEntityEnum.CONTRACTBILL.getValue().equals(entityName) || CfmEntityEnum.INVEST_CONTRACT.getValue().equals(entityName)) {
            return false;
        }
        if (CfmEntityConst.isLeaseContractBill(entityName) || "fl_receiptbill".equals(entityName) || "fl_rentpaybill".equals(entityName)) {
            return true;
        }
        String dataSource = data.getString("datasource");
        String orgFieldName = CfmBillCommonHelper.getFundOrgFieldName(dataSource, false);
        DynamicObject org = data.getDynamicObject(orgFieldName);
        HashSet<String> autoOps = new HashSet<String>(5);
        if (DataSourceEnum.INVEST.getValue().equals(dataSource)) {
            autoOps.addAll(CfmSysParamHelper.getParameterComboxs(org.getLong("id"), "cfm001"));
        } else {
            autoOps.addAll(CfmSysParamHelper.getParameterComboxs(org.getLong("id"), "cim001"));
        }
        if ((CfmEntityEnum.INVEST_EXTENDBILL.getValue().equals(entityName) || CfmEntityEnum.EXTENDBILL.getValue().equals(entityName)) && autoOps.contains(AutoConfirmParamEnum.EXTEND.getValue())) {
            isAuto = true;
        } else if ((CfmEntityEnum.INVEST_LOANBILL.getValue().equals(entityName) || CfmEntityEnum.LOANBILL.getValue().equals(entityName)) && autoOps.contains(AutoConfirmParamEnum.LOAN.getValue())) {
            isAuto = true;
        } else if ((CfmEntityEnum.INVEST_INTERESTBILL.getValue().equals(entityName) || CfmEntityEnum.INTERESTBILL.getValue().equals(entityName)) && autoOps.contains(AutoConfirmParamEnum.INTEREST.getValue())) {
            isAuto = true;
        } else if ((CfmEntityEnum.INVEST_REPAYBILL.getValue().equals(entityName) || CfmEntityEnum.REPAYMENTBILL.getValue().equals(entityName)) && autoOps.contains(AutoConfirmParamEnum.REPAY.getValue())) {
            isAuto = true;
        } else if ((CfmEntityEnum.PREINTERESTBILL.getValue().equals(entityName) || CfmEntityEnum.CIM_PREINTERESTBILL.getValue().equals(entityName)) && autoOps.contains(AutoConfirmParamEnum.PREINTEREST.getValue())) {
            isAuto = true;
        }
        return isAuto;
    }

    public static boolean isSameSource(String entityName, String dataSource) {
        boolean isSame = false;
        if (DataSourceEnum.INVEST.getValue().equals(dataSource) && (CfmEntityEnum.INVEST_CONTRACT.getValue().equals(entityName) || CfmEntityEnum.INVEST_EXTENDBILL.getValue().equals(entityName) || CfmEntityEnum.INVEST_LOANBILL.getValue().equals(entityName) || CfmEntityEnum.INVEST_INTERESTBILL.getValue().equals(entityName) || CfmEntityEnum.INVEST_REPAYBILL.getValue().equals(entityName)) || DataSourceEnum.CFM.getValue().equals(dataSource) && (CfmEntityEnum.CONTRACTBILL.getValue().equals(entityName) || CfmEntityEnum.EXTENDBILL.getValue().equals(entityName) || CfmEntityEnum.LOANBILL.getValue().equals(entityName) || CfmEntityEnum.INTERESTBILL.getValue().equals(entityName) || CfmEntityEnum.REPAYMENTBILL.getValue().equals(entityName))) {
            isSame = true;
        }
        return isSame;
    }

    public static String checkTargetBills(String entityName, Long billId) {
        return BusinessHelper.checkTargetBills(entityName, billId, null);
    }

    public static Map<Long, String> checkTargetBills(List<String> entityNames, List<Long> billIds, Set<String> excludeEntityNames, Map<String, QFilter> filterMap) {
        HashMap<Long, String> msgMap = new HashMap<Long, String>(billIds.size());
        HashMap<Long, Map> targetBillNoMap = new HashMap<Long, Map>(billIds.size());
        for (String entityName : entityNames) {
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"ifm_interestbill")) {
                if (excludeEntityNames == null) {
                    excludeEntityNames = new HashSet<String>(1);
                }
                excludeEntityNames.add("ifm_transhandlebill");
                excludeEntityNames.add("ifm_rectransbill");
            }
            Map billNoMap = TmcBotpHelper.getTargetBillNoMap((String)entityName, billIds, excludeEntityNames, null, filterMap);
            for (Map.Entry entry : billNoMap.entrySet()) {
                Long billId = (Long)entry.getKey();
                Map listMap = targetBillNoMap.computeIfAbsent(billId, d -> new HashMap(2));
                listMap.putAll((Map)entry.getValue());
            }
        }
        if (EmptyUtil.isEmpty(targetBillNoMap)) {
            return msgMap;
        }
        for (Long billId : billIds) {
            StringBuilder msgBuilder = new StringBuilder();
            Map billnoMap = (Map)targetBillNoMap.get(billId);
            if (EmptyUtil.isEmpty((Object)billnoMap)) continue;
            for (Map.Entry entry : billnoMap.entrySet()) {
                String entityDisplayName = EntityMetadataCache.getDataEntityType((String)((String)entry.getKey())).getDisplayName().getLocaleValue();
                String billNos = ((List)entry.getValue()).stream().collect(Collectors.joining(","));
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e[%2$s]\u3002", (String)"AbstractBizResource_101", (String)"tmc-cfm-common", (Object[])new Object[0]), entityDisplayName, billNos);
                msgBuilder.append(msg);
            }
            msgBuilder.insert(0, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"AbstractBizResource_100", (String)"tmc-cfm-common", (Object[])new Object[0]));
            msgMap.put(billId, msgBuilder.toString());
        }
        billIds.forEach(d -> msgMap.putIfAbsent((Long)d, ""));
        return msgMap;
    }

    public static Map<Long, String> checkTargetBills(String entityName, List<Long> billIds, Set<String> excludeEntityNames, Map<String, QFilter> filterMap) {
        ArrayList<String> entityNames = new ArrayList<String>(2);
        entityNames.add(entityName);
        String oppoEntityName = CfmEntityEnum.getOtherSideEntityName(entityName);
        if (EmptyUtil.isNoEmpty((String)oppoEntityName)) {
            entityNames.add(oppoEntityName);
        }
        return BusinessHelper.checkTargetBills(entityNames, billIds, excludeEntityNames, filterMap);
    }

    public static String checkTargetBills(String entityName, Long billId, Map<String, QFilter> filterMap) {
        String otherSideEntityName;
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource("");
        StringBuilder msg = new StringBuilder();
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{billId});
        if (botpMap != null && botpMap.size() > 0) {
            for (Map.Entry entry : botpMap.entrySet()) {
                String key = (String)entry.getKey();
                HashSet targetBillIds = (HashSet)entry.getValue();
                if (StringUtils.equals((CharSequence)entityName, (CharSequence)"ifm_interestbill") && StringUtils.equals((CharSequence)key, (CharSequence)"ifm_transhandlebill") || BusinessHelper.checkForYkx(filterMap, key, targetBillIds) || BusinessHelper.checkForSettle(key, entityName, billId)) continue;
                QFilter filter = null == filterMap ? null : filterMap.get(key);
                String existBillsMsg = BusinessHelper.findExistBillsMsg(key, targetBillIds, filter);
                msg.append(existBillsMsg);
            }
        }
        if (!StringUtils.isBlank((CharSequence)(otherSideEntityName = BusinessHelper.getOtherSideEntityName(entityName))) && (botpMap = BFTrackerServiceHelper.findTargetBills((String)otherSideEntityName, (Long[])new Long[]{billId})) != null && botpMap.size() > 0) {
            QFilter filter;
            HashSet payBillIds = (HashSet)botpMap.get(CfmEntityEnum.CAS_PAYBILL.getValue());
            QFilter qFilter = filter = null == filterMap ? null : filterMap.get(CfmEntityEnum.CAS_PAYBILL.getValue());
            if (payBillIds != null && payBillIds.size() > 0) {
                String existBillsMsg = BusinessHelper.findExistBillsMsg(CfmEntityEnum.CAS_PAYBILL.getValue(), payBillIds, filter);
                msg.append(existBillsMsg);
            }
            HashSet recBillIds = (HashSet)botpMap.get(CfmEntityEnum.CAS_RECBILL.getValue());
            QFilter qFilter2 = filter = null == filterMap ? null : filterMap.get(CfmEntityEnum.CAS_RECBILL.getValue());
            if (recBillIds != null && recBillIds.size() > 0) {
                String existBillsMsg = BusinessHelper.findExistBillsMsg(CfmEntityEnum.CAS_RECBILL.getValue(), recBillIds, filter);
                msg.append(existBillsMsg);
            }
        }
        if (msg.length() > 0) {
            msg.insert(0, bizResource.getExistTargetBillError());
        }
        return msg.toString();
    }

    public static String findExistBillsMsg(String targetEntityName, HashSet<Long> targetBillIds, QFilter filter) {
        DynamicObjectCollection query;
        QFilter qfilter = new QFilter("id", "in", targetBillIds);
        if (EmptyUtil.isNoEmpty((Object)filter)) {
            qfilter.and(filter);
        }
        if ((query = QueryServiceHelper.query((String)targetEntityName, (String)"billno", (QFilter[])new QFilter[]{qfilter})) == null || query.size() <= 0) {
            return "";
        }
        List billnos = query.stream().map(v -> v.getString("billno")).collect(Collectors.toList());
        String targetBillName = EntityMetadataCache.getDataEntityType((String)targetEntityName).getDisplayName().getLocaleValue();
        return String.format(new BizResourceFactory().getBizResource("").getExistTargetBillDetail(), StringUtils.isBlank((CharSequence)targetBillName) ? targetEntityName : targetBillName, String.join((CharSequence)",", billnos));
    }

    private static String getOtherSideEntityName(String entityName) {
        return CfmEntityEnum.getOtherSideEntityName(entityName);
    }

    public static String getLocalValue(DynamicObject obj, String prop) {
        if (EmptyUtil.isEmpty((DynamicObject)obj) || EmptyUtil.isEmpty((String)prop)) {
            return "";
        }
        String localeValue = obj.getLocaleString(prop).getLocaleValue();
        if (EmptyUtil.isEmpty((String)localeValue)) {
            String value = obj.getString(prop);
            return EmptyUtil.isEmpty((String)value) ? "" : value;
        }
        return localeValue;
    }

    public static Map<Long, String> checkTargetBillForInnerLoan(List<DynamicObject> bills, Map<String, QFilter> extFilterMap) {
        if (EmptyUtil.isEmpty(bills)) {
            return Collections.emptyMap();
        }
        List<Long> billIds = bills.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        HashSet<String> excludeTargetEntitys = new HashSet<String>(10);
        excludeTargetEntitys.add("ifm_rectransbill");
        excludeTargetEntitys.add("ifm_transhandlebill");
        return BusinessHelper.checkTargetBills(bills.get(0).getDataEntityType().getName(), billIds, excludeTargetEntitys, extFilterMap);
    }

    public static Map<Long, String> checkTargetBillForNotInnerLoan(List<DynamicObject> bills, Map<String, QFilter> extFilterMap) {
        if (EmptyUtil.isEmpty(bills)) {
            return Collections.emptyMap();
        }
        String entityName = bills.get(0).getDataEntityType().getName();
        List<Long> billIds = bills.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(16);
        filterMap.put(CfmEntityEnum.CAS_PAYBILL.getValue(), new QFilter("billstatus", "not in", Arrays.asList("G", "F")));
        if (EmptyUtil.isNoEmpty(extFilterMap)) {
            filterMap.putAll(extFilterMap);
        }
        return BusinessHelper.checkTargetBills(entityName, billIds, null, filterMap);
    }

    public static String checkTargetBillForInnerLoan(String entityName, Long billId, AbstractBizResource bizResource) {
        return BusinessHelper.checkTargetBillForInnerLoan(entityName, billId, bizResource, null);
    }

    public static String checkTargetBillForInnerLoan(String entityName, Long billId, AbstractBizResource bizResource, Map<String, QFilter> filterMap) {
        StringBuilder msg = new StringBuilder();
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{billId});
        if (botpMap != null && botpMap.size() > 0) {
            for (Map.Entry entry : botpMap.entrySet()) {
                String billName = (String)entry.getKey();
                String key = (String)entry.getKey();
                HashSet targetBillIds = (HashSet)entry.getValue();
                if ("ifm_rectransbill".equals(billName) || "ifm_transhandlebill".equals(billName) || BusinessHelper.checkForYkx(filterMap, key, targetBillIds)) continue;
                String existBillsMsg = BusinessHelper.findExistBillsMsg(key, targetBillIds, null);
                msg.append(existBillsMsg);
            }
        }
        if (msg.length() > 0) {
            msg.insert(0, bizResource.getExistTargetBillError());
        }
        return msg.toString();
    }

    private static boolean checkForYkx(Map<String, QFilter> filterMap, String entityName, HashSet<Long> targetBillIds) {
        if (filterMap == null || !filterMap.containsKey("ykx")) {
            return false;
        }
        if (!CfmEntityEnum.isInterestBill(entityName)) {
            return false;
        }
        QFilter qFilter = new QFilter("id", "in", targetBillIds).and("instbillctg", "=", (Object)InterestbillctgEnum.PREPAYINT.getValue());
        DynamicObjectCollection interestBills = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)interestBills)) {
            for (DynamicObject interestBill : interestBills) {
                targetBillIds.remove(interestBill.getLong("id"));
            }
        }
        return targetBillIds.isEmpty();
    }

    private static boolean checkForSettle(String key, String entityName, Long billId) {
        List<String> checkBills = Arrays.asList("cas_recbill", "cas_paybill", "ifm_transhandlebill", "ifm_rectransbill", "cas_bankjournal");
        if (!checkBills.contains(key)) {
            return false;
        }
        DynamicObject bill = QueryServiceHelper.queryOne((String)entityName, (String)"creditortype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        return null != bill && StringUtils.equals((CharSequence)bill.getString("creditortype"), (CharSequence)"settlecenter");
    }

    public static boolean isOutGroup(DynamicObject data) {
        String creditorType;
        boolean isOutGroup = DataSourceEnum.isInvest(data.getString("datasource")) ? !CreditorTypeEnum.isInnerUnit((String)data.getString("debtortype")) : !CreditorTypeEnum.isInnerUnit((String)(creditorType = data.getString("creditortype"))) && !CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType);
        return isOutGroup;
    }

    public static Set<Long> getEntryBillIds(DynamicObjectCollection colls, String field) {
        Set<Long> billIds = new HashSet<Long>();
        if (EmptyUtil.isEmpty((DynamicObjectCollection)colls) || EmptyUtil.isEmpty((String)field)) {
            return billIds;
        }
        billIds = colls.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject(field))).map(o -> o.getDynamicObject(field).getLong("id")).collect(Collectors.toSet());
        return billIds;
    }

    public static List<Long> getBillIds(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return Collections.emptyList();
        }
        return dataEntities.stream().map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getBizBillIds(List<DynamicObject> bills) {
        if (EmptyUtil.isEmpty(bills)) {
            return Collections.emptyList();
        }
        return bills.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
    }

    public static Long getBillId(ExtendedDataEntity dataEntity) {
        return dataEntity.getDataEntity().getLong("id");
    }

    public static List<DynamicObject> getBills(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return Collections.emptyList();
        }
        return dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
    }

    public static int getCurrencyPresion(DynamicObject currency) {
        return EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 2;
    }

    public static AbstractBizResource getBizResource(DynamicObject bill) {
        return new BizResourceFactory().getBizResource(bill.getString("datasource"));
    }
}

