/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CfmAttachmentHelper {
    private static Log logger = LogFactory.getLog(CfmAttachmentHelper.class);

    public static void dealAttachment(DynamicObject[] dataEntities) {
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        String entityName = dataEntities[0].getDataEntityType().getName();
        String oppositeEntity = CfmAttachmentHelper.getOppositeEntity(entityName);
        if (EmptyUtil.isEmpty((String)oppositeEntity)) {
            return;
        }
        List billIds = Arrays.stream(dataEntities).map(d -> d.getPkValue().toString()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("FBillType", "=", (Object)oppositeEntity).and("FInterID", "in", billIds);
        List deleteAttachs = QueryServiceHelper.queryPrimaryKeys((String)"bos_attachment", (QFilter[])qFilter.toArray(), null, (int)-1);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_attachment");
        qFilter = new QFilter("FBillType", "=", (Object)entityName).and(new QFilter("FInterID", "in", billIds));
        Object[] entityAttachs = BusinessDataServiceHelper.load((String)"bos_attachment", (String)String.join((CharSequence)",", dataEntityType.getFields().keySet()), (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> insertAttachs = new ArrayList<DynamicObject>(entityAttachs.length);
        if (EmptyUtil.isNoEmpty((Object[])entityAttachs)) {
            for (Object entityAttach : entityAttachs) {
                DynamicObject newAttach = TmcDataServiceHelper.clone((DynamicObject)entityAttach);
                newAttach.set("FBillType", (Object)oppositeEntity);
                insertAttachs.add(newAttach);
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (!deleteAttachs.isEmpty()) {
                    DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])deleteAttachs.toArray());
                }
                if (!insertAttachs.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])insertAttachs.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u540c\u6b65\u9644\u4ef6\u5f02\u5e38\uff1a" + entityName + e);
            }
        }
    }

    public static String getOppositeEntity(String entityName) {
        return CfmEntityEnum.getOtherSideEntityName(entityName);
    }
}

