/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.bean.FloatRateCalBean;
import kd.tmc.cfm.common.bean.RateAdjustBean;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustCycleTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.RateAdjustHelper;
import kd.tmc.cfm.common.repository.RateAdjustBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateCycleWayEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.model.interest.WorkCalendarAdjustParam;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class CfmRateAdjustHelper {
    private static final Log logger = LogFactory.getLog(CfmRateAdjustHelper.class);
    private static final String[] rateAdjustProps = new String[]{"id", "interestrate", "afterinterestrate", "refrate", "refrate.number", "afterrefrate.number", "afterrefrate", "ratesign", "ratefloatpoint", "afterratesign", "afterratefloatpoint", "rateadjustkey", "rateadjustval", "afterrateadjustkey", "afterrateadjustval", "adjusteffectdate", "issofrrate", "entry.ldrawbill", "entry.lloanrate", "entry.afterlloanrate", "entry.lratesign", "entry.lratefloatpoint", "entry.afterlratesign", "entry.afterlratefloatpoint", "entry.lisadjust", "entry.lrateadjustdate", "entry.lissofrrate", "entry.lrefrate", "entry.lrefrate.number", "entry.afterlrefrate", "entry.afterlrefrate.number", "entry.lrateadjustkey", "entry.lrateadjustval", "entry.afterlrateadjustkey", "entry.afterlrateadjustval", "entry.ladjusteffectdate"};
    private static final String[] contractExtProps = new String[]{"id", "renewalexpiredate", "renewalinteresttype", "renewalinterestrate", "isadjustinterestrate", "referencerate", "ratesign", "rateadjuststyle", "ratefloatpoint", "rateadjustcycletype", "rateadjustcycle", "referencerate.number", "loanbilllist.drawbillid", "loanbilllist.isrenewal", "loanbilllist.e_prevrenewalexpiredate", "loanbilllist.lrenewalexpiredate", "loanbilllist.exrateadjustdate", "loanbilllist.loanrate"};
    private static final String[] contractBondExtProps = new String[]{"id", "renewalexpiredate", "renewalinteresttype", "renewalinterestrate", "isadjustinterestrate", "referencerate", "ratesign", "rateadjuststyle", "ratefloatpoint", "rateadjustcycletype", "rateadjustcycle", "referencerate.number", "loanbilllist.drawbillid", "loanbilllist.isrenewal", "loanbilllist.e_prevrenewalexpiredate", "loanbilllist.lrenewalexpiredate", "loanbilllist.exrateadjustdate", "loanbilllist.loanrate", "loanbilllist.lisadjustinterestrate", "loanbilllist.lreferencerate", "loanbilllist.lreferencerate.number", "loanbilllist.lrateadjuststyle", "loanbilllist.lratesign", "loanbilllist.lratefloatpoint"};

    public static void showRateAdjustForm(Long pkId, Long contractId, IFormView view) {
        BillShowParameter param = new BillShowParameter();
        if (EmptyUtil.isNoEmpty((Long)pkId)) {
            param.setPkId((Object)pkId);
        } else {
            param.setCustomParam("RATEADJUSTBILLEDIT_CONTRACTID", (Object)contractId);
        }
        param.setCustomParam("biztype", (Object)CfmRateAdjustHelper.getBizType(view));
        param.setFormId(CfmRateAdjustHelper.getFormEntity(view));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillStatus(BillOperationStatus.EDIT);
        param.setStatus(OperationStatus.EDIT);
        view.showForm((FormShowParameter)param);
    }

    public static String getBizType(IFormView view) {
        String bizType = "loan,sl";
        String formId = CfmRateAdjustHelper.getFormIdFromView(view);
        if (StringUtils.equals((CharSequence)"cfm_loancontract_ic_l", (CharSequence)formId) || StringUtils.equals((CharSequence)"cim_invest_contract", (CharSequence)formId)) {
            bizType = "entrust,ec";
        } else if (StringUtils.equals((CharSequence)"cfm_loancontract_bo", (CharSequence)formId)) {
            bizType = "bond";
        }
        return bizType;
    }

    public static List<String> getBizTypes(IFormView view) {
        String bizType = CfmRateAdjustHelper.getBizType(view);
        List<String> bizTypes = Arrays.asList(bizType.split(","));
        return bizTypes;
    }

    public static String getFormIdFromView(IFormView view) {
        String formId = "";
        if (view instanceof BillView) {
            formId = ((BillView)view).getFormId();
        } else if (view instanceof ListView) {
            formId = ((ListView)view).getBillFormId();
        }
        return formId;
    }

    public static String getFormEntity(IFormView view) {
        String formId = CfmRateAdjustHelper.getFormIdFromView(view);
        String resultEntity = "cfm_rateadjustbill";
        switch (formId) {
            case "cfm_loancontract_ic_l": {
                resultEntity = "cfm_rateadjustbill_e_l";
                break;
            }
            case "cim_invest_contract": {
                resultEntity = "cim_rateadjustbill";
                break;
            }
            case "ifm_loancontractbill": {
                resultEntity = "ifm_rateadjustbill";
                break;
            }
            case "cfm_loancontract_bo": {
                resultEntity = "cfm_rateadjustbill_bond";
                break;
            }
        }
        return resultEntity;
    }

    public static String getFormEntityFromLoanBill(IFormView view) {
        String formId = CfmRateAdjustHelper.getFormIdFromView(view);
        String resultEntity = "cfm_rateadjustbill";
        switch (formId) {
            case "cfm_loanbill_e_l": {
                resultEntity = "cfm_rateadjustbill_e_l";
                break;
            }
            case "cim_invest_loanbill": {
                resultEntity = "cim_rateadjustbill";
                break;
            }
            case "ifm_loanbill": {
                resultEntity = "ifm_rateadjustbill";
                break;
            }
            case "cfm_loanbill_bond": {
                resultEntity = "cfm_rateadjustbill_bond";
                break;
            }
        }
        return resultEntity;
    }

    public static String getFormEntityFromRateAdjustBill(IFormView view) {
        String formId = CfmRateAdjustHelper.getFormIdFromView(view);
        String resultEntity = "cfm_loanbill_b_l";
        switch (formId) {
            case "cfm_rateadjustbill_e_l": {
                resultEntity = "cfm_loanbill_e_l";
                break;
            }
            case "cim_rateadjustbill": {
                resultEntity = "cim_invest_loanbill";
                break;
            }
            case "ifm_rateadjustbill": {
                resultEntity = "ifm_loanbill";
                break;
            }
            case "cfm_rateadjustbill_bond": {
                resultEntity = "cfm_loanbill_bond";
                break;
            }
        }
        return resultEntity;
    }

    public static void updateRateAdjustList(List<DynamicObject> loanBills, LoanWBTypeEnum loanWBTypeEnum, boolean isFromSch) {
        Map<Long, List<DynamicObject>> loanBillMap = loanBills.stream().collect(Collectors.groupingBy(d -> d.getLong("loancontractbill.id")));
        Map<Long, DynamicObject> rateAdjustBillMap = RateAdjustBillRepository.getRateAdjustBillByContractIds(new ArrayList<Long>(loanBillMap.keySet()));
        for (Map.Entry<Long, List<DynamicObject>> entry : loanBillMap.entrySet()) {
            Long contractId = entry.getKey();
            List<DynamicObject> loanBillList = entry.getValue();
            DynamicObject rateAdjustBill = rateAdjustBillMap.get(contractId);
            for (DynamicObject loanBill : loanBillList) {
                CfmRateAdjustHelper.updateRateAdjustListByLoanBill(loanBill, rateAdjustBill, loanWBTypeEnum, isFromSch);
            }
        }
    }

    public static void updateRateAdjustList(DynamicObject loanBill, LoanWBTypeEnum loanWBTypeEnum, boolean isFromSch) {
        CfmRateAdjustHelper.updateRateAdjustList(Collections.singletonList(loanBill), loanWBTypeEnum, isFromSch);
    }

    private static void updateRateAdjustListByLoanBill(DynamicObject loanBill, DynamicObject rateAdjustBill, LoanWBTypeEnum loanWBTypeEnum, boolean isFromSch) {
        logger.info("start updateRateAdjustList way ...");
        String interestType = loanBill.getString("interesttype");
        DynamicObjectCollection rateAdjustEntry = loanBill.getDynamicObjectCollection("rateadjust_entry");
        List<RateAdjustBean> rateAdjustList = new ArrayList(10);
        ArrayList<FloatRateCalBean> floatRateBizSegmBeans = new ArrayList(10);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)rateAdjustEntry) || !InterestTypeEnum.FLOAT.getValue().equals(interestType) || !RateAdjustStyleEnum.isHand(loanBill.getString("rateadjuststyle"))) {
            logger.info("start getRateAdjustList ...");
            Map<String, List> rateAdjustBeanMap = CfmRateAdjustHelper.getRateAdjustList(loanBill, loanWBTypeEnum, rateAdjustBill);
            rateAdjustList = rateAdjustBeanMap.get("rateAdjustBeanList");
            floatRateBizSegmBeans = rateAdjustBeanMap.get("floatRateBizSegmBeans");
        }
        if (RateAdjustStyleEnum.isHand(loanBill.getString("rateadjuststyle")) && !loanBill.getBoolean("israteadjustbyhand")) {
            logger.info("isHand start getRateAdjustList ...");
            rateAdjustList = CfmRateAdjustHelper.getRateAdjustList(rateAdjustList, rateAdjustBill);
        }
        if (rateAdjustList != null && !rateAdjustList.isEmpty()) {
            logger.info("rateAdjustList start insert rateAdjustEntry :\n" + SerializationUtils.toJsonString(rateAdjustList));
            rateAdjustList.sort(Comparator.comparing(RateAdjustBean::getEffectDate));
            if (EmptyUtil.isNoEmpty((DynamicObject)rateAdjustBill) && rateAdjustBill != null) {
                logger.info("rateAdjustList end insert rateAdjustEntry by loanType change :\n" + SerializationUtils.toJsonString(rateAdjustList));
                CfmRateAdjustHelper.updateRateAdjustList(loanBill, rateAdjustBill, rateAdjustList, floatRateBizSegmBeans, isFromSch);
            } else {
                logger.info("rateAdjustList end insert rateAdjustEntry no loanType change :\n" + SerializationUtils.toJsonString(rateAdjustList));
                CfmRateAdjustHelper.updateRateAdjustList(loanBill, rateAdjustList, floatRateBizSegmBeans, isFromSch);
            }
            loanBill.set("startloanrate", (Object)rateAdjustList.get(0).getYearRate());
        }
    }

    private static void updateRateAdjustList(DynamicObject loanBill, List<RateAdjustBean> rateAdjustList, List<FloatRateCalBean> floatRateBizSegmBeans, boolean isFromSch) {
        DynamicObjectCollection rateAdjustEntry = loanBill.getDynamicObjectCollection("rateadjust_entry");
        boolean isRateAdjustByHand = loanBill.getBoolean("israteadjustbyhand");
        int seq = 1;
        if (isRateAdjustByHand && floatRateBizSegmBeans.size() > 0) {
            logger.info("isRateAdjustByHand rateAdjustList end update rateAdjustEntry by hand :\n" + SerializationUtils.toJsonString((Object)rateAdjustEntry));
            if (isFromSch) {
                RateAdjustHelper.getRateAdjustEntry(rateAdjustEntry, floatRateBizSegmBeans, null, null, isFromSch);
                logger.info("isFromSch rateAdjustList update rateAdjustEntry just for yearRate :\n" + SerializationUtils.toJsonString((Object)rateAdjustEntry));
            } else {
                Date lastAdjustDate = RateAdjustHelper.getLastAdjustDate(floatRateBizSegmBeans);
                RateAdjustHelper.getRateAdjustEntry(rateAdjustEntry, lastAdjustDate, seq);
                RateAdjustHelper.getRateAdjustEntry(rateAdjustEntry, floatRateBizSegmBeans, null, lastAdjustDate, isFromSch);
                logger.info("isNotFromSch rateAdjustList update rateAdjustEntry just for yearRate :\n" + SerializationUtils.toJsonString((Object)rateAdjustEntry));
                CfmRateAdjustHelper.getRateAdjus1tBill(rateAdjustEntry, rateAdjustList, lastAdjustDate);
                logger.info("isNotFromSch rateAdjustList update rateAdjustEntry append new :\n" + SerializationUtils.toJsonString((Object)rateAdjustEntry));
            }
        } else {
            rateAdjustEntry.clear();
            logger.info("rateAdjustList end insert rateAdjustEntry no loanType change :\n" + SerializationUtils.toJsonString(rateAdjustList));
            for (RateAdjustBean rateAdjustBean : rateAdjustList) {
                CfmRateAdjustHelper.getRateAdjustList(rateAdjustBean, rateAdjustEntry, seq);
            }
        }
    }

    private static void updateRateAdjustList(DynamicObject loanBill, DynamicObject rateAdjustBill, List<RateAdjustBean> rateAdjustList, List<FloatRateCalBean> floatRateBizSegmBeans, boolean isFromSch) {
        DynamicObjectCollection rateAdjustEntry = loanBill.getDynamicObjectCollection("rateadjust_entry");
        boolean isRateAdjustByHand = loanBill.getBoolean("israteadjustbyhand");
        int seq = 1;
        Date adjustEffectDate = rateAdjustBill.getDate("entry.ladjusteffectdate");
        if (isRateAdjustByHand && floatRateBizSegmBeans.size() > 0) {
            logger.info("isRateAdjustByHand rateAdjustList end update rateAdjustEntry by hand :\n" + SerializationUtils.toJsonString((Object)rateAdjustEntry));
            if (isFromSch) {
                RateAdjustHelper.getRateAdjustEntry(rateAdjustEntry, floatRateBizSegmBeans, adjustEffectDate, null, isFromSch);
                logger.info("isFromSch rateAdjustList update rateAdjustEntry just for yearRate :\n" + SerializationUtils.toJsonString((Object)rateAdjustEntry));
            } else {
                Date lastAdjustDate = RateAdjustHelper.getLastAdjustDate(floatRateBizSegmBeans);
                RateAdjustHelper.getRateAdjustEntry(rateAdjustEntry, lastAdjustDate, seq);
                RateAdjustHelper.getRateAdjustEntry(rateAdjustEntry, floatRateBizSegmBeans, adjustEffectDate, lastAdjustDate, isFromSch);
                logger.info("isNotFromSch rateAdjustList update rateAdjustEntry just for yearRate :\n" + SerializationUtils.toJsonString((Object)rateAdjustEntry));
                CfmRateAdjustHelper.getRateAdjus1tBill(rateAdjustEntry, rateAdjustList, lastAdjustDate);
                logger.info("isNotFromSch rateAdjustList update rateAdjustEntry append new :\n" + SerializationUtils.toJsonString((Object)rateAdjustEntry));
            }
        } else {
            RateAdjustHelper.getRateAdjustEntry(rateAdjustEntry, adjustEffectDate, seq);
            seq = rateAdjustEntry.size() + 1;
            Date loanDate = loanBill.getDate("bizdate");
            Date actStartIntDate = loanBill.getDate("startintdate");
            actStartIntDate = loanDate.compareTo(actStartIntDate) > 0 ? actStartIntDate : loanDate;
            for (RateAdjustBean rateAdjustBean : rateAdjustList) {
                if (seq != 1 && (rateAdjustBean.getEffectDate().compareTo(adjustEffectDate) < 0 || rateAdjustBean.getEffectDate().compareTo(actStartIntDate) < 0)) continue;
                logger.info("rateAdjustList end insert rateAdjustEntry append new float rate :\n" + SerializationUtils.toJsonString(rateAdjustList));
                if (seq == 1 && rateAdjustBean.getEffectDate().compareTo(adjustEffectDate) < 0) {
                    rateAdjustBean.setYearRate(BigDecimal.ZERO);
                }
                CfmRateAdjustHelper.getRateAdjustList(rateAdjustBean, rateAdjustEntry, seq);
            }
        }
    }

    private static void getRateAdjus1tBill(DynamicObjectCollection rateAdjustEntry, List<RateAdjustBean> rateAdjustList, Date adjustEffectDate) {
        int seq = rateAdjustEntry.size() + 1;
        for (RateAdjustBean rateAdjustBean : rateAdjustList) {
            if (rateAdjustBean.getEffectDate().compareTo(adjustEffectDate) < 0) continue;
            CfmRateAdjustHelper.getRateAdjustList(rateAdjustBean, rateAdjustEntry, seq);
        }
    }

    private static void getRateAdjustList(RateAdjustBean rateAdjustBean, DynamicObjectCollection rateAdjustEntry, int seq) {
        DynamicObject rateAdjustEntryDo = rateAdjustEntry.addNew();
        rateAdjustEntryDo.set("seq", (Object)seq++);
        rateAdjustEntryDo.set("ra_confirmdate", (Object)rateAdjustBean.getConfirmDate());
        rateAdjustEntryDo.set("ra_effectdate", (Object)rateAdjustBean.getEffectDate());
        rateAdjustEntryDo.set("ra_yearrate", (Object)rateAdjustBean.getYearRate());
        rateAdjustEntryDo.set("ra_remark", (Object)rateAdjustBean.getRemark());
        rateAdjustEntryDo.set("ra_datasource", (Object)"auto");
        rateAdjustEntryDo.set("ra_modifier", (Object)rateAdjustBean.getModifier());
        rateAdjustEntryDo.set("ra_modifydate", (Object)rateAdjustBean.getModifyDate());
    }

    private static List<RateAdjustBean> getRateAdjustList(List<RateAdjustBean> rateAdjustList, DynamicObject rateAdjustBill) {
        if (EmptyUtil.isNoEmpty((DynamicObject)rateAdjustBill) && rateAdjustBill != null) {
            String refrateNum = rateAdjustBill.getString("afterrefrate.number");
            Date adjustEffectDate = rateAdjustBill.getDate("entry.ladjusteffectdate");
            String rateSign = rateAdjustBill.getString("afterratesign");
            BigDecimal rateFloatPoint = rateAdjustBill.getBigDecimal("afterratefloatpoint");
            BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
            if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                rateFloat = rateFloat.negate();
            }
            BigDecimal referRate = MarketDataServiceHelper.referRate((String)refrateNum, (Date)adjustEffectDate, (boolean)false);
            CfmRateAdjustHelper.volidRateIsExit(referRate);
            rateAdjustList.add(new RateAdjustBean(adjustEffectDate, adjustEffectDate, referRate.add(rateFloat)));
        }
        return rateAdjustList;
    }

    public static Map<String, List> getRateAdjustList(DynamicObject loanbill, LoanWBTypeEnum loanWBTypeEnum, DynamicObject rateAdjustBill) {
        DynamicObjectCollection rateAdjNoBills = CfmRateAdjustHelper.getRateAdjNoBills(loanbill, rateAdjustBill);
        DynamicObjectCollection extBills = CfmRateAdjustHelper.getExtBills(loanbill, rateAdjustBill);
        HashMap<String, List> rateAdjustBeanMap = new HashMap(2);
        List<RateAdjustBean> rateAdjustBeanList = null;
        Date actStartIntDate = loanbill.getDate("startintdate");
        String interestType = loanbill.getString("interesttype");
        if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            rateAdjustBeanMap = CfmRateAdjustHelper.adjustRateByFloatRate(loanbill, rateAdjNoBills, extBills, actStartIntDate);
        } else if (InterestTypeEnum.FIXED.getValue().equals(interestType) || InterestTypeEnum.AGREE.getValue().equals(interestType)) {
            rateAdjustBeanList = CfmRateAdjustHelper.adjustRateByFixedRate(loanbill, rateAdjNoBills, extBills, actStartIntDate, loanWBTypeEnum);
            rateAdjustBeanMap.put("rateAdjustBeanList", rateAdjustBeanList);
            rateAdjustBeanMap.put("floatRateBizSegmBeans", new ArrayList(1));
        }
        return rateAdjustBeanMap;
    }

    private static List<RateAdjustBean> adjustRateByFixedRate(DynamicObject loanbill, DynamicObjectCollection rateAdjNoBills, DynamicObjectCollection extBills, Date actStartIntDate, LoanWBTypeEnum loanWBTypeEnum) {
        boolean isBondExtend;
        ArrayList<RateAdjustBean> rateAdjustBeanList = new ArrayList<RateAdjustBean>(10);
        logger.info("interesttype-->fixedactStartIntDate: " + actStartIntDate);
        List<Object> beforeEndDateRateAdjNoBills = new ArrayList<DynamicObject>(8);
        List<Object> afterEndDateRateAdjNoBills = new ArrayList<DynamicObject>(8);
        if (rateAdjNoBills != null) {
            beforeEndDateRateAdjNoBills = rateAdjNoBills.stream().filter(r -> r.getDate("entry.ladjusteffectdate").compareTo(loanbill.getDate("expiredate")) <= 0).collect(Collectors.toList());
            afterEndDateRateAdjNoBills = rateAdjNoBills.stream().filter(r -> r.getDate("entry.ladjusteffectdate").compareTo(loanbill.getDate("expiredate")) > 0).collect(Collectors.toList());
        }
        CfmRateAdjustHelper.adjustRateByFixedRate(loanbill, beforeEndDateRateAdjNoBills, rateAdjustBeanList, actStartIntDate);
        boolean bl = isBondExtend = LoanWBTypeEnum.EXTEND == loanWBTypeEnum && LoanTypeEnum.isBond(loanbill.getString("loantype"));
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)extBills)) {
            CfmRateAdjustHelper.dealExtendFixRate(loanbill, extBills, rateAdjustBeanList, afterEndDateRateAdjNoBills, isBondExtend);
        }
        return rateAdjustBeanList;
    }

    private static void dealExtendFixRate(DynamicObject loanbill, DynamicObjectCollection extBills, List<RateAdjustBean> rateAdjustBeanList, List<DynamicObject> afterEndDateRateAdjNoBills, boolean isBondExtend) {
        DynamicObjectCollection rateAdjustEntry;
        for (DynamicObject extBill : extBills) {
            logger.info("interesttype-->fixed  extBills");
            Date startDate = extBill.getDate("loanbilllist.e_prevrenewalexpiredate");
            Date endDate = extBill.getDate("loanbilllist.lrenewalexpiredate");
            List<DynamicObject> rateAdjustTemp = afterEndDateRateAdjNoBills;
            if (EmptyUtil.isEmpty(rateAdjustTemp)) {
                CfmRateAdjustHelper.dealExtendRateAdjust(extBill, rateAdjustBeanList, startDate, isBondExtend);
                continue;
            }
            List<DynamicObject> innerRateBills = rateAdjustTemp.stream().filter(r -> r.getDate("entry.ladjusteffectdate").compareTo(endDate) <= 0).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(innerRateBills)) {
                CfmRateAdjustHelper.dealExtendRateAdjust(extBill, rateAdjustBeanList, startDate, isBondExtend);
                continue;
            }
            CfmRateAdjustHelper.adjustRateByFixedRateNotNull(loanbill, innerRateBills, rateAdjustBeanList, startDate);
            rateAdjustTemp.removeAll(innerRateBills);
        }
        if (isBondExtend && (rateAdjustEntry = loanbill.getDynamicObjectCollection("rateadjust_entry")).size() > 0) {
            Date ra_confirmdate = ((DynamicObject)rateAdjustEntry.get(0)).getDate("ra_confirmdate");
            BigDecimal ra_yearrate = ((DynamicObject)rateAdjustEntry.get(0)).getBigDecimal("ra_yearrate");
            CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(ra_confirmdate, ra_confirmdate, ra_yearrate));
        }
    }

    private static void dealExtendRateAdjust(DynamicObject extBill, List<RateAdjustBean> rateAdjustBeanList, Date startDate, boolean isBondExtend) {
        if (extBill.getBoolean("isadjustinterestrate")) {
            CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(startDate, startDate, extBill.getBigDecimal("renewalinterestrate")));
        } else if (isBondExtend) {
            BigDecimal yearRate = extBill.getBigDecimal("loanbilllist.loanrate");
            CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(startDate, startDate, yearRate));
        } else {
            rateAdjustBeanList.sort(Comparator.comparing(RateAdjustBean::getEffectDate));
            CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(startDate, startDate, rateAdjustBeanList.get(rateAdjustBeanList.size() - 1).getYearRate()));
        }
    }

    private static void adjustRateByFixedRate(DynamicObject loanbill, List<DynamicObject> rateAdjNoBills, List<RateAdjustBean> rateAdjustBeanList, Date actStartIntDate) {
        if (rateAdjNoBills != null && rateAdjNoBills.size() > 0) {
            logger.info("interesttype-->fixed  rateAdjNoBills");
            CfmRateAdjustHelper.adjustRateByFixedRateNotNull(loanbill, rateAdjNoBills, rateAdjustBeanList, actStartIntDate);
        } else {
            logger.info("interesttype-->fixed  normal");
            boolean isPerpetual = CfmRateAdjustHelper.isPerpetualBond(loanbill);
            if (isPerpetual) {
                CfmRateAdjustHelper.buildRateAdjustEntry(rateAdjustBeanList, loanbill, actStartIntDate, null, null);
            } else {
                CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(actStartIntDate, actStartIntDate, loanbill.getBigDecimal("loanrate")));
            }
        }
    }

    private static void adjustRateByFixedRateNotNull(DynamicObject loanbill, List<DynamicObject> rateAdjNoBills, List<RateAdjustBean> rateAdjustBeanList, Date actStartIntDate) {
        for (DynamicObject rateAdjNoBill : rateAdjNoBills) {
            BigDecimal afterIntRate = rateAdjNoBill.getBigDecimal("entry.afterlloanrate");
            boolean isPerpetual = CfmRateAdjustHelper.isPerpetualBond(loanbill);
            if (isPerpetual) {
                afterIntRate = CfmRateAdjustHelper.getRateAfterCompare(loanbill, afterIntRate);
            }
            Date adjustEffectDate = rateAdjNoBill.getDate("entry.ladjusteffectdate");
            CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(adjustEffectDate, adjustEffectDate, afterIntRate));
        }
        Date firstDate = rateAdjustBeanList.stream().map(RateAdjustBean::getEffectDate).min(Date::compareTo).orElseGet(null);
        if (EmptyUtil.isEmpty((Object)firstDate) || firstDate.compareTo(actStartIntDate) != 0) {
            BigDecimal preAdjustRate = rateAdjNoBills.get(rateAdjNoBills.size() - 1).getBigDecimal("entry.lloanrate");
            boolean isPerpetual = CfmRateAdjustHelper.isPerpetualBond(loanbill);
            if (isPerpetual) {
                CfmRateAdjustHelper.buildRateAdjustEntry(rateAdjustBeanList, loanbill, actStartIntDate, firstDate, preAdjustRate);
            } else {
                CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(actStartIntDate, actStartIntDate, preAdjustRate));
            }
        }
    }

    private static Map<String, List> adjustRateByFloatRate(DynamicObject loanbill, DynamicObjectCollection rateAdjNoBills, DynamicObjectCollection extBills, Date actStartIntDate) {
        HashMap<String, List> rateAdjustBeanMap = new HashMap<String, List>(2);
        ArrayList<RateAdjustBean> rateAdjustBeanList = new ArrayList<RateAdjustBean>(10);
        logger.info("interesttype-->float");
        ArrayList<FloatRateCalBean> floatRateBizSegmBeans = new ArrayList<FloatRateCalBean>(10);
        List<Object> beforeEndDateRateAdjNoBills = new ArrayList<DynamicObject>(10);
        List<Object> afterEndDateRateAdjNoBills = new ArrayList<DynamicObject>(10);
        if (rateAdjNoBills != null) {
            beforeEndDateRateAdjNoBills = rateAdjNoBills.stream().filter(r -> r.getDate("entry.ladjusteffectdate").compareTo(loanbill.getDate("expiredate")) <= 0).collect(Collectors.toList());
            afterEndDateRateAdjNoBills = rateAdjNoBills.stream().filter(r -> r.getDate("entry.ladjusteffectdate").compareTo(loanbill.getDate("expiredate")) > 0).collect(Collectors.toList());
        }
        CfmRateAdjustHelper.dealFloatRateAdjustList(beforeEndDateRateAdjNoBills, floatRateBizSegmBeans, loanbill, actStartIntDate, extBills, afterEndDateRateAdjNoBills);
        boolean isBond = LoanTypeEnum.isBond(loanbill.getString("loantype"));
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)extBills)) {
            if (isBond) {
                CfmRateAdjustHelper.dealBondExtFloatRateList(afterEndDateRateAdjNoBills, extBills, floatRateBizSegmBeans, loanbill);
            } else {
                CfmRateAdjustHelper.dealExtFloatRateList(afterEndDateRateAdjNoBills, extBills, loanbill, floatRateBizSegmBeans);
            }
        }
        DynamicObjectCollection instbills = null;
        boolean afterInt = RateAdjustStyleEnum.isAfterint(loanbill.getString("rateadjuststyle"));
        if (afterInt) {
            QFilter loanFilter = new QFilter("sourcebillid", "=", (Object)loanbill.getLong("id")).and("instbillctg", "!=", (Object)"payprinandinte").and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            instbills = QueryServiceHelper.query((String)"cfm_interestbill", (String)String.join((CharSequence)",", "id,endinstdate"), (QFilter[])loanFilter.toArray());
        }
        floatRateBizSegmBeans.sort(Comparator.comparing(FloatRateCalBean::getStartDate).thenComparing(FloatRateCalBean::getEndDate));
        rateAdjustBeanMap.put("floatRateBizSegmBeans", floatRateBizSegmBeans);
        logger.info("floatRateBizSegmBeans:\n" + SerializationUtils.toJsonString(floatRateBizSegmBeans));
        for (FloatRateCalBean floatRateSegBean : floatRateBizSegmBeans) {
            List<RateAdjustBean> rateAdjustBeans;
            if (afterInt) {
                logger.info("afterInt:{}", (Object)afterInt);
                rateAdjustBeans = CfmRateAdjustHelper.dealAfterIntRowAdjustRate(floatRateSegBean, loanbill, instbills);
            } else {
                rateAdjustBeans = CfmRateAdjustHelper.dealNewRowAdjustRate(floatRateSegBean, loanbill);
            }
            Date startDate = floatRateSegBean.getStartDate();
            for (RateAdjustBean rateAdjustBean : rateAdjustBeans) {
                if (isBond) {
                    CfmRateAdjustHelper.definListAdd4Bond(rateAdjustBeanList, rateAdjustBean, startDate);
                    continue;
                }
                CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, rateAdjustBean);
            }
        }
        logger.info("rateAdjustBeanList:\n" + SerializationUtils.toJsonString(rateAdjustBeanList));
        rateAdjustBeanMap.put("rateAdjustBeanList", rateAdjustBeanList);
        return rateAdjustBeanMap;
    }

    private static void dealFloatRateAdjustList(List<DynamicObject> rateAdjNoBills, List<FloatRateCalBean> floatRateBizSegmBeans, DynamicObject loanbill, Date actStartIntDate, DynamicObjectCollection extBills, List<DynamicObject> afterEndDateRateAdjNoBills) {
        Date rateAdjustDate = loanbill.getDate("rateadjustdate");
        String rateAdjustStyle = loanbill.getString("rateadjuststyle");
        Date endDate = CfmRateAdjustHelper.getEndDate(loanbill, extBills, afterEndDateRateAdjNoBills);
        if (rateAdjNoBills != null && rateAdjNoBills.size() > 0) {
            Date chgEndDate = endDate;
            for (DynamicObject rateAdjNoBill : rateAdjNoBills) {
                FloatRateCalBean floatRate = new FloatRateCalBean();
                Date effectDate = rateAdjNoBill.getDate("entry.ladjusteffectdate");
                floatRate.setConfirmDate(effectDate);
                floatRate.setStartDate(effectDate);
                floatRate.setEndDate(chgEndDate);
                chgEndDate = effectDate;
                floatRate.setRateAdjustStyle(rateAdjustStyle);
                floatRate.setFirstAdjust(true);
                Date lrateAdjustDate = rateAdjNoBill.getDate("entry.lrateadjustdate");
                floatRate.setFirstAdjustDate(EmptyUtil.isEmpty((Object)lrateAdjustDate) ? effectDate : lrateAdjustDate);
                CfmRateAdjustHelper.setRateAdjustCycle(loanbill, rateAdjNoBill, floatRate, false);
                floatRate.setRateSign(rateAdjNoBill.getString("entry.afterlratesign"));
                floatRate.setRateBasePoint(rateAdjNoBill.getBigDecimal("entry.afterlratefloatpoint"));
                floatRateBizSegmBeans.add(floatRate);
            }
            DynamicObject rateAdjustBill = rateAdjNoBills.get(rateAdjNoBills.size() - 1);
            FloatRateCalBean firstRate = new FloatRateCalBean();
            firstRate.setRateAdjustStyle(rateAdjustStyle);
            firstRate.setConfirmDate(actStartIntDate);
            firstRate.setStartDate(actStartIntDate);
            firstRate.setEndDate(chgEndDate);
            firstRate.setFirstAdjustDate(rateAdjustDate);
            firstRate.setFirstAdjust(true);
            CfmRateAdjustHelper.setRateAdjustCycle(loanbill, rateAdjustBill, firstRate, true);
            firstRate.setRateSign(rateAdjustBill.getString("entry.lratesign"));
            firstRate.setRateBasePoint(rateAdjustBill.getBigDecimal("entry.lratefloatpoint"));
            floatRateBizSegmBeans.add(firstRate);
        } else {
            FloatRateCalBean floatRate = new FloatRateCalBean();
            floatRate.setConfirmDate(actStartIntDate);
            floatRate.setStartDate(actStartIntDate);
            floatRate.setEndDate(endDate);
            floatRate.setRefrateNum(loanbill.getDynamicObject("referencerate").getString("number"));
            floatRate.setRateAdjustStyle(rateAdjustStyle);
            floatRate.setFirstAdjustDate(rateAdjustDate);
            floatRate.setFirstAdjust(true);
            floatRate.setRateAdjustType(loanbill.getString("rateadjustcycletype"));
            floatRate.setRateAdjustCycle(loanbill.getInt("rateadjustcycle"));
            floatRate.setRateSign(loanbill.getString("ratesign"));
            floatRate.setRateBasePoint(loanbill.getBigDecimal("ratefloatpoint"));
            floatRateBizSegmBeans.add(floatRate);
        }
    }

    private static void setRateAdjustCycle(DynamicObject loanbill, DynamicObject rateAdjNoBill, FloatRateCalBean floatRate, boolean isFirst) {
        String loanRateAdjustKey = loanbill.getString("rateadjustcycletype");
        int loanRateAdjustVal = loanbill.getInt("rateadjustcycle");
        if (isFirst) {
            floatRate.setRefrateNum(rateAdjNoBill.getString("entry.lrefrate.number"));
            String rateAdjustKey = rateAdjNoBill.getString("entry.lrateadjustkey");
            int rateAdjustVal = rateAdjNoBill.getInt("entry.lrateadjustval");
            floatRate.setRateAdjustType(EmptyUtil.isEmpty((String)rateAdjustKey) ? loanRateAdjustKey : rateAdjustKey);
            floatRate.setRateAdjustCycle(rateAdjustVal == 0 ? loanRateAdjustVal : rateAdjustVal);
        } else {
            floatRate.setRefrateNum(rateAdjNoBill.getString("entry.afterlrefrate.number"));
            String afterRateAdjustKey = rateAdjNoBill.getString("entry.afterlrateadjustkey");
            int afterRateAdjustVal = rateAdjNoBill.getInt("entry.afterlrateadjustval");
            floatRate.setRateAdjustType(EmptyUtil.isEmpty((String)afterRateAdjustKey) ? loanRateAdjustKey : afterRateAdjustKey);
            floatRate.setRateAdjustCycle(afterRateAdjustVal == 0 ? loanRateAdjustVal : afterRateAdjustVal);
        }
    }

    private static Date getEndDate(DynamicObject loanbill, DynamicObjectCollection extBills, List<DynamicObject> afterEndDateRateAdjNoBills) {
        Date endDate = loanbill.getDate("expiredate");
        Date renewalExpireDate = loanbill.getDate("renewalexpiredate");
        if (EmptyUtil.isNoEmpty((Object)renewalExpireDate)) {
            Date adjustDate = renewalExpireDate;
            for (DynamicObject extBill : extBills) {
                boolean isBond = LoanTypeEnum.isBond(loanbill.getString("loantype"));
                if (!extBill.getBoolean("isadjustinterestrate") && (!isBond || !extBill.getBoolean("loanbilllist.lisadjustinterestrate"))) continue;
                Date preExpireDate = extBill.getDate("loanbilllist.e_prevrenewalexpiredate");
                adjustDate = adjustDate.compareTo(preExpireDate) >= 0 ? preExpireDate : adjustDate;
            }
            for (DynamicObject rateAdj : afterEndDateRateAdjNoBills) {
                Date adjustEffectDate = rateAdj.getDate("entry.ladjusteffectdate");
                adjustDate = adjustDate.compareTo(adjustEffectDate) >= 0 ? adjustEffectDate : adjustDate;
            }
            endDate = adjustDate;
        }
        return endDate;
    }

    private static void dealFloatRateAdjust(List<DynamicObject> rateAdjNoBills, List<FloatRateCalBean> floatRateBizSegmBeans, DynamicObject extBill, DynamicObject loanbill, Date beginDate, Date endDate, Date rateAdjustDate) {
        String referenceRate;
        String loanRateAdjustKey = loanbill.getString("rateadjustcycletype");
        int loanRateAdjustVal = loanbill.getInt("rateadjustcycle");
        boolean isAdjustRate = extBill.getBoolean("isadjustinterestrate");
        boolean isBond = LoanTypeEnum.isBond(loanbill.getString("loantype"));
        if (isBond) {
            isAdjustRate = extBill.getBoolean("loanbilllist.lisadjustinterestrate");
        }
        String rateAdjustStyle = loanbill.getString("rateadjuststyle");
        String string = referenceRate = isAdjustRate ? extBill.getString("referencerate.number") : loanbill.getDynamicObject("referencerate").getString("number");
        if (isBond) {
            referenceRate = isAdjustRate ? extBill.getString("loanbilllist.lreferencerate.number") : loanbill.getDynamicObject("referencerate").getString("number");
        }
        String rateAdjustCycleType = isAdjustRate ? extBill.getString("rateadjustcycletype") : loanRateAdjustKey;
        int rateAdjustCycle = isAdjustRate ? extBill.getInt("rateadjustcycle") : loanRateAdjustVal;
        Date chgEndDate = endDate;
        for (DynamicObject rateAdjNoBill : rateAdjNoBills) {
            FloatRateCalBean floatRate = new FloatRateCalBean();
            Date effectDate = rateAdjNoBill.getDate("entry.ladjusteffectdate");
            floatRate.setConfirmDate(effectDate);
            floatRate.setStartDate(effectDate);
            floatRate.setEndDate(chgEndDate);
            chgEndDate = effectDate;
            floatRate.setRateAdjustStyle(rateAdjustStyle);
            floatRate.setFirstAdjust(true);
            Date lrateAdjustDate = rateAdjNoBill.getDate("entry.lrateadjustdate");
            floatRate.setFirstAdjustDate(EmptyUtil.isEmpty((Object)lrateAdjustDate) ? effectDate : lrateAdjustDate);
            CfmRateAdjustHelper.setRateAdjustCycle(loanbill, rateAdjNoBill, floatRate, false);
            floatRate.setRateSign(rateAdjNoBill.getString("entry.afterlratesign"));
            floatRate.setRateBasePoint(rateAdjNoBill.getBigDecimal("entry.afterlratefloatpoint"));
            floatRateBizSegmBeans.add(floatRate);
        }
        DynamicObject rateAdjustBill = rateAdjNoBills.get(rateAdjNoBills.size() - 1);
        Date adjustEffectDate = isAdjustRate ? beginDate : rateAdjustBill.getDate("entry.ladjusteffectdate");
        FloatRateCalBean firstRate = new FloatRateCalBean();
        firstRate.setRateAdjustStyle(rateAdjustStyle);
        firstRate.setStartDate(adjustEffectDate);
        firstRate.setConfirmDate(adjustEffectDate);
        firstRate.setEndDate(chgEndDate);
        Date fistAdjustDate = rateAdjustDate;
        if (LoanTypeEnum.BOND.getValue().equals(loanbill.getString("loantype")) || EmptyUtil.isEmpty((Object)fistAdjustDate)) {
            fistAdjustDate = beginDate;
        }
        fistAdjustDate = isAdjustRate ? fistAdjustDate : rateAdjustBill.getDate("entry.ladjusteffectdate");
        firstRate.setFirstAdjustDate(fistAdjustDate);
        firstRate.setFirstAdjust(true);
        firstRate.setRefrateNum(referenceRate);
        firstRate.setRateAdjustType(EmptyUtil.isEmpty((String)rateAdjustCycleType) ? loanRateAdjustKey : rateAdjustCycleType);
        firstRate.setRateAdjustCycle(rateAdjustCycle == 0 ? loanRateAdjustVal : rateAdjustCycle);
        firstRate.setRateSign(rateAdjustBill.getString("entry.lratesign"));
        firstRate.setRateBasePoint(rateAdjustBill.getBigDecimal("entry.lratefloatpoint"));
        floatRateBizSegmBeans.add(firstRate);
    }

    private static void dealExtFloatRateList(List<DynamicObject> rateAdjustBills, DynamicObjectCollection extBills, DynamicObject loanbill, List<FloatRateCalBean> floatRateBizSegmBeans) {
        List<DynamicObject> rateAdjustTemp = rateAdjustBills;
        for (DynamicObject extBill : extBills) {
            Date startDate = extBill.getDate("loanbilllist.e_prevrenewalexpiredate");
            Date endDate = extBill.getDate("loanbilllist.lrenewalexpiredate");
            Date rateAdjustDate = extBill.getDate("loanbilllist.exrateadjustdate");
            if (EmptyUtil.isEmpty(rateAdjustTemp)) {
                CfmRateAdjustHelper.dealExtendBillWhenNoRateBill(extBill, startDate, endDate, floatRateBizSegmBeans, loanbill);
                continue;
            }
            List<DynamicObject> innerRateBills = rateAdjustTemp.stream().filter(r -> r.getDate("entry.ladjusteffectdate").compareTo(endDate) <= 0).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(innerRateBills)) {
                CfmRateAdjustHelper.dealExtendBillWhenNoRateBill(extBill, startDate, endDate, floatRateBizSegmBeans, loanbill);
                continue;
            }
            CfmRateAdjustHelper.dealFloatRateAdjust(innerRateBills, floatRateBizSegmBeans, extBill, loanbill, startDate, endDate, rateAdjustDate);
            rateAdjustTemp.removeAll(innerRateBills);
        }
    }

    private static void dealExtendBillWhenNoRateBill(DynamicObject extBill, Date startDate, Date endDate, List<FloatRateCalBean> floatRateBizSegmBeans, DynamicObject loanbill) {
        String loanRateAdjustKey = loanbill.getString("rateadjustcycletype");
        int loanRateAdjustVal = loanbill.getInt("rateadjustcycle");
        String rateAdjustStyle = loanbill.getString("rateadjuststyle");
        if (extBill.getBoolean("isadjustinterestrate")) {
            FloatRateCalBean floatRate = new FloatRateCalBean();
            floatRate.setFirstAdjust(true);
            floatRate.setConfirmDate(startDate);
            floatRate.setStartDate(startDate);
            floatRate.setEndDate(endDate);
            floatRate.setLoanRate(extBill.getBigDecimal("renewalinterestrate"));
            floatRate.setRefrateNum(extBill.getString("referencerate.number"));
            floatRate.setRateAdjustStyle(rateAdjustStyle);
            Date exRateAdjustDate = extBill.getDate("loanbilllist.exrateadjustdate");
            floatRate.setFirstAdjustDate(EmptyUtil.isEmpty((Object)exRateAdjustDate) ? startDate : exRateAdjustDate);
            String afterRateAdjustKey = extBill.getString("rateadjustcycletype");
            int afterRateAdjustVal = extBill.getInt("rateadjustcycle");
            floatRate.setRateAdjustType(EmptyUtil.isEmpty((String)afterRateAdjustKey) ? loanRateAdjustKey : afterRateAdjustKey);
            floatRate.setRateAdjustCycle(afterRateAdjustVal == 0 ? loanRateAdjustVal : afterRateAdjustVal);
            floatRate.setRateSign(extBill.getString("ratesign"));
            floatRate.setRateBasePoint(extBill.getBigDecimal("ratefloatpoint"));
            floatRateBizSegmBeans.add(floatRate);
        } else {
            Optional<FloatRateCalBean> maxOptional = floatRateBizSegmBeans.stream().filter(o -> o.getStartDate().compareTo(startDate) <= 0).max(Comparator.comparing(FloatRateCalBean::getEndDate));
            if (maxOptional.isPresent()) {
                FloatRateCalBean floatRate = maxOptional.get();
                floatRate.setEndDate(endDate);
            }
        }
    }

    private static void dealBondExtFloatRateList(List<DynamicObject> rateAdjustBills, DynamicObjectCollection extBills, List<FloatRateCalBean> floatRateBizSegmBeans, DynamicObject loanbill) {
        List<DynamicObject> rateAdjustTemp = rateAdjustBills;
        for (DynamicObject extBill : extBills) {
            Date startDate = extBill.getDate("loanbilllist.e_prevrenewalexpiredate");
            Date endDate = extBill.getDate("loanbilllist.lrenewalexpiredate");
            Date rateAdjustDate = extBill.getDate("loanbilllist.exrateadjustdate");
            if (EmptyUtil.isEmpty(rateAdjustTemp)) {
                CfmRateAdjustHelper.dealBondExtFloatRate(floatRateBizSegmBeans, extBill, loanbill, rateAdjustDate, startDate, endDate);
                continue;
            }
            List<DynamicObject> innerRateBills = rateAdjustTemp.stream().filter(r -> r.getDate("entry.ladjusteffectdate").compareTo(endDate) <= 0).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(innerRateBills)) {
                CfmRateAdjustHelper.dealBondExtFloatRate(floatRateBizSegmBeans, extBill, loanbill, rateAdjustDate, startDate, endDate);
                continue;
            }
            CfmRateAdjustHelper.dealFloatRateAdjust(innerRateBills, floatRateBizSegmBeans, extBill, loanbill, startDate, endDate, rateAdjustDate);
            rateAdjustTemp.removeAll(innerRateBills);
        }
    }

    private static void dealBondExtFloatRate(List<FloatRateCalBean> floatRateBizSegmBeans, DynamicObject extBill, DynamicObject loanbill, Date rateAdjustDate, Date startDate, Date endDate) {
        if (!extBill.getBoolean("loanbilllist.lisadjustinterestrate")) {
            return;
        }
        FloatRateCalBean floatRate = new FloatRateCalBean();
        floatRate.setFirstAdjust(true);
        floatRate.setConfirmDate(startDate);
        floatRate.setStartDate(startDate);
        floatRate.setEndDate(endDate);
        floatRate.setRefrateNum(extBill.getString("loanbilllist.lreferencerate.number"));
        floatRate.setRateAdjustStyle(extBill.getString("loanbilllist.lrateadjuststyle"));
        floatRate.setRateAdjustType(loanbill.getString("rateadjustcycletype"));
        floatRate.setRateAdjustCycle(loanbill.getInt("rateadjustcycle"));
        floatRate.setFirstAdjustDate(EmptyUtil.isEmpty((Object)rateAdjustDate) ? startDate : rateAdjustDate);
        floatRate.setRateSign(extBill.getString("loanbilllist.lratesign"));
        floatRate.setRateBasePoint(extBill.getBigDecimal("loanbilllist.lratefloatpoint"));
        floatRateBizSegmBeans.add(floatRate);
    }

    private static List<RateAdjustBean> dealAfterIntRowAdjustRate(FloatRateCalBean floatRateSegBean, DynamicObject loanBill, DynamicObjectCollection instbills) {
        ArrayList<RateAdjustBean> rateAdjustBeanList = new ArrayList<RateAdjustBean>(16);
        BigDecimal rateFloat = RateAdjustHelper.getRateFloat(floatRateSegBean);
        Date startDate = floatRateSegBean.getStartDate();
        Date endDate = floatRateSegBean.getEndDate();
        WorkCalendarAdjustParam adjustParam = LoanBillHelper.buildWorkCalendarAdjustParam(loanBill, "rateresetadjustrule");
        Map<Date, Boolean> workCalendarMap = CfmRateAdjustHelper.getWorkCalendarMap(adjustParam.getWorkCalendars(), startDate, endDate);
        int rateResetDays = loanBill.getInt("rateresetdays");
        Map rateDatas = MarketDataServiceHelper.referRate((String)floatRateSegBean.getRefrateNum(), (Date)DateUtils.getLastDay((Date)startDate, (int)(rateResetDays + 7)), (Date)endDate);
        TreeMap<Date, BigDecimal> rateTreeDatas = new TreeMap<Date, BigDecimal>(rateDatas);
        HashSet<Date> effectDateSet = new HashSet<Date>(16);
        effectDateSet.add(floatRateSegBean.getStartDate());
        for (DynamicObject instbill : instbills) {
            Date endinstdate = instbill.getDate("endinstdate");
            if (!EmptyUtil.isNoEmpty((Object)endinstdate) || endinstdate.compareTo(startDate) <= 0 || endinstdate.compareTo(endDate) > 0) continue;
            effectDateSet.add(DateUtils.getNextDay((Date)endinstdate, (int)1));
        }
        TreeMap<Date, Date> confirmDateMap = CfmRateAdjustHelper.getConfirmDate(workCalendarMap, rateResetDays, new ArrayList<Date>(effectDateSet));
        logger.info("CfmRateAdjustHelper:confirmDateMap:\n" + SerializationUtils.toJsonString(confirmDateMap));
        for (Map.Entry<Date, Date> entry : confirmDateMap.entrySet()) {
            Date effectDate = entry.getKey();
            Date confirmDate = entry.getValue();
            BigDecimal confirmCurrRate = CfmRateAdjustHelper.getEffectYearRate(rateTreeDatas, confirmDate, rateFloat);
            rateAdjustBeanList.add(new RateAdjustBean(effectDate, confirmDate, confirmCurrRate));
        }
        return rateAdjustBeanList;
    }

    private static List<RateAdjustBean> dealNewRowAdjustRate(FloatRateCalBean floatRateSegBean, DynamicObject loanBill) {
        ArrayList<RateAdjustBean> rateAdjustBeanList = new ArrayList<RateAdjustBean>(16);
        String rateAdjustStyle = floatRateSegBean.getRateAdjustStyle();
        BigDecimal rateFloat = RateAdjustHelper.getRateFloat(floatRateSegBean);
        Date startDate = floatRateSegBean.getStartDate();
        Date endDate = floatRateSegBean.getEndDate();
        boolean isCycle = RateAdjustStyleEnum.isCycle(rateAdjustStyle);
        if (isCycle) {
            CfmRateAdjustHelper.dealRowAdjustRateByCycle(rateAdjustBeanList, floatRateSegBean, loanBill, startDate, endDate, rateFloat);
        } else {
            logger.info("floatRateSegBean.getRefrateNum() ... " + floatRateSegBean.getRefrateNum() + startDate);
            BigDecimal firstEffectYearRate = MarketDataServiceHelper.referRate((String)floatRateSegBean.getRefrateNum(), (Date)startDate, (boolean)false);
            logger.info("firstEffectYearRate  ..." + firstEffectYearRate);
            CfmRateAdjustHelper.volidRateIsExit(firstEffectYearRate);
            rateAdjustBeanList.add(new RateAdjustBean(startDate, startDate, firstEffectYearRate.add(rateFloat)));
            if (RateAdjustStyleEnum.isDeadline(rateAdjustStyle)) {
                CfmRateAdjustHelper.dealRowAdjustRateByDeadline(rateAdjustBeanList, floatRateSegBean, startDate, endDate, rateFloat);
            }
        }
        return rateAdjustBeanList;
    }

    private static void volidRateIsExit(Object rateObject) {
        if (EmptyUtil.isEmpty((Object)rateObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"CfmRateAdjustHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
        }
    }

    private static void dealRowAdjustRateByCycle(List<RateAdjustBean> rateAdjustBeanList, FloatRateCalBean floatRateSegBean, DynamicObject loanBill, Date startDate, Date endDate, BigDecimal rateFloat) {
        String rateAdjustCycleType = floatRateSegBean.getRateAdjustType();
        int rateAdjustCycle = floatRateSegBean.getRateAdjustCycle();
        WorkCalendarAdjustParam adjustParam = LoanBillHelper.buildWorkCalendarAdjustParam(loanBill, "rateresetadjustrule");
        logger.info("CfmRateAdjustHelper:adjustParam:\n" + SerializationUtils.toJsonString((Object)adjustParam));
        boolean isSofr = LoanBillHelper.isSofr(loanBill);
        boolean isNeedAdjust = isSofr || adjustParam.getRateCycleWay() == RateCycleWayEnum.FixCycle;
        Map<Date, Boolean> workCalendarMap = CfmRateAdjustHelper.getWorkCalendarMap(adjustParam.getWorkCalendars(), startDate, endDate);
        Date cycStartDate = floatRateSegBean.getFirstAdjustDate();
        List<Date> cycleDateList = CfmRateAdjustHelper.getCycleDateList(cycStartDate, endDate, rateAdjustCycleType, rateAdjustCycle, (WorkCalendarAdjustParam)(isNeedAdjust ? adjustParam : null), workCalendarMap);
        logger.info("CfmRateAdjustHelper:cycleDateList:\n" + SerializationUtils.toJsonString(cycleDateList));
        startDate = DateUtils.getNextDay((Date)startDate, (int)0);
        ArrayList<Date> cycleList = new ArrayList<Date>(cycleDateList);
        if (!cycleList.contains(startDate)) {
            cycleList.add(startDate);
        }
        logger.info("CfmRateAdjustHelper:cycleList:\n" + SerializationUtils.toJsonString(cycleList));
        if (cycleList.isEmpty()) {
            return;
        }
        Date finalStartDate = startDate;
        List<Date> dateList = cycleList.stream().filter(d -> d.compareTo(finalStartDate) >= 0).collect(Collectors.toList());
        if (dateList.isEmpty()) {
            return;
        }
        int rateResetDays = CfmRateAdjustHelper.getRateResetDiffDays(loanBill, isSofr);
        logger.info("CfmRateAdjustHelper:rateResetDays:" + rateResetDays);
        Map rateDatas = MarketDataServiceHelper.referRate((String)floatRateSegBean.getRefrateNum(), (Date)DateUtils.getLastDay((Date)startDate, (int)(rateResetDays + 7)), (Date)endDate);
        TreeMap<Date, BigDecimal> rateTreeDatas = new TreeMap<Date, BigDecimal>(rateDatas);
        boolean perpetualBond = CfmRateAdjustHelper.isPerpetualBond(loanBill);
        TreeMap<Date, Date> confirmDateMap = CfmRateAdjustHelper.getConfirmDate(workCalendarMap, rateResetDays, isSofr, adjustParam, dateList);
        logger.info("CfmRateAdjustHelper:confirmDateMap:\n" + SerializationUtils.toJsonString(confirmDateMap));
        for (Map.Entry<Date, Date> entry : confirmDateMap.entrySet()) {
            Date effectDate = entry.getKey();
            Date confirmDate = entry.getValue();
            BigDecimal confirmCurrRate = CfmRateAdjustHelper.getEffectYearRate(rateTreeDatas, confirmDate, rateFloat);
            if (perpetualBond) {
                confirmCurrRate = CfmRateAdjustHelper.getConfirmRateForPerptal(loanBill, effectDate, confirmCurrRate);
            }
            rateAdjustBeanList.add(new RateAdjustBean(effectDate, confirmDate, confirmCurrRate));
        }
    }

    private static int getRateResetDiffDays(DynamicObject loanbill, boolean isSofr) {
        int rateResetDays = loanbill.getInt("rateresetdays");
        logger.info("loanbill:rateResetDays:{}", (Object)rateResetDays);
        DynamicObject productFactory = loanbill.getDynamicObject("productfactory");
        if (isSofr && EmptyUtil.isEmpty((Integer)rateResetDays)) {
            logger.info("CfmRateAdjustHelper: isSofr");
            Date actStartIntDate = loanbill.getDate("startintdate");
            Date rateAdjustDate = loanbill.getDate("rateadjustdate");
            if (EmptyUtil.isNoEmpty((Object)rateAdjustDate) && EmptyUtil.isNoEmpty((Object)actStartIntDate)) {
                logger.info("CfmRateAdjustHelper: work_Difffdays");
                DynamicObject contractBillF7 = loanbill.getDynamicObject("loancontractbill");
                DynamicObjectCollection workCalendar = contractBillF7.getDynamicObjectCollection("workcalendar");
                Long[] wcIds = workCalendar.stream().map(w -> w.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()).toArray(new Long[1]);
                rateResetDays = CfmBillCommonHelper.getWorkDayCount(wcIds, rateAdjustDate, actStartIntDate);
                logger.info("CfmRateAdjustHelper:sofr:diffDays" + rateResetDays);
            }
        } else if (EmptyUtil.isEmpty((Integer)rateResetDays) && EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            rateResetDays = productFactory.getInt("rateresetdays");
            logger.info("CfmRateAdjustHelper:ProductFactoryProp.RATERESETDAYS:diffDays" + rateResetDays);
        }
        logger.info("result:rateResetDays:{}", (Object)rateResetDays);
        return rateResetDays;
    }

    private static TreeMap<Date, Date> getConfirmDate(Map<Date, Boolean> workCalendarMap, int rateResetDays, List<Date> dateList) {
        TreeMap<Date, Date> comfirmDateMap = new TreeMap<Date, Date>();
        for (Date beginDate : dateList) {
            Date confirmDate = rateResetDays > 0 && EmptyUtil.isNoEmpty(workCalendarMap) && workCalendarMap.size() > 0 ? CfmRateAdjustHelper.getConfirmDateByRateRestDays(workCalendarMap, rateResetDays, beginDate) : DateUtils.getLastDay((Date)beginDate, (int)rateResetDays);
            comfirmDateMap.put(beginDate, confirmDate);
        }
        return comfirmDateMap;
    }

    private static TreeMap<Date, Date> getConfirmDate(Map<Date, Boolean> workCalendarMap, int rateResetDays, boolean isSofr, WorkCalendarAdjustParam adjustParam, List<Date> dateList) {
        TreeMap<Date, Date> comfirmDateMap = new TreeMap<Date, Date>();
        for (Date beginDate : dateList) {
            Date confirmDate;
            if (!adjustParam.isCanAdjust()) {
                comfirmDateMap.put(beginDate, DateUtils.getLastDay((Date)beginDate, (int)rateResetDays));
                continue;
            }
            if (isSofr && rateResetDays > 0) {
                confirmDate = CfmRateAdjustHelper.getConfirmDateByRateRestDays(workCalendarMap, rateResetDays, beginDate);
            } else {
                if (!adjustParam.isCanAdjust()) {
                    comfirmDateMap.put(beginDate, DateUtils.getLastDay((Date)beginDate, (int)rateResetDays));
                    continue;
                }
                confirmDate = DateUtils.getLastDay((Date)beginDate, (int)rateResetDays);
                confirmDate = (Date)TermHelper.callAdjustSettleDate(workCalendarMap, (Date)confirmDate, (Date)confirmDate, (AdjustMethodEnum)adjustParam.getAdjustMethod()).get(confirmDate);
            }
            comfirmDateMap.put(beginDate, confirmDate);
        }
        return comfirmDateMap;
    }

    public static Map<Date, Boolean> getWorkCalendarMap(DynamicObjectCollection workCalendars, Date beginDate, Date endDate) {
        Long[] wcIds = null;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)workCalendars)) {
            wcIds = workCalendars.stream().map(w -> w.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()).toArray(new Long[1]);
        }
        return WorkCalendarHelper.getDateTypeMap(wcIds, (Date)DateUtils.getLastDay((Date)beginDate, (int)30), (Date)DateUtils.getNextDay((Date)endDate, (int)30));
    }

    private static BigDecimal getConfirmRateForPerptal(DynamicObject loanBill, Date effectDate, BigDecimal confirmCurrRate) {
        DynamicObjectCollection resetEntry = loanBill.getDynamicObjectCollection("condition_entry_er");
        Map<Date, BigDecimal> plusPointMap = resetEntry.stream().collect(Collectors.toMap(r -> r.getDate("effectdate_er"), r -> r.getBigDecimal("pluspoint_er")));
        DynamicObjectCollection rateAdjustEntry = loanBill.getDynamicObjectCollection("ratehistory_entry");
        Date firstAdjustDay = rateAdjustEntry.stream().map(r -> r.getDate("rh_effectdate")).min(Date::compareTo).orElse(null);
        confirmCurrRate = EmptyUtil.isEmpty((Object)firstAdjustDay) ? CfmRateAdjustHelper.compareAndGetRate(plusPointMap, effectDate, loanBill, confirmCurrRate) : (effectDate.compareTo(firstAdjustDay) < 0 ? CfmRateAdjustHelper.compareAndGetRate(plusPointMap, effectDate, loanBill, confirmCurrRate) : CfmRateAdjustHelper.getRateAfterCompare(loanBill, confirmCurrRate));
        return confirmCurrRate;
    }

    private static List<Date> getCycleDateList(Date beginDate, Date endDate, String rateAdjustCycleType, int rateAdjustCycle, WorkCalendarAdjustParam adjustParam, Map<Date, Boolean> workCalendarMap) {
        if (beginDate.after(endDate)) {
            return Collections.emptyList();
        }
        RateAdjustCycleTypeEnum cycleTypeEnum = RateAdjustCycleTypeEnum.getByValue(rateAdjustCycleType);
        if (cycleTypeEnum == null || EmptyUtil.isEmpty((Integer)rateAdjustCycle)) {
            return new ArrayList<Date>(Collections.singletonList(beginDate));
        }
        Set<Object> cycleDateSet = new TreeSet(Date::compareTo);
        LocalDate localBeginDate = DateUtils.date2LocalDate((Date)beginDate);
        LocalDate localEndDate = DateUtils.date2LocalDate((Date)endDate);
        rateAdjustCycle = rateAdjustCycle == 0 ? 1 : rateAdjustCycle;
        switch (cycleTypeEnum) {
            case D: {
                while (localBeginDate.compareTo(localEndDate) <= 0) {
                    localBeginDate = CfmRateAdjustHelper.getCycleDateByAdjustWorkCalendar(adjustParam, cycleDateSet, localBeginDate, workCalendarMap);
                    localBeginDate = localBeginDate.plusDays(rateAdjustCycle);
                }
                break;
            }
            case W: {
                while (localBeginDate.compareTo(localEndDate) <= 0) {
                    localBeginDate = CfmRateAdjustHelper.getCycleDateByAdjustWorkCalendar(adjustParam, cycleDateSet, localBeginDate, workCalendarMap);
                    localBeginDate = localBeginDate.plusWeeks(rateAdjustCycle);
                }
                break;
            }
            case M: {
                cycleDateSet = CfmRateAdjustHelper.getCycleDateByMonth(adjustParam, workCalendarMap, localBeginDate, localEndDate, rateAdjustCycle, 1);
                break;
            }
            case S: {
                cycleDateSet = CfmRateAdjustHelper.getCycleDateByMonth(adjustParam, workCalendarMap, localBeginDate, localEndDate, rateAdjustCycle, 3);
                break;
            }
            case H: {
                cycleDateSet = CfmRateAdjustHelper.getCycleDateByMonth(adjustParam, workCalendarMap, localBeginDate, localEndDate, rateAdjustCycle, 6);
                break;
            }
            case Y: {
                cycleDateSet = CfmRateAdjustHelper.getCycleDateByMonth(adjustParam, workCalendarMap, localBeginDate, localEndDate, rateAdjustCycle, 12);
                break;
            }
            default: {
                cycleDateSet = Collections.singleton(beginDate);
            }
        }
        return new ArrayList<Date>(cycleDateSet);
    }

    private static Set<Date> getCycleDateByMonth(WorkCalendarAdjustParam adjustParam, Map<Date, Boolean> workCalendarMap, LocalDate localBeginDate, LocalDate localEndDate, int rateAdjustCycle, int months) {
        TreeSet<Date> cycleDateSet = new TreeSet<Date>(Date::compareTo);
        int day = localBeginDate.getDayOfMonth();
        while (localBeginDate.compareTo(localEndDate) <= 0) {
            localBeginDate = CfmRateAdjustHelper.getCycleDateByAdjustWorkCalendar(adjustParam, cycleDateSet, localBeginDate, workCalendarMap);
            if (adjustParam != null && adjustParam.getRateCycleWay() == RateCycleWayEnum.FixCycle) {
                day = localBeginDate.getDayOfMonth();
                if (localBeginDate.getDayOfMonth() == localBeginDate.lengthOfMonth()) {
                    day = 31;
                }
            }
            localBeginDate = localBeginDate.plusMonths((long)months * (long)rateAdjustCycle);
            localBeginDate = localBeginDate.withDayOfMonth(Math.min(localBeginDate.lengthOfMonth(), day));
        }
        return cycleDateSet;
    }

    private static LocalDate getCycleDateByAdjustWorkCalendar(WorkCalendarAdjustParam adjustParam, Set<Date> cycleDateSet, LocalDate localBeginDate, Map<Date, Boolean> workCalendarMap) {
        Date bizDate = DateUtils.localDate2Date((LocalDate)localBeginDate);
        if (adjustParam != null && adjustParam.isCanAdjust()) {
            AdjustMethodEnum adjustMethod = adjustParam.getAdjustMethod();
            Map adjustDateMap = TermHelper.callAdjustSettleDate(workCalendarMap, (Date)bizDate, (Date)bizDate, (AdjustMethodEnum)adjustMethod);
            bizDate = (Date)adjustDateMap.get(bizDate);
            if (adjustParam.getRateCycleWay() == RateCycleWayEnum.FixCycle && adjustMethod != AdjustMethodEnum.ad_forward) {
                localBeginDate = DateUtils.date2LocalDate((Date)bizDate);
            }
        }
        cycleDateSet.add(bizDate);
        return localBeginDate;
    }

    private static void dealRowAdjustRateByDeadline(List<RateAdjustBean> rateAdjustBeanList, FloatRateCalBean floatRateSegBean, Date beginConfirmDate, Date endConfirmDate, BigDecimal rateFloat) {
        logger.info("floatRateSegBean.getRefrateNum()  ..." + floatRateSegBean.getRefrateNum() + beginConfirmDate + endConfirmDate);
        Map rateDatas = MarketDataServiceHelper.referRate((String)floatRateSegBean.getRefrateNum(), (Date)beginConfirmDate, (Date)endConfirmDate);
        logger.info("rateDatas  ..." + rateDatas);
        CfmRateAdjustHelper.volidRateIsExit(rateDatas);
        TreeMap deadLineRates = new TreeMap(Date::compareTo);
        for (Map.Entry entry : rateDatas.entrySet()) {
            Date key = (Date)entry.getKey();
            if (key.compareTo(beginConfirmDate) <= 0 || key.compareTo(endConfirmDate) >= 0) continue;
            deadLineRates.put(key, entry.getValue());
        }
        if (EmptyUtil.isEmpty(deadLineRates)) {
            return;
        }
        BigDecimal tempRate = rateAdjustBeanList.get(0).getYearRate().subtract(rateFloat);
        for (Map.Entry entry : deadLineRates.entrySet()) {
            if (((BigDecimal)entry.getValue()).compareTo(tempRate) == 0) continue;
            tempRate = (BigDecimal)entry.getValue();
            Date confirmDate = (Date)entry.getKey();
            CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(confirmDate, confirmDate, tempRate.add(rateFloat)));
        }
    }

    private static void definListAdd(List<RateAdjustBean> rateAdjustBeanList, RateAdjustBean needAddObj) {
        List theSameRateAdjusts;
        if (EmptyUtil.isNoEmpty(rateAdjustBeanList) && EmptyUtil.isNoEmpty(theSameRateAdjusts = rateAdjustBeanList.stream().filter(o -> o.getEffectDate().compareTo(needAddObj.getEffectDate()) == 0).collect(Collectors.toList()))) {
            rateAdjustBeanList.removeAll(theSameRateAdjusts);
        }
        rateAdjustBeanList.add(needAddObj);
    }

    private static void definListAdd4Bond(List<RateAdjustBean> rateAdjustBeanList, RateAdjustBean needAddObj, Date startDate) {
        if (EmptyUtil.isNoEmpty(rateAdjustBeanList)) {
            if (startDate.compareTo(needAddObj.getEffectDate()) <= 0) {
                List theSameRateAdjusts = rateAdjustBeanList.stream().filter(o -> o.getEffectDate().compareTo(needAddObj.getEffectDate()) == 0).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(theSameRateAdjusts)) {
                    rateAdjustBeanList.removeAll(theSameRateAdjusts);
                }
                rateAdjustBeanList.add(needAddObj);
            }
        } else {
            rateAdjustBeanList.add(needAddObj);
        }
    }

    public static BigDecimal getLoanDateYearRate(DynamicObject loanBill, Date loanDate) {
        DynamicObject refindex = loanBill.getDynamicObject("referencerate");
        if (EmptyUtil.isNoEmpty((DynamicObject)refindex) && EmptyUtil.isNoEmpty((Object)loanDate)) {
            Map rateDatas = MarketDataServiceHelper.referRate((String)refindex.getString("number"), (Date)loanDate, (Date)loanDate);
            if (EmptyUtil.isEmpty((Object)rateDatas) || rateDatas.size() == 0) {
                return BigDecimal.ZERO;
            }
            String rateSign = loanBill.getString("ratesign");
            BigDecimal rateFloatPoint = loanBill.getBigDecimal("ratefloatpoint");
            BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
            if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                rateFloat = rateFloat.negate();
            }
            return ((BigDecimal)rateDatas.values().stream().findFirst().get()).add(rateFloat);
        }
        return BigDecimal.ZERO;
    }

    public static boolean isCanRateAdjustOp(DynamicObject loanBillDo) {
        if (!loanBillDo.getDataEntityState().getFromDatabase()) {
            return false;
        }
        List<String> errorList = CfmRateAdjustHelper.validCanRateAdjustOp(loanBillDo);
        return CollectionUtils.isEmpty(errorList) && errorList.size() <= 0;
    }

    public static List<String> validCanRateAdjustOp(DynamicObject loanBillDo) {
        String dataSource = loanBillDo.getString("datasource");
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
        if (CreditorTypeEnum.isSettleCenter((String)loanBillDo.getString("creditortype")) && !"ifm_loanbill".equals(loanBillDo.getDataEntityType().toString())) {
            return Collections.singletonList(bizResource.getCreditorAdjustVolidError());
        }
        if (DrawTypeEnum.CLOSEOUT.getValue().equals(loanBillDo.getString("drawtype"))) {
            return Collections.singletonList(bizResource.getAdjustOpVolidError());
        }
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        if (!InterestTypeEnum.FLOAT.getValue().equals(loanBillDo.getString("interesttype")) || !RateAdjustStyleEnum.isHand(loanBillDo.getString("rateadjuststyle")) && !RateAdjustStyleEnum.isCycle(loanBillDo.getString("rateadjuststyle")) && !RateAdjustStyleEnum.isAfterint(loanBillDo.getString("rateadjuststyle"))) {
            errorMsg.add(bizResource.getAdjustVolidError());
        }
        return errorMsg;
    }

    private static BigDecimal getEffectYearRate(TreeMap<Date, BigDecimal> refRates, Date effectRate, BigDecimal rateFloatPoint) {
        Map.Entry<Date, BigDecimal> entry = refRates.floorEntry(effectRate);
        return entry != null ? entry.getValue().add(rateFloatPoint) : BigDecimal.ZERO;
    }

    public static void autoFillResetConditionEntry(DynamicObject loanBill) {
        DynamicObjectCollection resetConEntry = loanBill.getDynamicObjectCollection("condition_entry_er");
        DynamicObjectCollection rateAdjustEntry = loanBill.getDynamicObjectCollection("rateadjust_entry");
        resetConEntry.clear();
        int seq = 1;
        for (DynamicObject row : rateAdjustEntry) {
            DynamicObject rateAdjustEntryDo = resetConEntry.addNew();
            rateAdjustEntryDo.set("seq", (Object)seq++);
            rateAdjustEntryDo.set("effectdate_er", (Object)row.getDate("ra_effectdate"));
        }
        if (StringUtils.equals((CharSequence)InterestTypeEnum.AGREE.getValue(), (CharSequence)loanBill.getString("interesttype")) && EmptyUtil.isEmpty((DynamicObjectCollection)rateAdjustEntry)) {
            CfmRateAdjustHelper.buildOneRow(loanBill, resetConEntry);
        }
    }

    public static void buildOneRow(DynamicObject loanBill, DynamicObjectCollection resetConEntry) {
        Date bizDate = loanBill.getDate("bizdate");
        Date startIntDate = loanBill.getDate("startintdate");
        startIntDate = startIntDate.before(bizDate) ? startIntDate : bizDate;
        DynamicObject rateAdjustEntryDo = resetConEntry.addNew();
        rateAdjustEntryDo.set("seq", (Object)1);
        rateAdjustEntryDo.set("effectdate_er", (Object)startIntDate);
    }

    public static List<Date> getDateRange(IDataModel model) {
        Date endDate;
        Date startDate = (Date)model.getValue("startintdate");
        Date loanDate = (Date)model.getValue("bizdate");
        if (EmptyUtil.isNoEmpty((Object)loanDate) && loanDate.before(startDate)) {
            startDate = loanDate;
        }
        if (EmptyUtil.isEmpty((Object)(endDate = (Date)model.getValue("expiredate")))) {
            endDate = DateUtils.getCommonMaxDate();
        }
        String cycleType = (String)model.getValue("ratejumpcyclekey");
        Integer cycleVal = (Integer)model.getValue("ratejumpcycleval");
        return CfmRateAdjustHelper.getCycleDateList(startDate, endDate, cycleType, cycleVal, null, null);
    }

    public static List<Map<String, Object>> buildEntryFields(IDataModel model, List<Date> list) {
        ArrayList<Map<String, Object>> fieldList = new ArrayList<Map<String, Object>>(list.size());
        BigDecimal dif = (BigDecimal)model.getValue("ratejumpperpoint");
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Comparable<Date>> fieldMap = new HashMap<String, Comparable<Date>>(2);
            Date effectDate = list.get(i);
            fieldMap.put("effectdate_er", effectDate);
            BigDecimal plusPoint = dif.multiply(BigDecimal.valueOf(i));
            if (i > 0) {
                BigDecimal rateFloor;
                BigDecimal loanRate;
                BigDecimal rateCeil = (BigDecimal)model.getValue("rateceil");
                if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{rateCeil, loanRate = (BigDecimal)model.getValue("loanrate")})) {
                    BigDecimal tempVal = rateCeil.subtract(loanRate).multiply(BigDecimal.valueOf(100L));
                    plusPoint = plusPoint.compareTo(tempVal) <= 0 ? plusPoint : tempVal;
                }
                if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{rateFloor = (BigDecimal)model.getValue("ratefloor"), loanRate})) {
                    BigDecimal tempVal = rateFloor.subtract(loanRate).multiply(BigDecimal.valueOf(100L));
                    plusPoint = plusPoint.compareTo(tempVal) >= 0 ? plusPoint : tempVal;
                }
            }
            fieldMap.put("pluspoint_er", plusPoint);
            fieldList.add(fieldMap);
        }
        return fieldList;
    }

    private static void buildRateAdjustEntry(List<RateAdjustBean> rateAdjustBeanList, DynamicObject loanbill, Date actStartDate, Date firstAdjustDay, BigDecimal preAdjustRate) {
        DynamicObjectCollection resetEntry = loanbill.getDynamicObjectCollection("condition_entry_er");
        BigDecimal rate = preAdjustRate != null ? preAdjustRate : loanbill.getBigDecimal("loanrate");
        BigDecimal comparedRate = CfmRateAdjustHelper.getRateAfterCompare(loanbill, rate);
        CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(actStartDate, actStartDate, comparedRate));
        Map<Date, BigDecimal> resetMap = resetEntry.stream().collect(Collectors.toMap(r -> r.getDate("effectdate_er"), r -> r.getBigDecimal("pluspoint_er")));
        Set<Date> resetSet = resetMap.keySet();
        TreeSet<Date> newSet = new TreeSet<Date>(Date::compareTo);
        newSet.addAll(resetSet);
        for (Date effectDate : newSet) {
            if (EmptyUtil.isNoEmpty((Object)firstAdjustDay) && effectDate.compareTo(firstAdjustDay) >= 0) break;
            BigDecimal plusPoint = resetMap.getOrDefault(effectDate, BigDecimal.ZERO).divide(Constants.ONE_HUNDRED, 10, 4);
            BigDecimal yearRate = preAdjustRate != null ? preAdjustRate : loanbill.getBigDecimal("loanrate");
            BigDecimal finalRate = CfmRateAdjustHelper.getRateAfterCompare(loanbill, yearRate.add(plusPoint));
            CfmRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(effectDate, effectDate, finalRate));
        }
    }

    public static long getLoanBondBillNum(long selectedId) {
        QFilter contractFilter = new QFilter("loancontractbill", "=", (Object)selectedId);
        contractFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection loanBillCols = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)"issetpluspoint", (QFilter[])contractFilter.toArray());
        return loanBillCols.stream().filter(r -> r.getBoolean("issetpluspoint")).count();
    }

    public static boolean isPerpetualBond(DynamicObject loanbill) {
        boolean isPerpetual = false;
        if (!StringUtils.equals((CharSequence)"cfm_loanbill_bond", (CharSequence)loanbill.getDynamicObjectType().getName())) {
            return isPerpetual;
        }
        Optional<Boolean> perpetualbondOpt = Optional.ofNullable(loanbill.getDynamicObject("finproduct")).map(r -> r.getBoolean("perpetualbond"));
        if (perpetualbondOpt.isPresent()) {
            isPerpetual = perpetualbondOpt.get();
        }
        return isPerpetual;
    }

    public static BigDecimal compareAndGetRate(Map<Date, BigDecimal> plusPointMap, Date effectDate, DynamicObject loanBill, BigDecimal confirmCurrRate) {
        BigDecimal addRate = plusPointMap.getOrDefault(effectDate, BigDecimal.ZERO).divide(Constants.ONE_HUNDRED, 10, 4);
        confirmCurrRate = confirmCurrRate.add(addRate);
        return CfmRateAdjustHelper.getRateAfterCompare(loanBill, confirmCurrRate);
    }

    public static BigDecimal getRateAfterCompare(DynamicObject loanBill, BigDecimal confirmCurrRate) {
        BigDecimal rateCeil;
        BigDecimal rateFloor = loanBill.getBigDecimal("ratefloor");
        if (EmptyUtil.isNoEmpty((BigDecimal)rateFloor)) {
            BigDecimal bigDecimal = confirmCurrRate = confirmCurrRate.compareTo(rateFloor) >= 0 ? confirmCurrRate : rateFloor;
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)(rateCeil = loanBill.getBigDecimal("rateceil")))) {
            confirmCurrRate = confirmCurrRate.compareTo(rateCeil) <= 0 ? confirmCurrRate : rateCeil;
        }
        return confirmCurrRate;
    }

    public static void reInsertResetConditionEntry(DynamicObject loanBill) {
        DynamicObjectCollection resetConEntry = loanBill.getDynamicObjectCollection("condition_entry_er");
        DynamicObjectCollection rateAdjustEntry = loanBill.getDynamicObjectCollection("rateadjust_entry");
        resetConEntry.clear();
        int seq = 1;
        for (DynamicObject row : rateAdjustEntry) {
            DynamicObject rateAdjustEntryDo = resetConEntry.addNew();
            rateAdjustEntryDo.set("seq", (Object)seq++);
            rateAdjustEntryDo.set("effectdate_er", (Object)row.getDate("ra_effectdate"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loanBill});
    }

    public static Date getConfirmDateByRateRestDays(Map<Date, Boolean> workCalendarMap, int rateResetDays, Date confirmDate) {
        int resetDays = rateResetDays;
        while (resetDays > 0) {
            if (!TermHelper.isWorkDay(workCalendarMap, (Date)(confirmDate = DateUtils.getLastDay((Date)confirmDate, (int)1)))) continue;
            --resetDays;
        }
        return confirmDate;
    }

    private static DynamicObjectCollection getRateAdjNoBills(DynamicObject loanbill, DynamicObject rateAdjustBill) {
        DynamicObjectCollection rateHistorys = loanbill.getDynamicObjectCollection("ratehistory_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rateHistorys)) {
            List rateAdjNos = rateHistorys.stream().map(o -> o.getString("rh_rateadjno")).collect(Collectors.toList());
            QFilter filter = new QFilter("billstatus", "=", (Object)"C").and(new QFilter("billno", "in", rateAdjNos)).and(new QFilter("entry.ldrawbill.id", "=", (Object)loanbill.getLong("id")).and(new QFilter("entry.lisadjust", "=", (Object)true)));
            Date startIntDate = loanbill.getDate("startintdate");
            filter.and(new QFilter("entry.ladjusteffectdate", ">=", (Object)startIntDate));
            if (EmptyUtil.isNoEmpty((DynamicObject)rateAdjustBill) && rateAdjustBill != null) {
                Date adjustEffectDate = rateAdjustBill.getDate("entry.ladjusteffectdate");
                filter.and(new QFilter("adjusteffectdate", ">=", (Object)adjustEffectDate));
            }
            DynamicObjectCollection rateAdjNoBills = QueryServiceHelper.query((String)"cfm_rateadjustbill", (String)String.join((CharSequence)",", rateAdjustProps), (QFilter[])new QFilter[]{filter}, (String)"entry.ladjusteffectdate desc");
            logger.info("rateAdjNoBills:" + rateAdjNoBills.size());
            return rateAdjNoBills;
        }
        return null;
    }

    private static DynamicObjectCollection getExtBills(DynamicObject loanbill, DynamicObject rateAdjustBill) {
        if (loanbill.getDate("renewalexpiredate") != null) {
            QFilter filter = new QFilter("billstatus", "=", (Object)"C").and(new QFilter("loanbilllist.drawbillid", "=", (Object)loanbill.getLong("id"))).and(new QFilter("loanbilllist.isrenewal", "=", (Object)"1"));
            if (EmptyUtil.isNoEmpty((DynamicObject)rateAdjustBill)) {
                Date adjustEffectDate = rateAdjustBill.getDate("entry.ladjusteffectdate");
                filter.and(new QFilter("loanbilllist.e_prevrenewalexpiredate", ">=", (Object)adjustEffectDate));
            }
            DynamicObjectCollection extBills = QueryServiceHelper.query((String)"cfm_contractextendbill", (String)String.join((CharSequence)",", contractExtProps), (QFilter[])new QFilter[]{filter}, (String)"loanbilllist.lrenewalexpiredate asc");
            if (LoanTypeEnum.isBond(loanbill.getString("loantype"))) {
                extBills = QueryServiceHelper.query((String)"cfm_contractextend_bo", (String)String.join((CharSequence)",", contractBondExtProps), (QFilter[])new QFilter[]{filter}, (String)"loanbilllist.lrenewalexpiredate asc");
            }
            logger.info("extBills:" + extBills.size());
            return extBills;
        }
        return null;
    }
}

