/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.AdjustEleEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CfmRateAdjustWriteBackHelper {
    public static void writeback(DynamicObject[] dataEntities, Map<String, String> options) {
        HashMap<Long, DynamicObject> loanIdEntryMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> loanIdHeadMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Long> loanIdContractIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if (entry.getBoolean("lisadjust")) {
                    loanIdHeadMap.put(entry.getDynamicObject("ldrawbill").getLong("id"), dataEntity);
                    loanIdEntryMap.put(entry.getDynamicObject("ldrawbill").getLong("id"), entry);
                }
                if (!AdjustEleEnum.ADJUSTCONTRACT.getValue().equals(dataEntity.getString("adjustele"))) continue;
                loanIdContractIdMap.put(entry.getDynamicObject("ldrawbill").getLong("id"), dataEntity.getDynamicObject("loancontractbill").getLong("id"));
            }
        }
        DynamicObject[] drawBills = TmcDataServiceHelper.load((Object[])loanIdEntryMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill"));
        if (EmptyUtil.isNoEmpty(loanIdContractIdMap)) {
            DynamicObject[] contractBills = TmcDataServiceHelper.load((Object[])loanIdContractIdMap.values().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loancontractbill"));
            HashMap<Long, DynamicObject> loanIdContractMap = new HashMap<Long, DynamicObject>(16);
            for (Map.Entry entry : loanIdContractIdMap.entrySet()) {
                Long loanId = (Long)entry.getKey();
                Long contractId = (Long)entry.getValue();
                for (DynamicObject contractBill : contractBills) {
                    if (!contractBill.getPkValue().equals(contractId)) continue;
                    loanIdContractMap.put(loanId, contractBill);
                }
            }
            CfmRateAdjustWriteBackHelper.reWriteBackContractLoanBillOp(loanIdHeadMap, loanIdEntryMap, loanIdContractMap, drawBills);
            SaveServiceHelper.save((DynamicObject[])loanIdContractMap.values().toArray(new DynamicObject[0]));
        } else {
            CfmRateAdjustWriteBackHelper.reWriteBackContractLoanBillOp(loanIdHeadMap, loanIdEntryMap, new HashMap<Long, DynamicObject>(), drawBills);
        }
        SaveServiceHelper.save((DynamicObject[])drawBills);
    }

    static void reWriteBackContractLoanBillOp(Map<Long, DynamicObject> loanIdHeadMap, Map<Long, DynamicObject> loanIdEntryMap, Map<Long, DynamicObject> loanIdContractMap, DynamicObject[] drawBills) {
        for (DynamicObject drawBill : drawBills) {
            Long loanId = drawBill.getLong("id");
            DynamicObject adjustHeadInfo = loanIdHeadMap.get(loanId);
            DynamicObject adjustEntryInfo = loanIdEntryMap.get(loanId);
            DynamicObject loanContractBill = adjustHeadInfo.getDynamicObject("loancontractbill");
            boolean isAdjustToFloat = adjustHeadInfo.getBoolean("isadjusttofloat");
            String interestType = loanContractBill.getString("interesttype");
            if (LoanTypeEnum.isBond(drawBill.getString("loantype"))) {
                interestType = CfmRateAdjustWriteBackHelper.reCalInterestType(loanContractBill, interestType);
            }
            DynamicObject contractBill = loanIdContractMap.get(loanId);
            if (AdjustEleEnum.ADJUSTCONTRACT.getValue().equals(adjustHeadInfo.getString("adjustele"))) {
                if ((InterestTypeEnum.FIXED.getValue().equals(interestType) || InterestTypeEnum.AGREE.getValue().equals(interestType)) && !isAdjustToFloat) {
                    BigDecimal interestRate = adjustHeadInfo.getBigDecimal("interestrate");
                    BigDecimal afterInterestrRate = adjustHeadInfo.getBigDecimal("afterinterestrate");
                    if (afterInterestrRate.compareTo(interestRate) != 0 && EmptyUtil.isNoEmpty((DynamicObject)contractBill)) {
                        contractBill.set("interestrate", (Object)afterInterestrRate);
                    }
                    BigDecimal afterLLoanRate = adjustEntryInfo.getBigDecimal("afterlloanrate");
                    drawBill.set("loanrate", (Object)afterLLoanRate);
                    CfmRateAdjustWriteBackHelper.writeBackLoanByFixed(adjustEntryInfo, drawBill);
                } else {
                    CfmRateAdjustWriteBackHelper.writeBackContractByFloat(adjustHeadInfo, contractBill, isAdjustToFloat);
                    CfmRateAdjustWriteBackHelper.writeBackLoanByFloat(adjustEntryInfo, drawBill, isAdjustToFloat);
                }
                if (isAdjustToFloat) {
                    contractBill.set("interesttype", (Object)InterestTypeEnum.FLOAT.getValue());
                    drawBill.set("interesttype", (Object)InterestTypeEnum.FLOAT.getValue());
                    String rateAdjustStyle = adjustHeadInfo.getString("rateadjuststyle");
                    contractBill.set("rateadjuststyle", (Object)rateAdjustStyle);
                    drawBill.set("rateadjuststyle", (Object)rateAdjustStyle);
                    Date rateAdjustDate = adjustHeadInfo.getDate("rateadjustdate");
                    contractBill.set("rateadjustdate", (Object)rateAdjustDate);
                    drawBill.set("rateadjustdate", (Object)rateAdjustDate);
                    CfmRateAdjustWriteBackHelper.writeBackLoanByFixed(adjustEntryInfo, drawBill);
                    if (BigDecimal.ZERO.compareTo(contractBill.getBigDecimal("startinterestrate")) == 0) {
                        contractBill.set("interestsettledplan", (Object)adjustHeadInfo.getDynamicObject("interestsettledplan"));
                    }
                    int rateResetDays = adjustHeadInfo.getInt("rateresetdays");
                    contractBill.set("rateresetdays", (Object)rateResetDays);
                    drawBill.set("rateresetdays", (Object)rateResetDays);
                }
            } else if (InterestTypeEnum.FIXED.getValue().equals(interestType) || InterestTypeEnum.AGREE.getValue().equals(interestType)) {
                BigDecimal lLoanRate = adjustEntryInfo.getBigDecimal("lloanrate");
                BigDecimal afterLLoanRate = adjustEntryInfo.getBigDecimal("afterlloanrate");
                if (afterLLoanRate.compareTo(lLoanRate) != 0) {
                    drawBill.set("loanrate", (Object)afterLLoanRate);
                }
                CfmRateAdjustWriteBackHelper.writeBackLoanByFixed(adjustEntryInfo, drawBill);
            } else {
                CfmRateAdjustWriteBackHelper.writeBackLoanByFloat(adjustEntryInfo, drawBill, false);
            }
            CfmRateAdjustWriteBackHelper.genLoanRateAdjustEntry(adjustHeadInfo, adjustEntryInfo, drawBill);
        }
    }

    private static void writeBackContractByFloat(DynamicObject adjustHeadInfo, DynamicObject contractBill, boolean isAdjustToFloat) {
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return;
        }
        String rateSign = adjustHeadInfo.getString("ratesign");
        String afterRateSign = adjustHeadInfo.getString("afterratesign");
        if (!afterRateSign.equals(rateSign) || isAdjustToFloat) {
            contractBill.set("ratesign", (Object)afterRateSign);
        }
        BigDecimal rateFloatPoint = adjustHeadInfo.getBigDecimal("ratefloatpoint");
        BigDecimal afterRateFloatPoint = adjustHeadInfo.getBigDecimal("afterratefloatpoint");
        if (afterRateFloatPoint.compareTo(rateFloatPoint) != 0 || isAdjustToFloat) {
            contractBill.set("ratefloatpoint", (Object)afterRateFloatPoint);
        }
        String rateAdjustKey = adjustHeadInfo.getString("rateadjustkey");
        String afterRateAdjustKey = adjustHeadInfo.getString("afterrateadjustkey");
        if (!afterRateAdjustKey.equals(rateAdjustKey) || isAdjustToFloat) {
            contractBill.set("rateadjustcycletype", (Object)afterRateAdjustKey);
        }
        Integer rateAdjustVal = adjustHeadInfo.getInt("rateadjustval");
        Integer afterRateAdjustVal = adjustHeadInfo.getInt("afterrateadjustval");
        if (afterRateAdjustVal.compareTo(rateAdjustVal) != 0 || isAdjustToFloat) {
            contractBill.set("rateadjustcycle", (Object)afterRateAdjustVal);
        }
        DynamicObject refRate = adjustHeadInfo.getDynamicObject("refrate");
        DynamicObject afterRefRate = adjustHeadInfo.getDynamicObject("afterrefrate");
        if (!afterRefRate.equals(refRate) || isAdjustToFloat) {
            contractBill.set("referencerate", afterRefRate.getPkValue());
        }
        contractBill.set("issofrrate", (Object)adjustHeadInfo.getBoolean("issofrrate"));
    }

    private static void writeBackLoanByFloat(DynamicObject adjustEntryInfo, DynamicObject drawBill, boolean isAdjustToFloat) {
        String lRateSign = adjustEntryInfo.getString("lratesign");
        String afterLRateSign = adjustEntryInfo.getString("afterlratesign");
        if (!afterLRateSign.equals(lRateSign) || isAdjustToFloat) {
            drawBill.set("ratesign", (Object)afterLRateSign);
        }
        BigDecimal lrateFloatPoint = adjustEntryInfo.getBigDecimal("lratefloatpoint");
        BigDecimal afterLRateFloatPoint = adjustEntryInfo.getBigDecimal("afterlratefloatpoint");
        if (afterLRateFloatPoint.compareTo(lrateFloatPoint) != 0 || isAdjustToFloat) {
            drawBill.set("ratefloatpoint", (Object)afterLRateFloatPoint);
        }
        String lRateAdjustKey = adjustEntryInfo.getString("lrateadjustkey");
        String afterLRateAdjustKey = adjustEntryInfo.getString("afterlrateadjustkey");
        if (!afterLRateAdjustKey.equals(lRateAdjustKey) || isAdjustToFloat) {
            drawBill.set("rateadjustcycletype", (Object)afterLRateAdjustKey);
        }
        BigDecimal lRateAdjustVal = adjustEntryInfo.getBigDecimal("lrateadjustval");
        BigDecimal afterLRateAdjustVal = adjustEntryInfo.getBigDecimal("afterlrateadjustval");
        if (afterLRateAdjustVal.compareTo(lRateAdjustVal) != 0 || isAdjustToFloat) {
            drawBill.set("rateadjustcycle", (Object)afterLRateAdjustVal);
        }
        DynamicObject lRefRate = adjustEntryInfo.getDynamicObject("lrefrate");
        DynamicObject afterLRefRate = adjustEntryInfo.getDynamicObject("afterlrefrate");
        if (!afterLRefRate.equals(lRefRate) || isAdjustToFloat) {
            drawBill.set("referencerate", afterLRefRate.getPkValue());
        }
        drawBill.set("issofrrate", (Object)adjustEntryInfo.getBoolean("lissofrrate"));
    }

    static void genLoanRateAdjustEntry(DynamicObject adjustInfo, DynamicObject adjustEntryInfo, DynamicObject drawBill) {
        DynamicObjectCollection rateHistorys = drawBill.getDynamicObjectCollection("ratehistory_entry");
        DynamicObject rateAdjustEntryDo = null;
        for (DynamicObject entryDo : rateHistorys) {
            if (entryDo.getLong("id") != adjustEntryInfo.getLong("id")) continue;
            entryDo.set("rh_effectdate", (Object)adjustEntryInfo.getDate("ladjusteffectdate"));
            entryDo.set("rh_rateadjno", (Object)adjustInfo.getString("billno"));
            entryDo.set("rh_modifier", (Object)RequestContext.get().getCurrUserId());
            entryDo.set("rh_modifydate", (Object)DateUtils.getCurrentTime());
            rateAdjustEntryDo = entryDo;
            break;
        }
        if (rateAdjustEntryDo == null) {
            rateAdjustEntryDo = rateHistorys.addNew();
            rateAdjustEntryDo.set("rh_effectdate", (Object)adjustEntryInfo.getDate("ladjusteffectdate"));
            rateAdjustEntryDo.set("id", (Object)adjustEntryInfo.getLong("id"));
            rateAdjustEntryDo.set("rh_rateadjno", (Object)adjustInfo.getString("billno"));
            rateAdjustEntryDo.set("rh_modifier", (Object)RequestContext.get().getCurrUserId());
            rateAdjustEntryDo.set("rh_modifydate", (Object)DateUtils.getCurrentTime());
        }
    }

    public static String reCalInterestType(DynamicObject loanContractBill, String interestType) {
        String bondType = loanContractBill.getString("bondtype");
        String resIntType = interestType;
        switch (bondType) {
            case "floatratebond": {
                resIntType = InterestTypeEnum.FLOAT.getValue();
                break;
            }
            case "fixedratebond": 
            case "zerocouponbond": {
                resIntType = InterestTypeEnum.FIXED.getValue();
                break;
            }
        }
        return resIntType;
    }

    private static void writeBackLoanByFixed(DynamicObject adjustInfo, DynamicObject loanBill) {
        if (BigDecimal.ZERO.compareTo(loanBill.getBigDecimal("startloanrate")) == 0) {
            String settleIntMode = adjustInfo.getString("lsettleintmode");
            DynamicObject interestSettledPlan = adjustInfo.getDynamicObject("linterestsettledplan");
            if (RepaymentWayEnum.isZdyhk((String)loanBill.getString("repaymentway"))) {
                loanBill.set("settleintmode", (Object)settleIntMode);
            }
            loanBill.set("interestsettledplan", (Object)interestSettledPlan);
        }
    }
}

