/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.cfm.common.constant.CfmEntityConst;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitHelper {
    public static DynamicObject getCreditUseBill(Long billId, String billType) {
        Object[] creditUses;
        QFilter filter = new QFilter("sourcebillid", "=", (Object)billId);
        if (EmptyUtil.isNoEmpty((String)billType)) {
            filter.and("sourcetype", "=", (Object)billType);
        }
        return EmptyUtil.isNoEmpty((Object[])(creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"id,billstatus,sourcetype,amount,preamount,returnamt,creditlimit,realamt,bizcreditamount,creditrate,creditratio,currency", (QFilter[])new QFilter[]{filter}, (String)"modifytime desc", (int)1))) ? creditUses[0] : null;
    }

    public static DynamicObject getDynFormMultiple(DynamicObject obj, String field) {
        DynamicObjectCollection dyns = obj.getDynamicObjectCollection(field);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dyns)) {
            return ((DynamicObject)dyns.get(0)).getDynamicObject("fbasedataid");
        }
        return null;
    }

    public static void deleteCreditUse(Long billId, String billType) {
        billType = "fl_leasecontractbill_init".equals(billType) ? "fl_leasecontractbill" : billType;
        DeleteServiceHelper.delete((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billId), new QFilter("sourcetype", "=", (Object)billType), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())});
    }

    public static void creditBizSave(DynamicObject bizBill, DynamicObject preBill, String entryKey, String entryCreditLimitKey) {
        boolean isCreditLimit = CreditLimitHelper.cancelCreditLimit(bizBill, preBill, entryKey, entryCreditLimitKey);
        if (isCreditLimit) {
            DynamicObject srcBill = preBill != null && preBill.getDynamicObject("creditlimit") != null ? preBill : null;
            String entityName = bizBill.getDataEntityType().getName();
            String dateProp = CreditLimitHelper.isContratBill(entityName) ? "startdate" : "bizdate";
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)bizBill, (DynamicObject)srcBill, (boolean)true, (Date)bizBill.getDate(dateProp));
        }
    }

    public static void creditBizDel(DynamicObject bizBill, DynamicObject srcBill, String entryKey, String entryCreditLimitKey) {
        CreditLimitHelper.cancelCreditLimit(bizBill, srcBill, entryKey, entryCreditLimitKey);
    }

    public static void creditBizSubmit(DynamicObject bizBill, DynamicObject preBill, String entryKey, String entryCreditLimitKey) {
        boolean isCreditLimit = CreditLimitHelper.cancelCreditLimit(bizBill, preBill, entryKey, entryCreditLimitKey);
        if (isCreditLimit) {
            DynamicObject srcBill = preBill != null && preBill.getDynamicObject("creditlimit") != null ? preBill : null;
            String entityName = bizBill.getDataEntityType().getName();
            String dateProp = CreditLimitHelper.isContratBill(entityName) ? "startdate" : "bizdate";
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)bizBill, (DynamicObject)srcBill, (boolean)Boolean.FALSE, (Date)bizBill.getDate(dateProp));
        }
    }

    public static void creditBizUnSubmit(DynamicObject bizBill) {
        boolean isBanksLoanLimit;
        if ("cfm_loancontractbill".equals(bizBill.getDataEntityType().getName()) && bizBill.getBoolean("issyncdraw") && (isBanksLoanLimit = CreditLimitHelper.isBanksLoanLimit(bizBill.getDynamicObject("productfactory"), bizBill.getString("loantype")))) {
            return;
        }
        if (bizBill.getDynamicObject("creditlimit") == null && ("cfm_loanbill".equals(bizBill.getDataEntityType().getName()) ? !CreditLimitHelper.isLoanBillEntryCredit(bizBill) : !CreditLimitHelper.isEntryCredit(bizBill))) {
            return;
        }
        DynamicObject applybill = null;
        String entityName = bizBill.getDataEntityType().getName();
        boolean isPre = CfmContractBillHelper.creditPreUse(bizBill.getString("loantype"), bizBill.getString("creditortype"));
        if (!isPre) {
            DynamicObject loanContractBill = null;
            String loanContractEntity = null;
            if (CfmEntityConst.isContractBill(entityName)) {
                loanContractBill = bizBill;
                loanContractEntity = entityName;
            } else {
                loanContractBill = bizBill.getDynamicObject("loancontractbill");
                loanContractEntity = bizBill.getDataEntityType().getName();
            }
            applybill = BusinessHelper.getLoanApplyBill(loanContractBill, loanContractEntity);
        }
        CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)bizBill, applybill, (boolean)Boolean.FALSE);
        String entryName = bizBill.getDataEntityType().getName();
        if ("cfm_loancontractbill".equals(entryName) || "cfm_loanbill".equals(entityName)) {
            CreditLimitServiceHelper.deleteCreditLimitUse((Long)bizBill.getLong("id"), CreditLimitHelper.filterEntryCreditRowId(bizBill, "banksyndicate_entry", "cfm_loancontractbill".equals(entryName) ? "e_creditlimit" : "e_bankcreditlimit"));
        }
        if (isPre) {
            String dateProp = "cfm_loancontractbill".equals(entityName) ? "startdate" : "bizdate";
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)bizBill, null, (boolean)Boolean.TRUE, (Date)bizBill.getDate(dateProp));
        }
    }

    public static void creditBizUnAudit(DynamicObject bizBill) {
        if (bizBill.getDynamicObject("creditlimit") == null && !CreditLimitHelper.isEntryCredit(bizBill)) {
            return;
        }
        bizBill = TmcDataServiceHelper.loadSingle((Object)bizBill.getPkValue(), (String)bizBill.getDynamicObjectType().getName(), (String)"id,billno");
        CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)bizBill, null, (boolean)Boolean.FALSE);
    }

    public static boolean isEntryCredit(DynamicObject bizBill, String entryKey, String entryCreditLimitKey) {
        DynamicObjectCollection bankSyndicateEntry;
        List entryCredList;
        return EmptyUtil.isNoEmpty((String)entryKey) && bizBill.containsProperty(entryKey) && EmptyUtil.isNoEmpty(entryCredList = (bankSyndicateEntry = bizBill.getDynamicObjectCollection(entryKey)).stream().filter(o -> o.getDynamicObject(entryCreditLimitKey) != null).collect(Collectors.toList()));
    }

    public static Set<Long> filterEntryCreditRowId(DynamicObject bizBill, String entryKey, String entryCreditLimitKey) {
        if (EmptyUtil.isNoEmpty((String)entryKey) && bizBill.containsProperty(entryKey)) {
            DynamicObjectCollection bankSyndicateEntry = bizBill.getDynamicObjectCollection(entryKey);
            return bankSyndicateEntry.stream().filter(o -> o.getDynamicObject(entryCreditLimitKey) != null).map(entry -> entry.getLong("id")).collect(Collectors.toSet());
        }
        return null;
    }

    public static boolean isEntryCredit(DynamicObject bizBill) {
        DynamicObjectCollection bankSyndicateEntry;
        List entryCredList;
        return bizBill.containsProperty("banksyndicate_entry") && EmptyUtil.isNoEmpty(entryCredList = (bankSyndicateEntry = bizBill.getDynamicObjectCollection("banksyndicate_entry")).stream().filter(o -> o.getDynamicObject("e_creditlimit") != null).collect(Collectors.toList()));
    }

    public static boolean isLoanBillEntryCredit(DynamicObject bizBill) {
        DynamicObjectCollection bankSyndicateEntry;
        List entryCredList;
        return bizBill.containsProperty("banksyndicate_entry") && EmptyUtil.isNoEmpty(entryCredList = (bankSyndicateEntry = bizBill.getDynamicObjectCollection("banksyndicate_entry")).stream().filter(o -> o.getDynamicObject("e_bankcreditlimit") != null).collect(Collectors.toList()));
    }

    public static Set<Long> getCollIds(DynamicObjectCollection colls) {
        HashSet<Long> ids = new HashSet<Long>(16);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
            return ids;
        }
        colls.forEach(o -> {
            if (o.getDynamicObject("fbasedataid") != null) {
                ids.add(o.getDynamicObject("fbasedataid").getLong("id"));
            }
        });
        return ids;
    }

    private static boolean cancelCreditLimit(DynamicObject bizBill, DynamicObject srcBill, String entryKey, String entryCreditLimitKey) {
        DynamicObject productFactory;
        boolean isBanksLoanLimit;
        boolean isBankCredit;
        Object sourceBizBill;
        if ("cfm_loanbill_bond".equals(bizBill.getDynamicObjectType().getName())) {
            return false;
        }
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("creditlimit");
        if (EmptyUtil.isNoEmpty((String)entryCreditLimitKey)) {
            propertyList.add(entryCreditLimitKey);
        }
        String selectProperties = String.join((CharSequence)",", propertyList);
        Object[] sourceBizBills = TmcDataServiceHelper.load((String)bizBill.getDataEntityType().getName(), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", bizBill.getPkValue())});
        if (EmptyUtil.isNoEmpty((Object[])sourceBizBills) && ((sourceBizBill = sourceBizBills[0]).getDynamicObject("creditlimit") != null || CreditLimitHelper.isEntryCredit((DynamicObject)sourceBizBill, entryKey, entryCreditLimitKey)) && (isBankCredit = CreditLimitHelper.isCreditUse(bizBill.getLong("id"), null))) {
            srcBill = srcBill != null && srcBill.getDynamicObject("creditlimit") != null ? srcBill : null;
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)bizBill, (DynamicObject)srcBill, (boolean)true);
        }
        CreditLimitServiceHelper.deleteCreditLimitUse((Long)bizBill.getLong("id"), CreditLimitHelper.filterEntryCreditRowId(bizBill, entryKey, entryCreditLimitKey));
        if (bizBill.getDynamicObject("creditlimit") == null && !CreditLimitHelper.isEntryCredit(bizBill, entryKey, entryCreditLimitKey)) {
            return false;
        }
        return !"cfm_loancontractbill".equals(bizBill.getDynamicObjectType().getName()) || !(isBanksLoanLimit = CreditLimitHelper.isBanksLoanLimit(productFactory = bizBill.getDynamicObject("productfactory"), bizBill.getString("loantype"))) || bizBill.getBoolean("isinit");
    }

    public static Object getBankCateIdByFinOrgId(Long finOrgId) {
        DynamicObject finOrg = TmcDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finOrgId)});
        if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
            return finOrgId;
        }
        DynamicObject bankCate = finOrg.getDynamicObject("bank_cate");
        Object bankCateId = bankCate != null ? bankCate.getPkValue() : Long.valueOf(0L);
        return bankCateId;
    }

    public static void createCreditUse(DynamicObject bill, boolean isPre) {
        DynamicObject creditUseBill;
        boolean issyncdraw;
        boolean bl = issyncdraw = bill.containsProperty("issyncdraw") && bill.getBoolean("issyncdraw");
        if (!issyncdraw && bill.getDynamicObject("creditlimit") == null) {
            return;
        }
        boolean isBanksLoan = LoanTypeEnum.isBanksLoan(bill.getString("loantype"));
        if (isBanksLoan && !CreditLimitHelper.isEntryCredit(bill, "banksyndicate_entry", "cfm_loanbill".equals(bill.getDynamicObjectType().getName()) ? "e_bankcreditlimit" : "e_creditlimit")) {
            return;
        }
        if (issyncdraw && bill.getDynamicObject("synccreditlimit") == null) {
            return;
        }
        String entityName = bill.getDataEntityType().getName();
        if ("fl_leasecontractbill_init".equals(entityName)) {
            entityName = "fl_leasecontractbill";
        }
        if (EmptyUtil.isEmpty((DynamicObject)(creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)bill.getLong("id"), (String)entityName)))) {
            if (isBanksLoan) {
                DynamicObjectCollection bankCateEntrys = bill.getDynamicObjectCollection("banksyndicate_entry");
                for (DynamicObject bankCateEntry : bankCateEntrys) {
                    String limitField;
                    String string = limitField = "cfm_loanbill".equals(bill.getDynamicObjectType().getName()) ? "e_bankcreditlimit" : "e_creditlimit";
                    if (EmptyUtil.isEmpty((DynamicObject)bankCateEntry.getDynamicObject(limitField))) continue;
                    CreditLimitHelper.createCreditUses(bill, bankCateEntry.getLong("id"), isPre);
                }
            } else {
                CreditLimitHelper.createCreditUses(bill, bill.getLong("id"), isPre);
            }
        }
    }

    private static void createCreditUses(DynamicObject bill, long entryId, boolean isPre) {
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(Long.valueOf(bill.getLong("id")));
        useBean.setSourceBillEntryId(Long.valueOf(entryId));
        useBean.setEntityName(bill.getDataEntityType().getName());
        String orgProp = "org";
        long creditorId = bill.getLong("creditor");
        if ("cfm_loan_apply".equals(bill.getDynamicObjectType().getName())) {
            orgProp = "company";
        }
        if ("cim_invest_contract".equals(bill.getDynamicObjectType().getName())) {
            creditorId = bill.getLong("debtor");
        }
        useBean.setOrgId(Long.valueOf(bill.getDynamicObject(orgProp).getLong("id")));
        useBean.setFinOrgId(Long.valueOf(creditorId));
        useBean.setCurrencyId(Long.valueOf(bill.getDynamicObject("currency").getLong("id")));
        DynamicObject finproduct = bill.getDynamicObject("finproduct");
        DynamicObject creditType = finproduct != null ? finproduct.getDynamicObject("credittype") : null;
        useBean.setCreditTypeId(Long.valueOf(creditType != null ? creditType.getLong("id") : 0L));
        useBean.setCreditVariety(finproduct != null ? finproduct.getString("name") : "");
        useBean.setCreditRatio(Constants.ONE_HUNDRED);
        if (!EmptyUtil.isEmpty((DynamicObject)bill.getDynamicObject("creditlimit"))) {
            useBean.setCreditLimitNo(bill.getDynamicObject("creditlimit").getString("number"));
            useBean.setBizAmt(bill.getBigDecimal("amount"));
            useBean.setMaxAmt(bill.getBigDecimal("amount"));
            useBean.setStartDate(bill.getDate("startdate"));
            useBean.setEndDate(bill.getDate("enddate"));
            useBean.setPreOccupy(Boolean.valueOf(isPre));
        } else if (!EmptyUtil.isEmpty((DynamicObject)bill.getDynamicObject("synccreditlimit"))) {
            useBean.setCreditLimitNo(bill.getDynamicObject("synccreditlimit").getString("number"));
            useBean.setBizAmt(bill.getBigDecimal("syncdrawamount"));
            useBean.setMaxAmt(bill.getBigDecimal("syncdrawamount"));
            useBean.setStartDate(bill.getDate("syncdrawdate"));
            useBean.setEndDate(bill.getDate("expiredate"));
            useBean.setPreOccupy(Boolean.valueOf(false));
        }
        CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
    }

    private static boolean isContratBill(String entityName) {
        return CfmEntityConst.isContractBill(entityName);
    }

    public static DynamicObject getRealCreditLimit(DynamicObject creditLimit) {
        if (creditLimit.getBoolean("ismergesrc")) {
            DynamicObject targetCredit = TmcDataServiceHelper.loadSingleFromCache((String)"cfm_creditlimit", (String)"id,ismergesrc", (QFilter[])new QFilter[]{new QFilter("sourcebillids.fbasedataid", "=", creditLimit.getPkValue())});
            return CreditLimitHelper.getRealCreditLimit(targetCredit);
        }
        return creditLimit;
    }

    public static boolean isBanksLoanLimit(DynamicObject productFactory, String loanType) {
        return LoanTypeEnum.BANKSLOAN.getValue().equals(loanType) && (EmptyUtil.isEmpty((DynamicObject)productFactory) || !productFactory.getBoolean("isloancommit"));
    }

    public static boolean isCreditUse(long billid, Set<Long> entryIds) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)billid).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("realamt", ">", (Object)BigDecimal.ZERO);
        if (EmptyUtil.isNoEmpty(entryIds)) {
            filter.and("sourcebillentryid", "in", entryIds);
        }
        return QueryServiceHelper.exists((String)"cfm_credituse", (QFilter[])new QFilter[]{filter});
    }
}

