/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DealBotpRelationHelper {
    private static final Log logger = LogFactory.getLog(DealBotpRelationHelper.class);
    private static final Map<String, String> bizBillRelationMap = new HashMap<String, String>(16);
    public static final Map<String, String> oppoSiteSourceEntityNameMap = new HashMap<String, String>(16);
    private static final String needSelectField = String.join((CharSequence)",", "id", "lendernature", "sourcebillid", "billno", "datasource", "loantype", "debtortype", "creditortype");

    public static void creatOppositeBotpRelation(List<DynamicObject> bills) {
        if (EmptyUtil.isEmpty(bills)) {
            return;
        }
        List billIds = bills.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        String tarEntityName = bills.get(0).getDynamicObjectType().getName();
        DynamicObjectCollection colls = QueryServiceHelper.query((String)tarEntityName, (String)needSelectField, (QFilter[])new QFilter("id", "in", billIds).toArray());
        List tarBills = colls.stream().filter(d -> DealBotpRelationHelper.isDealBotp(d, tarEntityName)).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(tarBills)) {
            return;
        }
        for (DynamicObject tarBillObj : tarBills) {
            long tarBillId = tarBillObj.getLong("id");
            String dataSource = tarBillObj.getString("datasource");
            String currBillEntityName = DealBotpRelationHelper.getCurrBillEntityName(tarEntityName, dataSource);
            String oppoSiteSrcEntityName = oppoSiteSourceEntityNameMap.get(currBillEntityName);
            String oppoSiteTarEntityName = bizBillRelationMap.get(currBillEntityName);
            List<String> repayEntitys = Arrays.asList(CfmEntityEnum.REPAYMENTBILL.getValue(), CfmEntityEnum.INVEST_REPAYBILL.getValue());
            if (repayEntitys.contains(currBillEntityName)) {
                DynamicObjectCollection repayBills = QueryServiceHelper.query((String)CfmEntityEnum.REPAYMENTBILL.getValue(), (String)"loans.e_loanbill", (QFilter[])new QFilter("id", "=", (Object)tarBillId).toArray());
                List loanBillIds = repayBills.stream().map(o -> o.getLong("loans.e_loanbill")).collect(Collectors.toList());
                TmcBotpHelper.saveRelation((String)oppoSiteSrcEntityName, loanBillIds, (String)oppoSiteTarEntityName, (Long)tarBillId);
                continue;
            }
            Long srcId = tarBillObj.getLong("sourcebillid");
            logger.info("\u5efa\u7acb:" + tarBillObj.getString("billno") + " botp\u5173\u7cfb\u5f00\u59cb:oppoSiteSrcEntityName:" + oppoSiteSrcEntityName + " srcId:" + srcId + " oppoSiteTarEntityName:" + oppoSiteTarEntityName + " tarBillId:" + tarBillId);
            TmcBotpHelper.saveRelation((String)oppoSiteSrcEntityName, (Long)srcId, (String)oppoSiteTarEntityName, (Long)tarBillId);
            logger.info("\u5efa\u7acbbotp\u5173\u7cfb\u7ed3\u675f");
        }
    }

    public static void deleteOppositeBotpRelation(List<DynamicObject> bills) {
        List billIds = bills.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        String tarEntityName = bills.get(0).getDynamicObjectType().getName();
        DynamicObjectCollection colls = QueryServiceHelper.query((String)tarEntityName, (String)needSelectField, (QFilter[])new QFilter("id", "in", billIds).toArray());
        List tarBills = colls.stream().filter(d -> DealBotpRelationHelper.isDealBotp(d, tarEntityName)).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(tarBills)) {
            return;
        }
        for (DynamicObject tarBillObj : tarBills) {
            long tarBillId = tarBillObj.getLong("id");
            String dataSource = tarBillObj.getString("datasource");
            String srcEntityName = DealBotpRelationHelper.getCurrBillEntityName(tarEntityName, dataSource);
            String TarEntityName = bizBillRelationMap.get(srcEntityName);
            List<String> repayEntitys = Arrays.asList(CfmEntityEnum.REPAYMENTBILL.getValue(), CfmEntityEnum.INVEST_REPAYBILL.getValue());
            if (repayEntitys.contains(srcEntityName)) {
                DynamicObjectCollection repayBills = QueryServiceHelper.query((String)CfmEntityEnum.REPAYMENTBILL.getValue(), (String)"loans.e_loanbill", (QFilter[])new QFilter("id", "=", (Object)tarBillId).toArray());
                List loanBillIds = repayBills.stream().map(o -> o.getLong("loans.e_loanbill")).collect(Collectors.toList());
                for (Long loanBillId : loanBillIds) {
                    logger.info("\u5220\u9664:" + tarBillObj.getString("billno") + " botp\u5173\u7cfb\u5f00\u59cb");
                    TmcBotpHelper.deleteRation((String)TarEntityName, (Long)loanBillId, (Long)tarBillId);
                    logger.info("\u5220\u9664botp\u5173\u7cfb\u7ed3\u675f");
                }
                continue;
            }
            Long srcId = tarBillObj.getLong("sourcebillid");
            logger.info("\u5220\u9664:" + tarBillObj.getString("billno") + " botp\u5173\u7cfb\u5f00\u59cb");
            TmcBotpHelper.deleteRation((String)TarEntityName, (Long)srcId, (Long)tarBillId);
            logger.info("\u5220\u9664botp\u5173\u7cfb\u7ed3\u675f");
        }
    }

    private static boolean isDealBotp(DynamicObject tarBillObj, String tarEntityName) {
        String loanType = tarBillObj.getString("loantype");
        return bizBillRelationMap.containsKey(tarEntityName) && BusinessHelper.isOutGroup(tarBillObj) && Arrays.asList(LoanTypeEnum.ENTRUSTLOAN.getValue(), LoanTypeEnum.LINKLEND.getValue()).contains(loanType);
    }

    private static String getCurrBillEntityName(String tarEntityName, String dataSource) {
        String currBillEntityName = tarEntityName;
        if (!dataSource.isEmpty() && dataSource.equals(DataSourceEnum.INVEST.getValue())) {
            if (!tarEntityName.contains("cim_invest")) {
                currBillEntityName = bizBillRelationMap.get(tarEntityName);
            }
        } else if (tarEntityName.contains("cim_invest")) {
            currBillEntityName = bizBillRelationMap.get(tarEntityName);
        }
        return currBillEntityName;
    }

    static {
        bizBillRelationMap.put(CfmEntityEnum.EXTENDBILL.getValue(), CfmEntityEnum.INVEST_EXTENDBILL.getValue());
        bizBillRelationMap.put(CfmEntityEnum.INVEST_EXTENDBILL.getValue(), CfmEntityEnum.EXTENDBILL.getValue());
        bizBillRelationMap.put(CfmEntityEnum.LOANBILL.getValue(), CfmEntityEnum.INVEST_LOANBILL.getValue());
        bizBillRelationMap.put(CfmEntityEnum.INVEST_LOANBILL.getValue(), CfmEntityEnum.LOANBILL.getValue());
        bizBillRelationMap.put(CfmEntityEnum.REPAYMENTBILL.getValue(), CfmEntityEnum.INVEST_REPAYBILL.getValue());
        bizBillRelationMap.put(CfmEntityEnum.INVEST_REPAYBILL.getValue(), CfmEntityEnum.REPAYMENTBILL.getValue());
        bizBillRelationMap.put(CfmEntityEnum.INTERESTBILL.getValue(), CfmEntityEnum.INVEST_INTERESTBILL.getValue());
        bizBillRelationMap.put(CfmEntityEnum.INVEST_INTERESTBILL.getValue(), CfmEntityEnum.INTERESTBILL.getValue());
        oppoSiteSourceEntityNameMap.put(CfmEntityEnum.LOANBILL.getValue(), CfmEntityEnum.INVEST_CONTRACT.getValue());
        oppoSiteSourceEntityNameMap.put(CfmEntityEnum.INVEST_LOANBILL.getValue(), CfmEntityEnum.CONTRACTBILL.getValue());
        oppoSiteSourceEntityNameMap.put(CfmEntityEnum.EXTENDBILL.getValue(), CfmEntityEnum.INVEST_CONTRACT.getValue());
        oppoSiteSourceEntityNameMap.put(CfmEntityEnum.INVEST_EXTENDBILL.getValue(), CfmEntityEnum.CONTRACTBILL.getValue());
        oppoSiteSourceEntityNameMap.put(CfmEntityEnum.REPAYMENTBILL.getValue(), CfmEntityEnum.INVEST_LOANBILL.getValue());
        oppoSiteSourceEntityNameMap.put(CfmEntityEnum.INVEST_REPAYBILL.getValue(), CfmEntityEnum.LOANBILL.getValue());
        oppoSiteSourceEntityNameMap.put(CfmEntityEnum.INTERESTBILL.getValue(), CfmEntityEnum.INVEST_LOANBILL.getValue());
        oppoSiteSourceEntityNameMap.put(CfmEntityEnum.INVEST_INTERESTBILL.getValue(), CfmEntityEnum.LOANBILL.getValue());
    }
}

