/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.tmc.cfm.common.constant.CfmEntityConst;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FormParameterHelper {
    public static Set<String> getBizTypes(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        HashSet<String> bizTypes = new HashSet<String>(3);
        String bizType = (String)parameter.getCustomParam("biztype");
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            bizTypes.addAll(Arrays.asList(bizType.split(",")));
        }
        return bizTypes;
    }

    public static boolean containsKey(IFormView view, String key) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        return customParams.containsKey(key);
    }

    public static String getContractFormIdByBizType(DynamicObject info, IFormView view) {
        String form = "cfm_loancontractbill";
        String entity = CfmBillCommonHelper.getFormIdByShowParameter(view);
        if (entity.startsWith("cim") || "cim_invest_initbill".equals(entity)) {
            return "cim_invest_contract";
        }
        if (entity.startsWith("ifm")) {
            return "ifm_loancontractbill";
        }
        String biztype = info.getString("loantype");
        if (BizTypeEnum.LOAN.getValue().equals(biztype) || BizTypeEnum.SL.getValue().equals(biztype)) {
            form = "cfm_loancontract_bl_l";
        } else if (BizTypeEnum.EC.getValue().equals(biztype) || BizTypeEnum.ENTRUST.getValue().equals(biztype)) {
            form = "cfm_loancontract_ic_l";
        } else if (BizTypeEnum.BOND.getValue().equals(biztype)) {
            form = "cfm_loancontract_bo";
        }
        return form;
    }

    public static String getLoanBillFormByBizType(IFormView view) {
        String form = "cfm_loanbill";
        String entity = view.getModel().getDataEntityType().getName();
        if (entity.startsWith("cim")) {
            return "cim_invest_loanbill";
        }
        if (entity.startsWith("ifm")) {
            return "ifm_loanbill";
        }
        if (CfmEntityConst.isLeaseContractBill(entity) || entity.equals("fl_rentpaybill")) {
            return "fl_receiptbill";
        }
        String biztype = (String)view.getModel().getValue("loantype");
        if (BizTypeEnum.LOAN.getValue().equals(biztype) || BizTypeEnum.SL.getValue().equals(biztype)) {
            form = "cfm_loanbill_b_l";
        } else if (BizTypeEnum.EC.getValue().equals(biztype) || BizTypeEnum.ENTRUST.getValue().equals(biztype)) {
            form = "cfm_loanbill_e_l";
        } else if (BizTypeEnum.BOND.getValue().equals(biztype)) {
            form = "cfm_loanbill_bond";
        }
        return form;
    }

    public static String getRepayBillFormByBizType(IFormView view) {
        String form = "cfm_repaymentbill";
        String entity = view.getModel().getDataEntityType().getName();
        if (entity.startsWith("cim")) {
            return "cim_invest_repaybill";
        }
        if (entity.startsWith("ifm")) {
            return "ifm_repaymentbill";
        }
        if (entity.equals("fl_receiptbill") || CfmEntityConst.isLeaseContractBill(entity)) {
            return "fl_rentpaybill";
        }
        String biztype = (String)view.getModel().getValue("loantype");
        if (BizTypeEnum.LOAN.getValue().equals(biztype) || BizTypeEnum.SL.getValue().equals(biztype)) {
            form = "cfm_repaymentbill_b_l";
        } else if (BizTypeEnum.EC.getValue().equals(biztype) || BizTypeEnum.ENTRUST.getValue().equals(biztype)) {
            form = "cfm_repaymentbill_e_l";
        } else if (BizTypeEnum.BOND.getValue().equals(biztype)) {
            form = "cfm_repaymentbill_bond";
        }
        return form;
    }

    public static String getInterestBillFormByBizType(IFormView view) {
        String form = "cfm_interestbill";
        String entity = view.getModel().getDataEntityType().getName();
        if (entity.startsWith("cim")) {
            return "cim_invest_interestbill";
        }
        if (entity.startsWith("ifm")) {
            return "ifm_interestbill";
        }
        String biztype = (String)view.getModel().getValue("loantype");
        if (BizTypeEnum.LOAN.getValue().equals(biztype) || BizTypeEnum.SL.getValue().equals(biztype)) {
            form = "cfm_interestbill_b";
        } else if (BizTypeEnum.EC.getValue().equals(biztype) || BizTypeEnum.ENTRUST.getValue().equals(biztype)) {
            form = "cfm_interestbill_e";
        } else if (BizTypeEnum.BOND.getValue().equals(biztype)) {
            form = "cfm_interestbill_bond";
        }
        return form;
    }

    public static void showForm(IFormView view, String formId, Object pkId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        String biztype = (String)view.getFormShowParameter().getCustomParam("biztype");
        if (EmptyUtil.isNoEmpty((String)biztype)) {
            showParameter.setCustomParam("biztype", (Object)biztype);
        }
        showParameter.setPkId(pkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        view.showForm((FormShowParameter)showParameter);
    }

    public static DataEntityPropertyCollection getDataEntityProperties(IDataModel model, String entryName) {
        EntityType entityType;
        DataEntityPropertyCollection entryProperties = null;
        Map allEntities = model.getDataEntityType().getAllEntities();
        if (EmptyUtil.isNoEmpty((Object)allEntities) && EmptyUtil.isNoEmpty((Object)(entityType = (EntityType)allEntities.get(entryName)))) {
            entryProperties = entityType.getProperties();
        }
        return entryProperties;
    }
}

