/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IfmBizDealHelper {
    public static void setProjectCalendarByContract(DynamicObject bizDeal, String fields) {
        if (bizDeal == null) {
            return;
        }
        String contractBillno = bizDeal.getString("contractbillno");
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((String)"ifm_loancontractbill", (String)fields, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)contractBillno)});
        if (contractBill != null) {
            String[] fieldArr = fields.split(",", -1);
            for (int i = 0; i < fieldArr.length; ++i) {
                String field = fieldArr[i];
                Object obj = contractBill.get(field);
                if ("amount".equals(field)) {
                    field = "contractamt";
                }
                if (obj instanceof DynamicObjectCollection) {
                    DynamicObjectCollection srcCols = (DynamicObjectCollection)obj;
                    DynamicObject[] srcColArr = (DynamicObject[])srcCols.stream().map(o -> o.getDynamicObject("fbasedataid")).toArray(DynamicObject[]::new);
                    DynamicObjectCollection targetCol = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)bizDeal, (String)field, (DynamicObject[])srcColArr);
                    bizDeal.set(field, (Object)targetCol);
                    continue;
                }
                bizDeal.set(field, obj);
            }
        }
    }

    public static void setBizDealMainOrg(DynamicObject bizDeal) {
        DynamicObject creditor = bizDeal.getDynamicObject("creditor");
        if (EmptyUtil.isEmpty((DynamicObject)creditor)) {
            return;
        }
        DynamicObject finorg = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_finorginfo", (QFilter[])new QFilter[]{new QFilter("id", "=", creditor.getPkValue())});
        if (EmptyUtil.isEmpty((DynamicObject)finorg)) {
            return;
        }
        bizDeal.set("mainorg", (Object)finorg.getDynamicObject("org"));
    }

    public static void validatePush2SettleCenter(IFormView view, String entityname, List<Long> selectedIds, BeforeDoOperationEventArgs args) {
        List<Long> billIds = selectedIds;
        QFilter billQF = new QFilter("id", "in", billIds);
        DynamicObjectCollection loans = QueryServiceHelper.query((String)entityname, (String)"id,billno,creditortype,billstatus,datasource, confirmstatus", (QFilter[])billQF.toArray());
        List<DynamicObject> invalidStatusDOs = loans.stream().filter(o -> !BillStatusEnum.AUDIT.getValue().equals(o.getString("billstatus"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(invalidStatusDOs)) {
            args.setCancel(true);
            ArrayList billNos = new ArrayList(invalidStatusDOs.size());
            invalidStatusDOs.forEach(d -> billNos.add(d.getString("billno")));
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"%s \u975e\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u4e0d\u80fd\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"IfmBizDealHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]), String.join((CharSequence)",", billNos)));
            return;
        }
        List<DynamicObject> notSettleCenterDOs = loans.stream().filter(o -> !CreditorTypeEnum.SETTLECENTER.getValue().equals(o.getString("creditortype"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(notSettleCenterDOs)) {
            args.setCancel(true);
            ArrayList billNos = new ArrayList(notSettleCenterDOs.size());
            notSettleCenterDOs.forEach(d -> billNos.add(d.getString("billno")));
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"%s \u503a\u6743\u4eba\u7c7b\u578b\u975e\u7ed3\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"IfmBizDealHelper_1", (String)"tmc-cfm-common", (Object[])new Object[0]), String.join((CharSequence)",", billNos)));
            return;
        }
        List<DynamicObject> ifmDsDOs = loans.stream().filter(o -> DataSourceEnum.IFM.getValue().equals(o.getString("datasource"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(ifmDsDOs)) {
            args.setCancel(true);
            ArrayList billNos = new ArrayList(ifmDsDOs.size());
            ifmDsDOs.forEach(d -> billNos.add(d.getString("billno")));
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"%s \u6765\u81ea\u5185\u90e8\u501f\u8d37\u7ed3\u7b97\u4e2d\u5fc3\u7684\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"IfmBizDealHelper_2", (String)"tmc-cfm-common", (Object[])new Object[0]), String.join((CharSequence)",", billNos)));
            return;
        }
        List<DynamicObject> confirmDOs = loans.stream().filter(o -> ConfirmStatusEnum.YETCONFIRM.getValue().equals(o.getString("confirmstatus"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(confirmDOs)) {
            args.setCancel(true);
            ArrayList billNos = new ArrayList(confirmDOs.size());
            confirmDOs.forEach(d -> billNos.add(d.getString("billno")));
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"%s \u5df2\u786e\u8ba4\u72b6\u6001\u4e0d\u80fd\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"IfmBizDealHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]), String.join((CharSequence)",", billNos)));
            return;
        }
        Map botpMap = BFTrackerServiceHelper.findDirtTargetBills((String)entityname, (Long[])billIds.toArray(new Long[0]));
        HashMap srcId2TargetMap = new HashMap(16);
        for (Map.Entry entry : botpMap.entrySet()) {
            Long loanId = (Long)entry.getKey();
            List bfRows = (List)entry.getValue();
            HashMap<String, HashSet<Long>> targetBillMap = (HashMap<String, HashSet<Long>>)srcId2TargetMap.get(loanId);
            if (targetBillMap == null) {
                targetBillMap = new HashMap<String, HashSet<Long>>(16);
                srcId2TargetMap.put(loanId, targetBillMap);
            }
            for (BFRow row : bfRows) {
                TableDefine tdf = EntityMetadataCache.loadTableDefine((Long)row.getId().getMainTableId());
                HashSet<Long> targetBillIds = (HashSet<Long>)targetBillMap.get(tdf.getEntityNumber());
                if (targetBillIds == null) {
                    targetBillIds = new HashSet<Long>(10);
                    targetBillMap.put(tdf.getEntityNumber(), targetBillIds);
                }
                targetBillIds.add(row.getId().getBillId());
            }
        }
        ArrayList<String> billNos = new ArrayList<String>(loans.size());
        for (DynamicObject loan : loans) {
            Set bizdealBillIds;
            Map targetMap = (Map)srcId2TargetMap.get(loan.getLong("id"));
            if (EmptyUtil.isEmpty((Object)targetMap) || !EmptyUtil.isNoEmpty((Object)(bizdealBillIds = (Set)targetMap.get("ifm_bizdealbill")))) continue;
            billNos.add(loan.getString("billno"));
        }
        if (EmptyUtil.isNoEmpty(billNos)) {
            args.setCancel(true);
            String string = String.join((CharSequence)",", billNos);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"%s \u5df2\u7ecf\u6709\u7ed3\u7b97\u4e2d\u5fc3\u8d37\u6b3e\u53d7\u7406\u5355\uff0c\u4e0d\u80fd\u518d\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"IfmBizDealHelper_4", (String)"tmc-cfm-common", (Object[])new Object[0]), string));
        }
    }

    public static void pushInnerSettlePayBill(DynamicObject bill) {
        Object[] transHandle = TmcBotpHelper.push((DynamicObject)bill, (String)"ifm_transhandlebill");
        if (EmptyUtil.isEmpty((Object[])transHandle)) {
            return;
        }
        Object transHandleBill = transHandle[0];
        String transHandleBillNo = CodeRuleServiceHelper.readNumber((String)"ifm_transhandlebill", (DynamicObject)transHandleBill, null);
        transHandleBill.set("billno", (Object)transHandleBillNo);
        OperateOption operateOption = OperateOption.create();
        OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"ifm_transhandlebill", (DynamicObject[])transHandle, (OperateOption)operateOption);
        if (!submitResult.isSuccess()) {
            throw new KDBizException(String.join((CharSequence)";", TmcOperateServiceHelper.decodeErrorMsg((OperationResult)submitResult)));
        }
        Object[] idArr = submitResult.getSuccessPkIds().toArray();
        OperationResult auditResult = TmcOperateServiceHelper.execOperate((String)"audit", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
        if (!auditResult.isSuccess()) {
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
            throw new KDBizException(String.join((CharSequence)";", TmcOperateServiceHelper.decodeErrorMsg((OperationResult)auditResult)));
        }
        OperationResult conmmitfmResult = TmcOperateServiceHelper.execOperate((String)"commitifm", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
        if (!conmmitfmResult.isSuccess()) {
            TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
            throw new KDBizException(String.join((CharSequence)";", TmcOperateServiceHelper.decodeErrorMsg((OperationResult)conmmitfmResult)));
        }
        DynamicObject payBill = QueryServiceHelper.queryOne((String)"ifm_transhandlebill", (String)"bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idArr)});
        if (EmptyUtil.isNoEmpty((DynamicObject)payBill)) {
            bill.set("bankcheckflag", (Object)payBill.getString("bankcheckflag"));
            SaveServiceHelper.update((DynamicObject)bill);
        }
    }

    public static void deleteInnerSettlePayRec(DynamicObject billDyn, String entityName) {
        if (EmptyUtil.isEmpty((DynamicObject)billDyn)) {
            return;
        }
        List targetList = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billDyn.getLong("id"))}, null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)targetList)) {
            return;
        }
        TmcOperateServiceHelper.execOperate((String)"canclepay", (String)entityName, (Object[])targetList.toArray(), (OperateOption)OperateOption.create());
    }

    public static void matchPayBillByBankCheckFlag(Set<String> bankCheckFlags) {
        if (EmptyUtil.isEmpty(bankCheckFlags)) {
            return;
        }
        List bks = bankCheckFlags.stream().filter(s -> EmptyUtil.isNoEmpty((String)s)).collect(Collectors.toList());
        QFilter detailQF = new QFilter("datasource", "=", (Object)"fromifm");
        detailQF.and(new QFilter("bankcheckflag", "in", bks));
        DynamicObjectCollection details = QueryServiceHelper.query((String)"ifm_transdetail", (String)"id", (QFilter[])detailQF.toArray());
        if (details == null) {
            return;
        }
        List detailids = details.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        ThreadPools.executeOnceIncludeRequestContext((String)"matchbillintelpay", () -> TmcOperateServiceHelper.execOperateWithoutThrow((String)"matchbill", (String)"bei_intelpay", (Object[])detailids.toArray(), (OperateOption)OperateOption.create()));
    }
}

