/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LastPreIntDateEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillWriteOffHelper {
    public static DynamicObject getLoanBill(DynamicObject[] interestBills) {
        String loanBillNo = interestBills[0].getString("loanbillno");
        QFilter filter = new QFilter("billno", "=", (Object)loanBillNo);
        return TmcDataServiceHelper.loadSingle((String)"cfm_loanbill", (String)"drawtype,notrepayamount", (QFilter[])filter.toArray());
    }

    public static DynamicObject[] getPreIntBills(DynamicObject[] interestBills, List preIntBillIds) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        filter.and("nowriteoffamt", "!=", (Object)0L);
        List<String> writeOffStatus = Arrays.asList(WriteOffStatusEnum.WRITEOFF.getValue(), WriteOffStatusEnum.RED_WRITEOFF.getValue());
        filter.and("writeoffstatus", "not in", writeOffStatus);
        if (EmptyUtil.isEmpty((Collection)preIntBillIds)) {
            filter.and("loanbillno", "=", (Object)interestBills[0].getString("loanbillno"));
        } else {
            filter.and("id", "in", (Object)preIntBillIds);
        }
        return TmcDataServiceHelper.load((String)"cfm_preinterestbill", (String)"id,bizdate,billno,recordstatus,org,textcreditor,currency,prestartdate,prestenddate,actpreinstamt,nowriteoffamt,writeoffamt,writeoffstatus,operatetype,beforewriteoffamt", (QFilter[])filter.toArray(), (String)"bizdate asc");
    }

    public static DynamicObject[] getWriteOffPreIntBills(Object ids) {
        QFilter filter = new QFilter("id", "in", ids);
        return TmcDataServiceHelper.load((String)"cfm_preinterestbill", (String)"id,bizdate,billno,recordstatus,org,textcreditor,currency,prestartdate,prestenddate,actpreinstamt,nowriteoffamt,writeoffamt,writeoffstatus,operatetype", (QFilter[])filter.toArray(), (String)"bizdate asc");
    }

    public static DynamicObjectCollection getWriteOffRelations(DynamicObject[] interestBills) {
        long batchNo = interestBills[0].getLong("batchnoid");
        QFilter filter = new QFilter("batchnoid", "=", (Object)batchNo);
        return QueryServiceHelper.query((String)"cfm_instwriteoff_relation", (String)"preinstbillid,amount", (QFilter[])filter.toArray());
    }

    public static boolean verifyCanWriteOff(IFormView view, List ids) {
        DynamicObject[] intBills;
        QFilter filter = new QFilter("id", "in", (Object)ids);
        for (DynamicObject intBill : intBills = TmcDataServiceHelper.load((String)"cfm_interestbill", (String)"billstatus,writeoffstatus,org,currency,bizdate,loanbillno,confirmstatus,creditortype,creditorg,datasource", (QFilter[])filter.toArray())) {
            String billStatus = intBill.getString("billstatus");
            String writeOffStatus = intBill.getString("writeoffstatus");
            String confirmStatus = intBill.getString("confirmstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || !ConfirmStatusEnum.YETCONFIRM.getValue().equals(confirmStatus) || !EmptyUtil.isEmpty((String)writeOffStatus) && !WriteOffStatusEnum.NO_WRITEOFF.getValue().equals(writeOffStatus)) {
                String message = ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u5df2\u786e\u8ba4\u4e14\u672a\u51b2\u9500\u5355\u636e\u5141\u8bb8\u51b2\u9500\u3002", (String)"IntBillWriteOffHelper_4", (String)"tmc-cfm-common", (Object[])new Object[0]);
                view.showTipNotification(message);
                return false;
            }
            String mainOrgFeild = BatchIntBillHelper.getMainOrgFeild(intBill);
            if (!IntBillWriteOffHelper.isRedWriteOffParam(intBill.getDynamicObject(mainOrgFeild).getLong("id"))) continue;
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\uff1a\u5168\u989d\u51b2\u9500\u6cd5\u3002", (String)"IntBillWriteOffHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]);
            view.showTipNotification(message);
            return false;
        }
        Set loanBills = Arrays.stream(intBills).map(v -> v.getString("loanbillno")).collect(Collectors.toSet());
        if (loanBills.size() > 1) {
            String message = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c%s\u5355\u7684\u5229\u606f\u5355\u8fdb\u884c\u51b2\u9500\u3002", (String)"IntBillWriteOffHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]), IntBillWriteOffHelper.getBillName(view));
            view.showTipNotification(message);
            return false;
        }
        Date minBizDate = Arrays.stream(intBills).map(v -> v.getDate("bizdate")).min(Date::compareTo).get();
        filter = new QFilter("bizdate", "<=", (Object)minBizDate);
        filter = filter.and(new QFilter("writeoffstatus", "!=", (Object)WriteOffStatusEnum.WRITEOFF.getValue()));
        filter = filter.and(new QFilter("id", "not in", (Object)ids));
        boolean isExistLessDateBill = TmcDataServiceHelper.exists((String)"cfm_interestbill", (QFilter[])(filter = filter.and(new QFilter("loanbillno", "in", loanBills))).toArray());
        if (isExistLessDateBill) {
            String message = ResManager.loadKDString((String)"\u5b58\u5728\u524d\u5e8f\u672a\u51b2\u9500\u4ed8\u606f\u5355\u3002", (String)"IntBillWriteOffHelper_5", (String)"tmc-cfm-common", (Object[])new Object[0]);
            view.showTipNotification(message);
        }
        return true;
    }

    public static boolean verifyCanUnWriteOff(IFormView view, List ids) {
        DynamicObject[] intBills;
        QFilter filter = new QFilter("id", "in", (Object)ids);
        for (DynamicObject intBill : intBills = TmcDataServiceHelper.load((String)"cfm_interestbill", (String)"billstatus,writeoffstatus,org,currency,bizdate,loanbillno,datasource,creditortype,creditorg", (QFilter[])filter.toArray())) {
            long orgId = intBill.getDynamicObject(BatchIntBillHelper.getMainOrgFeild(intBill)).getLong("id");
            if (!IntBillWriteOffHelper.verifyWriteOffParam(view, orgId)) {
                return false;
            }
            String writeOffStatus = intBill.getString("writeoffstatus");
            if (WriteOffStatusEnum.WRITEOFF.getValue().equals(writeOffStatus)) continue;
            String message = ResManager.loadKDString((String)"\u5df2\u51b2\u9500\u5355\u636e\u624d\u5141\u8bb8\u53cd\u51b2\u9500\u3002", (String)"IntBillWriteOffHelper_6", (String)"tmc-cfm-common", (Object[])new Object[0]);
            view.showTipNotification(message);
            return false;
        }
        return true;
    }

    private static boolean verifyWriteOffParam(IFormView view, Long orgId) {
        boolean isRedWriteOffParam = IntBillWriteOffHelper.isRedWriteOffParam(orgId);
        if (isRedWriteOffParam) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\uff1a\u5168\u989d\u51b2\u9500\u6cd5\u3002", (String)"IntBillWriteOffHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]);
            view.showTipNotification(message);
            return false;
        }
        return true;
    }

    public static void writeOff(DynamicObject[] preInstBills, BigDecimal writeOffAmt, long batchNoId, boolean isAllWriteOff) {
        ArrayList<DynamicObject> relationList = new ArrayList<DynamicObject>();
        List preIntBills = Arrays.stream(preInstBills).sorted(Comparator.comparing(o -> o.getDate("prestartdate"))).collect(Collectors.toList());
        for (DynamicObject preIntBill : preIntBills) {
            BigDecimal leftNoWriteOffAmt;
            BigDecimal noWriteOffAmt = preIntBill.getBigDecimal("nowriteoffamt");
            boolean isPreInt = PreIntOperateTypeEnum.PREINT.getValue().equals(preIntBill.getString("operatetype"));
            BigDecimal bigDecimal = leftNoWriteOffAmt = isPreInt ? noWriteOffAmt : noWriteOffAmt.negate();
            if (writeOffAmt.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal beforeWriteOffAmt = writeOffAmt;
                BigDecimal actWriteOffAmt = (writeOffAmt = writeOffAmt.subtract(leftNoWriteOffAmt)).compareTo(BigDecimal.ZERO) >= 0 ? leftNoWriteOffAmt : beforeWriteOffAmt;
                preIntBill = IntBillWriteOffHelper.updatePreIntBill(preIntBill, actWriteOffAmt, true, isAllWriteOff);
                DynamicObject relation = IntBillWriteOffHelper.genWriteOffRelation(preIntBill, batchNoId, actWriteOffAmt);
                relationList.add(relation);
                continue;
            }
            if (!isAllWriteOff) continue;
            preIntBill.set("nowriteoffamt", (Object)BigDecimal.ZERO);
            preIntBill.set("beforewriteoffamt", (Object)noWriteOffAmt);
            preIntBill.set("writeoffstatus", (Object)WriteOffStatusEnum.WRITEOFF.getValue());
            DynamicObject relation = IntBillWriteOffHelper.genWriteOffRelation(preIntBill, batchNoId, BigDecimal.ZERO);
            relationList.add(relation);
        }
        SaveServiceHelper.save((DynamicObject[])relationList.toArray(new DynamicObject[relationList.size()]));
    }

    private static DynamicObject genWriteOffRelation(DynamicObject preIntBill, long batchNoId, BigDecimal writeOffAmt) {
        DynamicObject relation = TmcDataServiceHelper.newDynamicObject((String)"cfm_instwriteoff_relation");
        relation.set("batchnoid", (Object)batchNoId);
        relation.set("preinstbillid", (Object)preIntBill.getLong("id"));
        relation.set("currency", (Object)preIntBill.getDynamicObject("currency"));
        relation.set("amount", (Object)writeOffAmt);
        return relation;
    }

    public static DynamicObject updatePreIntBill(DynamicObject preIntBill, BigDecimal actWriteOffAmt, boolean isWriteOff, boolean isAllWriteOff) {
        BigDecimal noWriteOffAmt;
        BigDecimal actPreInstAmt = preIntBill.getBigDecimal("nowriteoffamt");
        BigDecimal beforeWriteOffAmt = preIntBill.getBigDecimal("beforewriteoffamt");
        if (isWriteOff) {
            preIntBill.set("writeoffamt", (Object)preIntBill.getBigDecimal("writeoffamt").add(actWriteOffAmt));
            noWriteOffAmt = actPreInstAmt.subtract(actWriteOffAmt);
            if (isAllWriteOff) {
                noWriteOffAmt = BigDecimal.ZERO;
                preIntBill.set("beforewriteoffamt", (Object)actPreInstAmt);
            }
        } else {
            noWriteOffAmt = actPreInstAmt.add(actWriteOffAmt);
            preIntBill.set("writeoffamt", (Object)preIntBill.getBigDecimal("writeoffamt").subtract(actWriteOffAmt));
            if (beforeWriteOffAmt.compareTo(BigDecimal.ZERO) > 0) {
                noWriteOffAmt = beforeWriteOffAmt;
                BigDecimal writeOffAmt = preIntBill.getBigDecimal("writeoffamt");
                if (writeOffAmt.compareTo(BigDecimal.ZERO) > 0) {
                    noWriteOffAmt = preIntBill.getBigDecimal("actpreinstamt").subtract(writeOffAmt);
                }
            }
            preIntBill.set("beforewriteoffamt", (Object)BigDecimal.ZERO);
        }
        preIntBill.set("nowriteoffamt", (Object)noWriteOffAmt);
        if (noWriteOffAmt.compareTo(BigDecimal.ZERO) <= 0) {
            preIntBill.set("writeoffstatus", (Object)WriteOffStatusEnum.WRITEOFF.getValue());
        } else if (noWriteOffAmt.compareTo(preIntBill.getBigDecimal("actpreinstamt")) < 0 || EmptyUtil.isNoEmpty((Object[])LoanBillHelper.getCorrectBills(preIntBill.getPkValue(), PreIntOperateTypeEnum.WRITEOFFINT.getValue()))) {
            preIntBill.set("writeoffstatus", (Object)WriteOffStatusEnum.PART_WRITEOFF.getValue());
        } else {
            preIntBill.set("writeoffstatus", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        }
        return preIntBill;
    }

    public static BigDecimal getTotalPreIntBillAmt(DynamicObject[] preIntBills) {
        BigDecimal noWriteOffAmt = Constants.ZERO;
        for (DynamicObject preIntBill : preIntBills) {
            noWriteOffAmt = PreIntOperateTypeEnum.REVERSEINT.getValue().equals(preIntBill.getString("operatetype")) ? noWriteOffAmt.subtract(preIntBill.getBigDecimal("nowriteoffamt")) : noWriteOffAmt.add(preIntBill.getBigDecimal("nowriteoffamt"));
        }
        return noWriteOffAmt;
    }

    public static boolean isRedWriteOffParam(long orgId) {
        String param = CfmSysParamHelper.getAppStringParameter(orgId, "cfm002");
        return EmptyUtil.isNoEmpty((String)param) && LastPreIntDateEnum.isLastRedSettleIntDate(param);
    }

    public static boolean isAutoRedWriteOffParam(long orgId) {
        String param = CfmSysParamHelper.getAppStringParameter(orgId, "cfm006");
        return EmptyUtil.isNoEmpty((String)param) && StringUtils.equals((CharSequence)param, (CharSequence)"true");
    }

    private static String getBillName(IFormView view) {
        String billName = ResManager.loadKDString((String)"\u63d0\u6b3e", (String)"IntBillWriteOffHelper_1", (String)"tmc-cfm-common", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)"cfm_interestbill_bond", (CharSequence)((ListView)view).getBillFormId())) {
            billName = ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"IntBillWriteOffHelper_2", (String)"tmc-cfm-common", (Object[])new Object[0]);
        }
        return billName;
    }

    public static void writeBackLastPreIntDate(Set loanBillIds) {
        DynamicObject[] loanBills;
        for (DynamicObject loanBill : loanBills = TmcDataServiceHelper.load((Object[])loanBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill"))) {
            LoanWriteBackHelper.preInterestBillDo(loanBill);
        }
        SaveServiceHelper.update((DynamicObject[])loanBills);
    }

    public static void writeBackDepositLastPreIntDate(Set<Object> loanBillIds, String depositEntifyName) {
        DynamicObject[] loanBills;
        for (DynamicObject loanBill : loanBills = TmcDataServiceHelper.load((Object[])loanBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_deposit"))) {
            Date lstDate2;
            Date transferDate;
            Date lstDate1;
            QFilter qFilter = new QFilter("sourcebillid", "=", loanBill.getPkValue());
            qFilter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
            qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and("writeoffstatus", "!=", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
            Object[] preInterests = TmcDataServiceHelper.load((String)depositEntifyName, (String)"id,loanbillno,operatetype,entrys,entrys.instenddate,prestenddate", (QFilter[])qFilter.toArray(), (String)"prestenddate desc");
            Date preInstEndDate = null;
            if (EmptyUtil.isNoEmpty((Object[])preInterests)) {
                preInstEndDate = preInterests[0].getDynamicObjectCollection("entrys").stream().map(v -> v.getDate("instenddate")).max(Comparator.naturalOrder()).orElse(null);
            }
            Date minDate = DateUtils.stringToDate((String)"1970-01-01", (String)"yyyy-MM-dd");
            Date date = lstDate1 = preInstEndDate != null ? preInstEndDate : minDate;
            if (loanBill.getBoolean("accepttransfer") && EmptyUtil.isNoEmpty((Object)loanBill.getDate("transferdate")) && (transferDate = DateUtils.getLastDay((Date)loanBill.getDate("transferdate"), (int)1)).compareTo(lstDate1) > 0) {
                lstDate1 = transferDate;
            }
            Date lstPayIntDate = lstDate1.compareTo(lstDate2 = Optional.ofNullable(loanBill.getDate("lastrevenuedate")).orElse(minDate)) >= 0 ? lstDate1 : lstDate2;
            lstPayIntDate = lstPayIntDate.compareTo(minDate) == 0 ? null : lstPayIntDate;
            loanBill.set("endpreinstdate", (Object)lstPayIntDate);
        }
        SaveServiceHelper.update((DynamicObject[])loanBills);
    }

    public static boolean isAutoPreInt(DynamicObject intBill) {
        if (EmptyUtil.isEmpty((DynamicObject)intBill)) {
            return false;
        }
        String mainOrgField = BatchIntBillHelper.getMainOrgFeild(intBill);
        long orgId = intBill.getDynamicObject(mainOrgField).getLong("id");
        String autoPreIntParam = CfmSysParamHelper.getAppStringParameter(orgId, "cfm004");
        return StringUtils.equals((CharSequence)autoPreIntParam, (CharSequence)"true");
    }

    public static boolean isLastPreIntEndDate(DynamicObject loanBill) {
        String creditorType = loanBill.getString("creditortype");
        String dataSource = loanBill.getString("datasource");
        String mainOrgField = CfmBillCommonHelper.getFundOrgFieldName(dataSource, true, creditorType);
        long orgId = loanBill.getDynamicObject(mainOrgField).getLong("id");
        String param = CfmSysParamHelper.getAppStringParameter(orgId, "cfm002");
        return EmptyUtil.isNoEmpty((String)param) && LastPreIntDateEnum.isLastPreIntEndDate(param);
    }
}

