/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.bean.BatchInterestCalcRequest;
import kd.tmc.cfm.common.bean.CalcInterestSegmRequest;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.cfm.common.service.calcint.LoanBillCalcIntService;
import kd.tmc.cfm.common.service.calcint.LoanBillIntPlanService;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.WorkCalendarAdjustParam;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class InterestCalcHelper {
    private static final LoanBillCalcIntService loanBillCalcIntService = new LoanBillCalcIntService();
    private static final LoanBillIntPlanService loanBillIntPlanService = new LoanBillIntPlanService();
    private static final String LOANBILL_PROPS = "id,currency.id,currency.amtprecision,drawamount,startintdate,endinstdate,cleardate,expiredate,renewalexpiredate,rateadjustdate,issofrrate,iscallcompint,repaymentway,basis,ratefloatpoint,ratesign,stageplan.id,interestsettledplan.id,settleintmode,loantype,intcalmethod,isnofixedterm,workcalendar.fbasedataid.id,repayplan_entry.exrepaymentdate,repayplan_entry.erepayamount,productfactory.intcapitalrule,productfactory.introundrule,productfactory.intheadtailrule,loancontractbill.overratetype,loancontractbill.overrate,loancontractbill.floatingratio,rateadjust_entry.ra_effectdate,rateadjust_entry.ra_confirmdate,rateadjust_entry.ra_yearrate";

    public static DynamicObject getLoanBill(Long loanBillId) {
        return TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill", (String)LOANBILL_PROPS);
    }

    public static List<DynamicObject> getLoanBills(List<Long> loanBillIds) {
        Object[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)LOANBILL_PROPS, (QFilter[])new QFilter("id", "in", loanBillIds).toArray());
        return EmptyUtil.isNoEmpty((Object[])loanBills) ? Arrays.asList(loanBills) : Collections.emptyList();
    }

    public static IntBillExtInfo callInt(Long loanBillid, Date beginDate, Date endDate, boolean isPreInt) {
        DynamicObject loanBill = InterestCalcHelper.getLoanBill(loanBillid);
        return InterestCalcHelper.callInt(InterestCalcRequest.build(loanBill, beginDate, endDate, isPreInt));
    }

    public static IntBillExtInfo callInt(InterestCalcRequest request) {
        return loanBillCalcIntService.callLoanBillInt(request);
    }

    public static <T> Map<Long, T> batchCalcLoanBillInt(BatchInterestCalcRequest request) {
        return loanBillCalcIntService.batchCalcLoanBillInt(request);
    }

    public static <T> Map<Long, T> batchCallInt(List<Long> loanBillIds, Date beginDate, Date endDate, boolean isPreInt) {
        return loanBillCalcIntService.batchCallInt(loanBillIds, beginDate, endDate, isPreInt);
    }

    public static IntBillExtInfo callInt(Long loanBillid, Date endDate, BigDecimal repayAmt) {
        return loanBillCalcIntService.callInt(loanBillid, endDate, repayAmt);
    }

    public static IntBillExtInfo callInt(DynamicObject loanBill, Date endDate, BigDecimal repayAmt) {
        return loanBillCalcIntService.callInt(loanBill, endDate, repayAmt);
    }

    public static IntBillExtInfo callInt(DynamicObject loanBill, Date beginDate, Date endDate, BigDecimal principle) {
        return loanBillCalcIntService.callInt(loanBill, beginDate, endDate, principle);
    }

    public static Pair<BigDecimal, List<IntBillExtInfo>> callIntPlan(DynamicObject loanBill) {
        return loanBillIntPlanService.callIntPlan(loanBill);
    }

    public static Pair<BigDecimal, List<IntBillExtInfo>> callIntPlanByHand(DynamicObject loanBill, List<PlanCallResult> intPlanList) {
        return loanBillIntPlanService.callIntPlanByHand(loanBill, intPlanList);
    }

    public static List<PlanCallResult> updatePlanListByAdjustRule(List<PlanCallResult> callResults, WorkCalendarAdjustParam adjustParam) {
        return loanBillIntPlanService.updatePlanListByAdjustRule(callResults, adjustParam);
    }

    public static void addDetail(DynamicObjectCollection intDetails, List<IntBillDetailExtInfo> details) {
        InterestCalcHelper.addDetail(intDetails, details, null);
    }

    public static void addDetail(DynamicObjectCollection intDetails, List<IntBillDetailExtInfo> details, DynamicObject loanInfo) {
        intDetails.clear();
        int seq = 1;
        boolean isFloatRate = false;
        String rateSign = "";
        BigDecimal rateFloatpoint = BigDecimal.ZERO;
        if (loanInfo != null && loanInfo.containsProperty("interesttype") && loanInfo.containsProperty("ratesign") && loanInfo.containsProperty("ratefloatpoint")) {
            isFloatRate = InterestTypeEnum.isFloat((String)loanInfo.getString("interesttype"));
            rateSign = loanInfo.getString("ratesign");
            rateFloatpoint = loanInfo.getBigDecimal("ratefloatpoint");
        }
        for (IntBillDetailExtInfo detail : details) {
            DynamicObject intDetail = intDetails.addNew();
            Date inststartdate = detail.getBeginDate();
            Date instenddate = detail.getEndDate();
            int instdays = detail.getDays();
            BigDecimal instprincipalamt = detail.getPrinciple();
            BigDecimal totalRate = detail.getRate();
            BigDecimal totalInt = detail.getTotalInt();
            totalInt = EmptyUtil.isEmpty((BigDecimal)totalInt) ? detail.getAmount() : totalInt;
            int ratetrandays = detail.getBasisDay();
            BigDecimal instamt = detail.getAmount();
            intDetail.set("seq", (Object)seq++);
            intDetail.set("inststartdate", (Object)inststartdate);
            intDetail.set("instenddate", (Object)instenddate);
            intDetail.set("instdays", (Object)instdays);
            intDetail.set("instprincipalamt", (Object)instprincipalamt);
            intDetail.set("rate", (Object)totalRate);
            intDetail.set("ratetrandays", (Object)ratetrandays);
            intDetail.set("instctg", (Object)detail.getIntType().getValue());
            intDetail.set("instamt", (Object)detail.getTotalInt());
            BigDecimal resPointRate = detail.getFloatRate();
            BigDecimal resPointInt = detail.getFloatInt();
            if (loanInfo != null && loanInfo.containsProperty("interesttype") && loanInfo.containsProperty("ratesign") && loanInfo.containsProperty("ratefloatpoint")) {
                resPointRate = InterestCalcHelper.getPointRate(isFloatRate, rateSign, rateFloatpoint, resPointRate);
                resPointInt = InterestCalcHelper.getPointInt(totalRate, totalInt, resPointRate);
            }
            if (intDetail.containsProperty("benchmarkrate") && intDetail.containsProperty("benchmarkint")) {
                intDetail.set("benchmarkrate", (Object)totalRate.subtract(resPointRate));
                intDetail.set("benchmarkint", (Object)totalInt.subtract(resPointInt));
            }
            if (!intDetail.containsProperty("lookdays")) continue;
            intDetail.set("instamt", (Object)instamt);
            intDetail.set("floatrate", (Object)resPointRate);
            intDetail.set("floatint", (Object)resPointInt);
            intDetail.set("totalint", (Object)detail.getTotalInt());
            intDetail.set("lasttotalint", (Object)detail.getLastTotalInt());
            intDetail.set("curtotalint", (Object)detail.getCurTotalInt());
            intDetail.set("confirmratedate", (Object)detail.getBeginConfirmDate());
            intDetail.set("lookdays", (Object)detail.getConfirmDays());
        }
    }

    public static Date getEndIntDate(DynamicObject loanBill, Date endDate) {
        BigDecimal notRepayAmount = loanBill.getBigDecimal("notrepayamount");
        Date lastRepayDate = loanBill.getDate("lastrepaydate");
        if (EmptyUtil.isNoEmpty((Object)lastRepayDate) && EmptyUtil.isNoEmpty((Object)endDate) && EmptyUtil.isEmpty((BigDecimal)notRepayAmount) && endDate.compareTo(lastRepayDate) >= 0) {
            return lastRepayDate;
        }
        return endDate;
    }

    public static BigDecimal getPrinciple(DynamicObject loanBill, Date beginDate) {
        beginDate = EmptyUtil.isEmpty((Object)beginDate) ? loanBill.getDate("startintdate") : beginDate;
        BigDecimal yetRepayAmt = BigDecimal.ZERO;
        DynamicObjectCollection repayPlanDoc = loanBill.getDynamicObjectCollection("repayplan_entry");
        for (DynamicObject repayPlan : repayPlanDoc) {
            if (repayPlan.getDate("exrepaymentdate").compareTo(beginDate) >= 0) continue;
            yetRepayAmt = yetRepayAmt.add(repayPlan.getBigDecimal("erepayamount"));
        }
        return loanBill.getBigDecimal("drawamount").subtract(yetRepayAmt);
    }

    public static BigDecimal getPointRate(boolean isFloatRate, String rateSign, BigDecimal rateFloatpoint, BigDecimal calpointRate) {
        if (!isFloatRate) {
            return BigDecimal.ZERO;
        }
        if (EmptyUtil.isEmpty((BigDecimal)calpointRate) && EmptyUtil.isNoEmpty((BigDecimal)rateFloatpoint)) {
            calpointRate = rateFloatpoint.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
            if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                calpointRate = calpointRate.negate();
            }
        }
        return calpointRate;
    }

    public static BigDecimal getPointInt(BigDecimal totalRate, BigDecimal totalInt, BigDecimal afterCalPointRate) {
        if (EmptyUtil.isEmpty((BigDecimal)afterCalPointRate) || EmptyUtil.isEmpty((BigDecimal)totalRate)) {
            return BigDecimal.ZERO;
        }
        return totalInt.multiply(afterCalPointRate.divide(totalRate, 20, RoundingMode.HALF_UP));
    }

    public static List<IntBillExtInfo> calcLoanBillSegmInt(CalcInterestSegmRequest request) {
        return loanBillCalcIntService.calcLoanBillSegmInt(request);
    }

    public static Map<Long, List<IntBillExtInfo>> batchCalcLoanBillSegmInt(List<CalcInterestSegmRequest> requests) {
        return loanBillCalcIntService.batchCalcLoanBillSegmInt(requests);
    }
}

