/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.bean.ValidateBean;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.repository.IntBillBatchPreRepository;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestValidateHelper {
    public static Map<Long, List<ExtendedDataEntity>> valiRepeatSubmit(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, List<ExtendedDataEntity>> repeatMap = new HashMap<Long, List<ExtendedDataEntity>>();
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return repeatMap;
        }
        HashMap<Long, ExtendedDataEntity> exisMap = new HashMap<Long, ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long loanBillId = (Long)dataEntity.getDataEntity().get("sourcebillid");
            ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)exisMap.get(loanBillId);
            if (extendedDataEntity != null) {
                List values = repeatMap.computeIfAbsent(loanBillId, d -> new ArrayList(2));
                values.add(dataEntity);
                continue;
            }
            exisMap.put(loanBillId, dataEntity);
        }
        return repeatMap;
    }

    private static Map<Long, ValidateBean> validateOnWayInterestBill(Collection<Long> loanbillIds, AbstractBizResource bizResource) {
        HashMap<Long, ValidateBean> validateMap = new HashMap<Long, ValidateBean>(loanbillIds.size());
        DynamicObjectCollection interestBills = InterestBillRepository.getUnAuditIntBillByLoanBillIds(loanbillIds);
        Map<Long, List<DynamicObject>> interestBillMap = interestBills.stream().collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
        for (Map.Entry<Long, List<DynamicObject>> entry : interestBillMap.entrySet()) {
            Long loanBillId = entry.getKey();
            List<DynamicObject> interestBillList = entry.getValue();
            String billnos = interestBillList.stream().filter(d -> BillStatusEnum.isSubmit((String)d.getString("billstatus"))).map(d -> d.getString("billno")).collect(Collectors.joining(","));
            if (EmptyUtil.isNoEmpty((String)billnos)) {
                validateMap.put(loanBillId, new ValidateBean(String.format(bizResource.getIbSubmitOnlyoneValidator(), billnos)));
                continue;
            }
            billnos = interestBillList.stream().filter(d -> BillStatusEnum.isSave((String)d.getString("billstatus"))).map(d -> d.getString("billno")).collect(Collectors.joining(","));
            if (!EmptyUtil.isNoEmpty((String)billnos)) continue;
            validateMap.put(loanBillId, new ValidateBean("warn", String.format(bizResource.getIbSubmitHavesaveValidator(), billnos)));
        }
        return validateMap;
    }

    private static Map<Long, ValidateBean> validateOnSubmitLessBizDateRepayBill(Map<Long, Date> loanBillDateMap, AbstractBizResource bizResource) {
        HashMap<Long, ValidateBean> validateMap = new HashMap<Long, ValidateBean>(loanBillDateMap.size());
        Map<Long, List<DynamicObject>> repaymentBillMap = RepaymentBillRepository.getOnSubmitRepaymentBillByLoanIds(loanBillDateMap.keySet());
        for (Map.Entry<Long, List<DynamicObject>> entry : repaymentBillMap.entrySet()) {
            Long loanBillId = entry.getKey();
            List<DynamicObject> repaymentBills = entry.getValue();
            Date bizDate = loanBillDateMap.get(loanBillId);
            String billNos = repaymentBills.stream().filter(d -> d.getDate("bizdate").compareTo(bizDate) < 0).map(d -> d.getString("billno")).collect(Collectors.joining(","));
            if (!EmptyUtil.isNoEmpty((String)billNos)) continue;
            validateMap.put(loanBillId, new ValidateBean(String.format(bizResource.getIngSubmitRepayValidator(), billNos)));
        }
        return validateMap;
    }

    public static Map<Long, ValidateBean> validateOnSubmit(Map<Long, Date> loanBillDateMap, AbstractBizResource bizResource) {
        HashMap<Long, Date> loanBillMap = new HashMap<Long, Date>(loanBillDateMap.size());
        Map<Long, ValidateBean> validateBeanMap = InterestValidateHelper.validateOnWayInterestBill(loanBillDateMap.keySet(), bizResource);
        for (Map.Entry<Long, Date> entry : loanBillDateMap.entrySet()) {
            Long loanBillId = entry.getKey();
            if (validateBeanMap.containsKey(loanBillId) || !EmptyUtil.isNoEmpty((Object)entry.getValue())) continue;
            loanBillMap.put(loanBillId, entry.getValue());
        }
        validateBeanMap.putAll(InterestValidateHelper.validateOnSubmitLessBizDateRepayBill(loanBillMap, bizResource));
        return validateBeanMap;
    }

    private static Map<Long, ValidateBean> validateForOverseaEntFill(Map<Long, Date> loanBillDateMap, AbstractBizResource bizResource) {
        HashMap<Long, ValidateBean> validateBeanMap = new HashMap<Long, ValidateBean>(loanBillDateMap.size());
        QFilter qFilter = new QFilter("id", "in", loanBillDateMap.keySet()).and("isoverseaentfill", "=", (Object)Boolean.FALSE);
        Map<Long, DynamicObject> loanBillMap = LoanBillRepository.getLoanBillByFilter(qFilter, "endinstdate,startintdate,expiredate,isoverseaentfill");
        if (loanBillMap.isEmpty()) {
            return validateBeanMap;
        }
        for (Map.Entry<Long, Date> entry : loanBillDateMap.entrySet()) {
            Long loanBillId = entry.getKey();
            DynamicObject loanBill = loanBillMap.get(loanBillId);
            if (loanBill == null) continue;
            Date startinstdate = entry.getValue();
            Date endlastinstdate = loanBill.getDate("endinstdate");
            if (endlastinstdate == null) continue;
            String pageStartInstDateStr = DateUtils.formatString((Date)startinstdate, (String)"yyyyMMdd");
            String endinstDateStr = DateUtils.formatString((Date)endlastinstdate, (String)"yyyyMMdd");
            Date newStartInstDate = DateUtils.getNextDay((Date)endlastinstdate, (int)1);
            String newStartInstDateStr = DateUtils.formatString((Date)newStartInstDate, (String)"yyyyMMdd");
            List<String> newStartInstDateVals = Arrays.asList(endinstDateStr, newStartInstDateStr);
            if (newStartInstDateVals.contains(pageStartInstDateStr)) continue;
            validateBeanMap.put(loanBillId, new ValidateBean(bizResource.getIbSUmbitThisdatedifflastValidator()));
        }
        return validateBeanMap;
    }

    public static List<ValidateBean> validateOnSubmit(Date startinstdate, Long loanbillId, AbstractBizResource bizResource, Date bizDate) {
        Map<Long, Date> loanBillDateMap = Collections.singletonMap(loanbillId, bizDate);
        Map<Long, ValidateBean> validateBeanMap = InterestValidateHelper.validateOnSubmit(loanBillDateMap, bizResource);
        if (!validateBeanMap.containsKey(loanbillId) && startinstdate != null) {
            loanBillDateMap = Collections.singletonMap(loanbillId, startinstdate);
            validateBeanMap = InterestValidateHelper.validateForOverseaEntFill(loanBillDateMap, bizResource);
        }
        return new ArrayList<ValidateBean>(validateBeanMap.values());
    }

    public static Map<Long, ValidateBean> validateOnConfirm(List<DynamicObject> interestBills) {
        if (EmptyUtil.isEmpty(interestBills)) {
            return Collections.emptyMap();
        }
        HashMap<Long, ValidateBean> validateMap = new HashMap<Long, ValidateBean>(interestBills.size());
        Set loanBillIds = interestBills.stream().map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("sourcebillid", "in", loanBillIds).and("billstatus", "in", Arrays.asList(BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()));
        DynamicObjectCollection preIntBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"sourcebillid", (QFilter[])qFilter.toArray());
        Set sourceBillIds = preIntBills.stream().map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
        for (DynamicObject interestBill : interestBills) {
            if (!sourceBillIds.contains(interestBill.getLong("sourcebillid"))) continue;
            validateMap.put(interestBill.getLong("id"), new ValidateBean(BusinessHelper.getBizResource(interestBill).getIbExistNotauditPreinterest()));
        }
        return validateMap;
    }

    public static ValidateBean validateOnConfirm(DynamicObject interestEntity, Boolean isRepayment) {
        Map<Long, ValidateBean> validateBeanMap = InterestValidateHelper.validateOnConfirm(Collections.singletonList(interestEntity));
        return !validateBeanMap.isEmpty() ? validateBeanMap.get(interestEntity.getLong("id")) : null;
    }

    public static Map<Long, ValidateBean> validateOnUnAudit(List<DynamicObject> interestBills) {
        if (EmptyUtil.isEmpty(interestBills)) {
            return Collections.emptyMap();
        }
        HashMap<Long, ValidateBean> validateBeanMap = new HashMap<Long, ValidateBean>(10);
        if (EmptyUtil.isEmpty(interestBills = interestBills.stream().filter(d -> BillStatusEnum.isAudit((String)d.getString("billstatus"))).collect(Collectors.toList()))) {
            return validateBeanMap;
        }
        ArrayList<DynamicObject> outGroupBills = new ArrayList<DynamicObject>(interestBills.size());
        for (DynamicObject dynamicObject : interestBills) {
            boolean isPrePayint;
            long billId = dynamicObject.getLong("id");
            if (BusinessHelper.isOutGroup(dynamicObject)) {
                outGroupBills.add(dynamicObject);
                continue;
            }
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(dynamicObject.getString("creditortype")) || (isPrePayint = InterestbillctgEnum.isPrePayint((String)dynamicObject.getString("instbillctg"))) || ConfirmStatusEnum.isWaitconfirm(dynamicObject.getString("confirmstatus"))) continue;
            validateBeanMap.put(billId, new ValidateBean(BusinessHelper.getBizResource(dynamicObject).getUnauditConfirmStatus()));
        }
        if (!outGroupBills.isEmpty()) {
            validateBeanMap.putAll(InterestValidateHelper.validateOutGroupInterestBill(outGroupBills));
        }
        return validateBeanMap;
    }

    private static Map<Long, ValidateBean> validateOutGroupInterestBill(List<DynamicObject> interestBills) {
        Map<Long, ValidateBean> validateBeanMap = InterestValidateHelper.validateHasTargetBill(interestBills);
        List<DynamicObject> interestBillList = interestBills.stream().filter(d -> !validateBeanMap.containsKey(d.getLong("id"))).collect(Collectors.toList());
        validateBeanMap.putAll(InterestValidateHelper.verifyIsLastInterest(interestBillList));
        return validateBeanMap;
    }

    private static Map<Long, ValidateBean> validateHasTargetBill(List<DynamicObject> interestBills) {
        HashMap<Long, ValidateBean> validateBeanMap = new HashMap<Long, ValidateBean>(10);
        if (EmptyUtil.isEmpty(interestBills)) {
            return validateBeanMap;
        }
        List<Long> billIds = interestBills.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        Map<String, QFilter> filterMap = Collections.singletonMap(CfmEntityEnum.CAS_PAYBILL.getValue(), new QFilter("billstatus", "not in", Arrays.asList("G", "F")));
        String entityName = interestBills.get(0).getDataEntityType().getName();
        Map<Long, String> checkResultMap = BusinessHelper.checkTargetBills(entityName, billIds, null, filterMap);
        for (DynamicObject interestBill : interestBills) {
            long billId = interestBill.getLong("id");
            String error = checkResultMap.get(billId);
            if (!EmptyUtil.isNoEmpty((String)error)) continue;
            validateBeanMap.put(billId, new ValidateBean(error));
        }
        return validateBeanMap;
    }

    private static Map<Long, ValidateBean> verifyIsLastInterest(List<DynamicObject> interestBills) {
        HashMap<Long, ValidateBean> validateBeanMap = new HashMap<Long, ValidateBean>(10);
        if ((interestBills = interestBills.stream().filter(d -> !InterestValidateHelper.isOverseaEntfill(d)).collect(Collectors.toList())).isEmpty()) {
            return validateBeanMap;
        }
        List sourceBillIds = interestBills.stream().map(d -> d.getLong("sourcebillid")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("sourcebillid", "in", sourceBillIds);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection interestBillColl = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id,sourcebillid,creditortype,datasource,confirmstatus,auditdate", (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> sourceBillMap = interestBillColl.stream().collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
        for (DynamicObject dynamicObject : interestBills) {
            long interestBillId = dynamicObject.getLong("id");
            long sourceBillId = dynamicObject.getLong("sourcebillid");
            List<Object> intBills = sourceBillMap.get(sourceBillId);
            if (!CreditorTypeEnum.SETTLECENTER.getValue().equals(dynamicObject.getString("creditortype"))) {
                intBills = intBills.stream().filter(d -> ConfirmStatusEnum.isYetconfirm(d.getString("confirmstatus"))).collect(Collectors.toList());
            }
            intBills.sort(Comparator.comparing(d -> d.getDate("auditdate"), Comparator.reverseOrder()));
            if (intBills.isEmpty() || ((DynamicObject)intBills.get(0)).getLong("id") == interestBillId) continue;
            validateBeanMap.put(interestBillId, new ValidateBean(BusinessHelper.getBizResource(dynamicObject).getIbUnauditChecklast()));
        }
        return validateBeanMap;
    }

    private static boolean isOverseaEntfill(DynamicObject interestBill) {
        return interestBill.containsProperty("isoverseaentfill") && interestBill.getBoolean("isoverseaentfill");
    }

    public static List<ValidateBean> validateOnUnAudit(DynamicObject interestEntity, OperateOption option) {
        Map<Long, ValidateBean> validateBeanMap = InterestValidateHelper.validateOnUnAudit(Collections.singletonList(interestEntity));
        return new ArrayList<ValidateBean>(validateBeanMap.values());
    }

    public static Map<Long, ValidateBean> validateOnUnConfirm(List<DynamicObject> interestBills, Boolean isRepayment) {
        HashMap<Long, ValidateBean> validateBeanMap = new HashMap<Long, ValidateBean>(10);
        ArrayList<DynamicObject> interestBillList = new ArrayList(interestBills.size());
        for (DynamicObject interestBill : interestBills) {
            long interestBillId = interestBill.getLong("id");
            if (!CreditorTypeEnum.SETTLECENTER.getValue().equals(interestBill.getString("creditortype"))) {
                if (BusinessHelper.isOutGroup(interestBill)) {
                    validateBeanMap.put(interestBillId, new ValidateBean(InterestValidateHelper.getBizResource(interestBill).getUnConfirmOutGroupData()));
                    continue;
                }
                String entityName = interestBill.getDataEntityType().getName();
                if (BusinessHelper.isSameSource(entityName, interestBill.getString("datasource")) && !isRepayment.booleanValue()) {
                    validateBeanMap.put(interestBillId, new ValidateBean(InterestValidateHelper.getBizResource(interestBill).getUnConfirmSameSourceData()));
                    continue;
                }
            }
            if (!ConfirmStatusEnum.isYetconfirm(interestBill.getString("confirmstatus"))) {
                validateBeanMap.put(interestBillId, new ValidateBean(InterestValidateHelper.getBizResource(interestBill).getConfirmStatusError()));
                continue;
            }
            interestBillList.add(interestBill);
        }
        if (!interestBillList.isEmpty()) {
            List<DynamicObject> intBills = interestBillList.stream().filter(InterestValidateHelper::isNotSettleCenter).collect(Collectors.toList());
            validateBeanMap.putAll(InterestValidateHelper.validateHasTargetBill(intBills));
        }
        interestBillList = interestBillList.stream().filter(d -> !validateBeanMap.containsKey(d.getLong("id"))).collect(Collectors.toList());
        validateBeanMap.putAll(InterestValidateHelper.verifyIsLastInterest(interestBillList));
        return validateBeanMap;
    }

    private static boolean isNotSettleCenter(DynamicObject interestBill) {
        return !CreditorTypeEnum.SETTLECENTER.getValue().equals(interestBill.getString("creditortype")) || !DataSourceEnum.isCfm(interestBill.getString("datasource"));
    }

    public static ValidateBean validateOnUnConfirm(DynamicObject interestEntity, Boolean isRepayment) {
        Map<Long, ValidateBean> validateBeanMap = InterestValidateHelper.validateOnUnConfirm(Collections.singletonList(interestEntity), isRepayment);
        return !validateBeanMap.isEmpty() ? validateBeanMap.values().iterator().next() : null;
    }

    public static Map<Long, List<ValidateBean>> batchValidateOnSaveBill(ExtendedDataEntity[] dataEntities) {
        List<ExtendedDataEntity> dataEntitys = Arrays.stream(dataEntities).filter(d -> BillStatusEnum.isSave((String)d.getDataEntity().getString("billstatus"))).collect(Collectors.toList());
        HashMap<Long, List<ValidateBean>> validateMap = new HashMap<Long, List<ValidateBean>>(dataEntitys.size());
        if (!dataEntitys.isEmpty()) {
            Map<Long, List<ExtendedDataEntity>> repeatLoanMap = InterestValidateHelper.valiRepeatSubmit(dataEntitys.toArray(new ExtendedDataEntity[0]));
            Set<Long> loanBillIds = dataEntitys.stream().map(d -> d.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
            Map<Long, DynamicObject> loanBillMap = LoanBillRepository.getLoanBillByIds(loanBillIds, "id,lastpayinstdate,settleintmode,endinstdate,startintdate,expiredate,isoverseaentfill");
            for (ExtendedDataEntity dataEntity : dataEntitys) {
                DynamicObject loanBill = loanBillMap.get(dataEntity.getDataEntity().getLong("sourcebillid"));
                List<ValidateBean> validateBeans = InterestValidateHelper.validateOnSaveBill(repeatLoanMap, dataEntity.getDataEntity(), loanBill);
                validateMap.put(dataEntity.getDataEntity().getLong("id"), validateBeans);
            }
        }
        return validateMap;
    }

    private static List<ValidateBean> validateOnSaveBill(Map<Long, List<ExtendedDataEntity>> repeatLoanMap, DynamicObject interestEntity, DynamicObject loanBill) {
        ArrayList<ValidateBean> validateResults = new ArrayList<ValidateBean>(4);
        Date startinstdate = interestEntity.getDate("startinstdate");
        Long loanBillId = interestEntity.getLong("sourcebillid");
        validateResults.addAll(InterestValidateHelper.validateOnSave(interestEntity, loanBill));
        if (!validateResults.isEmpty()) {
            return validateResults;
        }
        if (repeatLoanMap.containsKey(loanBillId)) {
            validateResults.add(new ValidateBean(InterestValidateHelper.getBizResource(interestEntity).getPbRepeatloanbillSumbit()));
            return validateResults;
        }
        validateResults.addAll(InterestValidateHelper.validateOnSubmit(startinstdate, loanBillId, InterestValidateHelper.getBizResource(interestEntity), interestEntity.getDate("bizdate")));
        return validateResults;
    }

    private static AbstractBizResource getBizResource(DynamicObject interestEntity) {
        return new BizResourceFactory().getBizResource(interestEntity.getString("datasource"));
    }

    public static List<ValidateBean> validateOnSave(DynamicObject interestEntity, DynamicObject loanBill) {
        long loanbillId = interestEntity.getLong("sourcebillid");
        String dataSource = interestEntity.getString("datasource");
        Date bizdate = interestEntity.getDate("bizdate");
        Date loandate = interestEntity.getDate("loandate");
        Date startinstdate = interestEntity.getDate("startinstdate");
        Date endinstdate = interestEntity.getDate("endinstdate");
        DynamicObject instbankacct = interestEntity.getDynamicObject("instbankacct");
        DynamicObject loanBankacct = interestEntity.getDynamicObject("loaneracctbank");
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
        ArrayList<ValidateBean> results = new ArrayList<ValidateBean>();
        if (EmptyUtil.isEmpty((Long)loanbillId) && loanbillId == 0L) {
            results.add(new ValidateBean(bizResource.getIbMustChooseloanno()));
            return results;
        }
        if (bizdate == null) {
            results.add(new ValidateBean(bizResource.getIbMustChooseBizDate()));
            return results;
        }
        boolean overseaEntFill = interestEntity.getBoolean("isoverseaentfill");
        if (DataSourceEnum.INVEST.getValue().equals(dataSource) && EmptyUtil.isEmpty((DynamicObject)loanBankacct)) {
            results.add(new ValidateBean(bizResource.getIbMustinputLoanBankacct()));
        } else if (!DataSourceEnum.INVEST.getValue().equals(dataSource) && EmptyUtil.isEmpty((DynamicObject)instbankacct)) {
            results.add(new ValidateBean(bizResource.getIbMustinputBankacct()));
        }
        Date lastpayinstdate = loanBill.getDate("lastpayinstdate");
        if (EmptyUtil.isNoEmpty((Object)lastpayinstdate) && bizdate.compareTo(lastpayinstdate) < 0 && !overseaEntFill) {
            results.add(new ValidateBean(String.format(bizResource.getIbSaveBizdatecompValidator(), DateUtils.formatString((Date)lastpayinstdate, (String)"yyyy-MM-dd"))));
        }
        if (bizdate.compareTo(loandate) <= 0 && !LoanBillHelper.isYkx(loanBill)) {
            results.add(new ValidateBean(bizResource.getIbSavePaydateecompValidator()));
        }
        if (endinstdate != null && startinstdate != null && endinstdate.compareTo(startinstdate) < 0) {
            results.add(new ValidateBean(bizResource.getIbSaveEndmorestartValidator()));
        }
        return results;
    }

    public static Map<Long, Boolean> checkPayCorAndInt(List<DynamicObject> interestBills) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(interestBills.size());
        interestBills.forEach(d -> map.put(d.getLong("id"), Boolean.TRUE));
        List interestBillList = interestBills.stream().filter(InterestValidateHelper::isPayprinandinte).collect(Collectors.toList());
        if (interestBillList.isEmpty()) {
            return map;
        }
        Map<Long, List<DynamicObject>> repayBillIdGroupMap = interestBillList.stream().collect(Collectors.groupingBy(d -> d.getLong("repaymentid")));
        Set loanBillIds = interestBillList.stream().map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", repayBillIdGroupMap.keySet()).and("loans.e_loanbill", "in", loanBillIds).and("loans.e_combineinst", "=", (Object)Boolean.TRUE);
        List repaymentBillIds = QueryServiceHelper.queryPrimaryKeys((String)"cfm_repaymentbill", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (EmptyUtil.isEmpty((Collection)repaymentBillIds)) {
            return map;
        }
        String repayBillEntity = CfmBillCommonHelper.getRepaymentBillEntityByIntBill(interestBills.get(0).getDataEntityType().getName());
        HashSet<String> includeTargetEntitys = new HashSet<String>(2);
        includeTargetEntitys.add("cas_paybill");
        includeTargetEntitys.add("ifm_transhandlebill");
        Map<String, QFilter> filterMap = Collections.singletonMap("cas_paybill", new QFilter("billstatus", "not in", Arrays.asList("G", "F")));
        List billIds = repaymentBillIds.stream().map(d -> (Long)d).collect(Collectors.toList());
        Map targetBillNoMap = TmcBotpHelper.getTargetBillNoMap((String)repayBillEntity, billIds, null, includeTargetEntitys, filterMap);
        ArrayList<Object> checkVoucherRepayIds = new ArrayList<Object>(repayBillIdGroupMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : repayBillIdGroupMap.entrySet()) {
            if (targetBillNoMap.containsKey(entry.getKey())) {
                entry.getValue().forEach(d -> map.put(d.getLong("id"), Boolean.FALSE));
                continue;
            }
            checkVoucherRepayIds.add(entry.getKey());
        }
        if (!checkVoucherRepayIds.isEmpty()) {
            List<String> paymentBills = Arrays.asList("ifm_repaymentbill", "cfm_repaymentbill", "cim_invest_repaybill");
            Set<Long> voucherList = CfmBillCommonHelper.getVoucherList(paymentBills, checkVoucherRepayIds);
            for (Map.Entry<Long, List<DynamicObject>> entry : repayBillIdGroupMap.entrySet()) {
                if (!voucherList.contains(entry.getKey())) continue;
                entry.getValue().forEach(d -> map.put(d.getLong("id"), Boolean.FALSE));
            }
        }
        return map;
    }

    private static boolean isPayprinandinte(DynamicObject interestBill) {
        return EmptyUtil.isNoEmpty((Object)interestBill.get("repaymentid")) && EmptyUtil.isNoEmpty((Object)interestBill.get("sourcebillid")) || InterestbillctgEnum.isPayprinandinte((String)interestBill.getString("instbillctg"));
    }

    public static boolean checkPayCorAndInt(ExtendedDataEntity dataEntity) {
        return InterestValidateHelper.checkPayCorAndInt(Collections.singletonList(dataEntity.getDataEntity())).values().iterator().next();
    }

    public static List<ValidateBean> preIntValidate(Date startinstdate, Date endinstdate, Long loanbillId, boolean autoRedWriteOff, Long preintpk, String loanbillno, AbstractBizResource bizResource) {
        QFilter loanbillnoFilter;
        ArrayList<ValidateBean> results = new ArrayList<ValidateBean>();
        QFilter idFilter = new QFilter("id", "!=", (Object)preintpk);
        QFilter submitStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection submitInterestBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"billstatus", (QFilter[])new QFilter[]{idFilter, submitStatusFilter, loanbillnoFilter = new QFilter("sourcebillid", "=", (Object)loanbillId)});
        if (submitInterestBills.size() >= 1) {
            results.add(new ValidateBean(bizResource.getPIbSubmitOnlyoneValidator()));
            return results;
        }
        if (EmptyUtil.isNoEmpty((Object)startinstdate) && !autoRedWriteOff) {
            QFilter qfilter = new QFilter("loanbillno", "=", (Object)loanbillno);
            qfilter.and(new QFilter("writeoffstatus", "in", Arrays.asList("no_writeoff", "part_writeoff")));
            QFilter dateQFilter = new QFilter("prestartdate", "<", (Object)startinstdate).and("bizdate", ">", (Object)startinstdate).or(new QFilter("prestartdate", "=", (Object)startinstdate)).or(new QFilter("prestartdate", ">", (Object)startinstdate).and("prestartdate", "<=", (Object)endinstdate));
            DynamicObjectCollection preInstIngInfos = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"id", (QFilter[])new QFilter[]{idFilter, qfilter, dateQFilter});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)preInstIngInfos)) {
                results.add(new ValidateBean(ResManager.loadKDString((String)"\u9884\u63d0\u5355\u8d77\u606f\u65e5\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u5728\u5355\u636e\u9875\u9762\u786e\u8ba4\u540e\u63d0\u4ea4\u3002", (String)"CfmNewBizResource_111", (String)"tmc-cfm-common", (Object[])new Object[0])));
            }
        }
        return results;
    }

    public static String getFieldName(String dataSource) {
        String name = ResManager.loadKDString((String)"\u6298\u63d0\u6b3e\u5e01\u79cd\u5229\u606f\u91d1\u989d", (String)"InterestValidateHelper_1", (String)"tmc-cfm-common", (Object[])new Object[0]);
        if (DataSourceEnum.isInvest(dataSource) || DataSourceEnum.isIfm(dataSource)) {
            name = ResManager.loadKDString((String)"\u6298\u8d37\u6b3e\u5e01\u79cd\u5229\u606f\u91d1\u989d", (String)"InterestValidateHelper_2", (String)"tmc-cfm-common", (Object[])new Object[0]);
        } else if (DataSourceEnum.isBond(dataSource)) {
            name = ResManager.loadKDString((String)"\u6298\u53d1\u884c\u5e01\u79cd\u5229\u606f\u91d1\u989d", (String)"InterestValidateHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]);
        }
        return name;
    }

    public static String getPayIntName(String dataSource) {
        if (DataSourceEnum.isInvest(dataSource) || DataSourceEnum.isIfm(dataSource)) {
            return ResManager.loadKDString((String)"\u5b9e\u6536\u5229\u606f", (String)"InterestValidateHelper_4", (String)"tmc-cfm-common", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5b9e\u4ed8\u5229\u606f", (String)"InterestValidateHelper_5", (String)"tmc-cfm-common", (Object[])new Object[0]);
    }

    public static Map<Long, String> validIngInterest(List<DynamicObject> repayBills) {
        HashMap<Long, String> validateMap = new HashMap<Long, String>(repayBills.size());
        ArrayList<DynamicObject> repayBillList = new ArrayList<DynamicObject>(repayBills.size());
        Map<Long, List<String>> batchIntBillNoMap = InterestValidateHelper.getSubmitLargeBizDateBatchIntBillNo(InterestValidateHelper.getLoanBillRepayDateMap(repayBills));
        for (DynamicObject repayBill : repayBills) {
            boolean isBreak = false;
            for (DynamicObject loanEntry : repayBill.getDynamicObjectCollection("loans")) {
                List<String> batchIntNos = batchIntBillNoMap.get(loanEntry.getLong("e_loanbill.id"));
                if (!EmptyUtil.isNoEmpty(batchIntNos)) continue;
                AbstractBizResource bizResource = new BizResourceFactory().getBizResource(repayBill.getString("datasource"));
                validateMap.put(repayBill.getLong("id"), String.format(bizResource.getIngBatchInterstBill(), String.join((CharSequence)",", batchIntNos)));
                isBreak = true;
                break;
            }
            if (isBreak) continue;
            repayBillList.add(repayBill);
        }
        Map<Long, List<String>> intBillBillNoMap = InterestValidateHelper.getSubmitLargeBizDateIntBillBillNo(InterestValidateHelper.getLoanBillRepayDateMap(repayBillList));
        for (DynamicObject repayBill : repayBillList) {
            long repayBillId = repayBill.getLong("id");
            for (DynamicObject loanEntry : repayBill.getDynamicObjectCollection("loans")) {
                List<String> intBillNos = intBillBillNoMap.get(loanEntry.getLong("e_loanbill.id"));
                if (!EmptyUtil.isNoEmpty(intBillNos)) continue;
                AbstractBizResource bizResource = new BizResourceFactory().getBizResource(repayBill.getString("datasource"));
                validateMap.put(repayBillId, String.format(bizResource.getIngInterstBill(), String.join((CharSequence)",", intBillNos)));
            }
        }
        return validateMap;
    }

    private static Map<Long, Date> getLoanBillRepayDateMap(List<DynamicObject> repayBills) {
        HashMap<Long, Date> loanBillRepayDateMap = new HashMap<Long, Date>(10);
        for (DynamicObject repayBill : repayBills) {
            List<Long> loanBillIds = repayBill.getDynamicObjectCollection("loans").stream().map(d -> d.getLong("e_loanbill.id")).collect(Collectors.toList());
            loanBillIds.forEach(d -> loanBillRepayDateMap.put((Long)d, repayBill.getDate("bizdate")));
        }
        return loanBillRepayDateMap;
    }

    private static Map<Long, List<String>> getSubmitLargeBizDateIntBillBillNo(Map<Long, Date> loanBillRepayDateMap) {
        HashMap<Long, List<String>> map = new HashMap<Long, List<String>>(1);
        DynamicObjectCollection intBillColls = InterestBillRepository.getSubmitIntBillByLoanBillIds(loanBillRepayDateMap.keySet());
        Map<Long, List<DynamicObject>> intBillMap = intBillColls.stream().collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
        for (Map.Entry<Long, Date> entry : loanBillRepayDateMap.entrySet()) {
            Long loanBillId = entry.getKey();
            List<DynamicObject> intBills = intBillMap.get(loanBillId);
            if (!EmptyUtil.isNoEmpty(intBills)) continue;
            Date repayDate = DateUtils.getDataFormat((Date)entry.getValue(), (boolean)false);
            List billnos = intBills.stream().filter(d -> d.getDate("bizdate").compareTo(repayDate) > 0).map(d -> d.getString("billno")).collect(Collectors.toList());
            map.put(loanBillId, billnos);
        }
        return map;
    }

    private static Map<Long, List<String>> getSubmitLargeBizDateBatchIntBillNo(Map<Long, Date> loanBillRepayDateMap) {
        HashMap<Long, List<String>> map = new HashMap<Long, List<String>>(1);
        if (EmptyUtil.isEmpty(loanBillRepayDateMap)) {
            return map;
        }
        DynamicObjectCollection batchIntColls = IntBillBatchPreRepository.getSubmitBatchIntBillsByLoanBillIds(loanBillRepayDateMap.keySet());
        Map<Long, List<DynamicObject>> batchIntMap = batchIntColls.stream().collect(Collectors.groupingBy(d -> d.getLong("entry.loanbillid")));
        for (Map.Entry<Long, Date> entry : loanBillRepayDateMap.entrySet()) {
            Long loanBillId = entry.getKey();
            List<DynamicObject> batchInts = batchIntMap.get(loanBillId);
            if (!EmptyUtil.isNoEmpty(batchInts)) continue;
            Date repayDate = DateUtils.getDataFormat((Date)entry.getValue(), (boolean)false);
            List billnos = batchInts.stream().filter(d -> d.getDate("bizdate").compareTo(repayDate) > 0).map(d -> d.getString("billno")).collect(Collectors.toList());
            map.put(loanBillId, billnos);
        }
        return map;
    }
}

