/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.common.resource.CfmCommonResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PushPayBillVerifyHelper {
    public static String verifyRepaymentBill(DynamicObject bill, boolean isVerifyStatus, boolean isVerifyCanPayAmt) {
        if (isVerifyStatus) {
            if (!BillStatusEnum.isAudit((String)bill.getString("billstatus"))) {
                return CfmCommonResourceEnum.Push2PayValidator_2.loadKDString();
            }
            if (!ConfirmStatusEnum.isYetconfirm(bill.getString("confirmstatus"))) {
                return CfmCommonResourceEnum.Push2PayValidator_3.loadKDString();
            }
        }
        if (!bill.getBoolean("isrelcash")) {
            return CfmCommonResourceEnum.Push2PayValidator_0.loadKDString();
        }
        if (bill.getBoolean("isinit")) {
            return CfmCommonResourceEnum.Push2PayValidator_1.loadKDString();
        }
        if (EmptyUtil.isNoEmpty((String)bill.getString("eassrcid"))) {
            return CfmCommonResourceEnum.Push2PayValidator_5.loadKDString();
        }
        if (bill.getBoolean("issuretyrepay") && EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("needpayamt"))) {
            return CfmCommonResourceEnum.Push2PayValidator_6.loadKDString(bill.getString("billno"));
        }
        if (isVerifyCanPayAmt) {
            BigDecimal lockPayAmt = RepaymentbillHelper.getAllPayBillAmt(bill, null);
            if (bill.getBigDecimal("needpayamt").subtract(lockPayAmt).compareTo(BigDecimal.ZERO) <= 0) {
                return CfmCommonResourceEnum.Push2PayValidator_7.loadKDString(bill.getString("billno"));
            }
        }
        return null;
    }

    public static String verifyCimInvestLoanBill(DynamicObject bill, boolean isVerifyStatus, boolean isVerifyCanPayAmt) {
        if (isVerifyStatus) {
            if (!BillStatusEnum.isAudit((String)bill.getString("billstatus"))) {
                return CfmCommonResourceEnum.Push2PayValidator_2.loadKDString();
            }
            if (!ConfirmStatusEnum.isYetconfirm(bill.getString("confirmstatus"))) {
                return CfmCommonResourceEnum.Push2PayValidator_3.loadKDString();
            }
        }
        if (!bill.getBoolean("isrelcash")) {
            return CfmCommonResourceEnum.Push2PayValidator_0.loadKDString();
        }
        if (bill.getBoolean("isinit")) {
            return CfmCommonResourceEnum.Push2PayValidator_1.loadKDString();
        }
        if (EmptyUtil.isNoEmpty((String)bill.getString("eassrcid"))) {
            return CfmCommonResourceEnum.Push2PayValidator_5.loadKDString();
        }
        if (!DrawTypeEnum.isDrawed(bill.getString("drawtype"))) {
            return CfmCommonResourceEnum.LoanPush2PayValidator_1.loadKDString();
        }
        if (isVerifyCanPayAmt) {
            BigDecimal lockPayAmt = RepaymentbillHelper.getAllPayBillAmt(bill, null);
            BigDecimal drawAmount = PushPayBillVerifyHelper.getLoanBillCanPayAmount(bill);
            if (drawAmount.subtract(lockPayAmt).compareTo(BigDecimal.ZERO) <= 0) {
                return CfmCommonResourceEnum.Push2PayValidator_7.loadKDString(bill.getString("billno"));
            }
        }
        return null;
    }

    public static BigDecimal getLoanBillCanPayAmount(DynamicObject sourceBill) {
        if (SettleIntModeEnum.isYkx((String)sourceBill.getString("settleintmode"))) {
            BigDecimal payedIntAmount = sourceBill.getBigDecimal("payedintamount");
            if (EmptyUtil.isEmpty((BigDecimal)payedIntAmount)) {
                QFilter instFilter = new QFilter("sourcebillid", "in", (Object)sourceBill.getLong("id")).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("instbillctg", "=", (Object)InterestbillctgEnum.PREPAYINT.getValue());
                DynamicObjectCollection instBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id,actualinstamt", (QFilter[])instFilter.toArray());
                payedIntAmount = instBills.stream().map(o -> o.getBigDecimal("actualinstamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            return sourceBill.getBigDecimal("drawamount").subtract(payedIntAmount);
        }
        return sourceBill.getBigDecimal("drawamount");
    }

    public static String verifyInterestBill(DynamicObject bill, boolean isVerifyStatus, boolean isVerifyCanPayAmt) {
        if (isVerifyStatus) {
            if (!BillStatusEnum.isAudit((String)bill.getString("billstatus"))) {
                return CfmCommonResourceEnum.Push2PayValidator_2.loadKDString();
            }
            if (!ConfirmStatusEnum.isYetconfirm(bill.getString("confirmstatus"))) {
                return CfmCommonResourceEnum.Push2PayValidator_3.loadKDString();
            }
        }
        if (!bill.getBoolean("isrelcash")) {
            return CfmCommonResourceEnum.Push2PayValidator_0.loadKDString();
        }
        if (bill.getBoolean("isinit")) {
            return CfmCommonResourceEnum.Push2PayValidator_1.loadKDString();
        }
        if (bill.getBoolean("combineinst")) {
            return CfmCommonResourceEnum.InterestBillPush2PayValidator_2.loadKDString();
        }
        if (EmptyUtil.isNoEmpty((String)bill.getString("eassrcid"))) {
            return CfmCommonResourceEnum.Push2PayValidator_5.loadKDString();
        }
        if (LoanBillHelper.isPrePayint(bill.getString("instbillctg"))) {
            return CfmCommonResourceEnum.InterestBillPush2PayValidator_1.loadKDString();
        }
        if (isVerifyCanPayAmt) {
            BigDecimal lockPayAmt = RepaymentbillHelper.getAllPayBillAmt(bill, null);
            if (bill.getBigDecimal("actualinstamt").subtract(lockPayAmt).compareTo(BigDecimal.ZERO) <= 0) {
                return CfmCommonResourceEnum.Push2PayValidator_7.loadKDString(bill.getString("billno"));
            }
        }
        return null;
    }
}

