/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.bean.FloatRateCalBean;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.cfm.common.repository.RateAdjustBillRepository;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateAdjustHelper {
    public static boolean validateLoanBillHasInDoingInt(DynamicObject adjustBill) {
        List<String> loanBillNoList = RateAdjustHelper.getLoanBillNoList(adjustBill);
        return RateAdjustHelper.validateLoanBillHasInDoingInt(loanBillNoList);
    }

    public static boolean validateLoanBillHasInDoingInt(List<String> loanBillNoList) {
        if (Objects.isNull(loanBillNoList) || loanBillNoList.size() == 0) {
            return false;
        }
        QFilter loanBillNoFilter = new QFilter("loanbillno", "in", loanBillNoList);
        QFilter confirmStatusFilter = new QFilter("confirmstatus", "in", (Object)new String[]{ConfirmStatusEnum.REGISTRYING.getValue(), ConfirmStatusEnum.WAITCONFIRM.getValue()});
        boolean singleFlag = TmcDataServiceHelper.exists((String)"cfm_interestbill", (QFilter[])new QFilter[]{loanBillNoFilter, confirmStatusFilter});
        QFilter batLoanBillFilter = new QFilter("entry.loanbillno", "in", loanBillNoList);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        boolean batchFlag = TmcDataServiceHelper.exists((String)"cfm_intbill_batch_loan", (QFilter[])new QFilter[]{batLoanBillFilter, statusFilter});
        return singleFlag || batchFlag;
    }

    public static List<String> getLoanBillNoList(DynamicObject adjustBill) {
        DynamicObjectCollection rows = adjustBill.getDynamicObjectCollection("entry");
        List<String> loanBillNoList = rows.stream().filter(r -> r.getBoolean("lisadjust")).map(r -> r.getDynamicObject("ldrawbill").getString("number")).collect(Collectors.toList());
        return loanBillNoList;
    }

    public static boolean isCannotOpRateAdjust(String dataSource, String rateAdjustFormId) {
        if (DataSourceEnum.CFM.getValue().equals(dataSource) && "cim_rateadjustbill".equals(rateAdjustFormId)) {
            return true;
        }
        if (DataSourceEnum.INVEST.getValue().equals(dataSource) && "cfm_rateadjustbill_e_l".equals(rateAdjustFormId)) {
            return true;
        }
        return DataSourceEnum.IFM.getValue().equals(dataSource) && "cfm_rateadjustbill".equals(rateAdjustFormId);
    }

    public static boolean validateLoanBillHasInDoingRepay(DynamicObject adjustBill) {
        List<Long> loanBillIdList = RateAdjustHelper.getLoanBillIdList(adjustBill);
        if (Objects.isNull(loanBillIdList) || loanBillIdList.size() == 0) {
            return false;
        }
        QFilter loanBillFilter = new QFilter("loans.e_loanbill", "in", loanBillIdList);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        return TmcDataServiceHelper.exists((String)"cfm_repaymentbill", (QFilter[])new QFilter[]{loanBillFilter, statusFilter});
    }

    public static DynamicObjectCollection validateOnWayApply(DynamicObject adjustBill) {
        List<Long> loanBillIdList = RateAdjustHelper.getLoanBillIdList(adjustBill);
        if (Objects.isNull(loanBillIdList) || loanBillIdList.size() == 0) {
            return null;
        }
        DynamicObjectCollection onWayApplys = QueryServiceHelper.query((String)"cfm_apply_loanbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("loanbill", "in", loanBillIdList).and(new QFilter("bizstatus", "!=", (Object)ApplyBusinessStatusEnum.HANDED.getValue()).or(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())))});
        return onWayApplys;
    }

    public static List<Long> getLoanBillIdList(DynamicObject adjustBill) {
        DynamicObjectCollection rows = adjustBill.getDynamicObjectCollection("entry");
        List<Long> loanBillNoList = rows.stream().filter(r -> r.getBoolean("lisadjust")).map(r -> r.getDynamicObject("ldrawbill").getLong("id")).collect(Collectors.toList());
        return loanBillNoList;
    }

    public static BigDecimal getRateFloat(FloatRateCalBean floatRateSegBean) {
        String rateSign = floatRateSegBean.getRateSign();
        BigDecimal rateFloatPoint = floatRateSegBean.getRateBasePoint();
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
        if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
            rateFloat = rateFloat.negate();
        }
        return rateFloat;
    }

    public static DynamicObject getRateChangeAdjustBills(DynamicObject loanBill) {
        long contractId = loanBill.getLong("loancontractbill.id");
        return RateAdjustBillRepository.getRateAdjustBillByContractIds(Collections.singletonList(contractId)).get(contractId);
    }

    public static void updateRateAdjustList(DynamicObject loanBill) {
        String interestType = loanBill.getString("interesttype");
        if (InterestTypeEnum.isFixed((String)interestType) || InterestTypeEnum.isAgree((String)interestType)) {
            DynamicObjectCollection rateAdjustEntry = loanBill.getDynamicObjectCollection("rateadjust_entry");
            rateAdjustEntry.clear();
            DynamicObjectCollection intPlans = loanBill.getDynamicObjectCollection("interest_entry");
            intPlans.clear();
        }
    }

    public static DynamicObjectCollection getRateAdjustEntry(DynamicObjectCollection rateAdjustEntry, Date adjustEffectDate, int seq) {
        DynamicObjectCollection newRateAdjustEntry = TmcDataServiceHelper.newDynamicObject((String)"cfm_loanbill").getDynamicObjectCollection("rateadjust_entry");
        for (DynamicObject rateAdjust : rateAdjustEntry) {
            boolean isRetain = rateAdjust.getDate("ra_effectdate").compareTo(adjustEffectDate) < 0;
            if (!isRetain) continue;
            newRateAdjustEntry.add((Object)rateAdjust);
            ++seq;
        }
        rateAdjustEntry.clear();
        for (DynamicObject rateAdjust : newRateAdjustEntry) {
            rateAdjustEntry.add((Object)rateAdjust);
        }
        return rateAdjustEntry;
    }

    public static DynamicObjectCollection getRateAdjustEntry(DynamicObjectCollection rateAdjustEntry, List<FloatRateCalBean> floatRateBizSegmBeans, Date adjustEffectDate, Date lastAdjustDate, boolean isFromSch) {
        if (EmptyUtil.isNoEmpty(floatRateBizSegmBeans)) {
            for (FloatRateCalBean floatRateSegBean : floatRateBizSegmBeans) {
                Date startDate = floatRateSegBean.getStartDate();
                Date endDate = floatRateSegBean.getEndDate();
                for (DynamicObject rateAdjust : rateAdjustEntry) {
                    boolean isUpdateRate2;
                    Date effectDate = rateAdjust.getDate("ra_effectdate");
                    boolean isInPeriod = effectDate.compareTo(startDate) >= 0 && effectDate.compareTo(endDate) < 0;
                    boolean isUpdateRate = isFromSch && isInPeriod && (EmptyUtil.isEmpty((Object)adjustEffectDate) || effectDate.compareTo(adjustEffectDate) >= 0);
                    boolean bl = isUpdateRate2 = !(isFromSch || !isInPeriod || !EmptyUtil.isEmpty((Object)adjustEffectDate) && effectDate.compareTo(adjustEffectDate) < 0 || !EmptyUtil.isEmpty((Object)lastAdjustDate) && effectDate.compareTo(lastAdjustDate) >= 0);
                    if (!isUpdateRate && !isUpdateRate2) continue;
                    Date confirmDate = rateAdjust.getDate("ra_confirmdate");
                    BigDecimal referRate = MarketDataServiceHelper.referRate((String)floatRateSegBean.getRefrateNum(), (Date)confirmDate, (boolean)false);
                    BigDecimal rateFloat = RateAdjustHelper.getRateFloat(floatRateSegBean);
                    BigDecimal yearRate = EmptyUtil.isEmpty((BigDecimal)referRate) ? BigDecimal.ZERO : referRate.add(rateFloat);
                    rateAdjust.set("ra_yearrate", (Object)yearRate);
                }
            }
        }
        return rateAdjustEntry;
    }

    public static Date getLastAdjustDate(List<FloatRateCalBean> floatRateBizSegmBeans) {
        Optional<Date> lastAdjustDateOp = floatRateBizSegmBeans.stream().map(r -> r.getStartDate()).max(Date::compareTo);
        if (lastAdjustDateOp.isPresent()) {
            return lastAdjustDateOp.get();
        }
        return null;
    }

    public static boolean isAdjustRate(DynamicObject extendBill) {
        if (LoanTypeEnum.isBond(extendBill.getString("loantype"))) {
            DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
            for (DynamicObject entry : entrys) {
                if (!entry.getBoolean("lisadjustinterestrate")) continue;
                return true;
            }
        } else {
            return extendBill.getBoolean("isadjustinterestrate");
        }
        return false;
    }

    public static Map<Long, Map<String, Object>> getLoanIdAdjustInfoMap(DynamicObject[] loanBills) {
        List<Long> loanIds = Arrays.stream(loanBills).map(r -> r.getLong("id")).collect(Collectors.toList());
        Map<Long, Map<String, Object>> loanIdAdjustInfoMapByAdjust = RateAdjustHelper.getLoanIdAdjustInfoMapByAdjust(loanIds);
        String dataSource = loanBills[0].getString("datasource");
        List<String> loanBillNos = Arrays.stream(loanBills).map(r -> r.getString("billno")).collect(Collectors.toList());
        Map<Long, Map<String, Object>> loanIdAdjustInfoMapByExtend = RateAdjustHelper.getLoanIdAdjustInfoMapByExtend(loanBillNos, dataSource);
        HashMap<Long, Map<String, Object>> loanIdAdjustInfoMap = new HashMap<Long, Map<String, Object>>(16);
        Map<String, Object> adjustInfoMap = null;
        for (DynamicObject loanBill : loanBills) {
            long loanId = loanBill.getLong("id");
            Map<String, Object> adjustMap = loanIdAdjustInfoMapByAdjust.get(loanId);
            Map<String, Object> extendMap = loanIdAdjustInfoMapByExtend.get(loanId);
            if (!EmptyUtil.isEmpty(adjustMap) || !EmptyUtil.isEmpty(extendMap)) {
                Date extendDate;
                Date adjustDate;
                adjustInfoMap = EmptyUtil.isEmpty(extendMap) ? adjustMap : (EmptyUtil.isEmpty(adjustMap) ? extendMap : ((adjustDate = (Date)adjustMap.get("adjustdate")).compareTo(extendDate = (Date)extendMap.get("adjustdate")) > 0 ? adjustMap : extendMap));
            }
            loanIdAdjustInfoMap.put(loanId, adjustInfoMap);
        }
        return loanIdAdjustInfoMap;
    }

    public static Map<Long, Map<String, Object>> getLoanIdAdjustInfoMapByAdjust(List<Long> loanIds) {
        DynamicObject[] rateAdjustBills = RateAdjustHelper.getRateAdjustBillsInfo(loanIds);
        HashMap<Long, Map<String, Object>> loanIdAdjustInfoMap = new HashMap<Long, Map<String, Object>>(16);
        for (DynamicObject rateAdjustBill : rateAdjustBills) {
            DynamicObjectCollection entrys = rateAdjustBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                HashMap<String, Object> adjustInfoMap = new HashMap<String, Object>(16);
                DynamicObject loanBill = entry.getDynamicObject("ldrawbill");
                long loanId = loanBill.getLong("id");
                Date adjustdate = entry.getDate("ladjusteffectdate");
                String ratesign = entry.getString("afterlratesign");
                BigDecimal ratefloatpoint = entry.getBigDecimal("afterlratefloatpoint");
                DynamicObject referencerate = entry.getDynamicObject("afterlrefrate");
                BigDecimal loanrate = entry.getBigDecimal("afterlloanrate");
                adjustInfoMap.put("adjustdate", adjustdate);
                adjustInfoMap.put("ratesign", ratesign);
                adjustInfoMap.put("ratefloatpoint", ratefloatpoint);
                adjustInfoMap.put("referencerate", referencerate);
                adjustInfoMap.put("loanrate", loanrate);
                if (EmptyUtil.isEmpty(loanIdAdjustInfoMap.get(loanId))) {
                    loanIdAdjustInfoMap.put(loanId, adjustInfoMap);
                    continue;
                }
                if (adjustdate.compareTo((Date)((Map)loanIdAdjustInfoMap.get(loanId)).get("adjustdate")) <= 0) continue;
                loanIdAdjustInfoMap.put(loanId, adjustInfoMap);
            }
        }
        return loanIdAdjustInfoMap;
    }

    public static Map<Long, Map<String, Object>> getLoanIdAdjustInfoMapByExtend(List<String> loanBillNos, String dataSource) {
        DynamicObject[] extendBills = RateAdjustHelper.getExtendBillsInfo(loanBillNos, dataSource);
        HashMap<Long, Map<String, Object>> loanIdAdjustInfoMap = new HashMap<Long, Map<String, Object>>(16);
        for (DynamicObject extendBill : extendBills) {
            DynamicObjectCollection loanBillLists = extendBill.getDynamicObjectCollection("loanbilllist");
            String ratesign = extendBill.getString("ratesign");
            BigDecimal ratefloatpoint = extendBill.getBigDecimal("ratefloatpoint");
            DynamicObject referencerate = extendBill.getDynamicObject("referencerate");
            BigDecimal loanrate = extendBill.getBigDecimal("renewalinterestrate");
            for (DynamicObject loanBillList : loanBillLists) {
                HashMap<String, Object> adjustInfoMap = new HashMap<String, Object>(16);
                Long loanId = loanBillList.getLong("drawbillid");
                Date adjustdate = loanBillList.getDate("e_prevrenewalexpiredate");
                if (DataSourceEnum.isBond(dataSource)) {
                    ratesign = loanBillList.getString("lratesign");
                    ratefloatpoint = loanBillList.getBigDecimal("lratefloatpoint");
                    referencerate = loanBillList.getDynamicObject("lreferencerate");
                    loanrate = loanBillList.getBigDecimal("loanrate");
                }
                adjustInfoMap.put("adjustdate", adjustdate);
                adjustInfoMap.put("ratesign", ratesign);
                adjustInfoMap.put("ratefloatpoint", ratefloatpoint);
                adjustInfoMap.put("referencerate", referencerate);
                adjustInfoMap.put("loanrate", loanrate);
                if (EmptyUtil.isEmpty(loanIdAdjustInfoMap.get(loanId))) {
                    loanIdAdjustInfoMap.put(loanId, adjustInfoMap);
                    continue;
                }
                if (adjustdate.compareTo((Date)((Map)loanIdAdjustInfoMap.get(loanId)).get("adjustdate")) <= 0) continue;
                loanIdAdjustInfoMap.put(loanId, adjustInfoMap);
            }
        }
        return loanIdAdjustInfoMap;
    }

    public static Map<Long, Date> getLoanIdDateMap(DynamicObjectCollection rateAdjustBills) {
        HashMap<Long, Date> loanIdDateMap = new HashMap<Long, Date>(16);
        for (DynamicObject rateAdjustBill : rateAdjustBills) {
            Long loanId = rateAdjustBill.getLong("entry.ldrawbill");
            Date adjustEffectDate = rateAdjustBill.getDate("entry.ladjusteffectdate");
            if (EmptyUtil.isEmpty(loanIdDateMap.get(loanId))) {
                loanIdDateMap.put(loanId, adjustEffectDate);
                continue;
            }
            if (adjustEffectDate.compareTo((Date)loanIdDateMap.get(loanId)) <= 0) continue;
            loanIdDateMap.put(loanId, adjustEffectDate);
        }
        return loanIdDateMap;
    }

    public static Map<String, Date> getLoanNoDateMap(DynamicObjectCollection extendBills) {
        HashMap<String, Date> loanNoDateMap = new HashMap<String, Date>(16);
        for (DynamicObject extendBill : extendBills) {
            String loanNo = extendBill.getString("loanbilllist.drawbillno");
            Date effectDate = extendBill.getDate("loanbilllist.e_prevrenewalexpiredate");
            if (EmptyUtil.isEmpty(loanNoDateMap.get(loanNo))) {
                loanNoDateMap.put(loanNo, effectDate);
                continue;
            }
            if (effectDate.compareTo((Date)loanNoDateMap.get(loanNo)) <= 0) continue;
            loanNoDateMap.put(loanNo, effectDate);
        }
        return loanNoDateMap;
    }

    public static HashMap<Long, Date> getLoanIdPayIntDateMap(DynamicObjectCollection loanBills) {
        HashMap<Long, Date> loanIdPayIntDateMap = new HashMap<Long, Date>(16);
        for (DynamicObject loanBill : loanBills) {
            Date endInstDate = loanBill.getDate("endinstdate");
            Date lastPayInstDate = loanBill.getDate("lastpayinstdate");
            if (EmptyUtil.isNoEmpty((Object)lastPayInstDate)) {
                endInstDate = DateUtils.getLastDay((Date)lastPayInstDate, (int)1);
            }
            if (!EmptyUtil.isNoEmpty((Object)endInstDate)) continue;
            loanIdPayIntDateMap.put(loanBill.getLong("id"), DateUtils.getDataFormat((Date)endInstDate, (boolean)true));
        }
        return loanIdPayIntDateMap;
    }

    public static DynamicObjectCollection getRateAdjustBills(List<Long> loanIds) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("entry.ldrawbill", "in", loanIds).and("entry.lisadjust", "=", (Object)true);
        String selectFields = "id, entry.ldrawbill, entry.lisadjust, entry.ladjusteffectdate";
        return QueryServiceHelper.query((String)"cfm_rateadjustbill_bond", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    public static DynamicObjectCollection getExtendBills(List<String> loanBillNos, String dataSource) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("loanbilllist.drawbillno", "in", loanBillNos);
        if (DataSourceEnum.isBond(dataSource)) {
            qFilter.and("loanbilllist.lisadjustinterestrate", "=", (Object)true);
        } else {
            qFilter.and("isadjustinterestrate", "=", (Object)true);
            qFilter.and("loanbilllist.isrenewal", "=", (Object)true);
        }
        String selectFields = "id, datasource, loanbilllist.drawbillno, loanbilllist.e_prevrenewalexpiredate";
        return QueryServiceHelper.query((String)"cfm_contractextend_bo", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private static DynamicObject[] getRateAdjustBillsInfo(List<Long> loanIds) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("entry.ldrawbill", "in", loanIds).and("entry.lisadjust", "=", (Object)true);
        String selectFields = "id, entry, entry.ldrawbill, entry.lisadjust, entry.ladjusteffectdate, entry.afterlratesign, entry.afterlratefloatpoint, entry.afterlrefrate, entry.afterlloanrate";
        return TmcDataServiceHelper.load((String)"cfm_rateadjustbill_bond", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    public static DynamicObject[] getExtendBillsInfo(List<String> loanBillNos, String dataSource) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("loanbilllist.drawbillno", "in", loanBillNos);
        if (DataSourceEnum.isBond(dataSource)) {
            qFilter.and("loanbilllist.lisadjustinterestrate", "=", (Object)true);
        } else {
            qFilter.and("isadjustinterestrate", "=", (Object)true);
            qFilter.and("loanbilllist.isrenewal", "=", (Object)true);
        }
        String selectFields = "id, datasource, loanbilllist, loanbilllist.drawbillno, loanbilllist.e_prevrenewalexpiredate, ratesign, ratefloatpoint, referencerate, renewalinterestrate, loanbilllist.lratesign, loanbilllist.lratefloatpoint, loanbilllist.lreferencerate, loanbilllist.loanrate, loanbilllist.drawbillid";
        return TmcDataServiceHelper.load((String)"cfm_contractextend_bo", (String)selectFields, (QFilter[])qFilter.toArray());
    }
}

