/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.cfm.common.constant.CfmEntityConst;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SyncDrawHelper {
    private static final Log logger = LogFactory.getLog(SyncDrawHelper.class);
    private static final String[] GUARANTEE_USE_PROPS = new String[]{"id", "gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate", "billstatus", "gsrcbilltype", "gsrcbillid", "gcreditortype", "gcreditor", "gcreditortext"};
    public static final String ISSYNCDRAW = "issyncdraw";

    public static void handleSyncDraw(DynamicObject loanContract) {
        SyncDrawHelper.handleSyncDraw(loanContract, false);
    }

    public static void handleSyncDraw(DynamicObject loanContract, boolean isConfirm) {
        DynamicObject[] loanContractCreditUse;
        DynamicObject productFact;
        boolean isBanksLoanLimit;
        String contractEntityName = loanContract.getDataEntityType().getName();
        String[] entityNames = SyncDrawHelper.getEntityNames(contractEntityName, isConfirm);
        String originEntityName = entityNames[0];
        String mappedEntityName = entityNames[1];
        DynamicObject loanBill = TmcBotpHelper.getTargetBill((String)contractEntityName, (Object)(loanContract = TmcDataServiceHelper.loadSingle((Object)loanContract.getLong("id"), (String)originEntityName)).getLong("id"), (String)mappedEntityName);
        if (EmptyUtil.isNoEmpty((DynamicObject)loanBill)) {
            return;
        }
        DynamicObject[] loanBills = TmcBotpHelper.push((DynamicObject)loanContract, (String)mappedEntityName);
        loanBill = loanBills[0];
        if ("fl_leasecontractbill_init".equals(contractEntityName)) {
            loanBill.set("isinit", (Object)"1");
        }
        SyncDrawHelper.setLoanBillSyncDrawField(loanContract, loanBill);
        String dataSource = loanContract.getString("datasource");
        String conEntityName = loanContract.getDataEntityType().getName();
        String creditUseSourceType = "cfm_loancontractbill";
        if (DataSourceEnum.isInvest(dataSource)) {
            creditUseSourceType = "cim_invest_contract";
        } else if (DataSourceEnum.isIfm(dataSource) || "ifm_loancontractbill".equals(conEntityName)) {
            creditUseSourceType = "ifm_loancontractbill";
        } else if (DataSourceEnum.isFl(dataSource)) {
            creditUseSourceType = "fl_leasecontractbill";
        }
        Set loanBillCreditUseId = null;
        Object[] loanCreditUseId = null;
        HashSet<Long> limitIds = new HashSet<Long>();
        DynamicObject syncLimit = loanContract.getDynamicObject("synccreditlimit");
        if (!LoanTypeEnum.isBanksLoan(loanContract.getString("loantype")) && EmptyUtil.isNoEmpty((DynamicObject)syncLimit)) {
            loanBill.set("creditlimit", (Object)syncLimit);
            limitIds.add(syncLimit.getLong("id"));
        }
        if (isBanksLoanLimit = CreditLimitHelper.isBanksLoanLimit(productFact = loanContract.getDynamicObject("productfactory"), loanContract.getString("loantype"))) {
            DynamicObjectCollection bankCateEntrys = loanContract.getDynamicObjectCollection("banksyndicate_entry");
            Set entrys = bankCateEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_creditlimit"))).collect(Collectors.toSet());
            for (DynamicObject entry : entrys) {
                syncLimit = CreditLimitHelper.getRealCreditLimit(entry.getDynamicObject("e_creditlimit"));
                limitIds.add(EmptyUtil.isNoEmpty((DynamicObject)syncLimit) ? syncLimit.getLong("id") : 0L);
            }
        }
        limitIds.removeIf(o -> EmptyUtil.isEmpty((Long)o));
        if (EmptyUtil.isNoEmpty(limitIds) && (loanContractCreditUse = SyncDrawHelper.getCreditUseBill(loanContract.getLong("id"), creditUseSourceType, limitIds)) != null && loanContractCreditUse.length > 0) {
            loanCreditUseId = SyncDrawHelper.saveCreditUse(loanContract, loanBill, loanContractCreditUse);
            loanBillCreditUseId = Arrays.stream(loanContractCreditUse).map(o -> o.getLong("id")).collect(Collectors.toSet());
        }
        SyncDrawHelper.setLoanBillGuaranteeUse(loanContract, loanBill);
        OperateOption option = OperateOption.create();
        option.setVariableValue(ISSYNCDRAW, Boolean.TRUE.toString());
        if (LoanTypeEnum.isBankLoan(loanContract.getString("loantype")) || LoanTypeEnum.isBanksLoan(loanContract.getString("loantype"))) {
            option.setVariableValue("formId", "cfm_loanbill_b_l");
        }
        String entityName = loanBills[0].getDataEntityType().getName();
        String syncBillStatus = loanContract.getString("syncbillstatus");
        String string = syncBillStatus = EmptyUtil.isEmpty((String)syncBillStatus) ? BillStatusEnum.AUDIT.getValue() : syncBillStatus;
        if (BillStatusEnum.isAudit((String)syncBillStatus)) {
            option.setVariableValue("WF", "TRUE");
        }
        try {
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)entityName, (DynamicObject[])loanBills, (OperateOption)option);
            if (EmptyUtil.isEmpty((Collection)operationResult.getSuccessPkIds())) {
                throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            if (BillStatusEnum.isSave((String)syncBillStatus)) {
                logger.info("SyncDrawHelper handleSyncDraw create loanBill status is save...");
                return;
            }
            Object loanBillId = operationResult.getSuccessPkIds().toArray()[0];
            if (EmptyUtil.isEmpty((Collection)(operationResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)entityName, (Object[])new Object[]{loanBillId}, (OperateOption)option)).getSuccessPkIds())) {
                throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            if (BillStatusEnum.isSubmit((String)syncBillStatus)) {
                logger.info("SyncDrawHelper handleSyncDraw create loanBill status is submit...");
                logger.info("\u63d0\u6b3e\u5355\u63d0\u4ea4\u6210\u529f\u540e\u7684\u63d0\u6b3e\u5355\u53f7\uff1a{}", (Object)loanBills[0].getString("billno"));
                return;
            }
            logger.info("SyncDrawHelper handleSyncDraw create loanBill status is audit...");
            loanBillId = operationResult.getSuccessPkIds().toArray()[0];
            operationResult = TmcOperateServiceHelper.execOperate((String)"audit", (String)entityName, (Object[])new Object[]{loanBillId}, (OperateOption)option);
            if (EmptyUtil.isEmpty((Collection)operationResult.getSuccessPkIds())) {
                throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            if (EmptyUtil.isNoEmpty(loanBillCreditUseId)) {
                SyncDrawHelper.deleteContractGuaUse(loanContract, (Long)loanBillId);
            }
        }
        catch (Exception e) {
            SyncDrawHelper.deleteCreditUse(loanCreditUseId);
            logger.error("\u540c\u6b65\u63d0\u6b3e\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
    }

    private static void deleteCreditUse(Object[] creditUseId) {
        if (creditUseId != null && creditUseId.length > 0 && creditUseId[0] instanceof DynamicObject) {
            Set ids = Arrays.stream(creditUseId).map(o -> ((DynamicObject)o).getLong("id")).collect(Collectors.toSet());
            DeleteServiceHelper.delete((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("id", "in", ids).and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())});
        }
    }

    private static String[] getEntityNames(String contractEntityName, boolean isConfirm) {
        String originEntityName = "cfm_loancontractbill";
        String mappedEntityName = "cfm_loanbill";
        if (CfmEntityConst.isLeaseContractBill(contractEntityName)) {
            return new String[]{"fl_leasecontractbill", "fl_receiptbill"};
        }
        if (!isConfirm) {
            if ("ifm_loancontractbill".equals(contractEntityName)) {
                originEntityName = "ifm_loancontractbill";
                mappedEntityName = "ifm_loanbill";
            } else if ("cim_invest_contract".equals(contractEntityName)) {
                originEntityName = "cim_invest_contract";
                mappedEntityName = "cim_invest_loanbill";
            }
        } else if ("cim_invest_contract".equals(contractEntityName)) {
            originEntityName = "cfm_loancontractbill";
            mappedEntityName = "cfm_loanbill";
        } else if ("cfm_loancontractbill".equals(contractEntityName)) {
            originEntityName = "cim_invest_contract";
            mappedEntityName = "cim_invest_loanbill";
        }
        return new String[]{originEntityName, mappedEntityName};
    }

    public static void handleSyncDrawForBond(DynamicObject bondPlan) {
        DynamicObject bondBill = TmcBotpHelper.getTargetBill((String)(bondPlan = TmcDataServiceHelper.loadSingle((Object)bondPlan.getLong("id"), (String)"cfm_loancontract_bo")).getDataEntityType().getName(), (Object)bondPlan.getLong("id"), (String)"cfm_loanbill_bond");
        if (EmptyUtil.isNoEmpty((DynamicObject)bondBill)) {
            return;
        }
        DynamicObject[] bondBills = TmcBotpHelper.push((DynamicObject)bondPlan, (String)"cfm_loanbill_bond");
        bondBill = bondBills[0];
        SyncDrawHelper.setBondSyncDrawField(bondPlan, bondBill);
        DynamicObjectCollection bondPlanInvEntrys = bondPlan.getDynamicObjectCollection("investor_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bondPlanInvEntrys)) {
            SyncDrawHelper.saveBondCreditUse(bondPlan, bondBill, bondPlanInvEntrys);
        }
        SyncDrawHelper.setLoanBillGuaranteeUse(bondPlan, bondBill);
        OperateOption option = OperateOption.create();
        option.setVariableValue(ISSYNCDRAW, Boolean.TRUE.toString());
        String entityName = bondBills[0].getDataEntityType().getName();
        String syncBillStatus = bondPlan.getString("syncbillstatus");
        String string = syncBillStatus = EmptyUtil.isEmpty((String)syncBillStatus) ? BillStatusEnum.AUDIT.getValue() : syncBillStatus;
        if (BillStatusEnum.isAudit((String)syncBillStatus)) {
            option.setVariableValue("WF", "TRUE");
        }
        try {
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)entityName, (DynamicObject[])bondBills, (OperateOption)option);
            if (EmptyUtil.isEmpty((Collection)operationResult.getSuccessPkIds())) {
                throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            if (BillStatusEnum.isSave((String)syncBillStatus)) {
                logger.info("SyncDrawHelper handleSyncDraw create loanBill status is save...");
                return;
            }
            Object loanBillId = operationResult.getSuccessPkIds().toArray()[0];
            if (EmptyUtil.isEmpty((Collection)(operationResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)entityName, (Object[])new Object[]{loanBillId}, (OperateOption)option, (boolean)false)).getSuccessPkIds())) {
                throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            if (BillStatusEnum.isSubmit((String)syncBillStatus)) {
                logger.info("SyncDrawHelper handleSyncDraw create loanBill status is submit...");
                logger.info("\u503a\u5238\u53d1\u884c\u5355\u63d0\u4ea4\u6210\u529f\u540e\u7684\u53d1\u884c\u5355\u53f7\uff1a{}", (Object)bondBills[0].getString("billno"));
                return;
            }
            logger.info("SyncDrawHelper handleSyncDraw create loanBill status is audit...");
            loanBillId = operationResult.getSuccessPkIds().toArray()[0];
            operationResult = TmcOperateServiceHelper.execOperate((String)"audit", (String)entityName, (Object[])new Object[]{loanBillId}, (OperateOption)option, (boolean)false);
            if (EmptyUtil.isEmpty((Collection)operationResult.getSuccessPkIds())) {
                throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            SyncDrawHelper.unauditBondBillPlanGuaUse(bondPlan);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u53d1\u884c\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
    }

    private static void unauditBondBillPlanGuaUse(DynamicObject bondPlan) {
        QFilter idFilter = new QFilter("gsrcbillid", "=", bondPlan.getPkValue());
        Object[] gcBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcBills)) {
            return;
        }
        for (Object gcBill : gcBills) {
            gcBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        }
        TmcDataServiceHelper.save((DynamicObject[])gcBills);
    }

    private static void saveBondCreditUse(DynamicObject bondPlan, DynamicObject bondbill, DynamicObjectCollection bondPlanInvEntrys) {
        Map<Long, DynamicObject> bondPlanVestLimitMap = bondPlanInvEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_creditlimit_inv"))).collect(Collectors.toMap(o -> o.getLong("e_investorid"), o -> o.getDynamicObject("e_creditlimit_inv"), (v1, v2) -> v2));
        DynamicObjectCollection bondBillInvEntrys = bondbill.getDynamicObjectCollection("investor_entry");
        HashMap<Long, DynamicObject> bondBillInvMap = new HashMap<Long, DynamicObject>(bondBillInvEntrys.size());
        for (DynamicObject bondBillInvEntry : bondBillInvEntrys) {
            long investorId = bondBillInvEntry.getLong("e_investorid");
            if (EmptyUtil.isEmpty((Long)investorId)) continue;
            if (bondPlanVestLimitMap.containsKey(investorId)) {
                bondBillInvEntry.set("e_creditlimit", (Object)bondPlanVestLimitMap.get(investorId));
            }
            bondBillInvMap.put(investorId, bondBillInvEntry);
        }
        boolean isBondPlanLimit = QueryServiceHelper.exists((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)bondPlan.getLong("id")).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
        if (isBondPlanLimit) {
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)bondPlan, null, (boolean)true);
        }
        long[] entryIds = DB.genLongIds((String)"cfm_loanbill_bond.investor_entry", (int)bondPlanInvEntrys.size());
        int entryCnt = 0;
        DynamicObject[] loanContractCreditUses = SyncDrawHelper.getBondCreditUseBill(bondPlan.getLong("id"), "cfm_loancontract_bo");
        Map creditUseMap = Arrays.stream(loanContractCreditUses).collect(Collectors.toMap(o -> o.getLong("sourcebillentryid"), Function.identity(), (v1, v2) -> v2));
        for (DynamicObject bondPlanInvEntry : bondPlanInvEntrys) {
            if (!EmptyUtil.isNoEmpty((Object)bondPlanInvEntry.get("e_creditlimit_inv"))) continue;
            DynamicObject bondBillInvEntry = (DynamicObject)bondBillInvMap.get(bondPlanInvEntry.getLong("e_investorid"));
            bondBillInvEntry.set("id", (Object)entryIds[entryCnt++]);
            DynamicObject loanContractCreditUse = (DynamicObject)creditUseMap.get(bondPlanInvEntry.getLong("id"));
            if (EmptyUtil.isEmpty((DynamicObject)loanContractCreditUse)) continue;
            SyncDrawHelper.saveBondCreditUse(bondbill, loanContractCreditUse, bondBillInvEntry);
        }
    }

    private static DynamicObject[] getCreditUseBill(Long sourcebillId, String billType, Set<Long> limitIds) {
        QFilter qFilters = new QFilter("sourcebillid", "=", (Object)sourcebillId).and("sourcetype", "=", (Object)billType).and("creditlimit", "in", limitIds);
        DynamicObjectCollection creditColls = QueryServiceHelper.query((String)"cfm_credituse", (String)"id", (QFilter[])new QFilter[]{qFilters});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)creditColls)) {
            return null;
        }
        DynamicObject[] creditUses = TmcDataServiceHelper.load((Object[])creditColls.stream().map(o -> o.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_credituse"));
        return creditUses;
    }

    private static DynamicObject[] getBondCreditUseBill(Long sourcebillId, String billType) {
        DynamicObject[] creditUse = TmcDataServiceHelper.loadByFilter((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)sourcebillId), new QFilter("sourcetype", "=", (Object)billType)});
        return creditUse;
    }

    private static Object[] saveCreditUse(DynamicObject loancontract, DynamicObject loanbill, DynamicObject[] contractCreditUses) {
        Map<Long, Long> conBankCateEntryMap = SyncDrawHelper.getBankCateEntryMap(loancontract, false);
        Map<Long, Long> loanBankCateEntryMap = SyncDrawHelper.getBankCateEntryMap(loanbill, true);
        ArrayList<DynamicObject> loanCreditUses = new ArrayList<DynamicObject>(contractCreditUses.length);
        String dataSource = loancontract.getString("datasource");
        String conEntityName = loancontract.getDataEntityType().getName();
        for (DynamicObject contractCreditUse : contractCreditUses) {
            DynamicObject loanCreditUse = TmcDataServiceHelper.clone((DynamicObject)contractCreditUse);
            String sourceType = "cfm_loanbill";
            if (DataSourceEnum.isIfm(dataSource) || "ifm_loancontractbill".equals(conEntityName)) {
                sourceType = "ifm_loanbill";
            } else if (DataSourceEnum.isInvest(dataSource)) {
                sourceType = "cim_invest_loanbill";
            } else if (DataSourceEnum.isFl(dataSource)) {
                sourceType = "fl_leasecontractbill";
            }
            loanCreditUse.set("sourcetype", (Object)sourceType);
            loanCreditUse.set("sourcename", (Object)CfmEntityEnum.getName(sourceType));
            loanCreditUse.set("sourcebillid", (Object)loanbill.getLong("id"));
            loanCreditUse.set("sourcebillno", (Object)loanbill.getString("billno"));
            Long bankId = conBankCateEntryMap.get(loanCreditUse.getLong("sourcebillentryid"));
            Long loanEntryId = loanBankCateEntryMap.get(bankId);
            loanCreditUse.set("sourcebillentryid", (Object)(EmptyUtil.isNoEmpty((Long)loanEntryId) ? loanEntryId.longValue() : loanbill.getLong("id")));
            loanCreditUses.add(loanCreditUse);
        }
        return TmcDataServiceHelper.save((DynamicObject[])loanCreditUses.toArray(new DynamicObject[0]));
    }

    private static Map<Long, Long> getBankCateEntryMap(DynamicObject bill, boolean isBank) {
        HashMap<Long, Long> entryIdTobank = new HashMap<Long, Long>();
        DynamicObjectCollection bankCateEntrys = bill.getDynamicObjectCollection("banksyndicate_entry");
        for (DynamicObject bankCateEntry : bankCateEntrys) {
            DynamicObject bank = bankCateEntry.getDynamicObject("e_bank");
            if (!EmptyUtil.isNoEmpty((DynamicObject)bank)) continue;
            if (isBank) {
                entryIdTobank.put(bank.getLong("id"), bankCateEntry.getLong("id"));
                continue;
            }
            entryIdTobank.put(bankCateEntry.getLong("id"), bank.getLong("id"));
        }
        return entryIdTobank;
    }

    private static void saveBondCreditUse(DynamicObject bondBill, DynamicObject contractCreditUse, DynamicObject bondBillEntry) {
        DynamicObject creditUseBill = BusinessDataServiceHelper.newDynamicObject((String)"cfm_credituse");
        creditUseBill.set("sourcetype", (Object)"cfm_loanbill_bond");
        creditUseBill.set("sourcename", (Object)CfmEntityEnum.getName(CfmEntityEnum.LOANBILL_BOND.getValue()));
        creditUseBill.set("sourcebillid", (Object)bondBill.getLong("id"));
        creditUseBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        creditUseBill.set("sourcebillno", (Object)bondBill.getString("billno"));
        creditUseBill.set("currency", (Object)contractCreditUse.getDynamicObject("currency"));
        creditUseBill.set("org", (Object)bondBill.getDynamicObject("org").getLong("id"));
        creditUseBill.set("creditlimit", (Object)contractCreditUse.getDynamicObject("creditlimit").getLong("id"));
        creditUseBill.set("sourcebillentryid", (Object)bondBillEntry.getLong("id"));
        creditUseBill.set("creditvariety", (Object)contractCreditUse.getString("creditvariety"));
        creditUseBill.set("startdate", (Object)bondBill.getDate("startintdate"));
        creditUseBill.set("enddate", (Object)bondBill.getDate("expiredate"));
        creditUseBill.set("amount", (Object)contractCreditUse.getBigDecimal("amount"));
        creditUseBill.set("realamt", (Object)contractCreditUse.getBigDecimal("realamt"));
        creditUseBill.set("preamount", (Object)contractCreditUse.getBigDecimal("preamount"));
        creditUseBill.set("returnamt", (Object)BigDecimal.ZERO);
        creditUseBill.set("ctrltype", (Object)contractCreditUse.getString("ctrltype"));
        creditUseBill.set("bizcurrency", (Object)bondBill.getDynamicObject("currency"));
        creditUseBill.set("bizcreditamount", (Object)contractCreditUse.getBigDecimal("bizcreditamount"));
        creditUseBill.set("creditratio", (Object)contractCreditUse.getBigDecimal("creditratio"));
        creditUseBill.set("creditrate", (Object)contractCreditUse.getBigDecimal("creditrate"));
        creditUseBill.set("createtime", (Object)new Date());
        creditUseBill.set("creator", (Object)bondBill.getDynamicObject("creator").getLong("id"));
        creditUseBill.set("totalamt", (Object)contractCreditUse.getBigDecimal("totalamt"));
        creditUseBill.set("avaramt", (Object)contractCreditUse.getBigDecimal("avaramt"));
        DynamicObject creditTypeDO = contractCreditUse.getDynamicObject("credittype");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditTypeDO)) {
            creditUseBill.set("credittype", (Object)creditTypeDO.getLong("id"));
        }
        contractCreditUse.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{creditUseBill, contractCreditUse});
    }

    private static void setLoanBillGuaranteeUse(DynamicObject loanContract, DynamicObject loanBill) {
        QFilter idFilter = new QFilter("gsrcbillid", "=", loanContract.getPkValue());
        DynamicObjectCollection gcs = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{idFilter}, (String)"id");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)gcs)) {
            return;
        }
        Map<Long, Boolean> creditMap = SyncDrawHelper.getCreditGuarantee(gcs.stream().map(a -> a.getLong("gcontract")).collect(Collectors.toSet()));
        TreeMap<String, ArrayList<DynamicObject>> sumGcMap = new TreeMap<String, ArrayList<DynamicObject>>();
        for (DynamicObject gc : gcs) {
            if (BigDecimal.ZERO.compareTo(gc.getBigDecimal("gratio")) == 0) continue;
            String creditorType = gc.getString("gcreditortype");
            Long creditor = gc.getLong("gcreditor");
            ArrayList<DynamicObject> gcTemp = (ArrayList<DynamicObject>)sumGcMap.get(creditorType + creditor);
            if (gcTemp == null) {
                gcTemp = new ArrayList<DynamicObject>(gcs.size());
            }
            gcTemp.add(gc);
            sumGcMap.put(creditorType + creditor, gcTemp);
        }
        DynamicObject productFactory = loanContract.getDynamicObject("productfactory");
        boolean isContractOccupy = EmptyUtil.isNoEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit");
        boolean isLoanAmount = loanContract.getBoolean(ISSYNCDRAW) && !isContractOccupy;
        Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)loanBill.getDataEntityType().getName(), (DynamicObject)loanBill);
        BigDecimal bizAmount = loanBill.getBigDecimal("drawamount");
        DynamicObject currency = loanBill.getDynamicObject("currency");
        DynamicObjectCollection guaUseCollection = loanBill.getDynamicObjectCollection("entry_gcontract");
        for (Map.Entry entry : sumGcMap.entrySet()) {
            List gcsList = (List)entry.getValue();
            if (EmptyUtil.isEmpty((Collection)gcsList)) continue;
            bizAmount = bizAmountMap.containsKey(entry.getKey()) ? (BigDecimal)bizAmountMap.get(entry.getKey()) : bizAmount;
            BigDecimal sumRatio = gcsList.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumAmount = BigDecimal.ZERO;
            for (int i = 0; i < gcsList.size(); ++i) {
                BigDecimal gAmount;
                DynamicObject gcBill = (DynamicObject)gcsList.get(i);
                if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == gcsList.size() - 1) {
                    gAmount = bizAmount.subtract(sumAmount);
                } else {
                    BigDecimal gRatio = gcBill.getBigDecimal("gratio");
                    gAmount = isLoanAmount && creditMap.get(gcBill.getLong("gcontract")) != false ? gcBill.getBigDecimal("gamount") : bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    sumAmount = sumAmount.add(gAmount);
                }
                DynamicObject guaUseObject = guaUseCollection.addNew();
                SyncDrawHelper.addGuaranteeUseObject(gcBill, gAmount, guaUseObject, loanBill.getDataEntityType().getName());
            }
        }
        loanBill.set("entry_gcontract", (Object)guaUseCollection);
    }

    private static Map<Long, Boolean> getCreditGuarantee(Set<Long> gContractIdSet) {
        DynamicObject[] guaranteeVarArr = BusinessDataServiceHelper.load((String)"gm_guaranteecontract", (String)"id,guarantee,guarantee.creditguarantee", (QFilter[])new QFilter[]{new QFilter("id", "in", gContractIdSet)});
        return Arrays.stream(guaranteeVarArr).collect(Collectors.toMap(k -> k.getLong("id"), e -> e.getBoolean("guarantee.creditguarantee")));
    }

    private static void addGuaranteeUseObject(DynamicObject guaranteeUseBill, BigDecimal gAmount, DynamicObject guaUseDynamicObject, String entityName) {
        DynamicObject guaRaContract = TmcDataServiceHelper.loadSingleFromCache((String)"gm_guaranteecontract_f7", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)guaranteeUseBill.getLong("gcontract"))});
        guaUseDynamicObject.set("gcontract", (Object)guaRaContract);
        guaUseDynamicObject.set("gamount", (Object)gAmount);
        guaUseDynamicObject.set("gratio", (Object)guaranteeUseBill.getBigDecimal("gratio"));
        guaUseDynamicObject.set("gcontractamount", (Object)guaranteeUseBill.getBigDecimal("gcontract.amount"));
        guaUseDynamicObject.set("gcontractcurrency", guaranteeUseBill.get("gcontract.currency"));
        guaUseDynamicObject.set("gexchrate", (Object)guaranteeUseBill.getBigDecimal("gexchrate"));
        guaUseDynamicObject.set("gcomment", (Object)guaranteeUseBill.getString("gcomment"));
        if (!"fl_receiptbill".equals(entityName)) {
            guaUseDynamicObject.set("gcreditortype", (Object)guaranteeUseBill.getString("gcreditortype"));
            guaUseDynamicObject.set("gcreditor", (Object)guaranteeUseBill.getLong("gcreditor"));
            guaUseDynamicObject.set("gcreditortext", (Object)guaranteeUseBill.getString("gcreditortext"));
        }
    }

    private static void setLoanBillSyncDrawField(DynamicObject loanContract, DynamicObject loanBill) {
        loanBill.set("drawamount", loanContract.get("syncdrawamount"));
        loanBill.set("bizdate", loanContract.get("syncdrawdate"));
        loanBill.set("startintdate", loanContract.get("startintdate"));
        loanBill.set("expiredate", loanContract.get("expiredate"));
        loanBill.set("datasource", loanContract.get("datasource"));
        if (loanContract.containsProperty("syncterm") && EmptyUtil.isNoEmpty((Object)loanContract.get("syncterm"))) {
            loanBill.set("term", loanContract.get("syncterm"));
        }
        loanBill.set("issofrrate", (Object)loanContract.getBoolean("issofrrate"));
        loanBill.set("iscallcompint", (Object)loanContract.getBoolean("iscallcompint"));
        loanBill.set("intcalmethod", (Object)loanContract.getString("intcalmethod"));
        loanBill.set("rateresetadjustrule", (Object)loanContract.getString("rateresetadjustrule"));
        DynamicObjectCollection workCalendar = loanContract.getDynamicObjectCollection("workcalendar");
        DynamicObject[] srcColArr = (DynamicObject[])workCalendar.stream().map(o -> o.getDynamicObject("fbasedataid")).toArray(DynamicObject[]::new);
        DynamicObjectCollection targetCol = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)loanBill, (String)"workcalendar", (DynamicObject[])srcColArr);
        loanBill.set("workcalendar", (Object)targetCol);
        loanBill.set("notdrawamount", loanContract.get("amount"));
        loanBill.set("irr", loanContract.get("irr"));
        loanBill.set("fixedRepayAmount", loanContract.get("fixedrepayamount"));
        SyncDrawHelper.setContractInterestRate(loanBill);
        if (loanBill.containsProperty("contractcny")) {
            loanBill.set("contractcny", loanContract.get("currency"));
        }
        if (loanBill.containsProperty("convertdrawamt")) {
            loanBill.set("convertdrawamt", loanContract.get("syncdrawamount"));
        }
        if (loanBill.containsProperty("convertrate")) {
            loanBill.set("convertrate", (Object)"1");
        }
        SyncDrawHelper.setLoanBillBanksEntryAmount(loanContract, loanBill);
    }

    private static void setBondSyncDrawField(DynamicObject bondPlan, DynamicObject bondBill) {
        if (bondBill.containsProperty("contractcny")) {
            bondBill.set("contractcny", bondPlan.get("currency"));
        }
        bondBill.set("notdrawamount", (Object)bondPlan.getBigDecimal("amount"));
        bondBill.set("drawamount", bondPlan.get("syncdrawamount"));
        bondBill.set("term", (Object)bondPlan.getString("syncterm"));
        bondBill.set("bizdate", (Object)bondPlan.getDate("syncbizdate"));
        bondBill.set("expiredate", (Object)bondPlan.getDate("expiredate"));
        bondBill.set("interesttype", (Object)bondPlan.getString("interesttype"));
        bondBill.set("loanrate", (Object)bondPlan.getBigDecimal("syncstartloanrate"));
        bondBill.set("startloanrate", (Object)bondPlan.getBigDecimal("syncstartloanrate"));
        bondBill.set("ratesign", (Object)bondPlan.getString("ratesign"));
        bondBill.set("ratefloatpoint", (Object)bondPlan.getBigDecimal("ratefloatpoint"));
        bondBill.set("rateadjuststyle", (Object)bondPlan.getString("rateadjuststyle"));
        bondBill.set("rateadjustdate", (Object)bondPlan.getDate("rateadjustdate"));
        bondBill.set("rateadjustcycletype", (Object)bondPlan.getString("rateadjustcycletype"));
        bondBill.set("rateadjustcycle", (Object)bondPlan.getInt("rateadjustcycle"));
        bondBill.set("basis", (Object)bondPlan.getString("basis"));
        bondBill.set("repaymentway", (Object)bondPlan.getString("repaymentway"));
        bondBill.set("stageplan", (Object)bondPlan.getDynamicObject("stageplan"));
        bondBill.set("settleintmode", (Object)bondPlan.getString("settleintmode"));
        bondBill.set("interestsettledplan", (Object)bondPlan.getDynamicObject("interestsettledplan"));
        bondBill.set("accountbank", (Object)bondPlan.getDynamicObject("accountbank"));
        bondBill.set("occupybondlimit", (Object)bondPlan.getDynamicObject("syncoccupybondlimit"));
        bondBill.set("selfsubscribeamt", (Object)bondPlan.getBigDecimal("syncselfsubscribeamt"));
        if (bondBill.containsProperty("convertdrawamt")) {
            bondBill.set("convertdrawamt", bondPlan.get("syncdrawamount"));
        }
        if (bondBill.containsProperty("convertrate")) {
            bondBill.set("convertrate", (Object)"1");
        }
    }

    public static void unsubmitAndDeleteLoanBill(DynamicObject loanContract) {
        Long loanContractId = loanContract.getLong("id");
        logger.info("\u8d37\u6b3e\u5408\u540c(\u5ba1\u6838/\u786e\u8ba4)-\u81ea\u52a8\u653e\u6b3e\u5931\u8d25: loanContractId:{}", (Object)loanContractId);
        QFilter loanBillFilter = new QFilter("sourcebillid", "=", (Object)loanContractId);
        String mappedEntityName = "cfm_loanbill";
        String contractEntityName = loanContract.getDataEntityType().getName();
        if ("ifm_loancontractbill".equals(contractEntityName)) {
            mappedEntityName = "ifm_loanbill";
        } else if ("cfm_loancontract_bo".equals(contractEntityName)) {
            mappedEntityName = "cfm_loanbill_bond";
        }
        DynamicObject loanBill = QueryServiceHelper.queryOne((String)mappedEntityName, (String)"id,billstatus", (QFilter[])loanBillFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)loanBill)) {
            OperationResult unsubmitResult;
            Long loanBillId = loanBill.getLong("id");
            String billStatus = loanBill.getString("billstatus");
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("WF", "TRUE");
            if (BillStatusEnum.isAudit((String)billStatus)) {
                logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u63d0\u6b3e\u5355 loanBillId: {}", (Object)loanBillId);
                unsubmitResult = TmcOperateServiceHelper.execOperate((String)"unaudit", (String)mappedEntityName, (Object[])new Object[]{loanBillId}, (OperateOption)operateOption);
                logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u7ed3\u679c: {}, loanBillId: {}", (Object)unsubmitResult, (Object)loanBillId);
            } else if (BillStatusEnum.isSubmit((String)billStatus)) {
                logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u64a4\u9500\u63d0\u6b3e\u5355 loanBillId: {}", (Object)loanBillId);
                unsubmitResult = TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)mappedEntityName, (Object[])new Object[]{loanBillId}, (OperateOption)operateOption);
                logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u64a4\u9500\u7ed3\u679c: {}, loanBillId: {}", (Object)unsubmitResult, (Object)loanBillId);
            }
            logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u5220\u9664\u63d0\u6b3e\u5355 loanBillId: {}", (Object)loanBillId);
            OperationResult deleteResult = TmcOperateServiceHelper.execOperate((String)"delete", (String)mappedEntityName, (Object[])new Object[]{loanBillId}, (OperateOption)operateOption);
            logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u5220\u9664\u7ed3\u679c: {}, loanBillId: {}", (Object)deleteResult, (Object)loanBillId);
        }
    }

    public static void unauditAndSubmitLoanContract(DynamicObject loanContract) {
        Long loanContractId = loanContract.getLong("id");
        logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u5e76\u63d0\u4ea4\u8d37\u6b3e\u5408\u540c, loancontractId: {}", (Object)loanContractId);
        String entityNumber = loanContract.getDataEntityType().getName();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        OperationResult unauditResult = TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityNumber, (Object[])new Object[]{loanContractId}, (OperateOption)operateOption);
        logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u5e76\u63d0\u4ea4\u8d37\u6b3e\u5408\u540c, \u53cd\u5ba1\u6838\u7ed3\u679c: {}, loancontractId: {}", (Object)unauditResult, (Object)loanContractId);
        if (unauditResult.isSuccess()) {
            OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)entityNumber, (Object[])new Object[]{loanContractId}, (OperateOption)operateOption);
            logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u5e76\u63d0\u4ea4\u8d37\u6b3e\u5408\u540c, \u63d0\u4ea4\u7ed3\u679c: {}, loancontractId: {}", (Object)submitResult, (Object)loanContractId);
        }
    }

    private static void deleteContractGuaUse(DynamicObject loanContract, Long loanBillId) {
        DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill", (String)"banksyndicate_entry.e_bankcreditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObject)loanBill)) {
            HashSet<Long> creditLimitIds = new HashSet<Long>(10);
            if (LoanTypeEnum.isBanksLoan(loanContract.getString("loantype"))) {
                DynamicObjectCollection bankCateEntrys = loanBill.getDynamicObjectCollection("banksyndicate_entry");
                creditLimitIds.addAll(bankCateEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_bankcreditlimit"))).map(o -> o.getDynamicObject("e_bankcreditlimit").getLong("id")).collect(Collectors.toSet()));
            } else if (EmptyUtil.isNoEmpty((DynamicObject)loanContract.getDynamicObject("synccreditlimit"))) {
                creditLimitIds.add(loanContract.getDynamicObject("synccreditlimit").getLong("id"));
            }
            if (EmptyUtil.isEmpty(creditLimitIds)) {
                return;
            }
            DynamicObjectCollection creditLimitGcBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)"id,gcontract", (QFilter[])new QFilter("gsrcbillid", "in", creditLimitIds).toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditLimitGcBills)) {
                List guaUseContractIdList = creditLimitGcBills.stream().map(guaUseBill -> guaUseBill.getLong("gcontract")).collect(Collectors.toList());
                QFilter contractCreditGuaUseFilter = new QFilter("gsrcbillid", "=", (Object)loanContract.getLong("id")).and(new QFilter("gcontract", "in", guaUseContractIdList));
                DeleteServiceHelper.delete((String)"gm_guaranteeuse", (QFilter[])new QFilter[]{contractCreditGuaUseFilter});
            }
        }
    }

    public static void unauditAndDeleteLoanContract(DynamicObject loanContract) {
        Long loanContractId = loanContract.getLong("id");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        logger.info("\u4e1a\u52a1\u53d7\u7406\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u5e76\u5220\u9664\u8d37\u6b3e\u5408\u540c, loancontractId: {}", (Object)loanContractId);
        OperationResult unauditResult = TmcOperateServiceHelper.execOperate((String)"unaudit", (String)loanContract.getDataEntityType().getName(), (Object[])new Object[]{loanContractId}, (OperateOption)operateOption);
        logger.info("\u4e1a\u52a1\u53d7\u7406\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u5e76\u5220\u9664\u8d37\u6b3e\u5408\u540c, \u53cd\u5ba1\u6838\u7ed3\u679c: {}, loancontractId: {}", (Object)unauditResult, (Object)loanContractId);
        OperationResult deleteResult = TmcOperateServiceHelper.execOperate((String)"delete", (String)loanContract.getDataEntityType().getName(), (Object[])new Object[]{loanContractId}, (OperateOption)operateOption);
        logger.info("\u4e1a\u52a1\u53d7\u7406\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u5e76\u5220\u9664\u8d37\u6b3e\u5408\u540c, \u5220\u9664\u7ed3\u679c: {}, loancontractId: {}", (Object)deleteResult, (Object)loanContractId);
    }

    public static void unauditAndSubmitBizdeal(DynamicObject bizdeal) {
        Long bizdealId = bizdeal.getLong("id");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u5e76\u63d0\u4ea4\u4e1a\u52a1\u53d7\u7406\u5355, bizdealId: {}", (Object)bizdealId);
        OperationResult unauditResult = TmcOperateServiceHelper.execOperate((String)"unaudit", (String)bizdeal.getDataEntityType().getName(), (Object[])new Object[]{bizdealId}, (OperateOption)operateOption);
        logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u5e76\u63d0\u4ea4\u4e1a\u52a1\u53d7\u7406\u5355, \u53cd\u5ba1\u6838\u7ed3\u679c: {}, loancontractId: {}", (Object)unauditResult, (Object)bizdealId);
        OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)bizdeal.getDataEntityType().getName(), (Object[])new Object[]{bizdealId}, (OperateOption)operateOption);
        logger.info("\u751f\u6210\u63d0\u6b3e\u5355\u5931\u8d25, \u53cd\u5ba1\u6838\u5e76\u63d0\u4ea4\u4e1a\u52a1\u53d7\u7406\u5355, \u63d0\u4ea4\u7ed3\u679c: {}, loancontractId: {}", (Object)submitResult, (Object)bizdealId);
    }

    private static void setLoanBillBanksEntryAmount(DynamicObject loanContract, DynamicObject loanBill) {
        String longType = loanContract.getString("loantype");
        if (LoanTypeEnum.isBanksLoan(longType)) {
            DynamicObjectCollection loanContractBanksEntry = loanContract.getDynamicObjectCollection("banksyndicate_entry");
            DynamicObjectCollection loanBillBanksEntry = loanBill.getDynamicObjectCollection("banksyndicate_entry");
            DynamicObject productFact = loanContract.getDynamicObject("productfactory");
            boolean isBanksLoanLimit = CreditLimitHelper.isBanksLoanLimit(productFact, longType);
            block0: for (DynamicObject loanContractBank : loanContractBanksEntry) {
                for (DynamicObject loanBillBank : loanBillBanksEntry) {
                    if (loanContractBank.getDynamicObject("e_bank").getLong("id") != loanBillBank.getDynamicObject("e_bank").getLong("id")) continue;
                    BigDecimal loanShareAmount = loanContractBank.getBigDecimal("e_loanamount");
                    loanBillBank.set("e_shareamount", (Object)loanShareAmount);
                    if (!isBanksLoanLimit || loanContract.getBoolean("isinit")) continue block0;
                    loanBillBank.set("e_bankcreditlimit", loanContractBank.get("e_creditlimit"));
                    continue block0;
                }
            }
        }
    }

    private static void setContractInterestRate(DynamicObject loanbill) {
        String interestType = loanbill.getString("interesttype");
        if (!InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            return;
        }
        DynamicObject referenceRate = loanbill.getDynamicObject("referencerate");
        Date startDate = loanbill.getDate("startintdate");
        BigDecimal rateFloatPoint = loanbill.getBigDecimal("ratefloatpoint");
        String rateSign = loanbill.getString("ratesign");
        if (EmptyUtil.isNoEmpty((DynamicObject)referenceRate) && EmptyUtil.isNoEmpty((Object)startDate)) {
            BigDecimal rate = MarketDataServiceHelper.referRate((String)referenceRate.getString("number"), (Date)startDate, (boolean)false);
            if (EmptyUtil.isEmpty((BigDecimal)rate)) {
                loanbill.set("startloanrate", (Object)BigDecimal.ZERO);
                return;
            }
            BigDecimal rateFloat = BigDecimal.ZERO;
            if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && EmptyUtil.isNoEmpty((String)rateSign)) {
                rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
                if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                    rateFloat = rateFloat.negate();
                }
            }
            loanbill.set("startloanrate", (Object)rate.add(rateFloat));
        } else {
            loanbill.set("startloanrate", (Object)BigDecimal.ZERO);
        }
    }
}

