/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TreeSelectHelper {
    public static void getTreeNodeIds(String entityName, Long currId, List<Long> ids) {
        ids.add(currId);
        DynamicObject node = TmcDataServiceHelper.loadSingle((Object)currId, (String)entityName, (String)"id,parent");
        DynamicObject parent = node.getDynamicObject("parent");
        if (parent != null) {
            TreeSelectHelper.getTreeNodeIds(entityName, (Long)parent.getPkValue(), ids);
        }
    }

    public static Set<Long> getRootChildNodeIds(String entityName, List<QFilter> qFilters, Long id) {
        HashSet<Long> ids = new HashSet<Long>(16);
        ArrayList<QFilter> nodeQFilter = new ArrayList<QFilter>();
        nodeQFilter.add(new QFilter("parent", "!=", (Object)0L));
        if (EmptyUtil.isNoEmpty(qFilters)) {
            nodeQFilter.addAll(qFilters);
        }
        DynamicObjectCollection nodes = QueryServiceHelper.query((String)entityName, (String)"id,parent", (QFilter[])nodeQFilter.toArray(new QFilter[0]));
        Map<Long, List<DynamicObject>> nodeMap = nodes.stream().collect(Collectors.groupingBy(item -> item.getLong("parent")));
        TreeSelectHelper.getRootChildNodeIds(id, ids, nodeMap);
        return ids;
    }

    private static void getRootChildNodeIds(Long id, Set<Long> ids, Map<Long, List<DynamicObject>> nodeMap) {
        Long cur = id;
        if (cur == null) {
            return;
        }
        ids.add(cur);
        while (EmptyUtil.isNoEmpty(nodeMap.get(cur))) {
            List<DynamicObject> nodeList = nodeMap.get(cur);
            for (DynamicObject node : nodeList) {
                cur = node.getLong("id");
                TreeSelectHelper.getRootChildNodeIds(cur, ids, nodeMap);
            }
        }
    }

    public static void getRootChildNodeIds(Long id, Map<Long, Set<Long>> nodeMap, Set<Long> ids) {
        Long cur = id;
        if (cur == null) {
            return;
        }
        ids.add(cur);
        while (EmptyUtil.isNoEmpty(nodeMap.get(cur))) {
            Set<Long> nodeList = nodeMap.get(cur);
            Iterator<Long> iterator = nodeList.iterator();
            while (iterator.hasNext()) {
                Long node;
                cur = node = iterator.next();
                TreeSelectHelper.getRootChildNodeIds(cur, nodeMap, ids);
            }
        }
    }
}

