/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UnifyLoanRepayHelper {
    public static final Log LOG = LogFactory.getLog(UnifyLoanRepayHelper.class);

    public static BigDecimal getNewestRate(DynamicObject loanBill) {
        if (InterestTypeEnum.isFixed((String)loanBill.getString("interesttype")) || InterestTypeEnum.isAgree((String)loanBill.getString("interesttype"))) {
            return loanBill.getBigDecimal("loanrate");
        }
        if (InterestTypeEnum.isFloat((String)loanBill.getString("interesttype"))) {
            BigDecimal rateFloatPoint = loanBill.getBigDecimal("ratefloatpoint");
            Optional<DynamicObject> rateAdjustOptional = loanBill.getDynamicObjectCollection("rateadjust_entry").stream().filter(o -> o.getDate("ra_effectdate") != null).max(Comparator.comparing(o -> o.getDate("ra_effectdate")));
            if (rateAdjustOptional.isPresent()) {
                BigDecimal yearRate = rateAdjustOptional.get().getBigDecimal("ra_yearrate");
                if (RateSignEnum.isAdd((String)loanBill.getString("ratesign"))) {
                    return yearRate.add(rateFloatPoint.divide(Constants.TEN_THOUSAND));
                }
                return yearRate.subtract(rateFloatPoint.divide(Constants.TEN_THOUSAND));
            }
        }
        return null;
    }

    public static void calcSynthesiseRate(DynamicObject bill) {
        DynamicObjectCollection unifyLoanReturnEntry = bill.getDynamicObjectCollection("unifyloanfrom_entry");
        long count = unifyLoanReturnEntry.stream().filter(row -> EmptyUtil.isEmpty((BigDecimal)row.getBigDecimal("e_useamt")) && EmptyUtil.isEmpty((BigDecimal)row.getBigDecimal("e_newloanrate"))).count();
        if (count != 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u201c\u7528\u6b3e\u91d1\u989d\u201d\u6216\u201c\u501f\u6b3e\u6700\u65b0\u5229\u7387\u201d\u4e3a\u7a7a\u7684\u5206\u5f55\u884c\uff0c\u65e0\u6cd5\u8ba1\u7b97\u7efc\u5408\u5229\u7387\u3002", (String)"UnifyLoanReturnHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
        }
        BigDecimal totalUseAmt = unifyLoanReturnEntry.stream().filter(o -> o.getString("e_loanbill") != null && EmptyUtil.isNoEmpty((BigDecimal)o.getBigDecimal("e_useamt"))).map(o -> o.getBigDecimal("e_useamt")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        if (totalUseAmt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        for (DynamicObject row2 : unifyLoanReturnEntry) {
            BigDecimal useAmt = row2.getBigDecimal("e_useamt");
            BigDecimal newLoanRate = row2.getBigDecimal("e_newloanrate");
            row2.set("e_generalrate", (Object)useAmt.divide(totalUseAmt, 18, RoundingMode.HALF_UP).multiply(newLoanRate));
        }
    }

    public static void removeRelateLink(DynamicObject[] dataEntities) {
        Set removeRelateIds = Arrays.stream(dataEntities).filter(r -> r.getBoolean("isunifyloanreturn")).filter(r -> EmptyUtil.isNoEmpty((DynamicObjectCollection)r.getDynamicObjectCollection("unifyloanfrom_entry"))).flatMap(r -> r.getDynamicObjectCollection("unifyloanfrom_entry").stream()).map(r -> r.getDynamicObject("e_loanbillid")).map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(removeRelateIds)) {
            return;
        }
        Object[] ids = Arrays.stream(dataEntities).filter(r -> r.getBoolean("isunifyloanreturn")).map(r -> r.getLong("id")).toArray();
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return;
        }
        Map<Long, DynamicObject> billMap = UnifyLoanRepayHelper.getRelateBillMap(dataEntities);
        Object[] relateLoanBills = BusinessDataServiceHelper.load((Object[])removeRelateIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cfm_loanbill"));
        if (EmptyUtil.isEmpty((Object[])relateLoanBills)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "not in", (Object)ids);
        qFilter.and(new QFilter("unifyloanfrom_entry.e_loanbillid", "in", removeRelateIds));
        Object[] otherBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"unifyloanfrom_entry.e_loanbillid", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((Object[])otherBills)) {
            Set otherLinkSet = Arrays.stream(otherBills).flatMap(r -> r.getDynamicObjectCollection("unifyloanfrom_entry").stream().map(p -> p.getDynamicObject("e_loanbillid")).map(p -> p.getLong("id"))).collect(Collectors.toSet());
            removeRelateIds.removeAll(otherLinkSet);
        }
        for (Object relateLoan : relateLoanBills) {
            long relateId = relateLoan.getLong("id");
            DynamicObject currLoan = billMap.get(relateId);
            DynamicObjectCollection useEntry = relateLoan.getDynamicObjectCollection("unifyloanuse_entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)useEntry)) continue;
            for (int i = 0; i < useEntry.size(); ++i) {
                long loanId = ((DynamicObject)useEntry.get(i)).getDynamicObject("u_loanbillid").getLong("id");
                if (loanId != currLoan.getLong("id")) continue;
                useEntry.remove(i);
            }
            if (!removeRelateIds.contains(relateId)) continue;
            relateLoan.set("isunifydebit", (Object)false);
            relateLoan.set("isunifyloanreturn", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])relateLoanBills);
    }

    public static Map<Long, DynamicObject> getRelateBillMap(DynamicObject[] dataEntities) {
        HashMap<Long, DynamicObject> relateMap = new HashMap<Long, DynamicObject>(dataEntities.length);
        for (DynamicObject loanBill : dataEntities) {
            DynamicObjectCollection fromEntry = loanBill.getDynamicObjectCollection("unifyloanfrom_entry");
            for (DynamicObject row : fromEntry) {
                Long loanId = Optional.ofNullable(row.getDynamicObject("e_loanbillid")).map(r -> r.getLong("id")).orElse(0L);
                relateMap.put(loanId, loanBill);
            }
        }
        return relateMap;
    }

    public static void updateRelateLoanUnify(DynamicObject[] dataEntities) {
        for (DynamicObject currLoan : dataEntities) {
            DynamicObject[] relateLoanBills;
            if (!currLoan.getBoolean("isunifyloanreturn")) continue;
            Long currId = currLoan.getLong("id");
            DynamicObject dbLoan = TmcDataServiceHelper.loadSingle((String)"cfm_loanbill", (String)"unifyloanfrom_entry.e_loanbillid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currId)});
            if (EmptyUtil.isEmpty((DynamicObject)dbLoan)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7edf\u501f\u7edf\u8fd8\u9875\u7b7e\u5173\u8054\u7684\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!", (String)"UnifyLoanRepayHelper_1", (String)"tmc-cfm-common", (Object[])new Object[0]));
            }
            Set dbRelates = dbLoan.getDynamicObjectCollection("unifyloanfrom_entry").stream().map(r -> r.getDynamicObject("e_loanbillid")).map(r -> r.getLong("id")).collect(Collectors.toSet());
            LOG.info("Db has {} entry rows.", (Object)dbRelates.size());
            Set relateLoanIds = currLoan.getDynamicObjectCollection("unifyloanfrom_entry").stream().map(r -> r.getDynamicObject("e_loanbillid")).map(r -> r.getLong("id")).collect(Collectors.toSet());
            LOG.info("Memory has {} entry rows.", (Object)relateLoanIds.size());
            if (EmptyUtil.isEmpty(relateLoanIds)) continue;
            dbRelates.removeAll(relateLoanIds);
            LOG.info("There are {} entry rows that need to remove.", (Object)dbRelates.size());
            Set<Object> otherLinkSet = new HashSet(8);
            if (EmptyUtil.isNoEmpty(dbRelates)) {
                QFilter qFilter = new QFilter("id", "!=", (Object)currId);
                qFilter.and(new QFilter("unifyloanfrom_entry.e_loanbillid", "in", dbRelates));
                Object[] otherBills = BusinessDataServiceHelper.load((String)"cfm_loanbill", (String)"unifyloanfrom_entry.e_loanbillid", (QFilter[])qFilter.toArray());
                if (EmptyUtil.isNoEmpty((Object[])otherBills)) {
                    otherLinkSet = Arrays.stream(otherBills).flatMap(r -> r.getDynamicObjectCollection("unifyloanfrom_entry").stream().map(p -> p.getDynamicObject("e_loanbillid"))).map(r -> r.getLong("id")).collect(Collectors.toSet());
                    LOG.info("OtherLink has {} entry rows.", (Object)otherLinkSet.size());
                    dbRelates.removeAll(otherLinkSet);
                    LOG.info("Finally there are {} entry rows that need to remove.", (Object)dbRelates.size());
                }
            }
            ArrayList idList = new ArrayList(relateLoanIds);
            idList.addAll(dbRelates);
            idList.addAll(otherLinkSet);
            for (DynamicObject relateLoan : relateLoanBills = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cfm_loanbill"))) {
                long relateId = relateLoan.getLong("id");
                DynamicObjectCollection useEntry = relateLoan.getDynamicObjectCollection("unifyloanuse_entry");
                for (int i = useEntry.size() - 1; i >= 0; --i) {
                    DynamicObject useRow = (DynamicObject)useEntry.get(i);
                    long loanId = useRow.getDynamicObject("u_loanbillid").getLong("id");
                    if (loanId != currLoan.getLong("id")) continue;
                    useEntry.remove(i);
                }
                if (relateLoanIds.contains(relateId)) {
                    relateLoan.set("isunifydebit", (Object)true);
                    relateLoan.set("isunifyloanreturn", (Object)true);
                    DynamicObjectCollection fromEntry = currLoan.getDynamicObjectCollection("unifyloanfrom_entry");
                    List rows = fromEntry.stream().filter(r -> relateId == r.getDynamicObject("e_loanbillid").getLong("id")).collect(Collectors.toList());
                    if (EmptyUtil.isEmpty(rows)) continue;
                    DynamicObject row = (DynamicObject)rows.get(0);
                    DynamicObject newRow = useEntry.addNew();
                    newRow.set("u_usetype", (Object)UnifyLoanRepayHelper.getUseType(currLoan));
                    newRow.set("u_loanbill", (Object)currLoan.getString("billno"));
                    newRow.set("u_loanbillid", (Object)currLoan.getLong("id"));
                    newRow.set("u_debitorg", (Object)currLoan.getDynamicObject("org"));
                    newRow.set("u_useamt", (Object)row.getBigDecimal("e_useamt"));
                    newRow.set("u_newloanrate", (Object)UnifyLoanRepayHelper.getNewestRate(currLoan));
                    newRow.set("u_startintdate", (Object)currLoan.getDate("startintdate"));
                    newRow.set("u_term", (Object)currLoan.getString("term"));
                    newRow.set("u_expiredate", (Object)currLoan.getDate("expiredate"));
                    continue;
                }
                if (!dbRelates.contains(relateId)) continue;
                relateLoan.set("isunifydebit", (Object)false);
                relateLoan.set("isunifyloanreturn", (Object)false);
            }
            SaveServiceHelper.save((DynamicObject[])relateLoanBills);
        }
    }

    private static String getUseType(DynamicObject loanBill) {
        String loanType = loanBill.getString("loantype");
        return LoanTypeEnum.isEntrustLoan(loanType) || LoanTypeEnum.isLinklend(loanType) ? "enter" : "bank";
    }
}

