/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.repository;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.bean.LoanBillIntBillInfo;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.repository.bean.BillAmountDTO;
import kd.tmc.cfm.common.repository.bean.LoanBillDTO;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillRepository {
    private static final String INTEREST_BILL_SELECT_PROPS = "id,sourcebillid,actualinstamt,startinstdate,endinstdate,instbillctg,bizdate,instbankacct,convertintamt,isoverseaentfill,loanbillno";
    private static final String INTEREST_BILL_ENTRYS_SELECT_PROPS = "entrys.inststartdate,entrys.instenddate,entrys.instdays,entrys.instprincipalamt,entrys.rate,entrys.ratetrandays,entrys.instamt,entrys.instctg,entrys.floatint,entrys.floatrate,entrys.lasttotalint,entrys.curtotalint,entrys.confirmratedate,entrys.lookdays,entrys.totalint";

    public static Map<Long, List<DynamicObject>> loadComfirmInterestBills(Collection<Long> loanBillIds, boolean isAsc, boolean includeEntrys) {
        QFilter qFilter = InterestBillRepository.getLoanBillFilter(loanBillIds);
        String props = INTEREST_BILL_SELECT_PROPS + (includeEntrys ? ",entrys.inststartdate,entrys.instenddate,entrys.instdays,entrys.instprincipalamt,entrys.rate,entrys.ratetrandays,entrys.instamt,entrys.instctg,entrys.floatint,entrys.floatrate,entrys.lasttotalint,entrys.curtotalint,entrys.confirmratedate,entrys.lookdays,entrys.totalint" : "");
        DynamicObject[] interestBills = TmcDataServiceHelper.load((String)"cfm_interestbill", (String)props, (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> map = Arrays.stream(interestBills).sorted((d1, d2) -> isAsc ? InterestBillRepository.compare(d1, d2) : InterestBillRepository.compare(d2, d1)).collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
        loanBillIds.forEach(l -> map.putIfAbsent((Long)l, Collections.emptyList()));
        return map;
    }

    private static int compare(DynamicObject d1, DynamicObject d2) {
        return d1.getDate("bizdate").compareTo(d2.getDate("bizdate"));
    }

    public static DynamicObjectCollection queryInterestBillByIds(Collection<Long> interestBillIds, String selectFields) {
        QFilter qFilter = new QFilter("id", "in", interestBillIds);
        return QueryServiceHelper.query((String)"cfm_interestbill", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    public static Map<Long, DynamicObject> getInterestBillByIds(Collection<Long> interestBillIds, String selectFields) {
        DynamicObjectCollection colls = InterestBillRepository.queryInterestBillByIds(interestBillIds, InterestBillRepository.getSelectFields(selectFields));
        return colls.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
    }

    private static String getSelectFields(String selectFields) {
        if (Arrays.stream(selectFields.split(",")).noneMatch(s -> s.equals("id"))) {
            selectFields = "id," + selectFields;
        }
        return selectFields;
    }

    public static DynamicObjectCollection queryByFilter(QFilter qFilter, String selectFields) {
        return QueryServiceHelper.query((String)"cfm_interestbill", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    public static Map<Long, DynamicObject> getByFilter(QFilter qFilter, String selectFields) {
        DynamicObjectCollection colls = InterestBillRepository.queryByFilter(qFilter, InterestBillRepository.getSelectFields(selectFields));
        return colls.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
    }

    private static DynamicObjectCollection queryInterestBillByLoanBillIds(Collection<Long> loanBillIds, String selectFields) {
        QFilter qFilter = InterestBillRepository.getLoanBillFilter(loanBillIds);
        return QueryServiceHelper.query((String)"cfm_interestbill", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private static QFilter getLoanBillFilter(Collection<Long> loanBillIds) {
        return new QFilter("sourcebillid", "in", loanBillIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
    }

    public static DynamicObjectCollection queryPrePayInterestBills(Collection<Long> loanBillIds, boolean isConfirmed) {
        QFilter qFilter = new QFilter("sourcebillid", "in", loanBillIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("instbillctg", "=", (Object)InterestbillctgEnum.PREPAYINT.getValue());
        if (isConfirmed) {
            qFilter = qFilter.and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        }
        return QueryServiceHelper.query((String)CfmEntityEnum.INTERESTBILL.getValue(), (String)"id,confirmstatus,endinstdate,actualinstamt", (QFilter[])qFilter.toArray());
    }

    public static boolean isExistByLoanBillId(Long loanBillId) {
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)loanBillId);
        return QueryServiceHelper.exists((String)"cfm_interestbill", (QFilter[])qFilter.toArray());
    }

    public static Map<Long, List<DynamicObject>> getInterestBillByLoanBillIds(Collection<Long> loanBillIds) {
        DynamicObjectCollection intBills = InterestBillRepository.queryInterestBillByLoanBillIds(loanBillIds, INTEREST_BILL_SELECT_PROPS);
        return intBills.stream().collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, BillAmountDTO> getInterestAmountByLoanBills(Collection<LoanBillDTO> loanBills) {
        HashMap<Long, BillAmountDTO> hashMap;
        HashMap<Long, BillAmountDTO> map = new HashMap<Long, BillAmountDTO>(loanBills.size());
        Map<Long, LoanBillDTO> loanBillMap = loanBills.stream().collect(Collectors.toMap(LoanBillDTO::getLoanBillId, d -> d));
        ArrayList<Long> loanBillIds = new ArrayList<Long>(loanBillMap.keySet());
        String selectFields = "sourcebillid,actualinstamt,convertintamt";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryInterestAmountByLoanBillIds", (String)"cfm_interestbill", (String)selectFields, (QFilter[])InterestBillRepository.getLoanBillFilter(loanBillIds).toArray(), null);
        DataSet dsAmount = dataSet.groupBy(new String[]{"sourcebillid"}).sum("actualinstamt").sum("convertintamt").finish();
        try {
            for (Row row : dsAmount) {
                Long loanBillId = row.getLong("sourcebillid");
                LoanBillDTO loanBillDTO = loanBillMap.get(loanBillId);
                BigDecimal convertIntAmt = row.getBigDecimal("convertintamt").multiply(loanBillDTO.getConvertRate());
                map.put(loanBillId, BillAmountDTO.build(row.getBigDecimal("actualinstamt"), convertIntAmt));
            }
            loanBillIds.forEach(l -> map.putIfAbsent((Long)l, new BillAmountDTO()));
            hashMap = map;
        }
        catch (Throwable throwable) {
            IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataSet, dsAmount});
            throw throwable;
        }
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataSet, dsAmount});
        return hashMap;
    }

    public static Map<Long, BillAmountDTO> getInterestAmountByLoanBillIds(Collection<Long> loanBillIds) {
        DynamicObjectCollection loanBills = LoanBillRepository.queryLoanBillByIds(new HashSet<Long>(loanBillIds), "id,convertrate,loancontractbill.id");
        return InterestBillRepository.getInterestAmountByLoanBills(LoanBillDTO.transfer(loanBills));
    }

    public static Map<Long, BillAmountDTO> getInterestAmountByContractIds(Collection<Long> contractIds) {
        HashMap<Long, BillAmountDTO> map = new HashMap<Long, BillAmountDTO>(contractIds.size());
        ArrayList<Long> loanBillIds = new ArrayList<Long>(contractIds.size());
        Map<Long, List<Long>> contactMap = LoanBillRepository.getLoanBillIdByContractId(new HashSet<Long>(contractIds));
        for (Map.Entry<Long, List<Long>> entry : contactMap.entrySet()) {
            loanBillIds.addAll((Collection<Long>)entry.getValue());
        }
        Map<Long, BillAmountDTO> loanIntAmountMap = InterestBillRepository.getInterestAmountByLoanBillIds(loanBillIds);
        for (Map.Entry<Long, List<Long>> entry : contactMap.entrySet()) {
            BillAmountDTO amountDTO = new BillAmountDTO();
            for (Long loanBillId : entry.getValue()) {
                amountDTO.add(loanIntAmountMap.get(loanBillId));
            }
            map.put(entry.getKey(), amountDTO);
        }
        contractIds.forEach(l -> map.putIfAbsent((Long)l, new BillAmountDTO()));
        return map;
    }

    public static Map<Long, LoanBillIntBillInfo> getLoanBillIntBillInfo(Collection<Long> loanBillIds) {
        HashMap<Long, LoanBillIntBillInfo> map = new HashMap<Long, LoanBillIntBillInfo>(loanBillIds.size());
        if (EmptyUtil.isEmpty(loanBillIds)) {
            return map;
        }
        Map<Long, List<DynamicObject>> interestBillMap = InterestBillRepository.getInterestBillByLoanBillIds(loanBillIds);
        for (Long loanBillId : loanBillIds) {
            List<DynamicObject> interestBills = interestBillMap.get(loanBillId);
            if (interestBills == null) {
                map.put(loanBillId, new LoanBillIntBillInfo());
                continue;
            }
            DynamicObject intBill = null;
            Date endDate = null;
            Date bizDate = null;
            BigDecimal payYetInterestAmt = BigDecimal.ZERO;
            interestBills.sort(Comparator.comparing(b -> b.getDate("bizdate"), Comparator.reverseOrder()));
            for (DynamicObject interestBill : interestBills) {
                if (intBill == null && InterestbillctgEnum.isPayinterst((String)interestBill.getString("instbillctg"))) {
                    intBill = interestBill;
                }
                payYetInterestAmt = payYetInterestAmt.add(interestBill.getBigDecimal("convertintamt"));
                if (!interestBill.getBoolean("isoverseaentfill")) continue;
                endDate = endDate == null || interestBill.getDate("endinstdate") != null && endDate.before(interestBill.getDate("endinstdate")) ? interestBill.getDate("endinstdate") : endDate;
            }
            if (intBill != null && !intBill.getBoolean("isoverseaentfill")) {
                endDate = intBill.getDate("endinstdate");
            }
            bizDate = interestBills.get(0).getDate("bizdate");
            map.put(loanBillId, LoanBillIntBillInfo.build(endDate, bizDate, payYetInterestAmt));
        }
        return map;
    }

    public static Map<Long, Date> queryLastPayinstDate(Collection<Long> loanBillIds) {
        HashMap<Long, Date> map = new HashMap<Long, Date>(loanBillIds.size());
        QFilter qFilter = InterestBillRepository.getLoanBillFilter(loanBillIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryLastPayinstDate", (String)"cfm_interestbill", (String)"sourcebillid,bizdate", (QFilter[])qFilter.toArray(), null);
        DataSet dsMaxBizDate = dataSet.groupBy(new String[]{"sourcebillid"}).max("bizdate").finish();
        for (Row row : dsMaxBizDate) {
            map.put(row.getLong("sourcebillid"), row.getDate("bizdate"));
        }
        return map;
    }

    public static DynamicObjectCollection getOnWayInterestBills(Collection<String> loanBillNos) {
        QFilter qFilter = new QFilter("loanbillno", "in", loanBillNos).and(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).or(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())));
        return QueryServiceHelper.query((String)"cfm_interestbill", (String)INTEREST_BILL_SELECT_PROPS, (QFilter[])qFilter.toArray());
    }

    public static DynamicObjectCollection getInterestBillsByLoanBillNos(Collection<String> loanBillNos) {
        QFilter qFilter = new QFilter("loanbillno", "in", loanBillNos);
        return QueryServiceHelper.query((String)"cfm_interestbill", (String)INTEREST_BILL_SELECT_PROPS, (QFilter[])qFilter.toArray());
    }

    public static DynamicObjectCollection getSubmitIntBillByLoanBillIds(Collection<Long> loanBillIds) {
        QFilter interestQfiter = new QFilter("sourcebillid", "in", loanBillIds).and("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
        return QueryServiceHelper.query((String)"cfm_interestbill", (String)"sourcebillid,billno,bizdate", (QFilter[])interestQfiter.toArray());
    }

    public static DynamicObjectCollection getUnAuditIntBillByLoanBillIds(Collection<Long> loanBillIds) {
        QFilter qFilter = new QFilter("sourcebillid", "in", loanBillIds).and("billstatus", "in", Arrays.asList(BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.SAVE.getValue()));
        return QueryServiceHelper.query((String)"cfm_interestbill", (String)"id,sourcebillid,billno,billstatus", (QFilter[])qFilter.toArray());
    }
}

