/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.repository;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.RepayStateEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.cfm.common.repository.bean.BillAmountDTO;
import kd.tmc.cfm.common.repository.bean.ContractBillAmountSumDTO;
import kd.tmc.cfm.common.repository.bean.LoanBillAmountSumDTO;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillRepository {
    private static final String LOANBILL_ENTRY_INTEREST = "id,loancontractbill,convertrate,interest_entry.interestcalamount,interest_entry.intstate,interest_entry.interesdate";
    static final String LOANBILL_AMOUNT_FIELDS = "id, loancontractbill, case when convertdrawamt = 0 then drawamount else convertdrawamt end as drawamount,case when convertrate > 0 then convertrate * repayamount else repayamount end as repayamount,case when convertrate > 0 then convertrate * notrepayamount else notrepayamount end as notrepayamount,case when convertrate > 0 then convertrate * calculaterateamount else calculaterateamount end as calculaterateamount";

    public static DynamicObject loadSingle(Long loanBillId) {
        return TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill");
    }

    public static DynamicObjectCollection queryLoanBillByIds(Collection<Long> loanBillIds, String selectFields) {
        QFilter qFilter = new QFilter("id", "in", loanBillIds);
        return QueryServiceHelper.query((String)"cfm_loanbill", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    public static Map<Long, DynamicObject> getLoanBillByIds(Collection<Long> loanBillIds, String selectFields) {
        if (Arrays.stream(selectFields.split(",")).noneMatch(s -> s.equals("id"))) {
            selectFields = "id," + selectFields;
        }
        DynamicObjectCollection colls = LoanBillRepository.queryLoanBillByIds(loanBillIds, selectFields);
        return colls.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
    }

    public static Map<Long, DynamicObject> getLoanBillByFilter(QFilter qFilter, String selectFields) {
        if (Arrays.stream(selectFields.split(",")).noneMatch(s -> s.equals("id"))) {
            selectFields = "id," + selectFields;
        }
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cfm_loanbill", (String)selectFields, (QFilter[])qFilter.toArray());
        return colls.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
    }

    public static Map<Long, BigDecimal> getLoanBillConvertRate(Collection<Long> loanBillIds) {
        DynamicObjectCollection loanBills = LoanBillRepository.queryLoanBillByIds(loanBillIds, "id,convertrate");
        return loanBills.stream().collect(Collectors.toMap(d -> d.getLong("id"), LoanBillHelper::getConvertRate));
    }

    public static Map<Long, LoanBillAmountSumDTO> queryLoanBillRepayAmount(List<Long> loanBillIds) {
        return LoanBillRepository.queryLoanBillStatAmount(loanBillIds, Boolean.TRUE, Boolean.FALSE);
    }

    public static Map<Long, LoanBillAmountSumDTO> queryLoanBillInterestAmount(List<Long> loanBillIds) {
        return LoanBillRepository.queryLoanBillStatAmount(loanBillIds, Boolean.FALSE, Boolean.TRUE);
    }

    public static Map<Long, LoanBillAmountSumDTO> queryLoanBillStatAmount(List<Long> loanBillIds) {
        return LoanBillRepository.queryLoanBillStatAmount(loanBillIds, Boolean.TRUE, Boolean.TRUE);
    }

    private static Map<Long, LoanBillAmountSumDTO> queryLoanBillStatAmount(List<Long> loanBillIds, boolean isQueryRepayAmount, boolean isQueryIntAmount) {
        HashMap<Long, LoanBillAmountSumDTO> result = new HashMap<Long, LoanBillAmountSumDTO>(loanBillIds.size());
        QFilter qFilter = new QFilter("id", "in", loanBillIds);
        String selectFields = "id,loancontractbill,convertrate";
        if (isQueryRepayAmount) {
            selectFields = selectFields + ",drawamount,convertdrawamt";
        }
        if (isQueryIntAmount) {
            selectFields = selectFields + ",interest_entry.interestcalamount";
        }
        DynamicObjectCollection loanBillColl = QueryServiceHelper.query((String)"cfm_loanbill", (String)selectFields, (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> loanBillMap = loanBillColl.stream().collect(Collectors.groupingBy(d -> d.getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : loanBillMap.entrySet()) {
            Long loanBillId = entry.getKey();
            List<DynamicObject> loanBills = entry.getValue();
            DynamicObject loanBill = loanBills.get(0);
            LoanBillAmountSumDTO dto = new LoanBillAmountSumDTO(loanBillId, loanBill.getLong("loancontractbill"));
            BigDecimal convertRate = LoanBillHelper.getConvertRate(loanBill);
            if (isQueryRepayAmount) {
                Map<Long, BillAmountDTO> repayAmountMap = RepaymentBillRepository.getRepayAmountByLoanBillIds(loanBillIds);
                BillAmountDTO repayAmount = repayAmountMap.get(loanBillId);
                dto.setPayedPrinAmt(repayAmount != null ? repayAmount : new BillAmountDTO());
                BigDecimal drawAmount = loanBill.getBigDecimal("drawamount");
                BigDecimal convertDrawAmount = loanBill.getBigDecimal("convertdrawamt");
                convertDrawAmount = EmptyUtil.isEmpty((BigDecimal)convertDrawAmount) ? drawAmount.multiply(convertRate) : convertDrawAmount;
                BillAmountDTO payedPrinAmt = dto.getPayedPrinAmt();
                dto.setUnpayPrinAmt(BillAmountDTO.build(drawAmount.subtract(payedPrinAmt.getAmount()), convertDrawAmount.subtract(payedPrinAmt.getConvertAmount())));
            }
            if (isQueryIntAmount) {
                Map<Long, BillAmountDTO> intAmountMap = InterestBillRepository.getInterestAmountByLoanBillIds(loanBillIds);
                BillAmountDTO intAmount = intAmountMap.get(loanBillId);
                dto.setPayedIntAmt(intAmount != null ? intAmount : new BillAmountDTO());
                BillAmountDTO payedIntAmt = dto.getPayedIntAmt();
                BigDecimal totalIntAmount = loanBills.stream().map(d -> d.getBigDecimal("interest_entry.interestcalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal convertTotalIntAmount = totalIntAmount.multiply(convertRate);
                dto.setUnpayIntAmt(BillAmountDTO.build(totalIntAmount.subtract(payedIntAmt.getAmount()), convertTotalIntAmount.subtract(payedIntAmt.getConvertAmount())));
            }
            result.put(loanBillId, dto);
        }
        return result;
    }

    public static Map<Long, List<Long>> getLoanBillIdByContractId(Set<Long> contractIds) {
        QFilter qFilter = new QFilter("loancontractbill", "in", contractIds);
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"loancontractbill,id", (QFilter[])qFilter.toArray());
        return loanBills.stream().collect(Collectors.groupingBy(d -> d.getLong("loancontractbill"), Collectors.mapping(d -> d.getLong("id"), Collectors.toList())));
    }

    private static DynamicObjectCollection queryLoanBillByContractIds(Set<Long> contractIds, String selectFields) {
        return LoanBillRepository.queryLoanBillByContractIds(contractIds, null, selectFields);
    }

    private static DynamicObjectCollection queryLoanBillByContractIds(Collection<Long> contractIds, List<Long> excludeLoanBillIds, String selectFields) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and("loancontractbill", "in", contractIds);
        if (EmptyUtil.isNoEmpty(excludeLoanBillIds)) {
            qFilter.and("id", "not in", excludeLoanBillIds);
        }
        return QueryServiceHelper.query((String)"cfm_loanbill", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    public static Map<Long, List<DynamicObject>> getLoanBillByContractId(Set<Long> contractIds, String selectFields) {
        if (!selectFields.contains("loancontractbill")) {
            selectFields = selectFields + "," + "loancontractbill";
        }
        DynamicObjectCollection loanBills = LoanBillRepository.queryLoanBillByContractIds(contractIds, selectFields);
        return loanBills.stream().collect(Collectors.groupingBy(d -> d.getLong("loancontractbill")));
    }

    public static Map<Long, BigDecimal> queryDrawAmountByContractIds(Set<Long> contractIds) {
        DynamicObjectCollection colls = LoanBillRepository.queryLoanBillByContractIds(contractIds, "loancontractbill,convertdrawamt");
        Map<Long, BigDecimal> map = colls.stream().collect(Collectors.groupingBy(i -> i.getLong("loancontractbill"), Collectors.mapping(d -> d.getBigDecimal("convertdrawamt"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        contractIds.forEach(d -> map.putIfAbsent((Long)d, BigDecimal.ZERO));
        return map;
    }

    public static Map<Long, Set<Long>> queryNotCloseLoanBillIds(Set<Long> contractIds) {
        QFilter qFilter = new QFilter("sourcebillid", "in", contractIds).and("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue());
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,sourcebillid", (QFilter[])qFilter.toArray());
        return colls.stream().collect(Collectors.groupingBy(l -> l.getLong("sourcebillid"), Collectors.mapping(l -> l.getLong("id"), Collectors.toSet())));
    }

    public static Map<Long, ContractBillAmountSumDTO> getLoanIntPlanAmountByContractId(Collection<Long> contractIds, List<Long> excludeLoanBillIds) {
        HashMap<Long, ContractBillAmountSumDTO> map = new HashMap<Long, ContractBillAmountSumDTO>(contractIds.size());
        DynamicObjectCollection colls = LoanBillRepository.queryLoanBillByContractIds(contractIds, excludeLoanBillIds, LOANBILL_ENTRY_INTEREST);
        Map<Long, List<DynamicObject>> contractMap = colls.stream().collect(Collectors.groupingBy(c -> c.getLong("loancontractbill")));
        for (Map.Entry<Long, List<DynamicObject>> entry : contractMap.entrySet()) {
            Long contractId = entry.getKey();
            ContractBillAmountSumDTO statAmtInfo = new ContractBillAmountSumDTO(contractId);
            List<DynamicObject> intPlans = contractMap.get(contractId);
            BigDecimal payedIntAmt = BigDecimal.ZERO;
            BigDecimal unpayIntAmt = BigDecimal.ZERO;
            if (EmptyUtil.isNoEmpty(intPlans)) {
                for (DynamicObject intPlan : intPlans) {
                    BigDecimal intAmt = intPlan.getBigDecimal("interest_entry.interestcalamount").multiply(LoanBillHelper.getConvertRate(intPlan));
                    if (RepayStateEnum.isPayed(intPlan.getString("interest_entry.intstate"))) {
                        payedIntAmt = payedIntAmt.add(intAmt);
                        continue;
                    }
                    unpayIntAmt = unpayIntAmt.add(intAmt);
                }
            }
            statAmtInfo.setPayedIntAmt(payedIntAmt).setUnpayIntAmt(unpayIntAmt);
            map.put(contractId, statAmtInfo);
        }
        contractIds.forEach(d -> map.putIfAbsent((Long)d, new ContractBillAmountSumDTO((Long)d)));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet queryLoanBillAmountSumByContractIds(Collection<Long> contractIds, QFilter filter) {
        QFilter qFilter = new QFilter("loancontractbill", "in", contractIds);
        if (filter != null) {
            qFilter.and(filter);
        } else {
            qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getContractBillAmountSum", (String)"cfm_loanbill", (String)LOANBILL_AMOUNT_FIELDS, (QFilter[])qFilter.toArray(), null);
        try {
            DataSet dataSet2 = dataSet.groupBy(new String[]{"loancontractbill"}).sum("drawamount").sum("repayamount").sum("notrepayamount").sum("calculaterateamount").finish();
            return dataSet2;
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)dataSet);
        }
    }

    public static DynamicObjectCollection getBanksCreditByContractId(Long contractId) {
        return QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,banksyndicate_entry.e_bankcreditlimit", (QFilter[])new QFilter("loancontractbill", "=", (Object)contractId).and("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()}).and(QFilter.isNotNull((String)"banksyndicate_entry.e_bankcreditlimit")).toArray());
    }

    public static DynamicObject[] getLoanBillByContractId(Long contractId) {
        QFilter filter = new QFilter("loancontractbill", "=", (Object)contractId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        return TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"id, bizdate, drawamount, accountbank, loaneracctbank, datasource", (QFilter[])filter.toArray());
    }

    public static DynamicObject getAutoDrawByContractId(Object contractId, String dataSource) {
        String entity = DataSourceEnum.isIfm(dataSource) ? "ifm_loanbill" : "cfm_loanbill";
        QFilter filter = new QFilter("loancontractbill", "=", contractId).and("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        return TmcDataServiceHelper.loadSingleFromCache((String)entity, (QFilter[])filter.toArray());
    }

    public static Object[] queryLoanBillIdByDrawApply(Long repayApplyId) {
        Object[] objectArray;
        QFilter applyFilter = new QFilter("drawapplybill", "=", (Object)repayApplyId);
        DynamicObject loanBill = QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"id", (QFilter[])applyFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)loanBill)) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = loanBill.getLong("id");
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public static DynamicObject getLoanBillById(Long loanBillId) {
        String selects = "id, billno, drawtype, datasource, startintdate, expiredate, isvoucher, lastrepaydate, endinstdate, endpreinstdate, renewalexpiredate, confirmstatus, billstatus";
        return QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)selects, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)loanBillId)});
    }

    public static DynamicObject getLoanBillBySelectId(Long loanBillId) {
        String selects = "id, drawtype, datasource, repaymentway, interesttype, loanrate, productfactory, loantype, loantype, creditortype, org, creditorg";
        return TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill", (String)selects);
    }

    public static DynamicObjectCollection getLoanBillByIds(List<Long> loanIds) {
        String selects = String.join((CharSequence)",", "id", "billno", "endinstdate", "lastpayinstdate", "startintdate", "expiredate", "renewalexpiredate", "interestsettledplan", "startloanrate");
        return QueryServiceHelper.query((String)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill").getName(), (String)selects, (QFilter[])new QFilter[]{new QFilter("id", "in", loanIds)});
    }

    public static DynamicObject[] getLoanBillsByPayInt(Object[] loanIds) {
        QFilter filter = new QFilter("id", "in", (Object)loanIds);
        filter = filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filter = filter.and(new QFilter("drawtype", "in", Arrays.asList(DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue(), DrawTypeEnum.ALLPAYMENT.getValue())));
        String selects = "id, currency, org, loancontractbill, contractno, billno, name, settlecenter, creditortype, creditorg, datasource";
        return TmcDataServiceHelper.load((String)"ifm_loanbill", (String)selects, (QFilter[])filter.toArray());
    }

    public static DynamicObject[] getLoanBillById(List<Object> loanBillIds, String queryFields) {
        return TmcDataServiceHelper.load((String)"ifm_loanbill", (String)queryFields, (QFilter[])new QFilter[]{new QFilter("id", "in", loanBillIds)});
    }
}

